<?php
require_once 'intelligent_mailer.api.php';
// Leellenőrizzük, hogy meg van-e adva már a kora, mert akkor nem tesszük fel
// a kérdést neki újra. Akkor sem tesszük fel neki, ha nincs megadva az e-mail
// címe, hiszen, ebben az esetben, nem tudjuk kihez kötni az eredményt.
if (isset($_GET['email'])) {
  $email = im_check_plain($_GET['email']);
  $result = is_age_set($email);
} else {
  $result = TRUE;
}

function is_age_set($email) {
  $subscriber = json_decode(im_getSubscriberByEmail($email));
  if ($subscriber->status == 'success') {
    foreach ($subscriber->data->fields as $value) {
      if ($value->fieldName == 'Kora') {
        return TRUE;
      }
    }
  }
  return FALSE;
}

if ($result) {
  // Nem kell bekérni a korát.
  $js = <<<EOF
<script>
  function goTop() {
    $("html, body").animate({scrollTop: 0}, 1000);
    $('#nm').focus();
  }
  $(document).ready(function () {
    $("#frm1-btn").hide();
    $("#story").show();
  });
</script>
EOF;
} else {
  // Be kell kérni a korát.
  $js = <<<EOF
<script>
  function goTop() {
    $("html, body").animate({scrollTop: 0}, 1000);
    $('#nm').focus();
  }
  $(document).ready(function () {
    $("#frm1-btn").click(function () {
      $("#form1").fadeIn(1000);
      $("#frm1-btn").fadeOut(100);
    });

    $("#send").click(function () {
      $.post("myscripts/ajax/set_im_after_subscribe.php",
        $("form#question").serialize(),
        function (data, status) {
          $("#form1").fadeOut(100);
          $("#alerts-wrap-filled").fadeIn(1000);
          $("#story").fadeIn(2000);
        });
    });

    $("#notsend").click(function () {
      $("#form1").fadeOut(100);
      $("#alerts-wrap-not-filled").fadeIn(1000);
      $("#story").fadeIn(2000);
    });

    // Meghívjuk amikor egy billentyűt lenyom a szövegdobozban.
    $("#age").keypress(function (e) {
      // Ha nem számot üt le, megjelenítjük a hibüzenetet és nem írunk be semmit.
      if (e.which != 8 && e.which != 0 && (e.which < 48 || e.which > 57)) {
        // Hibaüznet kiírása.
        $("#errmsg").html("Csak számokat írj!").show().fadeOut(2000);
        return false;
      }
    });
  });
</script>
EOF;
}
?>

<!DOCTYPE html>
<html>
  <head>
    <meta charset="UTF-8">
    <title>Hottie | Hogyan legyél jó nő?</title>
    <meta name="viewport" content="width=device-width, maximum-scale=1, user-scalable=no">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <link rel="shortcut icon" href="http://placehold.it/32x32" type="image/x-icon">
    <link href="//maxcdn.bootstrapcdn.com/font-awesome/4.2.0/css/font-awesome.min.css" rel="stylesheet">
    <link href="http://fonts.googleapis.com/css?family=Open+Sans:300italic,300,400,500,700,900" rel="stylesheet">
    <link href='http://fonts.googleapis.com/css?family=Open+Sans:400,300,300italic,600,700,800&subset=latin,latin-ext' rel='stylesheet' type='text/css'>
    <link rel="stylesheet" href="assets/css/bootstrap.css">
    <link rel="stylesheet" href="assets/css/baguetteBox.min.css">
    <link rel="stylesheet" href="assets/css/animate.css">
    <link rel="stylesheet" href="assets/css/main.css">
    <link rel="stylesheet" href="assets/css/jquery.cookiebar.css">
    <link rel="stylesheet" href="assets/css/bootstrap-custom-utils.css">
    <style>
      .subscribe-section {
        background-image: url("assets/images/c1.jpg") !important;
      }
      .btn.btn-default {
        color: #333 !important;
        background-color: #FFF !important;
        border: 1px solid !important;
        border-color: #CCC !important;
      }
      .btn.btn-default:hover {
        background-color: #E6E6E6 !important;
        border-color: #ADADAD !important;
      }
      .btn.btn-primary {
        color: #FFF !important;
        background-color: #337AB7 !important;
        border-color: #2E6DA4 !important;
      }
      .btn.btn-primary:hover {
        background-color: #204D74 !important;
        border-color: #122B40 !important;
      }
      p {
        font-size: 20px;
        font-weight: 300 !important;
        line-height: 150%;
        padding-bottom: 20px;
      }
	  #cookie-bar p {
		  line-height: 24px;
	  }

      #errmsg {
        color: #f15a5a;
      }

      #story, #form1, #alerts-wrap-filled, #alerts-wrap-not-filled {
        display: none;
      }
    </style>
    <script>
      (function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
      (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
      m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
      })(window,document,'script','//www.google-analytics.com/analytics.js','ga');

      ga('create', 'UA-66305831-2', 'auto');
      ga('send', 'pageview');

    </script>
	<!-- Facebook Pixel Code -->
	<script>
	!function(f,b,e,v,n,t,s){if(f.fbq)return;n=f.fbq=function(){n.callMethod?
	n.callMethod.apply(n,arguments):n.queue.push(arguments)};if(!f._fbq)f._fbq=n;
	n.push=n;n.loaded=!0;n.version='2.0';n.queue=[];t=b.createElement(e);t.async=!0;
	t.src=v;s=b.getElementsByTagName(e)[0];s.parentNode.insertBefore(t,s)}(window,
	document,'script','https://connect.facebook.net/en_US/fbevents.js');

	fbq('init', '1662603517394285');
	fbq('track', "PageView");</script>
	<noscript><img height="1" width="1" style="display:none"
	src="https://www.facebook.com/tr?id=1662603517394285&ev=PageView&noscript=1"
	/></noscript>
	<!-- End Facebook Pixel Code -->
	<noscript><img height="1" width="1" alt="" style="display:none" src="https://www.facebook.com/tr?ev=6030953312303&amp;cd[value]=0.00&amp;cd[currency]=HUF&amp;noscript=1" /></noscript>
	<!-- Google Code for Hottie feliratkoz&oacute;k -->

<!-- Remarketing tags may not be associated with personally identifiable information or placed on pages related to sensitive categories. For instructions on adding this tag and more information on the above requirements, read the setup guide: google.com/ads/remarketingsetup -->

<script type="text/javascript">

/* <![CDATA[ */

var google_conversion_id = 944131648;

var google_conversion_label = "XwbkCIv0_GEQwJyZwgM";

var google_custom_params = window.google_tag_params;

var google_remarketing_only = true;

/* ]]> */

</script>

<script type="text/javascript" src="//www.googleadservices.com/pagead/conversion.js">

</script>

<noscript>

<div style="display:inline;">

<img height="1" width="1" style="border-style:none;" alt="" src="//googleads.g.doubleclick.net/pagead/viewthroughconversion/944131648/?value=1.00&amp;currency_code=HUF&amp;label=XwbkCIv0_GEQwJyZwgM&amp;guid=ON&amp;script=0"/>

</div>

</noscript>
</head>
<body class="no-scroll">
  <div class="site-wrapper">
    <!-- Main wrapper-->
    <section id="detailed" class="section">
      <!-- Section begin-->
      <div class="container">
        <!--<h2 class="section-title">Detailed documentation</h2>-->
        <div class="image-slider">
          <div class="row section-table">
            <div class="col-sm-7 padding-medium-bottom">
              <h2>Köszönöm a feliratkozásod</h2>

              <p>Azért, amit most megmutatok neked, a legtöbb férfi meglincselne.</p>
              <p>Azt mondanák, hogyan árulhattam el őket, és hogyan adhatok ilyen eszközöket a kezedbe.</p>
              <p>
                De teljesen igaz az, hogyha elkezded azt a módszert használni amit mondok,
                ők lesznek a legboldogabbak. A lábad előtt fognak heverni.
              </p>
              <p>
                Még énrajtam is működne, ha nem találtam volna már meg a legjobb nőt a világon.
                De ugyanúgy képtelen lennék ennek ellenállni, mint bármelyik másik férfi. 
                (Beleértve a 70 éves papot is, aki eddig sikeresen őrizte a szüzességét.)
              </p>
              <p>
                Olyan  őszintén fogok veled beszélni mint még senki, és olyan dolgokat fogok 
                elmondani, amit eddig senkitől nem hallhattál.
              </p>
              <p>
                A legdurvább azonban az, hogy sem a korodtól sem a testalkatodtól, sem pedig a 
                külsődtől nem függ a sikered. Mindjárt be is bizonyítom.
              </p>

              <div id="frm1-btn">

                <p>De mielőtt tovább megyünk had kérdezzek pár dolgot, hogy jobban lássam a helyzeted.</p>
                <button type="button" class="btn text-uppercase margin-medium-vertical">Tovább >></button>
              </div>

              <div id="form1">
                <h2>Csak két lényeges kérdés:</h2>
                <form action="" data-sr="enter left move 100px" id="question">
                  <label for="ager">Hány éves vagy?</label>
                  <input type="text" placeholder="" name="age" id="age" required="required" maxlength="2" class="form-control" > 
                  <span id="errmsg"></span><br>
                  <label for="reason">Írd le egy mondatban, miért akarsz jobb nő lenni.</label>
                  <textarea placeholder="" name="reason" id="reason" required="required" class="form-control"></textarea>
                  <input type="hidden" name="email" value="<?php print $email; ?>">
                  <button type="button" class="btn btn-default" id="notsend">Kihagyom most</button>
                  <button type="button" class="btn" id="send">Tovább</button>
                </form>
              </div>
              <div id="alerts-wrap-filled">
                <p>
                  <strong>Köszönöm a válaszodat. Így sokkal jobban tudok majd segíteni neked.</strong>
                </p>
                <p>Folytassuk a sztorival:</p>
              </div>
              <div id="alerts-wrap-not-filled">
                <p>
                  <strong>
                    Sajnálom, hogy nem adtad meg, mert jobban tudtam volna segíteni neked.
                    Remélem nemsokára sikerül elnyernem a bizalmad.
                  </strong>
                </p>
                <p>Folytassuk a sztorival:</p>
              </div>

              <div id="story">
                <h2>Figyelj nagyon, mert ez lesz az alapja mindennek!</h2>
                <p>Egy régi ex barátnőm (nevezzük Petrának) mesélt egy lányról. Nem szerette. Csak úgy említette, hogy a „sísánc orrú”.</p>
                <p>
                  <em>„Nem tudom mi a fenét esznek rajta a palik”</em> — mondta. Persze mesélt arról, hogy milyen ronda, meg milyen hülye. 
                  Én pedig meg voltam győződve, hogy a szokásos női féltékenység. A csaj biztos egy bombázó. Azonban nem így volt…
                </p>
                <h2>Megdöbbentem</h2>
                <p>A lányt egy komoly zenei koncerten láttam először.</p>
                <p>
                  Átlagos és csúnyácska volt. Hosszú fekete haj, átlagos szeplős arc, átlagos 
                  alkat, az orra pedig az a fajta, amit talán fitosnak hívunk, olyan kis homorú.
                </p>
                <p>Az igazság az, hogy a lány <strong>messze rosszabbul nézett ki mint a barátnőm.</strong></p>
                <p>Hmm. Ő lenne az akiért megdöglenek a férfiak? Vakok járnak ide vagy mi??</p>
                <p>
                  Aztán bemutatott neki, beszéltünk 1-2 mondatot. Majd elváltunk. Megnéztük a fellépési rendet. 
                  A barátnőm ott marad, hogy készüljön.
                </p>
                <p>Én meg visszamentem a nézőtérre, leültem és vártam a koncert kezdetét. Ekkor jött oda hozzám a lány.</p>

                <h2>A beszélgetés ártatlannak tűnt</h2>
                <p><em>„Petra lesz a harmadik”</em>.<br><em>„Ja igen”</em> – mondtam.</p>
                <p>
                  Nem untatlak a beszélgetés részleteivel. Sima érdektelen fecsegés volt, egy csúnyácska lánnyal. 
                  Nem is volt hosszú. Pár perc múlva elsétált.
                </p>
                <p>De valami meglepő történt…</p>
                <h2>Alig vártam, hogy újra beszéljünk</h2>
                <p>
                  Nevezhetjük ezt sármnak, kisugárzásnak vagy akárminek. De ez egyik sem. 
                  Ez a „valami” nem függ a kortól, a megjelenéstől. 
                  Ez egy megfogható dolog, de akkor még nem tudtam hogy mi ez. Most már tudom.
                </p>
                <p>Ez a lány nem is tudatosan, ösztönösen használt, egyetlen dolgot.</p>
                <p>
                  Mindössze egyetlen dolgot a sokból, amit meg fogok neked tanítani. És ez az egyetlen dolog, azt eredményezte, 
                  hogy beszélni akartam vele, a közelében akartam lenni.
                </p>
                <p>El fogom mondani, mi volt ez és hogyan lehetsz képes te is erre.</p>
                <p>Holnap folytatjuk.</p>

              </div>
            </div>
          </div>
        </div>
      </div>
  </div>

  <!-- Section end-->
</section>

<footer class="footer">
  <!-- Footer begin-->
  <div class="container">
    <div class="row">
      <div class="col-sm-6 col-sm-offset-3">
        <p class="copy">Copyright © 2015 Müller Péter<br><a href="http://hottie.hu/node/27" target="_blank">Kapcsolat</a> / <a href="http://hottie.hu/node/95" target="_blank">Adatvédelmi nyilatkozat</a> / <a href="http://hottie.hu/node/245" target="_blank">Jogi nyilatkozat</a></p>
      </div>
    </div>
  </div>
  <!-- Footer end-->
</footer>
</div>
<div class="loader">
  <!-- Loader-->
  <div class="spinner"></div>
</div>
<!-- Scripts-->
<script src="assets/js/vendors/jquery.min.js"></script>
<script src="assets/js/vendors/bootstrap.min.js"></script>
<script src="assets/js/vendors/jquery.stellar.min.js"></script>
<script src="assets/js/vendors/jquery.ajaxchimp.min.js"></script>
<script src="assets/js/vendors/scrollReveal.min.js"></script>
<script src="assets/js/vendors/baguetteBox.min.js"></script>
<script src="assets/js/vendors/slick.min.js"></script>
<script src="assets/js/vendors/jquery.flexslider-min.js"></script>
<!--<script src="https://maps.googleapis.com/maps/api/js?v=3.exp&amp;signed_in=true"></script>-->
<script type="text/javascript" src="assets/js/jquery.cookiebar.js"></script> 
<script src="assets/js/main.js"></script>
<?php print $js; ?>
<!-- Google Code for Feliratkoz&aacute;s Conversion Page -->
<script type="text/javascript">
/* <![CDATA[ */
var google_conversion_id = 944131648;
var google_conversion_language = "en";
var google_conversion_format = "3";
var google_conversion_color = "ffffff";
var google_conversion_label = "va83CKfuwF8QwJyZwgM";
var google_remarketing_only = false;
/* ]]> */
</script>
<script type="text/javascript" src="//www.googleadservices.com/pagead/conversion.js">
</script>
<noscript>
<div style="display:inline;">
<img height="1" width="1" style="border-style:none;" alt="" src="//www.googleadservices.com/pagead/conversion/944131648/?label=va83CKfuwF8QwJyZwgM&amp;guid=ON&amp;script=0"/>
</div>
</noscript>
</body>
</html>