<?php

define('ERROR_URL', 'http://www.hottie.hu/error.php'); 
define('THANK_YOU_PAGE', 'http://hottie.hu/thank-you.php');

// Az Email Marketer API-ját beolvassuk.
require_once 'intelligent_mailer.api.php';

// A hibajelző változót hamsira (nincs hiba) állítjuk.
$error = FALSE;

// Megtisztítjuk a paramétereket, és az utónevet nagybetűssé alakítjuk.
$email = trim(im_check_plain($_POST['email']));
$nickname = capitalize(trim(im_check_plain($_POST['nickname'])));

// Nem üresek a mezők?
if (empty($email) || empty($nickname)) {
  error('Hiányzó mezők! Kérlek tölts ki minden szükséges mezőt a feliratkozáshoz.');
  $error = TRUE;
}

// Helyes az e-mail címe?
if (!is_valid_email($email)) {
  error('Hibás e-mail cím! Kérlek nézd meg újra az e-mail címed, és add meg helyesen.');
  $error = TRUE;
}

if (!$error) {
  // Hozzáadjuk a feliratkozót az adatbázisahoz.
  $result = json_decode(im_subscribeEmail($email, ''));
  
  $id = $result->data->id; 

  // Hozzáadjuk az utónév mezőt a feliratkozókhoz.
  $result = im_setSubscriberField($email, 'GaBiydUMho2Bv5ZWGEB4F5X2G8lnREw7y', $nickname);
  
  // Elindítjuk a szekvencián.
  $result = im_startSubscriberSequence($email, 'GvRHVLw0zYUctqPzbmtlgxKlXD16KoqF1oPaFtptO');
  
  // Átirányítjuk a Thank you page-re.
  header('Location: ' . THANK_YOU_PAGE . "?id=$id&email=$email");
}

/**
 * Ellenőrzi az email címet. 
 * 
 * @param string $email
 *   A nyers e-mail cím.
 * 
 * @return boolean
 *   TRUE ha az email korrekt és a domain létezik.
 */
function is_valid_email($email) {
  $isValid = true;
  $atIndex = strrpos($email, "@");
  if (is_bool($atIndex) && !$atIndex) {
    $isValid = false;
  } else {
    $domain = substr($email, $atIndex+1);
    $local = substr($email, 0, $atIndex);
    $localLen = strlen($local);
    $domainLen = strlen($domain);
    if ($localLen < 1 || $localLen > 64){
      // A helyi rész szabályos hosszát túlléptük.
      $isValid = false;
    } else if ($domainLen < 1 || $domainLen > 255) {
      // A domain rész szabályos hosszát túlléptük.
      $isValid = false;
    } else if ($local[0] == '.' || $local[$localLen-1] == '.') {
      // A helyi rész '.'-ra végződik.
      $isValid = false;
    } else if (preg_match('/\\.\\./', $local)) {
      // A helyi részben két folyamatos pont van.
      $isValid = false;
    } else if (!preg_match('/^[A-Za-z0-9\\-\\.]+$/', $domain)) {
      // A karakter nem valós a domain részben.
      $isValid = false;
    } else if (preg_match('/\\.\\./', $domain)) {
      // A domain részben két folyamatos pont van.
      $isValid = false;
    } else if(!preg_match('/^(\\\\.|[A-Za-z0-9!#%&`_=\\/$\'*+?^{}|~.-])+$/', str_replace("\\\\","",$local))) {
      // A karakter nem valós a helyi részben, kivéve ha idézett.
      if (!preg_match('/^"(\\\\"|[^"])+"$/', str_replace("\\\\","",$local))) {
          $isValid = false;
      }
    }
    if ($isValid && !(checkdnsrr($domain,"MX") || checkdnsrr($domain,"A"))) {
      // A domain DNS rekordja nem található.
      $isValid = false;
    }
  }
  return $isValid;
}

/**
 * Nagybetűsítjük a stringet.
 * 
 * @param string $str
 *   A konvertálandó string.
 *  
 * @return string
 *   A string első betűje nagy a többi kicsi.
 */
function capitalize($str) {
  $outstr = ucfirst(strtolower($str));
  return $outstr;
}

function error($error_message) {
  header("Location: " . ERROR_URL. "?error=$error_message");
  //print "Error: $error_message";
} 
