<?php

/**
 * @file Shows the logged user what product he has.
 * @copyright (c) 2016, Müller Péter
 * @package CD
 */
if (cd_is_the_current_user_logged()) {
  $list = cd_get_pid_role_pairs();
  $products = cd_get_current_users_products($list);
  $pairs = cd_user_product_have($products);
  cd_print_user_products($pairs);
} else {
  cd_print_need_log_in();
}

function cd_is_the_current_user_logged() {
  global $user;
  if ($user->uid) {
    return TRUE;
  } else {
    return FALSE;
  }
}

function cd_get_pid_role_pairs() {
  $pids_roles = array(
    array(
      'pid' => 1,
      'role' => 'Tanuló: Hottie',
      'link' => '/list/hottie',
      'cover' => '/assets/images/hottie_borito_es_sales-1.png',
      'sales' => '/sales.php',
      'desc' => 'A Hottie-ból megismered a férfiak gondolkodását. Meg tudod találni az igazi férfiakat. Azokat a pasikat, akik még mindig kényeztetik a nőket. Ajándékokkal, utazással, figyelmességgel és kedvességgel. Nem átlagos fickók, hanem igazi, sármos befolyásos pasik. Nem használhatnának ki. Úgy csábítanál, hogy a férfiak rajonganának érted. Ha tudnád mit mondj, rejtett kapcsolókat és érzelmi rugókat indítanál be a férfi elméjében. Ebből érezné a férfi, hogy te kellesz neki. Hogy te, és senki más.',
    ),
    array('pid' => 2,
      'role' => 'Tanuló: Hottie megjelenés',
      'link' => '/list/hottie-megjelenes',
      'cover' => '/assets/images/hottie_megjelenes_borito.png',
      'sales' => '/node/284#H-Style',
      'desc' => 'Sok nő nem találja a megfelelő színeket és a megfelelő árnyalatokat. Olyan színeket vesz fel, amiről azt hiszi, hogy jól áll rajta. Ehelyett eltereli róla a figyelmet, nyúzottnak, és fáradtnak hat. Az emberek ösztönösen érzik ezt. Ha a jó színeket viseled, frissnek nézel ki. De nem csak ez az előnye. A helyes színárnyalatokban sokkal vonzóbbnak és csábítóbbnak hatsz. Persze ennél sokkal többről fogunk beszélni…',
    ),
    array('pid' => 3,
      'role' => 'Tanuló: Hottie csábítás',
      'link' => '/list/hottie-csabitas',
      'cover' => '/assets/images/hottie_csabitas_borito.png',
      'sales' => '/node/284#Allure',
      'desc' => 'Ez atzoknak szól, akik bizonytalanok a flörtölésben, vagy jobban akarnak csábítnai. Persze ez csak a jéghegy csúcsa, mert ami ezalatt található, sokkal több mint amire gondoltál.Onnan indulunk, hogy megtanítalak olyan alapvető technikákra, amiket bárhol, nyilvánosan is elsüthetsz, és a férfiak úgy beindulnak tőle, mintha a kezedbe vennéd a farkukat. Lépésenként tanítalak meg erre, rengeteg példával. Ameddig eljutunk a hálószobák legmélyebb bugyráig. Ez a verbális (szóbeli) csábítás kézikönyve.',
    ),
  );
  return $pids_roles;
}

function cd_get_current_users_products($pids_roles = array()) {
  foreach ($pids_roles as $row) {
    $pids[] = $row['pid'];
  }

  $products = db_query('SELECT name, hash FROM {membership_products} WHERE pid IN (:pids)', array(':pids' => $pids))->fetchAll();

  $pairs = $pids_roles;

  foreach ($pairs as $key => $value) {
    $pairs[$key]['name'] = $products[$key]->name;
    $pairs[$key]['hash'] = $products[$key]->hash;
  }

  return $pairs;
}

function cd_user_product_have($pairs = array()) {
  global $user;
  $user_roles = $user->roles;
  foreach ($pairs as $key => $value) {
    if (in_array($value['role'], $user_roles)) {
      $pairs[$key]['have'] = TRUE;
    } else {
      $pairs[$key]['have'] = FALSE;
    }
  }
  return $pairs;
}

function cd_print_user_products($pairs = array()) {
  $html = '';

  foreach ($pairs as $row) {
    $html .= <<<HTML
      <div class="media">
      <div class="media-right media-middle">
        <a href="{$row['link']}">
          <img class="media-object pull-left" src="{$row['cover']}" alt="" style="width: 15%; margin-right: 20px;">
        </a>
      </div>
      <div class="media-body">
        <h4 class="media-heading">{$row['name']}</h4>
        <p>{$row['desc']}</p>
HTML;


    if ($row['have']) {
      $html .='<p><a href="' . $row['link'] . '" class="btn btn-primary" role="button">Ugrás a tananyagra</a></p>';
    } else {
      $html .='<p>'
        . '  <a href="' . $row['sales'] . '" class="btn btn-primary" role="button">Információ</a>'
        . '  <a href="/megrendeles/?pid=' . $row['pid'] . '&hash=' . $row['hash'] . '" class="btn btn-success" role="button">Megrendelés</a>'
        . '</p>';
    }

    $html .= '  </div>';
    $html .= '</div><hr>';
  }

  $html .= <<<HTML
    <div class="media">
      <div class="media-left">
        <a href="/list/hottie-bevezeto">
          <img class="media-object" src="" alt="">
        </a>
      </div>
      <div class="media-body">
        <h4 class="media-heading">Hottie bevezető leckék</h4>
        <p>
          A Hottie bevezető leckéi egy kis ízelítőt adnak abból, hogy milyen is
          valójában a Hottie. Kapsz benne pár olyan alapvető információt, amiből
          megtanulhatod, hogyan gondolkoznak a férfiak.
        </p>
        <p><a href="/list/hottie-bevezeto" class="btn btn-primary" role="button">Ugrás a tananyagra</a></p>
      </div>
    </div><hr>
HTML;

  print $html;
}

function cd_print_need_log_in() {
  $html = <<<HTML
    <p>
      A tananyagaid eléréséhez meg kell adnod a felhasználó neved és a jelszavad. Itt tudsz belépni:<br>
      <a href="/user" class="btn btn-primary" role="button">Belépés</a>
    </p>
    <p>
      Ha elfelejtetted a felhasználó neved, vagy a jelszavad erre a gombra kattintva tudsz újat kérni az e-mail címed megadásával:<br>
      <a href="/user/password" class="btn btn-danger" role="button">Elfelejett jelszó</a>
    </p>
HTML;
  print $html;
}
