/*!
 * This application make a simple slidebar for your page.
 * You need to change the default options to make own apps.
 */
(function ($) {
Drupal.behaviors.slideBarFunc = {
  attach: function (context, settings) {
	var slideBar = function(){
		var defaults = {
				barHeight: "50px",
				align: "bottom",
				oneBorder: "1px solid #333",
				bgColor: "rgba(0,0,0,0.5)",
				bgUrl: "",
				bgImage: "no-repeat fixed center center / cover",
				barHtmlContent: "Hello!",
				closeCookie: "1",
				appeare: "1000",
				delay: '1000'
		},
		options = {
				barHeight: $('#slideBarContent[data-barheight]').length ? $('#slideBarContent').data('barheight') : defaults.barHeight,
				align: $('#slideBarContent[data-align]').length ? $('#slideBarContent').data('align') : defaults.align,
				oneBorder: $('#slideBarContent[data-border]').length ? $('#slideBarContent').data('border') : defaults.oneBorder,
				bgColor: $('#slideBarContent[data-background-color]').length ? $('#slideBarContent').data('background-color') : defaults.bgColor,
				bgUrl: $('#slideBarContent[data-background-url]').length ? $('#slideBarContent').data('background-url') : defaults.bgUrl,
				bgImage: $('#slideBarContent[data-background-image]').length ? $('#slideBarContent').data('background-image') : defaults.bgImage,
				appeare: $('#slideBarContent[data-appeare]').length ? $('#slideBarContent').data('appeare') : defaults.appeare,
				closeCookie: $('#slideBarContent[data-close-cookie]').length ? $('#slideBarContent').data('close-cookie') : defaults.closeCookie,
				barHtmlContent: $('#slideBarContent').html(),
				delay: $('#slideBarContent[data-delay]').length ? $('#slideBarContent').data('delay') : defaults.delay
		},
		initSlideBar = (function(){
			var startCss = '-' + options.barHeight,
				animateCss = '', animObj = '';
			if ( options.align == 'bottom' ){
				animateCss = { bottom: '-' + options.barHeight };
				animObj = { bottom: '0px' };
			} else if ( options.align == 'top' ){
				animateCss = { top: '-' + options.barHeight };
				animObj = { top: '0px' };
			} else if ( options.align == 'left' ){
				animateCss = { left: '-' + options.barHeight };
				animObj = { left: '0px' };
			} else if ( options.align == 'right' ){
				animateCss = { right: '-' + options.barHeight };
				animObj = { right: '0px' };
			}
			if (options.delay == "exit"){
				setTimeout(function(){
					console.log("exit trigger active");
					$(document).mousemove(function(e) {
						if(e.pageY <= 15 + $(document).scrollTop()){
							$('#slide-bar').css('display', 'block').css( options.align, startCss ).animate(animObj, options.appeare, 'swing');
							$(document).off('mousemove');
						}
					});
				}, 10000);
			} else {
				$('#slide-bar').css('display', 'block').css( options.align, startCss ).delay(options.delay).animate(animObj, options.appeare, 'swing');
			}
			$('.slb-close').click(function(){
				$('#slide-bar').animate(animateCss, 1000, 'swing').delay(1000).animate({opacity: '0', "z-index": '-100000'}, 'fast');
				setCookie("HottieBlog.closed_popup", "1", options.closeCookie);
				$(document).off('mousemove');
			});
		}),
		buildSlideBar = (function(){
			console.log("eredmény" + $('#slideBarContent[data-barheight]').length);
			$('#slideBarContent').css('display', 'none');
			var alignCss = '', slideCss = '', borderCss = '';
			
			if ( options.align == 'bottom' ){
				alignCss = 'bottom: 0; left: 0; width: 100%; min-height: ' + options.barHeight + '; ';
			} else if ( options.align == 'top' ){
				alignCss = 'top: 0; left: 0; width: 100%; min-height: ' + options.barHeight + '; ';
			} else if ( options.align == 'left' ){
				alignCss = 'top: 0; left: 0; height: 100%; min-width: ' + options.barHeight + '; ';
			} else if ( options.align == 'right' ){
				alignCss = 'top: 0; right: 0; height: 100%; min-width: ' + options.barHeight + '; ';
			}
			
			if ( options.align == 'bottom' ){
				borderCss = 'border-top: ' + options.oneBorder + '; ';
			} else if ( options.align == 'top' ){
				borderCss = 'border-bottom: ' + options.oneBorder + '; ';
			} else if ( options.align == 'left' ){
				borderCss = 'border-right: ' + options.oneBorder + '; ';
			} else if ( options.align == 'right' ){
				borderCss = 'border-left: ' + options.oneBorder + '; ';
			}
			if ( options.bgUrl !== ""){
				slideCss = alignCss + borderCss + ' background: ' + options.bgColor + " url(" + options.bgUrl + ") " + options.bgImage + '; ';
			} else {
				slideCss = alignCss + borderCss + ' background-color: ' + options.bgColor + '; ';
			}
			
			var closeBar = '<button title="Close" type="button" class="slb-close" style="z-index: 10001; position: absolute; right: 0; top: 0;">&times;</button>',
				construction =	'<div id="slide-bar" style="display: none; position: fixed; z-index: 10000; ' + slideCss + '">' +
									options.barHtmlContent +
									closeBar +
								'</div>';
			if (!getCookie("HottieBlog.closed_popup").length && !getCookie("HottieBlog.subscribed").length){
				$('body').append(construction);
				initSlideBar();
			}
		});
		buildSlideBar();
	};

	$(document).ready(function(){	
		$('#slideBarContent').length ? slideBar() : "";
	});

		function setCookie(cname, cvalue, exdays) {
			var d = new Date();
			d.setTime(d.getTime() + (exdays*24*60*60*1000));
			var expires = "expires="+d.toUTCString();
			document.cookie = cname + "=" + cvalue + "; " + expires + "; path=/";
		}


		function getCookie(cname) {
			var name = cname + "=";
			var ca = document.cookie.split(';');
			for(var i = 0; i <ca.length; i++) {
				var c = ca[i];
				while (c.charAt(0)==' ') {
					c = c.substring(1);
				}
				if (c.indexOf(name) == 0) {
					return c.substring(name.length,c.length);
				}
			}
			return "";
		}
		
		function exitPopup(){
			console.log("exitPopup funkció elindult");
			$(document).mousemove(function(e) {

				if(e.pageY <= 15 + $(document).scrollTop())
				{
					slideBar();
				}
			
			});
		}
  }
};
})(jQuery);