<?php
/**
 * Pre-processes variables for the "page" theme hook.
 *
 * See template for list of available variables.
 *
 * @see page.tpl.php
 *
 * @ingroup theme_preprocess
 */
function kyonewaza_preprocess_page(&$variables) {
  // Primary nav.
  $variables['primary_nav'] = FALSE;
  if (!empty($variables['main_menu'])) {
    // Build links.
    $variables['primary_nav'] = menu_tree(variable_get('menu_main_links_source', 'main-menu'));
    // Provide default theme wrapper function.
    $variables['primary_nav']['#theme_wrappers'] = ['menu_tree__primary'];
  }

  // Secondary nav.
  $variables['secondary_nav'] = FALSE;
  if (!empty($variables['secondary_menu'])) {
    // Build links.
    $variables['secondary_nav'] = menu_tree(variable_get('menu_secondary_links_source', 'user-menu'));
    // Provide default theme wrapper function.
    $variables['secondary_nav']['#theme_wrappers'] = ['menu_tree__secondary'];
  }

  // Manage display of cards
  $cards = variable_get('kyonewaza_page_cards', FALSE);

  $variables['kyonewaza_set_page_card'] = TRUE;
  if ($cards) {
    if (isset($variables['node'])) {
      if (is_array($cards) && isset($cards[$variables['node']->nid])) {
        $variables['kyonewaza_set_page_card'] = FALSE;
      }
    }
  }


  // Add help content
  kyonewaza_add_help_variables($variables);
}
