<?php
/**
 * @file
 * Default theme implementation to display a single Drupal page.
 *
 * The doctype, html, head and body tags are not in this template. Instead they
 * can be found in the html.tpl.php template in this directory.
 *
 * Available variables:
 *
 * General utility variables:
 * - $base_path: The base URL path of the Drupal installation. At the very
 *   least, this will always default to /.
 * - $directory: The directory the template is located in, e.g. modules/system
 *   or themes/bartik.
 * - $is_front: TRUE if the current page is the front page.
 * - $logged_in: TRUE if the user is registered and signed in.
 * - $is_admin: TRUE if the user has permission to access administration pages.
 *
 * Site identity:
 * - $front_page: The URL of the front page. Use this instead of $base_path,
 *   when linking to the front page. This includes the language domain or
 *   prefix.
 * - $logo: The path to the logo image, as defined in theme configuration.
 * - $site_name: The name of the site, empty when display has been disabled
 *   in theme settings.
 * - $site_slogan: The slogan of the site, empty when display has been disabled
 *   in theme settings.
 *
 * Navigation:
 * - $main_menu (array): An array containing the Main menu links for the
 *   site, if they have been configured.
 * - $secondary_menu (array): An array containing the Secondary menu links for
 *   the site, if they have been configured.
 * - $breadcrumb: The breadcrumb trail for the current page.
 *
 * Page content (in order of occurrence in the default page.tpl.php):
 * - $title_prefix (array): An array containing additional output populated by
 *   modules, intended to be displayed in front of the main title tag that
 *   appears in the template.
 * - $title: The page title, for use in the actual HTML content.
 * - $title_suffix (array): An array containing additional output populated by
 *   modules, intended to be displayed after the main title tag that appears in
 *   the template.
 * - $messages: HTML for status and error messages. Should be displayed
 *   prominently.
 * - $tabs (array): Tabs linking to any sub-pages beneath the current page
 *   (e.g., the view and edit tabs when displaying a node).
 * - $action_links (array): Actions local to the page, such as 'Add menu' on the
 *   menu administration interface.
 * - $feed_icons: A string of all feed icons for the current page.
 * - $node: The node object, if there is an automatically-loaded node
 *   associated with the page, and the node ID is the second argument
 *   in the page's path (e.g. node/12345 and node/12345/revisions, but not
 *   comment/reply/12345).
 *
 * Regions:
 * - $page['help']: Dynamic help text, mostly for admin pages.
 * - $page['highlighted']: Items for the highlighted content region.
 * - $page['content']: The main content of the current page.
 * - $page['sidebar_first']: Items for the first sidebar.
 * - $page['sidebar_second']: Items for the second sidebar.
 * - $page['header']: Items for the header region.
 * - $page['footer']: Items for the footer region.
 *
 * @see bootstrap_preprocess_page()
 * @see template_preprocess()
 * @see template_preprocess_page()
 * @see bootstrap_process_page()
 * @see template_process()
 * @see html.tpl.php
 *
 * @ingroup templates
 */
?>
<?php /* print $node->type */ ?>

<?php
$h = $node->field_is_menu;
/* print render($h['und']['0']['value']); */
if ($h['und']['0']['value'] == 1):
    ?>
    <header class="topnavbar-wrapper">
        <!-- START Top Navbar-->
        <nav class="navbar topnavbar navbar-expand-lg navbar-light">
            <!-- START navbar header-->
            <div class="navbar-header">
                <a class="navbar-brand" href="<?php print $logo ? $front_page : ''; ?>" title="<?php print t('Home'); ?>">
                    <div class="brand-logo">
                        <img class="img-fluid" src="<?php print $logo; ?>" alt="<?php print t('Home'); ?>">
                        <?php if (!empty($site_name)): ?>
                            <?php print $site_name; ?>
                        <?php endif; ?>
                    </div>
                    <div class="brand-logo-collapsed">
                        <img class="img-fluid" src="<?php print $logo ? $front_page : ''; ?>" alt="<?php print t('Home'); ?>">
                        <?php if (!empty($site_name)): ?>
                            <?php print $site_name; ?>
                        <?php endif; ?>
                    </div>
                </a>
                <?php if (!empty($primary_nav) || !empty($secondary_nav) || !empty($page['navigation'])): ?>
                    <button class="navbar-toggler collapsed" type="button" data-toggle="collapse" data-target="#topnavbar" aria-expanded="false">
                        <span class="navbar-toggler-icon"></span>
                    </button>
                <?php endif; ?>
            </div>
            <!-- END navbar header-->
            <!-- START Nav wrapper-->
            <div class="navbar-collapse collapse" id="topnavbar" style="">
                <!-- START Left navbar-->
                <!--ul class="nav navbar-nav mr-auto flex-column flex-lg-row">
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle dropdown-toggle-nocaret" href="#dashboard" data-toggle="dropdown">Dashboard</a>
                        <div class="dropdown-menu animated fadeIn">
                            <a class="dropdown-item" href="dashboard.html">Dashboard v1</a>
                            <a class="dropdown-item" href="dashboard_v2.html">Dashboard v2</a>
                            <a class="dropdown-item" href="dashboard_v3.html">Dashboard v3</a>
                        </div>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="widgets.html">Widgets</a>
                    </li>
                </ul-->
                <!-- END Left navbar-->
                <!-- START Left navbar-->
                <?php if (!empty($primary_nav) || !empty($page['navigation'])): ?>
                    <ul class="nav navbar-nav mr-auto flex-column flex-lg-row">
                        <?php if (!empty($primary_nav)): ?>
                            <?php print render($primary_nav); ?>
                        <?php endif; ?>
                        <?php if (!empty($page['navigation'])): ?>
                            <?php print render($page['navigation']); ?>
                        <?php endif; ?>
                    </ul>
                <?php endif; ?>
                <!-- END Left navbar-->
                <!-- START Right Navbar-->
                <?php if (!empty($secondary_nav)): ?>
                    <ul class="navbar-nav flex-row">
                        <?php if (!empty($secondary_nav)): ?>
                            <?php print render($secondary_nav); ?>
                        <?php endif; ?>
                        <!-- START Offsidebar button-->
                        <!--                <li class="nav-item">
                                            <a class="nav-link" href="#" title="<?php echo t('Credits you have.'); ?>" data-toggle="tooltip" data-placement="bottom" data-original-title="<?php echo t('Credits you have.'); ?>">
                                                <span class="badge badge-danger"><?php // echo $certify_user_credits;     ?></span>
                                            </a>
                                        </li>-->
                        <!-- END Offsidebar menu-->
                    </ul>
                <?php endif; ?>
                <!-- END Right Navbar-->
            </div>
            <!-- END Nav wrapper-->
            <!-- START Search form-->
            <form class="navbar-form" role="search" action="search.html">
                <div class="form-group">
                    <input class="form-control" type="text" placeholder="Type and hit enter ...">
                    <div class="fa fa-times navbar-form-close" data-search-dismiss=""></div>
                </div>
                <button class="d-none" type="submit">Submit</button>
            </form>
            <!-- END Search form-->
        </nav>
        <!-- END Top Navbar-->
    </header>
<?php endif; ?>

<?php if (!empty($page['top_banner'])): ?>
    <section class="top-banner-region">
        <?php print render($page['top_banner']); ?>
    </section>
<?php endif; ?>

<?php if (!empty($action_links)): ?>
    <div class="main-container <?php print $container_class; ?>">
        <ul class="action-links"><?php print render($action_links); ?></ul>
    </div>
<?php endif; ?>
<?php if (!empty($tabs)): ?>
    <div class="main-container <?php print $container_class; ?> padding-none">
        <?php print $messages; ?>
        <?php if (!empty($tabs)): ?>
            <?php print render($tabs); ?>
        <?php endif; ?>
        <?php if (!empty($page['help'])): ?>
            <?php print render($page['help']); ?>
        <?php endif; ?>
    </div>
<?php endif; ?>

<?php print render($page['content']); ?>

<?php
$f = $node->field_is_footer;
if ($f['und']['0']['value'] == 1):
    ?>
    <?php if (!empty($page['footer'])): ?>
        <footer class="footer">
            <div class="footer-bottom">
                <div class=" <?php print $container_class; ?>">
                    <?php print render($page['footer']); ?>
                </div>
            </div>
        </footer>
    <?php endif; ?>
<?php endif; ?>
