<?php
/**
 * @file
 * The primary PHP file for this theme.
 */

 
require_once dirname(__FILE__) . '/includes/common.inc';

function avilon_preprocess_page(&$variables) {
  // Add information about the number of sidebars.
  if (!empty($variables['page']['sidebar_first']) && !empty($variables['page']['sidebar_second'])) {
    $variables['content_column_class'] = ' class="col-sm-6"';
  }
  elseif (!empty($variables['page']['sidebar_first']) || !empty($variables['page']['sidebar_second'])) {
    $variables['content_column_class'] = ' class="col-sm-8"';
  }
  else {
    $variables['content_column_class'] = ' class="col-sm-12"';
  }

  if(bootstrap_setting('fluid_container') === 1) {
    $variables['container_class'] = 'container-fluid';
  }
  else {
    $variables['container_class'] = 'container';
  }
  
  drupal_add_css('https://fonts.googleapis.com/css?family=Montserrat:300,400,500,700|Open+Sans:300,300i,400,400i,700,700i', array('group' => CSS_THEME));
  
  
    // Do we have a node?
    if (isset($variables['node'])) {

		// Ref suggestions cuz it's stupid long.
		$suggests = &$variables['theme_hook_suggestions'];

		// Get path arguments.
		$args = arg();
		// Remove first argument of "node".
		unset($args[0]);

		// Set type.
		$type = "page__type_{$variables['node']->type}";

		// Bring it all together.
		$suggests = array_merge(
		  $suggests,
		  array($type),
		  theme_get_suggestions($args, $type)
		);

		// if the url is: 'http://domain.com/node/123/edit'
		// and node type is 'blog'..
		// 
		// This will be the suggestions:
		//
		// - page__node
		// - page__node__%
		// - page__node__123
		// - page__node__edit
		// - page__type_blog
		// - page__type_blog__%
		// - page__type_blog__123
		// - page__type_blog__edit
		// 
		// Which connects to these templates:
		//
		// - page--node.tpl.php
		// - page--node--%.tpl.php
		// - page--node--123.tpl.php
		// - page--node--edit.tpl.php
		// - page--type-blog.tpl.php          << this is what you want.
		// - page--type-blog--%.tpl.php
		// - page--type-blog--123.tpl.php
		// - page--type-blog--edit.tpl.php
		// 
		// Latter items take precedence.
	}  
}