<?php
/**
 * @file
 * Default theme implementation to display a single Drupal page.
 *
 * The doctype, html, head and body tags are not in this template. Instead they
 * can be found in the html.tpl.php template in this directory.
 *
 * Available variables:
 *
 * Variables:
 * - $site_name: site name
 * - $questions: all available question of the test
 * - $test: all test data
 * - $question_number: questions number
 * - $time: test max time in minutes
 * - $seconds: test max time in seconds
 * - $next: next button text.
 *
 * @ingroup templates
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
global $base_url;

//pdd($form, true);

function loadPartial($fileName, $compact = array()) {

    $partial = file_get_contents($fileName);
    foreach ($compact as $key => $data) {

        $partial = str_replace("[$key]", $data, $partial);
    }
    echo $partial;
}

function arrayToList(array $dataArray) {

    $resultStr = '';
    foreach ($dataArray as $key => $data) {

        $value = 'value="' . $key . '"';
        $resultStr .= "<option $value>$data</option>";
    }
    return $resultStr;
}

$proposal = $form['proposal']['#value'];
$previewTitle = $proposal->title;
$previewContent = $proposal->content;
?>
<body id="proposal_view">
    <div id="preview_operation_bar">
        <?php loadPartial("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/partials/view_operation_bar.tpl.php", ['title' => $previewTitle]); ?>
    </div>
    <div id="app_container">
        <div id="left_side_bar">
            <label><?php echo t('Tartalomjegyzék'); ?></label>
            <div class="headers"></div>
            <?php if ($proposal->accepted == null): ?>
                <div class="accept-form" data-toggle="tooltip" data-placement="top" title="<?php echo t('Az allábbi mezőbe rajzolt szignóddal tudod elfogadni az ajánlatod!'); ?>">
                    <div>Ajánlat elfogadása:</div>
                    <div class="js-signature"></div>
                    <div class="row">
                        <button type="button" class="btn btn-sm btn-default" id="clear_sign" onclick="clearCanvas();"><i class="la la-close"></i></button>
                        <?php print render($form['submit']); ?>
                    </div>
                    <!--                <button type="button" class="btn btn-sm btn-default sr-only" id="save_sign" onclick="saveSignature();">Save</button>
                                    <div id="signature_img" class="sr-only"><p><em>Your signature will appear here when you click "Save Signature"</em></p></div>-->
                    <?php
                    print render($form['hash']);
                    print render($form['canvas']);
                    print render($form['form_id']);
                    print render($form['form_token']);
                    print render($form['form_build_id']);
                    ?>
                </div>
            <?php else: ?>
                <div class="accept-form">
                    <div class="">Ajánlat elfogadva</div>
                    <div class="signature"><img src="<?php echo $proposal->accepted; ?>" /></div>
                    <div class="accepted-at"><?php echo $proposal->accepted_at; ?></div>
                </div>
            <?php endif; ?>
        </div>
        <div id="page_container">
            <div id="zoom_field"></div>
        </div>
    </div>
    <div class="loader">
        <div class="ball-clip-rotate-multiple">
            <div></div>
            <div></div>
        </div>
    </div>
    <div class="pointer"></div>
</body>
<style>
    .pointer {
        position: absolute;
        top: 0;
        left: 0;
        display: none;
        background: #00000050;
        padding: 10px;
    }
</style>

<footer>
    <!--<script src="https://cdn.jsdelivr.net/npm/@editorjs/editorjs@latest"></script>-->

    <script type="text/javascript" src="/<?php print drupal_get_path('module', 'propeditor'); ?>/libraries/editor/helpers/jquery/dist/jquery.js"></script>
    <script type="text/javascript" src="/<?php print drupal_get_path('module', 'propeditor'); ?>/libraries/editor/helpers/bootstrap/js/bootstrap.js"></script>

    <!--<script type="text/javascript" src="https://cdn.quilljs.com/1.2.6/quill.min.js"></script>-->
    <script type="text/javascript" src="/<?php print drupal_get_path('module', 'propeditor'); ?>/libraries/editor/helpers/quill-1.3.7/quill.min.js"></script>

    <script type="text/javascript" src="/<?php print drupal_get_path('module', 'propeditor'); ?>/libraries/editor/helpers/jq.js"></script>
    <script type="text/javascript" src="/<?php print drupal_get_path('module', 'propeditor'); ?>/libraries/editor/helpers/common.js"></script>
    <script type="text/javascript" src="/<?php print drupal_get_path('module', 'propeditor'); ?>/libraries/editor/helpers/view.js"></script>

    <script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/Base64/1.0.1/base64.js"></script>
    <script type="text/javascript" src="/<?php print drupal_get_path('module', 'propeditor'); ?>/assets/plugins/heatmap/heatmap.js"></script>
    <script type="text/javascript" src="/<?php print drupal_get_path('module', 'propeditor'); ?>/assets/plugins/html2canvas/html2canvas.js"></script>
    <script type="text/javascript" src="/<?php print drupal_get_path('module', 'propeditor'); ?>/assets/plugins/jsPDF/jspdf.debug.js"></script>

    <script>

                        $(document).ready(function () {
                            suiter();
                        });

                        $(window).resize(function () {
                            suiter();
                        });

                        const base_url = "<?php echo $base_url . '/'; ?>";

                        const header_nav = '<?php echo urlencode(file_get_contents("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/header_nav.html")); ?>';
                        const preview_stream = '<?php echo urlencode($previewContent); ?>';

                        let params = {
                            pageWidth: Number(jQuery(".page-a4").width()),
                            pageHeight: Number(jQuery(".page-a4").height()),
                            topMargin: 0,
                            leftMargin: 0,
                            totalPages: $(".page-a4").length
                        };
                        let pdf = new jsPDF('p', 'pt', [params.pageWidth, params.pageHeight]);
                        let i = 0;
                        let run = false;

                        let movements = [];
                        let scrolls = [];
                        let clicks = [];

                        $(document).ready(function () {
                            initHeatmap();

                            setTimeout(function () {
                                $('.loader').fadeOut();
                            }, 1000);

                            params.pageWidth = Number($(".page-a4").width());
                            params.pageHeight = Number($(".page-a4").height());
                            params.topMargin = 0;
                            params.leftMargin = 0;
                            params.totalPages = $(".page-a4").length;
                            pdf = new jsPDF('p', 'pt', [params.pageWidth, params.pageHeight]);
                            $(document).on('click', '#op_preview_download', function () {
                                $('.loader').fadeIn();
                                getPDF();
                            });
                        });

                        function generateCanvas() {           //  create a loop function
                            setTimeout(function () {    //  call a 3s setTimeout when the loop is called
                                if (i < params.totalPages) {            //  if the counter < 10, call the loop function
                                    html2canvas($(".page-a4")[i], {allowTaint: true, useCORS: true, scale: 4}).then(function (canvas) {
                                        canvas.getContext('2d');
                                        console.log(canvas.height + "  " + canvas.width);

                                        console.log('params', params);
                                        var imgData = canvas.toDataURL("image/jpeg", 1.0);
                                        pdf.addImage(imgData, 'JPG', params.leftMargin, params.topMargin, params.pageWidth, params.pageHeight);

                                        console.log('step', i);
                                        i++;

                                        if (i < params.totalPages) {
                                            pdf.addPage([params.pageWidth, params.pageHeight]);
                                        }
                                        generateCanvas();             //  ..  again which will trigger another

                                        if (i === params.totalPages) {
//                                                pdf.save("HTML-Document.pdf");
                                            pdf.save("<?php echo $proposal->title; ?>.pdf");
                                            $('.loader').fadeOut();
                                        }
                                    });
                                }
                            }, 1000);
                        }

                        function getPDF() {

                            params.pageWidth = Number($(".page-a4").width());
                            params.pageHeight = Number($(".page-a4").height());
                            params.topMargin = 0;
                            params.leftMargin = 0;
                            params.totalPages = $(".page-a4").length;
                            console.log('params', params);

                            generateCanvas();
                        }

                        function initHeatmap() {
                            // create a heatmap container
                            const heatmapContainer = document.getElementById('proposal_view');
                            const scrollContainer = document.getElementById('page_container');
                            let save = false;
                            let scrollTopPosition = 0;
                            let x = 0;
                            let y = 0;

//                            console.log('heatmap', heatmapContainer);

                            scrollContainer.onscroll = function (event) {
                                event.preventDefault();
                                scrollTopPosition = scrollContainer.scrollTop;
                                $('.pointer').text('x:' + x + ', y:' + (y + scrollTopPosition) + ', offset:' + scrollTopPosition + ', height:' + window.innerHeight);
                                if (!save) {
                                    save = true;
                                    setTimeout(function () {
                                        save = false;
                                    }, 200);
                                    movements.push({x: x, y: y + scrollTopPosition, value: 1, offset: scrollTopPosition, height: window.innerHeight});
                                }
                            };
                            heatmapContainer.onmousemove = heatmapContainer.ontouchmove = function (event) {
                                // we need preventDefault for the touchmove
                                event.preventDefault();
                                event = event || window.event; // IE-ism

                                x = event.pageX;
                                y = event.pageY;
                                if (event.touches) {
                                    x = event.touches[0].pageX;
                                    y = event.touches[0].pageY;
                                }

//                                $('.pointer').css({'left': (event.pageX + 10), 'top': event.pageY});
//                                $('.pointer').text('x:' + x + ', y:' + (y + scrollTopPosition) + ', offset:' + scrollTopPosition + ', height:' + window.innerHeight);

                                if (!save) {
                                    save = true;
                                    setTimeout(function () {
                                        save = false;
                                    }, 200);
                                    movements.push({x: x, y: y + scrollTopPosition, value: 1, offset: scrollTopPosition, height: window.innerHeight});
                                }

                            };

                            heatmapContainer.onclick = function (event) {
                                event.preventDefault();
                                event = event || window.event; // IE-ism

                                x = event.pageX;
                                y = event.pageY;
                                if (event.touches) {
                                    x = event.touches[0].pageX;
                                    y = event.touches[0].pageY;
                                }
                                clicks.push({x: x, y: y + scrollTopPosition, value: 1});
//                                heatmap.addData({x: x, y: y, value: 1});
                            };

//                            document.addEventListener('visibilitychange', function () {
//                                console.log('change', document.visibilityState);
//                            });

                            sender = setInterval(heater, 5000);
                        }

                        function heater() {
//                            console.log('heater', document.visibilityState, movements);
                            if (document.visibilityState === 'visible') {
                                let data = {
                                    page_id: 'view',
                                    moves: movements,
                                    scrolls: scrolls,
                                    clicks: clicks
                                };
                                movements = [];
                                scrolls = [];
                                clicks = [];
                                opix("event", "heat", data);
                            }
                        }

                        function suiter() {
                            // Resize
                            const pages = $('#zoom_field .page-frame').length;
                            const windowWidth = window.innerWidth;
                            const windowHeight = window.innerHeight;
                            const pageWidth = 794 + 32 + 32;
                            const pageHeight = 1123 + 32 + 32;
                            const purePageHeight = 1123;
                            const scale = windowWidth / pageWidth;
                            const translateX = pageWidth * (1 - scale) / 2;
                            const translateY = pageHeight * (1 - scale) / 2;
                            const marginBottom = 2 * translateY + (pageHeight * scale) - 32;
                            const zoomHeight = pageHeight * scale * pages + 50;

                            if (windowWidth <= 768) {
                                $('#zoom_field .page-frame').css({
                                    'transform': 'translate(-' + translateX + 'px, -' + translateY + 'px) scale(' + scale + ')',
                                    'margin-bottom': '-' + marginBottom + 'px'
                                });
                                $('#zoom_field').css({
                                    'height': zoomHeight + 'px',
                                    'overflow': 'hidden'
                                });
                            } else {
                                $('#zoom_field .page-frame').removeAttr('style');
                                $('#zoom_field').removeAttr('style');
                            }
                        }

                        $(function () {
                            jQuery('[data-toggle="tooltip"]').tooltip();
                        });
    </script>

    <?php print render($form['script']); ?>
</footer>