<?php
/**
 * @file
 * Default theme implementation to display a node.
 *
 * Available variables:
 * - $title: the (sanitized) title of the node.
 * - $content: An array of node items. Use render($content) to print them all,
 *   or print a subset such as render($content['field_example']). Use
 *   hide($content['field_example']) to temporarily suppress the printing of a
 *   given element.
 * - $user_picture: The node author's picture from user-picture.tpl.php.
 * - $date: Formatted creation date. Preprocess functions can reformat it by
 *   calling format_date() with the desired parameters on the $created variable.
 * - $name: Themed username of node author output from theme_username().
 * - $node_url: Direct URL of the current node.
 * - $display_submitted: Whether submission information should be displayed.
 * - $submitted: Submission information created from $name and $date during
 *   template_preprocess_node().
 * - $classes: String of classes that can be used to style contextually through
 *   CSS. It can be manipulated through the variable $classes_array from
 *   preprocess functions. The default values can be one or more of the
 *   following:
 *   - node: The current template type; for example, "theming hook".
 *   - node-[type]: The current node type. For example, if the node is a
 *     "Blog entry" it would result in "node-blog". Note that the machine
 *     name will often be in a short form of the human readable label.
 *   - node-teaser: Nodes in teaser form.
 *   - node-preview: Nodes in preview mode.
 *   The following are controlled through the node publishing options.
 *   - node-promoted: Nodes promoted to the front page.
 *   - node-sticky: Nodes ordered above other non-sticky nodes in teaser
 *     listings.
 *   - node-unpublished: Unpublished nodes visible only to administrators.
 * - $title_prefix (array): An array containing additional output populated by
 *   modules, intended to be displayed in front of the main title tag that
 *   appears in the template.
 * - $title_suffix (array): An array containing additional output populated by
 *   modules, intended to be displayed after the main title tag that appears in
 *   the template.
 *
 * Other variables:
 * - $node: Full node object. Contains data that may not be safe.
 * - $type: Node type; for example, story, page, blog, etc.
 * - $comment_count: Number of comments attached to the node.
 * - $uid: User ID of the node author.
 * - $created: Time the node was published formatted in Unix timestamp.
 * - $classes_array: Array of html class attribute values. It is flattened
 *   into a string within the variable $classes.
 * - $zebra: Outputs either "even" or "odd". Useful for zebra striping in
 *   teaser listings.
 * - $id: Position of the node. Increments each time it's output.
 *
 * Node status variables:
 * - $view_mode: View mode; for example, "full", "teaser".
 * - $teaser: Flag for the teaser state (shortcut for $view_mode == 'teaser').
 * - $page: Flag for the full page state.
 * - $promote: Flag for front page promotion state.
 * - $sticky: Flags for sticky post setting.
 * - $status: Flag for published status.
 * - $comment: State of comment settings for the node.
 * - $readmore: Flags true if the teaser content of the node cannot hold the
 *   main body content.
 * - $is_front: Flags true when presented in the front page.
 * - $logged_in: Flags true when the current user is a logged-in member.
 * - $is_admin: Flags true when the current user is an administrator.
 *
 * Field variables: for each field instance attached to the node a corresponding
 * variable is defined; for example, $node->body becomes $body. When needing to
 * access a field's raw values, developers/themers are strongly encouraged to
 * use these variables. Otherwise they will have to explicitly specify the
 * desired field language; for example, $node->body['en'], thus overriding any
 * language negotiation rule that was previously applied.
 *
 * @see template_preprocess()
 * @see template_preprocess_node()
 * @see template_process()
 *
 * @ingroup templates
 */
$emails_count = count($emails);
$accepted = $proposal->accepted_at != null;
//$at = date('Y-m-d H:i:s', 1569856055681 / 1000);
//pdd($login_stat);

sort($groups);
$groups[] = 992;
?>
<section id="proposal-stat" class="">
    <div class="row">
        <div class="col-12">
            <h1 class="page-header"><em><?php echo $proposal->title; ?></em> statisztika</h1>
        </div>
    </div>
    <div class="row">
        <div class="col-8">
            <div class="row">
                <div class="col-12">
                    <h3 class=""><?php echo t('Ajánlat állapota'); ?></h3>
                </div>
                <div class="col-9">
                    <!-- START card-->
                    <div class="card">
                        <div class="progress progress-card-top">
                            <div class="progress-bar bg-success" role="progressbar"
                                 aria-valuenow="60" aria-valuemin="0" aria-valuemax="100" style="width: calc( 100% / 3 * <?php echo $emails_count; ?> );"></div>
                        </div>
                        <div class="d-flex">
                            <div class="w-50  br px-3">
                                <div class="d-flex align-items-center pt-3 mh-46">
                                    <!-- Bar chart-->
                                    <!--<div data-sparkline="" data-bar-color="#5d9cec" data-height="20" data-bar-width="3" data-bar-spacing="2" data-values="0,0,0,0,0,0,0,0,0,0,0,0,5,9,4,1,3,4,7,5"></div>-->
                                    <div data-sparkline="" data-bar-color="#5d9cec" data-height="20" data-bar-width="3" data-bar-spacing="2" data-values="<?php echo $emails[0]->opens_list; ?>"></div>
                                    <div class="ml-auto">
                                        <div class="card-body text-right p-0">
                                            <h4 class="mb-0"><?php echo $emails[0]->opens; ?></h4>
                                        </div>
                                    </div>
                                </div>
                                <p class="text-muted my-2 text-right"><?php echo t('1. email megnyitások'); ?></p>
                            </div>
                            <?php if ($emails_count > 1): ?>
                                <div class="w-50  br px-3">
                                    <div class="d-flex align-items-center pt-3 mh-46">
                                        <!-- Bar chart-->
                                        <div data-sparkline="" data-bar-color="#5d9cec" data-height="20" data-bar-width="3" data-bar-spacing="2" data-values="<?php echo $emails[1]->opens_list; ?>"></div>
                                        <div class="ml-auto">
                                            <div class="card-body text-right p-0">
                                                <h4 class="mb-0"><?php echo $emails[1]->opens; ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                    <p class="text-muted my-2 text-right"><?php echo t('2. email megnyitások'); ?></p>
                                </div>
                            <?php else: ?>
                                <div class="w-50 px-3">
                                    <div class="d-flex align-items-center pt-3 mh-46">
                                        <!-- Bar chart-->
                                        <?php if ($accepted): ?>
                                            <em class="la la-ban la-2x text-dark ml-4"></em>
                                        <?php else: ?>
                                            <em class="la la-hourglass-half la-2x text-dark ml-4"></em>
                                        <?php endif; ?>
                                        <div class="ml-auto">
                                            <div class="card-body text-right p-0">
                                                <h4 class="mt-0">...</h4>
                                            </div>
                                        </div>
                                    </div>
                                    <p class="text-muted my-2 text-right"><?php echo t('2. email kiküldés'); ?></p>
                                </div>
                            <?php endif; ?>
                            <?php if ($emails_count > 2): ?>
                                <div class="w-50 px-3">
                                    <div class="d-flex align-items-center pt-3 mh-46">
                                        <!-- Bar chart-->
                                        <div data-sparkline="" data-bar-color="#5d9cec" data-height="20" data-bar-width="3" data-bar-spacing="2" data-values="<?php echo $emails[2]->opens_list; ?>"></div>
                                        <div class="ml-auto">
                                            <div class="card-body text-right p-0">
                                                <h4 class="mb-0"><?php echo $emails[2]->opens; ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                    <p class="text-muted my-2 text-right"><?php echo t('3. email megnyitások'); ?></p>
                                </div>
                            <?php else: ?>
                                <div class="w-50 px-3">
                                    <div class="d-flex align-items-center pt-3 mh-46">
                                        <!-- Bar chart-->
                                        <?php if ($accepted): ?>
                                            <em class="la la-ban la-2x text-dark ml-4"></em>
                                        <?php else: ?>
                                            <em class="la la-hourglass-half la-2x text-dark ml-4"></em>
                                        <?php endif; ?>
                                        <div class="ml-auto">
                                            <div class="card-body text-right p-0">
                                                <h4 class="mt-0">...</h4>
                                            </div>
                                        </div>
                                    </div>
                                    <p class="text-muted my-2 text-right"><?php echo t('3. email kiküldés'); ?></p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="col-3">
                    <!-- START card-->
                    <!-- START card-->
                    <?php if ($accepted): ?>
                        <div class="card accepted" style="background-image: url('<?php echo $proposal->accepted; ?>'); ">
                        <?php else: ?>
                            <div class="card">
                            <?php endif; ?>
                            <div class="progress progress-card-top">
                                <div class="progress-bar bg-success" role="progressbar"
                                     aria-valuenow="60" aria-valuemin="0" aria-valuemax="100" style="width: calc( 100% * <?php echo (int) $accepted; ?> );"></div>
                            </div>
                            <div class="">
                                <?php if ($accepted): ?>
                                    <div class="px-3">
                                        <div class="d-flex align-items-center pt-3">
                                            <!-- Bar chart-->
                                            <em class="la la-check la-2x text-success mx-1"></em>
                                            <div class="ml-auto">
                                                <div class="card-body text-right p-0">
                                                    <h4 class="mt-0"><?php echo t('Elfogadva'); ?></h4>
                                                </div>
                                            </div>
                                        </div>
                                        <p class="text-muted my-2 text-right"><?php echo $proposal->accepted_at; ?></p>
                                    </div>
                                <?php else: ?>
                                    <div class="px-3">
                                        <div class="d-flex align-items-center">
                                            <em class="la la-hourglass-half la-2x text-dark mx-1"></em>
                                            <div class="ml-auto">
                                                <div class="card-body text-right">
                                                    <h4 class="mt-0"><?php echo t('Várakozik'); ?></h4>
                                                    <p class="mb-0 text-muted">...</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <!-- END card-->
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <h3 class=""><?php echo t('Látogatások'); ?></h3>
                    </div>
                    <div class="col-6">
                        <h4 class=""><?php echo t('Érkező oldal'); ?></h4>
                        <!-- START card-->
                        <div class="card">
                            <div class="d-flex">
                                <div class="w-50 bb br px-3">
                                    <div class="d-flex align-items-center pt-3">
                                        <!-- Bar chart-->
                                        <div data-sparkline="" data-bar-color="#5d9cec" data-height="20" data-bar-width="3" data-bar-spacing="2" data-values="<?php echo $login_stat['visits_data']; ?>"></div>
                                        <div class="ml-auto">
                                            <div class="card-body text-right p-0">
                                                <h4 class="mb-0"><?php echo count($login_stat['visits']); ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                    <p class="text-muted my-2 text-right"><?php echo t('Megtekintések'); ?></p>
                                </div>
                                <div class="w-50 bb px-3">
                                    <div class="d-flex align-items-center pt-3">
                                        <!-- Bar chart-->
                                        <div data-sparkline="" data-bar-color="#5d9cec" data-tooltip-format="{{value}} sec" data-height="20" data-bar-width="3" data-bar-spacing="2" data-values="<?php echo $login_stat['times_data']; ?>"></div>
                                        <div class="ml-auto">
                                            <div class="card-body text-right p-0">
                                                <h4 class="mb-0"><?php echo count($login_stat['times']) > 0 ? round(array_sum($login_stat['times']) / count($login_stat['times']), 1) : 0; ?>&nbsp;s</h4>
                                            </div>
                                        </div>
                                    </div>
                                    <p class="text-muted my-2 text-right"><?php echo t('Átlagos időtartam'); ?></p>
                                </div>
                            </div>
                            <div class="d-flex">
                                <div class="w-50 br px-3">
                                    <div class="d-flex align-items-center pt-3">
                                        <!-- Bar chart-->
                                        <div data-sparkline="" data-bar-color="#5d9cec" data-height="20" data-bar-width="3" data-bar-spacing="2" data-values="<?php echo $login_stat['returns_data']; ?>"></div>
                                        <div class="ml-auto">
                                            <div class="card-body text-right p-0">
                                                <h4 class="mb-0"><?php echo $login_stat['returns']; ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                    <p class="text-muted my-2 text-right"><?php echo t('Visszatérések'); ?></p>
                                </div>
                                <div class="w-50 px-3">
                                    <div class="d-flex align-items-center pt-3">
                                        <!-- Bar chart-->
                                        <div data-sparkline="" data-bar-color="#5d9cec" data-height="20" data-bar-width="3" data-bar-spacing="2" data-values="<?php echo $login_stat['uniques_data']; ?>"></div>
                                        <div class="ml-auto">
                                            <div class="card-body text-right p-0">
                                                <h4 class="mb-0"><?php echo count($login_stat['unique']); ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                    <p class="text-muted my-2 text-right"><?php echo t('Egyedi látogatók'); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-6">
                        <h4 class=""><?php echo t('Ajánlat oldal'); ?></h4>
                        <!-- START card-->
                        <div class="card">
                            <div class="d-flex">
                                <div class="w-50 bb br px-3">
                                    <div class="d-flex align-items-center pt-3">
                                        <!-- Bar chart-->
                                        <div data-sparkline="" data-bar-color="#5d9cec" data-height="20" data-bar-width="3" data-bar-spacing="2" data-values="<?php echo $view_stat['visits_data']; ?>"></div>
                                        <div class="ml-auto">
                                            <div class="card-body text-right p-0">
                                                <h4 class="mb-0"><?php echo count($view_stat['visits']); ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                    <p class="text-muted my-2 text-right"><?php echo t('Megtekintések'); ?></p>
                                </div>
                                <div class="w-50 bb px-3">
                                    <div class="d-flex align-items-center pt-3">
                                        <!-- Bar chart-->
                                        <div data-sparkline="" data-bar-color="#5d9cec" data-height="20" data-bar-width="3" data-bar-spacing="2" data-values="<?php echo $view_stat['times_data']; ?>"></div>
                                        <div class="ml-auto">
                                            <div class="card-body text-right p-0">
                                                <h4 class="mb-0"><?php echo count($view_stat['times']) > 0 ? round(array_sum($view_stat['times']) / count($view_stat['times']), 1) : 0; ?>&nbsp;s</h4>
                                            </div>
                                        </div>
                                    </div>
                                    <p class="text-muted my-2 text-right"><?php echo t('Átlagos időtartam'); ?></p>
                                </div>
                            </div>
                            <div class="d-flex">
                                <div class="w-50 br px-3">
                                    <div class="d-flex align-items-center pt-3">
                                        <!-- Bar chart-->
                                        <div data-sparkline="" data-bar-color="#5d9cec" data-height="20" data-bar-width="3" data-bar-spacing="2" data-values="<?php echo $view_stat['returns_data']; ?>"></div>
                                        <div class="ml-auto">
                                            <div class="card-body text-right p-0">
                                                <h4 class="mb-0"><?php echo $view_stat['returns']; ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                    <p class="text-muted my-2 text-right"><?php echo t('Visszatérések'); ?></p>
                                </div>
                                <div class="w-50 px-3">
                                    <div class="d-flex align-items-center pt-3">
                                        <!-- Bar chart-->
                                        <div data-sparkline="" data-bar-color="#5d9cec" data-height="20" data-bar-width="3" data-bar-spacing="2" data-values="<?php echo $view_stat['uniques_data']; ?>"></div>
                                        <div class="ml-auto">
                                            <div class="card-body text-right p-0">
                                                <h4 class="mb-0"><?php echo count($view_stat['unique']); ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                    <p class="text-muted my-2 text-right"><?php echo t('Egyedi látogatók'); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-4">
                <h3 class=""><?php echo t('Események'); ?></h3>
                <!-- START list group-->
                <div class="log-col">
                    <div class="list-group mb-0">
                        <?php foreach ($events_log as $event): ?>
                            <span class="list-group-item list-group-item-action">
                                <span class="badge badge-purple float-right"><?php echo $event['at']; ?></span>
                                <em class="fa-fw <?php echo $event['icon']; ?> mr-2"></em><?php echo $event['text']; ?></span>
                        <?php endforeach; ?>
                    </div>
                </div>
                <!-- END list group-->
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <h3 class=""><?php echo t('Viselkedés'); ?></h3>
            </div>
            <div class="col-12">
                <div class="card card-default-off">
                    <div class="card-header">Hőtérképek</div>
                    <div class="card-body">
                        <div role="tabpanel" style="position: relative;">
                            <div class="btn-group-toggle" id="hmMode" data-toggle="buttons" style="position: absolute;left: 0;top: 0;">
                                <label class="btn btn-primary active">
                                    <input id="option-moves" type="radio" name="options" checked="" value="moves"><?php echo t('Mozgás'); ?></label>
                                <label class="btn btn-primary">
                                    <input id="option-clicks" type="radio" name="options" value="clicks"><?php echo t('Kattintások'); ?></label>
                            </div>
                            <!-- Nav tabs-->
                            <ul class="nav nav-pills pb-2 btn-group-toggle justify-content-end" role="tablist">
                                <?php foreach ($groups as $k => $width): ?>
                                    <li class="nav-item <?php echo $k === 0 ? 'active' : ''; ?>" role="presentation">
                                        <a class="nav-link btn btn-primary" href="#hm-<?php echo $width; ?>" aria-controls="hm-<?php echo $width; ?>" role="tab" data-width="<?php echo $width; ?>" data-toggle="tab" aria-selected="true"><?php echo $width === 992 ? t('Összesített') : $width . 'px'; ?></a>
                                    </li>
                                <?php endforeach; ?>
                                <!--                                <li class="nav-item" role="presentation">
                                                                    <a class="nav-link btn btn-primary" href="#hm-992" aria-controls="hm-992" role="tab" data-width="992" data-toggle="tab" aria-selected="true"><?php echo t('Összesített'); ?></a>
                                                                </li>-->
                            </ul>
                            <!-- Tab panes-->
                            <div class="tab-content p-0 b-0">
                                <?php foreach ($groups as $k => $width): ?>
                                    <div class="tab-pane heatmap-wrapper <?php echo $k === 0 ? 'active' : ''; ?>" id="hm-<?php echo $width; ?>"  role="tabpanel">
                                        <?php if ($k === 0): ?>
                                            <div class="heatmap" style="margin: auto;">
                                                <iframe id="hmIrfame-<?php echo $width; ?>" frameborder="0" data-width="<?php echo $width; ?>" src="<?php echo str_replace('stat', 'preview', "//$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]"); ?>" style="width: 100%; height: 550px;" ></iframe>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; ?>
                                <!--                                <div class="tab-pane heatmap-wrapper" id="hm-992"  role="tabpanel">
                                                                </div>-->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <style>

            #heatmapLegend { background:white; position:absolute; bottom:0; right:0; padding:10px; }
            #min { float:left; }
            #max { float:right; }
        </style>
        </article>
        <script type="text/javascript" src="/<?php print drupal_get_path('module', 'propeditor'); ?>/assets/plugins/heatmap/heatmap.js"></script>
        <script src="/<?php print drupal_get_path('theme', 'crt'); ?>/assets/vendor/jquery-sparkline/jquery.sparkline.js"></script>
        <script src="/<?php print drupal_get_path('theme', 'crt'); ?>/assets/js/app.js"></script>

        <script>
(function ($) {
    const groups = <?php echo json_encode($groups); ?>;
    const clicks = <?php echo json_encode($clicks); ?>;
    const moves = <?php echo json_encode($moves); ?>;
    const heatmaps = {};
    let baseHeight = 0;
    let hmMode = 'moves';

    $(document).ready(function () {
//        console.log('ready');

        $('iframe').each(function () {
            document.getElementById($(this).attr('id')).onload = function (ev) {
                console.log('irfame load', ev);
                set_iframe_height(ev.target.id, ev.target.attributes['data-width'].value);
            };
        });

        $('.nav-link[data-toggle]').on('click', function () {
            const width = $(this).attr('data-width');
            const wrapperWidth = $('.heatmap-wrapper').parent().innerWidth();
            const translate = wrapperWidth / width;
            const suiter = 'transform: translate(' + (translate - 1) / 2 * 100 + '%, ' + (translate - 1) / 2 * 100 + '%) scale(' + translate + ')';
//            console.log('suiter', suiter, width, wrapperWidth, translate);
            const ifrm = '<div class="heatmap" style="margin: auto; width: ' + width +
                    'px;' + (wrapperWidth < Number(width) ? suiter : '') + ';"><iframe id="hmIrfame-' + width +
                    '" frameborder="0" data-width="' + width +
                    '" src="<?php echo str_replace('stat', 'preview', "//$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]"); ?>" style="width: ' + width +
                    'px; height: 550px;" ></iframe></div>';
//            console.log('ifrm', $($(this).attr('href')).html().trim().length, $($(this).attr('href')), ifrm);
            if ($($(this).attr('href')).html().trim().length === 0) {
                $($(this).attr('href')).html(ifrm);
                document.getElementById('hmIrfame-' + width).onload = function (ev) {
//                    console.log('irfame load', ev);
                    set_iframe_height(ev.target.id, ev.target.attributes['data-width'].value);
                };
            } else {
                setHeatData(heatmaps[width], Object.values(moves[width]), moves[width]['max']);
            }
        });

    });

    function set_iframe_height(id, width = null) {
        var ifrm = document.getElementById(id);
        var doc = ifrm.contentDocument ? ifrm.contentDocument :
                ifrm.contentWindow.document;
        var newHeight = get_doc_height(doc) + 4;
        doc.getElementById('page_container').style.overflow = 'visible';
        ifrm.style.visibility = 'hidden';
        ifrm.style.height = "550px"; // reset to minimal height ...
        // IE opt. for bing/msn needs a bit added or scrollbar appears
        ifrm.style.height = newHeight > baseHeight ? newHeight + 'px' : baseHeight + 'px';
        ifrm.style.visibility = 'visible';
//        console.log('heatmaps', heatmaps, width, Object.keys(moves), Object.keys(clicks));
//        console.log('set', hmMode, baseHeight, newHeight, width, moves[width]['max'], clicks[width]['max']);

//        console.log('heatmaps', heatmaps, width);
        if (width < 992 || width < $('.heatmap-wrapper').innerWidth()) {
            ifrm.style.width = width + 'px';
            ifrm.parentNode.style.width = width + 'px';
            setTimeout(function () {
                var nh = doc.getElementById('zoom_field').style.height;
                ifrm.style.height = Number(nh.substr(0, nh.length - 2)) + 45 + 'px';

                var heatmapInstance = h337.create({
                    container: document.querySelector('#hm-' + width + ' .heatmap'),
                    radius: 30
                });
                heatmaps[width] = heatmapInstance;
                setHeatData(heatmapInstance, Object.values(moves[width]), moves[width]['max']);

                $('body').on('click.xs', '#hmMode label', function (ev) {
                    hmMode = ev.target.children[0].value;
//                    console.log('radio', hmMode);
                    if (hmMode === 'clicks') {
                        setHeatData(heatmapInstance, Object.values(clicks[width]), clicks[width]['max']);
                    } else {
                        setHeatData(heatmapInstance, Object.values(moves[width]), moves[width]['max']);

                    }
                });
            }, 500);
        } else {

            setTimeout(function () {
                var heatmapInstance = h337.create({
                    container: document.querySelector('#hm-' + width + ' .heatmap'),
                    radius: 30
                });
                heatmaps[width] = heatmapInstance;
                setHeatData(heatmapInstance, Object.values(moves[width]), moves[width]['max']);

                $('body').on('click.md', '#hmMode label', function (ev) {
                    hmMode = ev.target.children[0].value;
                    console.log('radio', hmMode);
                    if (hmMode === 'clicks') {
                        setHeatData(heatmapInstance, Object.values(clicks[width]), clicks[width]['max']);
                    } else {
                        setHeatData(heatmapInstance, Object.values(moves[width]), moves[width]['max']);
                    }
                });
            }, 500);
    }
//        console.log('heatmaps', heatmaps);
    }

    function setHeatData(heatmapInstance, points, maximum = 1) {
        heatmapInstance.setData({
            min: 0,
            max: maximum,
            data: points
        });
    }

    function get_doc_height(doc) {
        doc = doc || document;
        // stackoverflow.com/questions/1145850/
        var body = doc.body, html = doc.documentElement;
        var height = Math.max(body.scrollHeight, body.offsetHeight, doc.getElementById('zoom_field').scrollHeight,
                doc.getElementById('zoom_field').clientHeight, doc.getElementById('zoom_field').offsetHeight,
                html.clientHeight, html.scrollHeight, html.offsetHeight) + 45;
        baseHeight = height;
        return height;
    }

//                            document.querySelector('.heatmap-wrapper').onclick = function (ev) {
//                                heatmapInstance.addData({
//                                    x: ev.layerX,
//                                    y: ev.layerY,
//                                    value: 1
//                                });
//                            };

    /* tooltip code start */
//                            var demoWrapper = document.querySelector('.heatmap-wrapper');
//                            var tooltip = document.querySelector('.tooltip');
//                            function updateTooltip(x, y, value) {
//                                // + 15 for distance to cursor
//                                var transl = 'translate(' + (x + 15) + 'px, ' + (y + 15) + 'px)';
//                                tooltip.style.webkitTransform = transl;
//                                tooltip.innerHTML = value;
//                            }
//                            ;
//                            demoWrapper.onmousemove = function (ev) {
//                                var x = ev.layerX;
//                                var y = ev.layerY;
//                                // getValueAt gives us the value for a point p(x/y)
//                                var value = heatmapInstance.getValueAt({
//                                    x: x,
//                                    y: y
//                                });
//                                tooltip.style.display = 'block';
//                                updateTooltip(x, y, value);
//                            };
//                            // hide tooltip on mouseout
//                            demoWrapper.onmouseout = function () {
//                                tooltip.style.display = 'none';
//                            };
//                            /* tooltip code end */
})(jQuery);
        </script>