<?php
/**
 * @file
 * Default theme implementation to display a single Drupal page.
 *
 * The doctype, html, head and body tags are not in this template. Instead they
 * can be found in the html.tpl.php template in this directory.
 *
 * Available variables:
 *
 * Variables:
 * - $site_name: site name
 * - $questions: all available question of the test
 * - $test: all test data
 * - $question_number: questions number
 * - $time: test max time in minutes
 * - $seconds: test max time in seconds
 * - $next: next button text.
 *
 * @ingroup templates
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
global $base_url;

function loadPartial($fileName, $compact = array()) {

    $partial = file_get_contents($fileName);
    foreach ($compact as $key => $data) {

        $partial = str_replace("[$key]", $data, $partial);
    }
    echo $partial;
}

function arrayToList(array $dataArray) {

    $resultStr = '';
    foreach ($dataArray as $key => $data) {

        $value = 'value="' . $key . '"';
        $resultStr .= "<option $value>$data</option>";
    }
    return $resultStr;
}

$previewTitle = $proposal->title;
$previewContent = $proposal->content;
$updated = isset($_GET['updated']);
?>
<body>
    <?php loadPartial("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/partials/component_modal.tpl.php"); ?>
    <div id="preview_operation_bar">
        <?php loadPartial("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/partials/preview_operation_bar.tpl.php", ['title' => $previewTitle]); ?>
    </div>
    <div id="app_container">
        <div id="left_side_bar">
            <label>Tartalomjegyzék</label>
        </div>
        <div id="page_container">
            <div id="zoom_field"></div>
        </div>
    </div>

    <section id="thumbnail" style="display: none;"></section>
</body>

<footer>
    <!--<script src="https://cdn.jsdelivr.net/npm/@editorjs/editorjs@latest"></script>-->

    <script src="/<?php print drupal_get_path('module', 'propeditor'); ?>/libraries/editor/helpers/jquery/dist/jquery.js"></script>
    <script src="/<?php print drupal_get_path('module', 'propeditor'); ?>/libraries/editor/helpers/bootstrap/js/bootstrap.js"></script>

    <!--<script src="https://cdn.quilljs.com/1.2.6/quill.min.js"></script>-->
    <script type="text/javascript" src="/<?php print drupal_get_path('module', 'propeditor'); ?>/libraries/editor/helpers/quill-1.3.7/quill.min.js"></script>

    <script src="/<?php print drupal_get_path('module', 'propeditor'); ?>/libraries/editor/helpers/common.js"></script>
    <script src="/<?php print drupal_get_path('module', 'propeditor'); ?>/libraries/editor/helpers/preview.js"></script>

    <script>
        $(document).ready(function () {
            suiter();
        });

        $(window).resize(function () {
            suiter();
        });

        const base_url = "<?php echo $base_url . '/'; ?>";

        const header_nav = '<?php echo urlencode(file_get_contents("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/header_nav.html")); ?>';
        const preview_stream = '<?php echo urlencode($previewContent); ?>';

        function suiter() {
            // Resize
            const pages = $('#zoom_field .page-frame').length;
            const windowWidth = window.innerWidth;
            const windowHeight = window.innerHeight;
            const pageWidth = 794 + 32 + 32;
            const pageHeight = 1123 + 32 + 32;
            const purePageHeight = 1123;
            const scale = windowWidth / pageWidth;
            const translateX = pageWidth * (1 - scale) / 2;
            const translateY = pageHeight * (1 - scale) / 2;
            const marginBottom = 2 * translateY + (pageHeight * scale) - 32;
            const zoomHeight = pageHeight * scale * pages + 50;
//            console.log('list', windowWidth, windowHeight, pageWidth, pageHeight, scale, translateX, translateY);

            if (windowWidth <= 768) {
                $('#zoom_field .page-frame').css({
                    'transform': 'translate(-' + translateX + 'px, -' + translateY + 'px) scale(' + scale + ')',
                    'margin-bottom': '-' + marginBottom + 'px'
                });
                $('#zoom_field').css({
                    'height': zoomHeight + 'px',
                    'overflow': 'hidden'
                });
            } else {
                $('#zoom_field .page-frame').removeAttr('style');
                $('#zoom_field').removeAttr('style');
            }
        }
    </script>

    <?php
    if ($updated):
        ?>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/Base64/1.0.1/base64.js"></script>
        <script src="/<?php print drupal_get_path('module', 'propeditor'); ?>/assets/plugins/html2canvas/html2canvas.js"></script>
        <script>
            $(document).ready(function () {
                setTimeout(function () {
                    var src = document.querySelector("#zoom_field .page-frame .page-a4:first-child");
                    var img = document.getElementById("thumbnail");
                    // Generate first canvas
                    html2canvas(document.querySelector('#zoom_field .page-frame .page-a4:first-child'), {
                        allowTaint: true,
                        useCORS: true,
                        scale: 1
                    }).then(function (canvas) {
                        console.log('scale', window.devicePixelRatio);
                        document.body.appendChild(canvas);
                        $("#thumbnail").html(canvas);

                        const url = "<?php echo $base_url; ?>/propeditor/api/v1/save-thumbnail";
                        const data = {
                            hash: '<?php echo $template->hash; ?>',
                            thumbnail: document.querySelector('#thumbnail canvas').toDataURL('image/jpeg')
                        };
                        $.ajax({
                            type: "json",
                            method: "POST",
                            processData: "true",
                            cache: "cache",
                            contentType: "application/x-www-form-urlencoded",
                            url: url,
                            data: data,
                            beforeSend: function () {},
                            success: function (response) {},
                            complete: function () {},
                            error: function () {}
                        });
                    });
                }, 2000);
            });
        </script>
    <?php endif; ?>
</footer>