<?php
/**
 * @file
 * Default theme implementation to display the basic html structure of a single
 * Drupal page.
 *
 * Variables:
 * - $css: An array of CSS files for the current page.
 * - $language: (object) The language the site is being displayed in.
 *   $language->language contains its textual representation.
 *   $language->dir contains the language direction. It will either be 'ltr' or
 *   'rtl'.
 * - $html_attributes:  String of attributes for the html element. It can be
 *   manipulated through the variable $html_attributes_array from preprocess
 *   functions.
 * - $html_attributes_array: An array of attribute values for the HTML element.
 *   It is flattened into a string within the variable $html_attributes.
 * - $body_attributes:  String of attributes for the BODY element. It can be
 *   manipulated through the variable $body_attributes_array from preprocess
 *   functions.
 * - $body_attributes_array: An array of attribute values for the BODY element.
 *   It is flattened into a string within the variable $body_attributes.
 * - $rdf_namespaces: All the RDF namespace prefixes used in the HTML document.
 * - $grddl_profile: A GRDDL profile allowing agents to extract the RDF data.
 * - $head_title: A modified version of the page title, for use in the TITLE
 *   tag.
 * - $head_title_array: (array) An associative array containing the string parts
 *   that were used to generate the $head_title variable, already prepared to be
 *   output as TITLE tag. The key/value pairs may contain one or more of the
 *   following, depending on conditions:
 *   - title: The title of the current page, if any.
 *   - name: The name of the site.
 *   - slogan: The slogan of the site, if any, and if there is no title.
 * - $head: Markup for the HEAD section (including meta tags, keyword tags, and
 *   so on).
 * - $styles: Style tags necessary to import all CSS files for the page.
 * - $scripts: Script tags necessary to load the JavaScript files and settings
 *   for the page.
 * - $page_top: Initial markup from any modules that have altered the
 *   page. This variable should always be output first, before all other dynamic
 *   content.
 * - $page: The rendered page content.
 * - $page_bottom: Final closing markup from any modules that have altered the
 *   page. This variable should always be output last, after all other dynamic
 *   content.
 * - $classes String of classes that can be used to style contextually through
 *   CSS.
 *
 * @see bootstrap_preprocess_html()
 * @see template_preprocess()
 * @see template_preprocess_html()
 * @see template_process()
 *
 * @ingroup templates
 */
?><!DOCTYPE html>
<html<?php print $html_attributes; ?><?php print $rdf_namespaces; ?>>
    <head>
        <link rel="profile" href="<?php print $grddl_profile; ?>" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <?php print $head; ?>
        <title><?php print $head_title; ?></title>

        <link rel="stylesheet" href="/<?php print drupal_get_path('module', 'propeditor'); ?>/libraries/editor/helpers/bootstrap/css/bootstrap.btn.css">
        <link rel="stylesheet" href="/<?php print drupal_get_path('module', 'propeditor'); ?>/libraries/editor/helpers/bootstrap/css/bootstrap.loader.css">
        <link rel="stylesheet" href="/<?php print drupal_get_path('module', 'propeditor'); ?>/libraries/editor/helpers/bootstrap/css/bootstrap.css">
        <link rel="stylesheet" href="/<?php print drupal_get_path('module', 'propeditor'); ?>/libraries/editor/helpers/bootstrap/css/bootstrap-theme.min.css">
        <link rel="stylesheet" href="/<?php print drupal_get_path('module', 'propeditor'); ?>/libraries/editor/helpers/font-awesome/css/font-awesome.min.css">
        <link rel="stylesheet" href="/<?php print drupal_get_path('module', 'propeditor'); ?>/libraries/editor/helpers/line-awesome/css/line-awesome.min.css">
        <!--<link href="https://cdn.quilljs.com/1.2.6/quill.snow.css" rel="stylesheet">-->

        <link rel="stylesheet" href="/<?php print drupal_get_path('module', 'propeditor'); ?>/libraries/editor/helpers/quill-1.3.7/quill.snow.css">
        <link rel="stylesheet" href="/<?php print drupal_get_path('module', 'propeditor'); ?>/libraries/editor/preview.css">
        <!-- HTML5 element support for IE6-8 -->
        <!--[if lt IE 9]>
          <script src="https://cdn.jsdelivr.net/html5shiv/3.7.3/html5shiv-printshiv.min.js"></script>
        <![endif]-->
        <?php // print $scripts;  ?>

        <!-- Matomo -->
        <script type="text/javascript">
//            var _paq = window._paq || [];
//            /* tracker methods like "setCustomDimension" should be called before "trackPageView" */
//            _paq.push(['trackPageView']);
//            _paq.push(['enableLinkTracking']);
//            (function () {
//                var u = "//proposeasy.dev.vallalatiszoftver.hu/matomo/";
//                _paq.push(['setTrackerUrl', u + 'matomo.php']);
//                _paq.push(['setSiteId', '1']);
//                var d = document, g = d.createElement('script'), s = d.getElementsByTagName('script')[0];
//                g.type = 'text/javascript';
//                g.async = true;
//                g.defer = true;
//                g.src = u + 'matomo.js';
//                s.parentNode.insertBefore(g, s);
//            })();
        </script>
        <!-- End Matomo Code -->

    </head>
    <?php print $page; ?>
</html>
