<?php
/**
 * @file
 * Default theme implementation to display a single Drupal page.
 *
 * The doctype, html, head and body tags are not in this template. Instead they
 * can be found in the html.tpl.php template in this directory.
 *
 * Available variables:
 *
 * Variables:
 * - $site_name: site name
 * - $questions: all available question of the test
 * - $test: all test data
 * - $question_number: questions number
 * - $time: test max time in minutes
 * - $seconds: test max time in seconds
 * - $next: next button text.
 *
 * @ingroup templates
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
global $base_url;

function loadPartial($fileName, $compact = array()) {

    $compact['tooltip'] = isset($compact['tooltip']) ? $compact['tooltip'] : 'false';
    $compact['tooltip_text'] = isset($compact['tooltip_text']) ? $compact['tooltip_text'] : '';
    $compact['icon'] = isset($compact['icon']) ? $compact['icon'] : '';
    $compact['operation_icon'] = isset($compact['operation_icon']) ? $compact['operation_icon'] : '';

    $partial = file_get_contents($fileName);
    foreach ($compact as $key => $data) {

        $partial = str_replace("[$key]", $data, $partial);
    }
    echo $partial;
}

function arrayToList(array $dataArray) {

    $resultStr = '';
    foreach ($dataArray as $key => $data) {

        $value = 'value="' . $key . '"';
        $resultStr .= "<option $value>$data</option>";
    }
    return $resultStr;
}
?>
<body>
    <?php
    loadPartial("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/partials/token_editor_modal.tpl.php");
    loadPartial("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/partials/component_modal.tpl.php");
    ?>
    <div id="top_bar">
        <?php loadPartial("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/partials/top_bar.tpl.php"); ?>
    </div>
    <div id="toastr_container"></div>
    <div id="app_container">
        <div id="left_side_bar">
            <div id="layer_panel">
                <div id="layer_panel_header">
                    <label><?php echo t('Rétegek'); ?></label>
                    <span id="add_new_a4"><i class="la la-file"></i> <?php echo t('Új oldal'); ?></span>
                </div>
                <div id="layer_panel_tree">
                </div>
            </div>
            <div id="component_element_panel">
                <div class="common-tab-bar">
                    <div class="common-tab-pillow active" data-target="#element_panel">
                        <i class="la la-lg la-cube"></i>
                        <span><?php echo t('Elemek'); ?></span>
                    </div>
                    <div class="common-tab-pillow" data-target="#component_panel">
                        <i class="la la-lg la-image"></i>
                        <span><?php echo t('Blokkok'); ?></span>
                    </div>
                </div>
                <div class="common-tab-container">
                    <div id="element_panel" class="common-tab-panel active">
                        <?php
                        loadPartial("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/stamp_element.html", ['type' => 'container', 'blank' => 'false', 'name' => 'Doboz', 'icon' => '', 'tooltip' => 'false', 'tooltip_text' => '']);
                        loadPartial("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/stamp_element.html", ['type' => 'link', 'blank' => 'false', 'name' => 'Link', 'icon' => 'icon-link', 'tooltip' => 'false', 'tooltip_text' => '']);
                        loadPartial("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/stamp_element.html", ['type' => 'image', 'blank' => 'true', 'name' => 'Kép', 'icon' => 'icon-image', 'tooltip' => 'true', 'tooltip_text' => 'Ezt csak egy üres<br>dobozban lehet elhelyezni!']);
                        loadPartial("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/stamp_element.html", ['type' => 'text', 'blank' => 'true', 'name' => 'Szöveg', 'icon' => 'icon-paragraph', 'tooltip' => 'true', 'tooltip_text' => 'Ezt csak egy üres<br>dobozban lehet elhelyezni!']);
                        loadPartial("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/stamp_element.html", ['type' => 'h1', 'blank' => 'false', 'name' => 'Címsor H1', 'icon' => 'icon-heading', 'tooltip' => 'false', 'tooltip_text' => '']);
                        loadPartial("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/stamp_element.html", ['type' => 'h2', 'blank' => 'false', 'name' => 'Címsor H2', 'icon' => 'icon-heading', 'tooltip' => 'false', 'tooltip_text' => '']);
                        loadPartial("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/stamp_element.html", ['type' => 'h3', 'blank' => 'false', 'name' => 'Címsor H3', 'icon' => 'icon-heading', 'tooltip' => 'false', 'tooltip_text' => '']);
                        loadPartial("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/stamp_element.html", ['type' => 'h4', 'blank' => 'false', 'name' => 'Címsor H4', 'icon' => 'icon-heading', 'tooltip' => 'false', 'tooltip_text' => '']);
                        loadPartial("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/stamp_element.html", ['type' => 'h5', 'blank' => 'false', 'name' => 'Címsor H5', 'icon' => 'icon-heading', 'tooltip' => 'false', 'tooltip_text' => '']);
                        loadPartial("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/stamp_element.html", ['type' => 'h6', 'blank' => 'false', 'name' => 'Címsor H6', 'icon' => 'icon-heading', 'tooltip' => 'false', 'tooltip_text' => '']);
                        ?>
                    </div>
                    <div id="component_panel" class="common-tab-panel">
                    </div>
                </div>
            </div>
        </div>

        <div id="highlighted_mask"></div>
        <div id="page_container"></div>

        <div id="right_side_bar">
            <div class="common-tab-bar">
                <div class="common-tab-pillow active" data-target="#style_panel">
                    <i class="la la-image"></i>
                    <span><?php echo t('Stílus'); ?></span>
                </div>
                <div class="common-tab-pillow" data-target="#attribute_panel">
                    <i class="la la-cog"></i>
                    <span><?php echo t('Jellemzők'); ?></span>
                </div>
            </div>
            <div class="common-tab-container">
                <div id="style_panel" class="common-tab-panel active">
                    <?php
                    $unitArray = arrayToList([
                        'px' => 'px',
                        '%' => '%'
                    ]);
                    $borderStyleListHtml = arrayToList([
                        'dotted' => 'Dotted',
                        'dashed' => 'Dashed',
                        'solid' => 'Solid',
                        'double' => 'Double',
                        'groove' => 'Groove',
                        'ridge' => 'Ridge',
                        'inset' => 'Inset',
                        'outset' => 'Outset',
                        'none' => 'None',
                        'hidden' => 'Hidden'
                    ]);
                    $textAlignListHtml = arrayToList([
                        'left' => 'Balra',
                        'right' => 'Jobbra',
                        'center' => 'Középre',
                        'justify' => 'Sorkizárt',
                        'initial' => 'Alapértelmezett'
                    ]);
                    $fontWeightListHtml = arrayToList([
                        '100' => '100',
                        '200' => '200',
                        '300' => '300',
                        '400' => '400',
                        '500' => '500',
                        '600' => '600',
                        '700' => '700',
                        '800' => '800',
                        '900' => '900'
                    ]);
                    $fontFamilyListHtml = arrayToList([
                        'Times New Roman' => 'Times New Roman',
                        'Arial' => 'Arial',
                        'Courier New' => 'Courier New',
                        'Tahoma' => 'Tahoma'
                    ]);
                    $backgroundPositionListHtml = arrayToList([
                        'left top' => 'Bal - Fent',
                        'left center' => 'Bal - Közép',
                        'left bottom' => 'Bal - Lent',
                        'right top' => 'Jobb - Fent',
                        'right center' => 'Jobb - Közép',
                        'right bottom' => 'Jobb - Lent',
                        'center top' => 'Közép - Fent',
                        'center center' => 'Közép - Közép',
                        'center bottom' => 'Közép - Lent'
                    ]);
                    $backgroundRepeatListHtml = arrayToList([
                        'repeat' => 'repeat',
                        'repeat-x' => 'repeat-x',
                        'repeat-y' => 'repeat-y',
                        'no-repeat' => 'no-repeat',
                        'initial' => 'initial',
                        'inherit' => 'inherit'
                    ]);
                    $backgroundSizeListHtml = arrayToList([
                        'auto' => 'auto',
                        'length' => 'length',
                        'cover' => 'cover',
                        'contain' => 'contain',
                        'initial' => 'initial',
                        'inherit' => 'inherit'
                    ]);

                    loadPartial("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/partials/style_panel.tpl.php", [
                        'units' => $unitArray,
                        'border_styles' => $borderStyleListHtml,
                        'text_alignes' => $textAlignListHtml,
                        'font_weights' => $fontWeightListHtml,
                        'font_families' => $fontFamilyListHtml,
                        'background_position' => $backgroundPositionListHtml,
                        'background_repeat' => $backgroundRepeatListHtml,
                        'background_size' => $backgroundSizeListHtml,
                        'display' => t('Megjelenés'),
                        'font' => t('Tipográfia'),
                        'padding' => t('Belső margók'),
                        'background' => t('Háttér'),
                        'border' => t('Keret'),
                        'x' => t('Vízszintesen'),
                        'y' => t('Függőlegesen'),
                        'width' => t('Szélesség'),
                        'height' => t('Magasság'),
                        'align' => t('Igazítás'),
                        'opacity' => t('Láthatóság'),
                        'family' => t('Betűtípus'),
                        'size' => t('Méret'),
                        'color' => t('Szín'),
                        'weight' => t('Súly'),
                        'letter_spacing' => t('Betűköz'),
                        'line_height' => t('Sorköz'),
                        'top' => t('Fent'),
                        'bottom' => t('Lent'),
                        'left' => t('Balra'),
                        'right' => t('Jobbra'),
                        'image' => t('Kép'),
                        'position' => t('Pozíció'),
                        'repeat' => t('Ismétlés'),
                        'style' => t('Stílus'),
                        'radius' => t('Kerekítés')
                    ]);
                    ?>
                </div>
                <div id="attribute_panel" class="common-tab-panel">
                    <?php
                    if (strpos($base_url, 'localhost') !== false) {
                        $imgUploadUrl = 'https://proposeasy.editor.vallalatiszoftver.hu/propeditor/api/v1/image-upload';
                    } else {
                        $imgUploadUrl = $base_url . '/propeditor/api/v1/image-upload';
                    }
                    loadPartial("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/partials/attribute_panel.tpl.php", [
                        'file_upload_url' => $imgUploadUrl,
                        'base' => t('Alap'),
                        'name' => t('Elnevezés'),
                        'content' => t('Tartalom'),
                        'text' => t('Szöveg'),
                        'source' => t('Forrás'),
                        'link' => t('Hivatkozás'),
                        'image_link' => t('Kép link'),
                    ]);
                    ?>
                </div>
            </div>
        </div>
    </div>
</body>

<footer>
    <div id="thumbnails">
    </div>

    <script src="/<?php print drupal_get_path('module', 'propeditor'); ?>/libraries/editor/helpers/jquery/dist/jquery.js"></script>
    <script src="/<?php print drupal_get_path('module', 'propeditor'); ?>/libraries/editor/helpers/bootstrap/js/bootstrap.js"></script>
    <script src="/<?php print drupal_get_path('module', 'propeditor'); ?>/libraries/editor/helpers/hashids/hashids.min.js"></script>
    <script src="https://cdn.quilljs.com/1.2.6/quill.min.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/Base64/1.0.1/base64.js"></script>
    <script src="/<?php print drupal_get_path('module', 'propeditor'); ?>/assets/plugins/html2canvas/html2canvas.js"></script>

    <script>
        const base_url = "<?php echo $base_url . '/'; ?>";
        const project_hash = "<?php echo $proposal->hash; ?>"; //Ki kell cserélni, hogy a php tegye bele!!!
        var token_list = <?php print json_encode($proposal->tokens, JSON_UNESCAPED_UNICODE); ?>; //Ki kell cserélni, hogy a php tegye bele!!!
        var template_hash = "";
        var quillToolbarOptions = {
            container: [
                ['undo', 'redo', {'font': []}, {'size': ['small', false, 'large', 'huge']}],
                ['bold', 'italic', 'underline', 'strike'], // toggled buttons
                ['clean'], // remove formatting button

                [{'align': []}, {'indent': '-1'}, {'indent': '+1'}, {'list': 'ordered'}, {'list': 'bullet'}],
                [{'script': 'sub'}, {'script': 'super'}], // superscript/subscript
                //            [{'header': 1}, {'header': 2}], // custom button values
                //            [{ 'direction': 'rtl' }],                         // text direction
                //            [{ 'header': [1, 2, 3, 4, 5, 6, false] }],

                [{'color': []}, {'background': []}], // dropdown with defaults from theme
                ['blockquote', 'code-block', 'image', 'link']
            ],
            handlers: {
                // handlers object will be merged with default handlers object
                redo() {
                    active_editor.history.redo();
                },
                undo() {
                    active_editor.history.undo();
                }
            }
        };
        const drag_zone = '<?php echo urlencode(file_get_contents("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/drag_zone.html")) ?>';
        const tools_tree_leaf = '<?php echo urlencode(file_get_contents("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/tree_leaf.html")) ?>';
        const tools_page_a4 = '<?php echo urlencode(file_get_contents("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/canvas_page_a4.html")) ?>';
        const stamp_element = '<?php echo urlencode(file_get_contents("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/stamp_element.html")) ?>';
        const stamp_element_bg = '<?php echo urlencode(file_get_contents("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/stamp_element_bg.html")) ?>';
        const stamp_create_component = '<?php echo urlencode(file_get_contents("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/stamp_create_component.html")) ?>';
        const helper_line_vertical = '<?php echo urlencode(file_get_contents("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/helper_line_vertical.html")) ?>';
        const helper_line_horizontal = '<?php echo urlencode(file_get_contents("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/helper_line_horizontal.html")) ?>';
        const btn_save_component = '<?php echo urlencode(file_get_contents("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/btn_save_component.html")) ?>';
        const btn_delete_component = '<?php echo urlencode(file_get_contents("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/btn_delete_component.html")) ?>';
        const token_row = '<?php echo urlencode(file_get_contents("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/token_row.html")) ?>';
        const elements = {
            container: '<?php echo urlencode(file_get_contents("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/element_container.html")) ?>',
            link: '<?php echo urlencode(file_get_contents("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/element_link.html")) ?>',
            image: '<?php echo urlencode(file_get_contents("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/element_image.html")) ?>',
            text: '<?php echo urlencode(file_get_contents("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/element_text.html")) ?>',
            h1: '<?php echo urlencode(file_get_contents("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/element_h1.html")) ?>',
            h2: '<?php echo urlencode(file_get_contents("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/element_h2.html")) ?>',
            h3: '<?php echo urlencode(file_get_contents("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/element_h3.html")) ?>',
            h4: '<?php echo urlencode(file_get_contents("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/element_h4.html")) ?>',
            h5: '<?php echo urlencode(file_get_contents("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/element_h5.html")) ?>',
            h6: '<?php echo urlencode(file_get_contents("./" . drupal_get_path('module', 'propeditor') . "/libraries/editor/tools/element_h6.html")) ?>'
        };
    </script>

    <script src="/<?php print drupal_get_path('module', 'propeditor'); ?>/libraries/editor/helpers/ajax_queue.js"></script>
    <script src="/<?php print drupal_get_path('module', 'propeditor'); ?>/libraries/editor/helpers/common.js"></script>
    <script src="/<?php print drupal_get_path('module', 'propeditor'); ?>/libraries/editor/helpers/toastr.js"></script>
    <script src="/<?php print drupal_get_path('module', 'propeditor'); ?>/libraries/editor/helpers/tooltip.js"></script>
    <script src="/<?php print drupal_get_path('module', 'propeditor'); ?>/libraries/editor/helpers/index.js"></script>
    <script src="/<?php print drupal_get_path('module', 'propeditor'); ?>/libraries/editor/helpers/operations.js"></script>
</footer>