<?php
    function loadPartial($fileName, $compact = array()) {

        $partial = file_get_contents($fileName);
        foreach($compact as $key => $data) {

            $partial = str_replace("[$key]", $data, $partial);
        }
        echo $partial;
    }

    function arrayToList(array $dataArray) {

        $resultStr = '';
        foreach($dataArray as $key => $data) {
            
            $value = 'value="' . $key . '"';
            $resultStr .= "<option $value>$data</option>";
        }
        return $resultStr;
    }

    function Url()
    {
        $currentUrl = sprintf(
            "%s://%s%s",
            isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http',
            $_SERVER['SERVER_NAME'],
            $_SERVER['SCRIPT_NAME']
        );
        return strstr($currentUrl, '/index.php', true);
    }

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL,"https://proposeasy.dev.vallalatiszoftver.hu/propeditor/api/v1/get-template");
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, 'hash=' . $_GET['hash']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close ($ch); 

    $responseData   = json_decode($response, true);
    $previewTitle   = $responseData['result']['title'];
    $previewContent = $responseData['result']['content'];
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <link rel="stylesheet" href="helpers\bootstrap\css\bootstrap.css">
        <link rel="stylesheet" href="helpers\bootstrap\css\bootstrap-theme.min.css">
        <link rel="stylesheet" href="helpers\font-awesome\css\font-awesome.min.css">
        <link rel="stylesheet" href="helpers\summernote-0.8.12-dist\dist\summernote.css">

        <link href="https://cdn.quilljs.com/1.2.6/quill.snow.css" rel="stylesheet">

        <link rel="stylesheet" href="preview.css">
    </head>
    <body>
        <?php loadPartial("partials/component_modal.html"); ?>
        <div id="preview_operation_bar">
            <?php loadPartial("partials/preview_operation_bar.html", ['title' => $previewTitle]); ?>
        </div>
        <div id="app_container">
            <div id="left_side_bar">
                <label>Tartalomjegyzék</label>
            </div>
            <div id="page_container">
                <div id="zoom_field"></div>
            </div>
        </div>
    </body>

    <footer>
        <script src="https://cdn.jsdelivr.net/npm/@editorjs/editorjs@latest"></script>

        <script src="helpers/jquery/dist/jquery.js"></script>
        <script src="helpers/bootstrap/js/bootstrap.js"></script>
    
        <script src="https://cdn.quilljs.com/1.2.6/quill.min.js"></script>

        <script src="helpers/common.js"></script>
        <script src="helpers/preview.js"></script>

        <script>
            const base_url          = "<?php echo Url() . '/'; ?>";

            const header_nav        = '<?php echo urlencode(file_get_contents("tools/header_nav.html")); ?>';
            const preview_stream    = '<?php echo urlencode($previewContent); ?>';
        </script>
    </footer>
</html>
