<?php
    function loadPartial($fileName, $compact = array()) {

        $partial = file_get_contents($fileName);
        foreach($compact as $key => $data) {

            $partial = str_replace("[$key]", $data, $partial);
        }
        echo $partial;
    }

    function arrayToList(array $dataArray) {

        $resultStr = '';
        foreach($dataArray as $key => $data) {
            
            $value = 'value="' . $key . '"';
            $resultStr .= "<option $value>$data</option>";
        }
        return $resultStr;
    }

    function Url()
    {
        $currentUrl = sprintf(
            "%s://%s%s",
            isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http',
            $_SERVER['SERVER_NAME'],
            $_SERVER['SCRIPT_NAME']
        );
        return strstr($currentUrl, '/index.php', true);
    }
?>

<!DOCTYPE html>
<html lang="en">
    <head>
        <link rel="stylesheet" href="helpers\bootstrap\css\bootstrap.css">
        <link rel="stylesheet" href="helpers\bootstrap\css\bootstrap-theme.min.css">
        <link rel="stylesheet" href="helpers\font-awesome\css\font-awesome.min.css">
        <link href="https://cdn.quilljs.com/1.2.6/quill.snow.css" rel="stylesheet">

        <link rel="stylesheet" href="toastr.css">
        <link rel="stylesheet" href="tooltip.css">
        <link rel="stylesheet" href="index.css">
    </head>
    <body>
        <?php 
            loadPartial("partials/token_editor_modal.html");
            loadPartial("partials/component_modal.html"); 
            ?>
        <div id="top_bar">
            <?php loadPartial("partials/top_bar.html"); ?>
        </div>
        <div id="toastr_container"></div>
        <div id="app_container">
            <div id="left_side_bar">
                <div id="layer_panel">
                    <div id="layer_panel_header">
                        <label>Layers</label>
                    </div>
                    <div id="layer_panel_tree">
                    </div>
                </div>
                <div id="component_element_panel">
                    <div class="common-tab-bar">
                        <div class="common-tab-pillow active" data-target="#element_panel">
                            <i class="fa fa-wrench"></i>
                            <span>elements</span>
                        </div>
                        <div class="common-tab-pillow" data-target="#component_panel">
                            <i class="fa fa-tags"></i>
                            <span>components</span>
                        </div>
                    </div>
                    <div class="common-tab-container">
                        <div id="element_panel" class="common-tab-panel active">
                            <?php 
                            loadPartial("tools/stamp_element.html", ['type' => 'container', 'blank' => 'false', 'name' => 'container',  'operation_icon' => '']);
                            loadPartial("tools/stamp_element.html", ['type' => 'link',      'blank' => 'false', 'name' => 'link',       'operation_icon' => '']);
                            loadPartial("tools/stamp_element.html", ['type' => 'image',     'blank' => 'true',  'name' => 'image',      'operation_icon' => '']);
                            loadPartial("tools/stamp_element.html", ['type' => 'text',      'blank' => 'true',  'name' => 'text',       'operation_icon' => '']);
                            loadPartial("tools/stamp_element.html", ['type' => 'h1',        'blank' => 'false', 'name' => 'header 1',   'operation_icon' => '']);
                            loadPartial("tools/stamp_element.html", ['type' => 'h2',        'blank' => 'false', 'name' => 'header 2',   'operation_icon' => '']);
                            loadPartial("tools/stamp_element.html", ['type' => 'h3',        'blank' => 'false', 'name' => 'header 3',   'operation_icon' => '']);
                            loadPartial("tools/stamp_element.html", ['type' => 'h4',        'blank' => 'false', 'name' => 'header 4',   'operation_icon' => '']);
                            loadPartial("tools/stamp_element.html", ['type' => 'h5',        'blank' => 'false', 'name' => 'header 5',   'operation_icon' => '']);
                            loadPartial("tools/stamp_element.html", ['type' => 'h6',        'blank' => 'false', 'name' => 'header 6',   'operation_icon' => '']);
                            ?>
                        </div>
                        <div id="component_panel" class="common-tab-panel">
                        </div>
                    </div>
                </div>
            </div>
            
            <div id="highlighted_mask"></div>
            <div id="page_container"></div>

            <div id="right_side_bar">
                <div class="common-tab-bar">
                    <div class="common-tab-pillow active" data-target="#style_panel">
                        <i class="fa fa-tags"></i>
                        <span>styles</span>
                    </div>
                    <div class="common-tab-pillow" data-target="#attribute_panel">
                        <i class="fa fa-wrench"></i>
                        <span>attributes</span>
                    </div>
                </div>
                <div class="common-tab-container">
                    <div id="style_panel" class="common-tab-panel active">
                        <?php 
                        $unitArray = arrayToList([
                            'px'    => 'pixel',
                            '%'     => 'percent'
                        ]);
                        $borderStyleListHtml = arrayToList([
                            'dotted'    => 'dotted',
                            'dashed'    => 'dashed',
                            'solid'     => 'solid',
                            'double'    => 'double',
                            'groove'    => 'groove',
                            'ridge'     => 'ridge',
                            'inset'     => 'inset',
                            'outset'    => 'outset',
                            'none'      => 'none',
                            'hidden'    => 'hidden'
                        ]);
                        $textAlignListHtml = arrayToList([
                            'left'      => 'left',
                            'right'     => 'right',
                            'center'    => 'center',
                            'justify'   => 'justify',
                            'initial'   => 'initial'
                        ]);
                        $fontWeightListHtml = arrayToList([
                            '100'   => '100',
                            '200'   => '200',
                            '300'   => '300',
                            '400'   => '400',
                            '500'   => '500',
                            '600'   => '600',
                            '700'   => '700',
                            '800'   => '800',
                            '900'   => '900'
                        ]);
                        $fontFamilyListHtml = arrayToList([
                            'Times New Roman'   => 'Times New Roman',
                            'Arial'             => 'Arial',
                            'Courier New'       => 'Courier New'
                        ]);

                        loadPartial("partials/style_panel.html", [
                            'units'         => $unitArray,
                            'border_styles' => $borderStyleListHtml, 
                            'text_alignes'  => $textAlignListHtml,
                            'font_weights'  => $fontWeightListHtml,
                            'font_families' => $fontFamilyListHtml
                        ]); 
                        ?>
                    </div>
                    <div id="attribute_panel" class="common-tab-panel">
                        <?php 
                            if(strpos(Url(), 'localhost') !== false)
                            {
                                $imgUploadUrl = 'https://proposeasy.editor.vallalatiszoftver.hu/propeditor/api/v1/image-upload';
                            }
                            else
                            {
                                $imgUploadUrl = Url() . '/propeditor/api/v1/image-upload';
                            }
                            loadPartial("partials/attribute_panel.html", ['file_upload_url' => $imgUploadUrl]); 
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </body>

    <footer>
        <script src="helpers/jquery/dist/jquery.js"></script>
        <script src="helpers/bootstrap/js/bootstrap.js"></script>
        <script src="https://cdn.quilljs.com/1.2.6/quill.min.js"></script>

        <script>
            const base_url                  = "<?php echo Url() . '/'; ?>";
            const project_hash              = "JC740495"; //Ki kell cserélni, hogy a php tegye bele!!!                      

            const drag_zone                 = '<?php echo urlencode(file_get_contents("tools/drag_zone.html")) ?>';
            const tools_tree_leaf           = '<?php echo urlencode(file_get_contents("tools/tree_leaf.html")) ?>';
            const tools_page_a4             = '<?php echo urlencode(file_get_contents("tools/canvas_page_a4.html")) ?>';
            const stamp_element             = '<?php echo urlencode(file_get_contents("tools/stamp_element.html")) ?>';
            const stamp_create_component    = '<?php echo urlencode(file_get_contents("tools/stamp_create_component.html")) ?>';
            const helper_line_vertical      = '<?php echo urlencode(file_get_contents("tools/helper_line_vertical.html")) ?>';
            const helper_line_horizontal    = '<?php echo urlencode(file_get_contents("tools/helper_line_horizontal.html")) ?>';
            const btn_save_component        = '<?php echo urlencode(file_get_contents("tools/btn_save_component.html")) ?>';
            const btn_delete_component      = '<?php echo urlencode(file_get_contents("tools/btn_delete_component.html")) ?>';
            const token_row                 = '<?php echo urlencode(file_get_contents("tools/token_row.html")) ?>';

            const elements = {
                container:  '<?php echo urlencode(file_get_contents("tools/element_container.html")) ?>',
                link:       '<?php echo urlencode(file_get_contents("tools/element_link.html")) ?>',
                image:      '<?php echo urlencode(file_get_contents("tools/element_image.html")) ?>',
                text:       '<?php echo urlencode(file_get_contents("tools/element_text.html")) ?>',
                h1:         '<?php echo urlencode(file_get_contents("tools/element_h1.html")) ?>',
                h2:         '<?php echo urlencode(file_get_contents("tools/element_h2.html")) ?>',
                h3:         '<?php echo urlencode(file_get_contents("tools/element_h3.html")) ?>',
                h4:         '<?php echo urlencode(file_get_contents("tools/element_h4.html")) ?>',
                h5:         '<?php echo urlencode(file_get_contents("tools/element_h5.html")) ?>',
                h6:         '<?php echo urlencode(file_get_contents("tools/element_h6.html")) ?>'
            };
        </script>

        <script src="helpers/ajax_queue.js"></script>
        <script src="helpers/common.js"></script>
        <script src="helpers/toastr.js"></script>
        <script src="helpers/tooltip.js"></script>
        <script src="helpers/index.js"></script>
        <script src="helpers/operations.js"></script>
    </footer>
</html>
