var zoom_level = 1;

$(document).ready(function() 
{
    $("#zoom_field").html(
        preview_stream.tohtml()
    );

    $("#page_container").find(".editor-element").each(function(key, item) 
    {
        const $item = $(item);
        switch($item.prop("tagName").toLowerCase())
        {
            case "h1":
                $("#left_side_bar").append(createHeaderNav(1, $item));
                break;
            case "h2":
                $("#left_side_bar").append(createHeaderNav(2, $item));
                break;
            case "h3":
                $("#left_side_bar").append(createHeaderNav(3, $item));
                break;
            case "h4":
                $("#left_side_bar").append(createHeaderNav(4, $item));
                break;
            case "h5":
                $("#left_side_bar").append(createHeaderNav(5, $item));
                break;
            case "h6":
                $("#left_side_bar").append(createHeaderNav(6, $item));
                break;
        }
    });

    recalcPageNumber(0);
});

function createHeaderNav(header, $item)
{
    return header_nav.tohtml({ 
        size:       header,
        id:         $item.attr("id"),
        content:    $item.find(".text-container").html() 
    });
}

$(document).on("click", ".nav-to-header", function() 
{
    const id = $(this).attr("data-id");
    setTimeout(function () 
    {
        $("#" + id)[0].scrollIntoView({behavior: "smooth", block: "center", inline: "center"});
    }, 200);
});

$("#page_container").scroll(function()
{
    recalcPageNumber(this.scrollTop);
});

function recalcPageNumber(scroll_top)
{
    const page_frames   = $(".page-frame");
    var counter         = 1;
    var offset          = 0;

    page_frames.each(function() 
    {
        offset += ($(this).height() * zoom_level);
        if(offset < scroll_top)
        {
            ++counter;
        }
    });
    $("#page_num").html(counter + "/" + page_frames.length);
}

$(document).on("click", "#op_preview_zoom_in", function() 
{
    $("#left_side_bar").addClass("zoom_in");
    $("#page_container").addClass("zoom_in");
    $(".page-frame").addClass("zoom_in");

    zoom_level += 0.25;
    if(zoom_level > 2)
    {
        zoom_level = 2.0;
    }

    const page_width    = $(".page-frame").width();
    const page_height   = $(".page-frame").height();
    const trX           = ((page_width * zoom_level) - page_width);
    const trY           = ((page_height * zoom_level) - page_height);


    $("#zoom_field").css({
        transform: "translate(" + trX + "px," + trY + "px) scale(" + zoom_level + ")"
    });

    const $page_container = $("#page_container");
    if($page_container.length > 0)
    {
        $page_container.get(0).scrollLeft = ($page_container.get(0).scrollWidth - $page_container.width()) / 2;
    }
});

$(document).on("click", "#op_preview_zoom_out", function() 
{
    zoom_level -= 0.25;
    if(zoom_level <= 1)
    {
        zoom_level = 1.0;

        $("#left_side_bar").removeClass("zoom_in");
        $("#page_container").removeClass("zoom_in");
        $(".page-frame").removeClass("zoom_in");
        $("#zoom_field").css({transform: ""});
    }
    else
    {
        const page_width    = $(".page-frame").width();
        const page_height   = $(".page-frame").height();
        const trX           = ((page_width * zoom_level) - page_width);
        const trY           = ((page_height * zoom_level) - page_height);
    
        $("#zoom_field").css({
            transform: "translate(" + trX + "px," + trY + "px) scale(" + zoom_level + ")"
        });
        
        const $page_container = $("#page_container");
        if($page_container.length > 0)
        {
            $page_container.get(0).scrollLeft = ($page_container.get(0).scrollWidth - $page_container.width()) / 2;
        }
    }
});