$(document).ready(function() 
{
    addAjaxToQueue(function() 
    {
//        const url = "https://proposeasy.dev.vallalatiszoftver.hu/propeditor/api/v1/get-template";
        const url = "https://proposeasy.dev.vallalatiszoftver.hu/propeditor/api/v1/get-proposal";
        const data = {
            hash: project_hash
        };
        $.ajax({
            type:           "json",
            method:         "POST",
            processData:    "true",
            cache:          "cache",
            contentType:    "application/x-www-form-urlencoded",
            url:            url,
            data:           data,
            beforeSend: function() 
            {
            },
            success: function(response) 
            {
                if(response.success)
                {
                    $("#template_label").html(response.result.title);
                    $("#page_container").html(response.result.content);
//                    // Init text editors
//                    $("#page_container").find('.text-editor-container').each(function() {
//                        let text = JSON.parse($(this).attr('data-content'));
//                        let editor = new Quill("#" + $(this).attr("id"), {
//                            formats: false,
//                            debug: true,
//                            theme: "snow",
//                            placeholder: 'Ide írhatod a szöveget...',
//                            modules: {
//                                toolbar: quillToolbarOptions
//                            }
//                        });
//                        editor.setContents(text);
//                    });
                    saveStack();
                    template_hash = response.result.t_hash;
                }
                else
                {
                    toastr("", "warning");
                }
            },
            complete: function() 
            {
                reloadHiearchyView();
            },
            error: function() 
            {
                toastr("Network problem", "error");
            }
        });
    });

    addAjaxToQueue(function() 
    {
        const data  = {};
        const url = "https://proposeasy.dev.vallalatiszoftver.hu/propeditor/api/v1/get-component-list";
        $.ajax({
            type:           "json",
            method:         "POST",
            processData:    "true",
            cache:          "cache",
            contentType:    "application/x-www-form-urlencoded",
            url:            url,
            data:           data,

            beforeSend: function() 
            {
            },
            success: function(response) 
            {
                if(response.success)
                {
                    reloadComponentView(response.result);
                }
                else
                {
                    toastr("", "warning");
                }
            },
            complete: function() 
            {
            },
            error: function() 
            {
                toastr("Network problem", "error");
            }
        });
    });
});

$(document).on("click", "#operation_save_project", function(event)
{
    addAjaxToQueue(function() 
    {
        setSelectedItem(null);
        // Disable text editor
//        let content = $("#page_container .page-frame").clone();
        let content = $("#page_container").clone();
            content.find('.text-editor-container').each(function() {
                $(this).find('.ql-toolbar').remove();
            });
//        $("#page_container").html(content);
        const url = "https://proposeasy.dev.vallalatiszoftver.hu/propeditor/api/v1/save-template";
        const data = {
            hash:       template_hash,
            title:      $("#template_label").html(),
            content:    content.html()
        };
        
        console.log('save', data);
//        return false;
        $.ajax({
            type:           "json",
            method:         "POST",
            processData:    "true",
            cache:          "cache",
            contentType:    "application/x-www-form-urlencoded",
            url:            url,
            data:           data,
            beforeSend: function() 
            {
            },
            success: function(response) 
            {
                if(response.success)
                {
                    toastr("Session saved", "success");
                }
                else
                {
                    toastr("", "warning");
                }
            },
            complete: function() 
            {
            },
            error: function() 
            {
                toastr("Network problem", "error");
            }
        });
    });
});

$(document).on("click", "#operation_exit", function(event)
{
    window.location.href = "/my-proposals";
});

$(document).on("click", ".save-component", function(event) 
{
    const $component_element    = $(this).closest(".component-element");
    const component_name        = $component_element.attr("data-type");
    const thumbnail             = document.querySelector('#canvas-' + component_name.substr(1) + ' canvas').toDataURL('image/jpeg');

//    console.log('thumbnail', '#canvas-' + component_name.substr(1) + ' canvas', $('#canvas-' + component_name.substr(1) + ' canvas'));
//    return false;

    addAjaxToQueue(function() 
    {
        const url = "https://proposeasy.dev.vallalatiszoftver.hu/propeditor/api/v1/save-component";
        const data = {
//            hash:       project_hash,
            name:       component_name,
            label:      component_list[component_name].label,
            content:    component_list[component_name].data,
            thumbnail:  thumbnail,
            status:     1
        };
        $.ajax({
            type:           "json",
            method:         "POST",
            processData:    "true",
            cache:          "cache",
            contentType:    "application/x-www-form-urlencoded",
            url:            url,
            data:           data,
            beforeSend: function() 
            {
            },
            success: function(response) 
            {
                if(response.success)
                {
                    component_list[component_name].hash = response.result.hash;
                    reloadComponentView();

                    toastr("Component saved", "success");
                }
                else
                {
                    toastr("", "warning");
                }
            },
            complete: function() 
            {
            },
            error: function() 
            {
                toastr("Network problem", "error");
            }
        });
    });
});

$(document).on("click", ".delete-component", function() 
{
    const $component_element    = $(this).closest(".component-element");
    const component_name        = $component_element.attr("data-type");

    addAjaxToQueue(function() 
    {
        const url = "https://proposeasy.dev.vallalatiszoftver.hu/propeditor/api/v1/delete-component";
        const data = {
            hash: component_list[component_name].hash,
        };
        $.ajax({
            type:           "json",
            method:         "POST",
            processData:    "true",
            cache:          "cache",
            contentType:    "application/x-www-form-urlencoded",
            url:            url,
            data:           data,
            beforeSend: function() 
            {
            },
            success: function(response) 
            {
                if(response.success)
                {
                    delete component_list[component_name];
                    reloadComponentView();

                    toastr("Component saved", "success");
                }
                else
                {
                    toastr("", "warning");
                }
            },
            complete: function() 
            {
            },
            error: function() 
            {
                toastr("Network problem", "error");
            }
        });
    });
});

$(document).on("shown.bs.modal", "#token_editor_modal", function(event) 
{
    console.log('tokens', token_list);
    
    var tokens_html = "";
    Object.keys(token_list).forEach(element => 
    {    
        tokens_html += token_row.tohtml({ 
            key:    element,
            value:  token_list[element]
        });
    });
    $("#token_list_container").html(tokens_html);
    
});

$(document).on("change", ".token-row.editable input", function(event) 
{
    const $input_field = $(this);
    token_list[$input_field.attr("data-key")] = $input_field.val();
    addAjaxToQueue(function() 
    {
        const url = "https://proposeasy.dev.vallalatiszoftver.hu/propeditor/api/v1/save-proposal-tokens";
        const data = {
            proposal_hash: project_hash,
            tokens: token_list
        };
        $.ajax({
            type:           "json",
            method:         "POST",
            processData:    "true",
            cache:          "cache",
            contentType:    "application/x-www-form-urlencoded",
            url:            url,
            data:           data,
            beforeSend: function() 
            {
            },
            success: function(response) 
            {
                if(response.success)
                {
                    toastr("Component saved", "success");
                }
                else
                {
                    toastr("", "warning");
                }
            },
            complete: function() 
            {
            },
            error: function() 
            {
                toastr("Network problem", "error");
            }
        });
    });
});

//$(document).on("change", ".token-row.editable input", function(event) 
//{
//    const $input_field = $(this);
//    addAjaxToQueue(function() 
//    {
//        const url = "https://proposeasy.dev.vallalatiszoftver.hu/propeditor/api/v1/save-token";
//        const data = {
//            key:    $input_field.attr("data-key"),
//            value:  $input_field.val()
//        };
//        $.ajax({
//            type:           "json",
//            method:         "POST",
//            processData:    "true",
//            cache:          "cache",
//            contentType:    "application/x-www-form-urlencoded",
//            url:            url,
//            data:           data,
//            beforeSend: function() 
//            {
//            },
//            success: function(response) 
//            {
//                if(response.success)
//                {
//                    toastr("Component saved", "success");
//                }
//                else
//                {
//                    toastr("", "warning");
//                }
//            },
//            complete: function() 
//            {
//            },
//            error: function() 
//            {
//                toastr("Network problem", "error");
//            }
//        });
//    });
//});

$(document).on("click", ".delete-token", function(event) 
{
    const $token_row = $(this).closest(".token-row");
    addAjaxToQueue(function() 
    {
        const url = "https://proposeasy.dev.vallalatiszoftver.hu/propeditor/api/v1/delete-token";
        const data = {
            key: $token_row.find("input").attr("data-key")
        };
        $.ajax({
            type:           "json",
            method:         "POST",
            processData:    "true",
            cache:          "cache",
            contentType:    "application/x-www-form-urlencoded",
            url:            url,
            data:           data,
            beforeSend: function() 
            {
            },
            success: function(response) 
            {
                if(response.success)
                {
                    var tokens_html = "";
                    response.result.forEach(element => 
                    {    
                        tokens_html += token_row.tohtml({ 
                            key:    element.toid,
                            value:  element.token
                        });
                    });
                    $("#token_list_container").html(tokens_html);

                    toastr("Component saved", "success");
                }
                else
                {
                    toastr("", "warning");
                }
            },
            complete: function() 
            {
            },
            error: function() 
            {
                toastr("Network problem", "error");
            }
        });
    });
});

$(document).on("click", "#create_new_token", function(event) 
{
    addAjaxToQueue(function() 
    {
        const url = "https://proposeasy.dev.vallalatiszoftver.hu/propeditor/api/v1/save-token";
        const data = {
            key:    $("#new_token_key").val(),
            value:  $("#new_token_value").val()
        };
        $.ajax({
            type:           "json",
            method:         "POST",
            processData:    "true",
            cache:          "cache",
            contentType:    "application/x-www-form-urlencoded",
            url:            url,
            data:           data,
            beforeSend: function() 
            {
            },
            success: function(response) 
            {
                if(response.success)
                {
                    var tokens_html = "";
                    response.result.forEach(element => 
                    {    
                        tokens_html += token_row.tohtml({ 
                            key:    element.toid,
                            value:  element.token
                        });
                    });
                    $("#token_list_container").html(tokens_html);

                    toastr("Component saved", "success");
                }
                else
                {
                    toastr("", "warning");
                }
            },
            complete: function() 
            {
            },
            error: function() 
            {
                toastr("Network problem", "error");
            }
        });
    });
});

$(document).on("click", "#operation_preview", function(event) 
{
    window.open(base_url + "/proposal/" + project_hash + "/preview?updated=", '_blank');
//    window.open(base_url + "preview.php?hash=" + project_hash, '_blank');
});

//$(document).on("submit", "#img_uploader_form", function(event) 
//{
//    event.preventDefault();
//
//    const $selected_item    = $(getSelectedItem());
//    var form                = new FormData();
//
//    form.append('uploaded_img', $('[name="uploaded_img"]').val());
//
//    $.ajax({
//        type:           "json",
//        method:         "POST",
//        processData:    false,
//        cache:          false,
//        contentType:    false,
//        url:            this.getAttribute("action"),
//        data:           form,
//        beforeSend: function() 
//        {
//        },
//        success: function(result_stream) 
//        {
//            const response = result_stream.toResponse();
//            if(response.successR())
//            {
//                $selected_item.find("img").attr("src", response.responseData());
//                toastr("Images is uploaded", "success");
//            }
//            else
//            {
//                toastr(response.responseData().msg, "warning");
//            }
//        },
//        complete: function() 
//        {
//        },
//        error: function() 
//        {
//            toastr("Network problem", "error");
//        }
//    });
//});

$(document).on("click", "#operation_undo", function(event) 
{
    stackBack();
});

$(document).on("click", "#operation_redo", function(event) 
{
    stackForward();
});
