//==============================================================================
//Globals
//==============================================================================
var component_list  = {}; //Container for components
var active_editor   = null; //Active text editor pointer
var mouse_x         = 0; //Mouse location x
var mouse_y         = 0; //Mouse location y
var status_stack    = []; //Undo/redo stack
var stack_pointer   = -1; //Pointer for undo/redo stack
var action_on_move  = false; //Drag zone under moveing
var translate_x     = 0; //Drag motion offset x
var translate_y     = 0; //Drag motion offset y
var action_pick_x   = 0; //Drag zone offset x
var action_pick_y   = 0; //Drag zone offset y
var last_width      = 0; //Selected item width
var last_height     = 0; //Selected item height
var icons = Quill.import("ui/icons");
icons["undo"] = '<svg viewbox="0 0 18 18"><polygon class="ql-fill ql-stroke" points="6 10 4 12 2 10 6 10"></polygon><path class="ql-stroke" d="M8.09,13.91A4.6,4.6,0,0,0,9,14,5,5,0,1,0,4,9"></path></svg>';
icons["redo"] = '<svg viewbox="0 0 18 18"><polygon class="ql-fill ql-stroke" points="12 10 14 12 16 10 12 10"></polygon><path class="ql-stroke" d="M9.91,13.91A4.6,4.6,0,0,1,9,14a5,5,0,1,1,5-5"></path></svg>';

// Init text editor undo/redo
//$(document).on('click', '.ql-toolbar .ql-undo', function() {
//    console.log('Undo Clicked!');
//});
//$(document).on('click', '.ql-toolbar .ql-redo', function() {
//    console.log('Redo Clicked!');
//});

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------

function saveStack()
{
    if(stack_pointer < status_stack.length - 1)
    {
        status_stack.splice(stack_pointer + 1);
        $("#operation_redo").removeClass("active");
    }

    if(status_stack.length > 32)
    {
        status_stack.splice(0);
    }

    status_stack.push($("#page_container").html());
    stack_pointer = status_stack.length - 1;
 
    if(stack_pointer > 0)
    {
        $("#operation_undo").addClass("active");
    }
}

function stackBack()
{
    if(stack_pointer - 1 >= 0)
    {
        $("#page_container").html(status_stack[--stack_pointer]);
        $("#operation_redo").addClass("active");

        if(stack_pointer == 0)
        {
            $("#operation_undo").removeClass("active");
        }
    } 
}

function stackForward()
{
    if(stack_pointer + 1 < status_stack.length)
    {
        $("#page_container").html(status_stack[++stack_pointer]);
        $("#operation_undo").addClass("active");

        if(stack_pointer == status_stack.length - 1)
        {
            $("#operation_redo").removeClass("active");
        }
    }
}

//==============================================================================
//Left side bar layer fields handling
//==============================================================================
function setSelectedItem(node) //Manage selected item resources
{
    /* @TODO Ha kiválasztok egy elemet akkor ellenőrizni kell, hogy az előző elem quill volt-e és ha igen, akkor előbb abból getContents-el ki kell nyerni
     * az adatot és JSON.stringify-jal betenni egy data-content attribútumba.
     * Ezután destroy-olni kell a quillt. Ez azért van, hogy amikor legközelebb az elem aktív lesz, akkor a data-content-ből nyert adattal fel lehet
     * tölteni az újonnan aktivált quill-t, és így lehet menteni és szerkesztehtően tartani a szöveg blokkokat.
     */
    let $previous = $(".page-a4.active, .editor-element.active");
    if ($previous.hasClass('text-editor-container') && $(node).attr('id') != $previous.attr('id')) {
        let editor_content = active_editor.getContents();
        $previous.find('.ql-toolbar').remove();
        $previous.attr('data-content', JSON.stringify(editor_content));
        active_editor = null;
    }
    
    $previous.removeClass("active"); //Remove current item selection
    
    $("#drag_zone").remove(); //Remove drag zone
    hideTextEditorToolbar(); //Hide text editor toolbar
    hideBlocksOnRightSideBar(); //Hide property blocks

    const $selected_item    = $(node);
    last_width              = $selected_item.width(); 
    last_height             = $selected_item.height();

    $selected_item.addClass("active");
    
    // If text editor init editor
    if ($selected_item.hasClass('text-editor-container') && $selected_item.attr('id') != $previous.attr('id')) {
        initTextEditor($selected_item.attr("id"));
    }
    
    reloadHiearchyView();
}

function getSelectedItem()
{
    const $item = $(".page-a4.active, .editor-element.active");
    return $item.length > 0 ? $item.get(0) : null;
}

function isSelectedItem(node)
{
    const $node = $(node);
    return $node.hasClass("active") && ($node.hasClass("page-a4") || $node.hasClass("editor-element"));
}

function reloadHiearchyView() //Reload layer panel
{ 
    $("#layer_panel_tree").html(
        createHiearchyView()
    );
    $("#layer_panel_tree")
        .find(".tree-view-leaf[data-state='false']")
        .find(".tree-view-leaf")
        .hide();
}

function createHiearchyView(parent, depth) //Create layer panel components by editor canvas content
{ 
    if(_isUndefined(parent)) 
    {
        parent = "#page_container";
    }
    if(_isUndefined(depth)) 
    {
        depth = 0;
    }

    const $node_list    = (parent == "#page_container" ? $(parent).find(".page-a4") : $(parent).children(".editor-element"));
//    var result_html     = (depth == 0 ? '<span id="add_new_a4">Add new A4 <i class="fa fa-paperclip"></i></span>' : "");
    var result_html     = "";

    $node_list.each(function (key, node) 
    {
        const active_class  = isSelectedItem(node) ? "active" : "";
        const leaf_name     = getLeafLabel(this);

        if($(node).children(".editor-element").length > 0) 
        {
            const state = nodeIsOpened(node);
            result_html += tools_tree_leaf.tohtml(
                { 
                    id:         this.getAttribute("id"),  
                    text:       printDepth(depth) + leaf_name + printToggle(state), 
                    childrens:  createHiearchyView(node, depth + 1),
                    state:      state,
                    class:      active_class
                });
        } 
        else 
        {
            result_html += tools_tree_leaf.tohtml(
                { 
                    id:         this.getAttribute("id"),  
                    text:       printDepth(depth) + leaf_name, 
                    childrens:  "",
                    state:      "",
                    class:      active_class
                });
        }
    });
    return result_html;
}

function getLeafLabel(element)
{
    const name = element.getAttribute("name");
    return _isValid(name) ? name : element.getAttribute("id");
}

function printDepth(depth) //Tree view hiearchy marker
{
    var result = "";
    for(var i = 0; i < depth; ++i) 
    {
        result += "|---";
    }
    return result;
}

function printToggle(opened) //Tree view layer toggle 
{
    if(opened) 
    {
        return '<i class="fa fa-angle-right rotated"></i>';
    } 
    else 
    {
        return '<i class="fa fa-angle-right"></i>';
    }
}

$(document).on("click", ".tree-view-leaf label i", function() //Event for set layer toggle state
{
    const tree_leaf     = $(this).closest(".tree-view-leaf");
    const element_id    = tree_leaf.attr("data-id");
    const state         = nodeIsOpened("#" + element_id, true);

    if(state) 
    {
        $(this).removeClass("rotated");
        tree_leaf.find(".tree-view-leaf").hide("medium");
    } 
    else 
    {
        $(this).addClass("rotated");
        tree_leaf.find(".tree-view-leaf").show("medium");
    }
    return false;
});

$(document).on("click", ".tree-view-leaf label i.fa-trash", function(event) //Remove layer
{
    event.stopPropagation();

    const data_id       = $(this).closest(".tree-view-leaf").attr("data-id");
    var $removed_item   = $("#" + data_id);

    if($removed_item.hasClass("page-a4"))
    {
        $removed_item = $removed_item.closest(".page-frame");
    }
    $removed_item.remove();

    hideBlocksOnRightSideBar();
    hideHighlightedMask();
    saveStack();

    reloadHiearchyView();
});

function nodeIsOpened(node, flip_state) //Get and flip layer toggle state 
{
    const state = $(node).attr("data-editor_opened") == "true";
    if(_isTrue(flip_state)) 
    {
        $(node).attr("data-editor_opened", state ? "false" : "true");
    }
    return state;
}

$(document).on("click", ".tree-view-leaf label", function() //Event for set layer toggle state
{
    const element_id = $(this).closest(".tree-view-leaf").attr("data-id");
    $("#" + element_id).click();
});

$(document).on("mouseover", ".tree-view-leaf label", function() //Event for show highlight mask for selected layer component 
{
    const element_id    = $(this).closest(".tree-view-leaf").attr("data-id");
    const offset        = $("#" + element_id).offset();

    $("#highlighted_mask").css({ 
        top:        offset.top - 4, 
        left:       offset.left - 4, 
        display:    "block",
        width:      $("#" + element_id).outerWidth(),
        height:     $("#" + element_id).outerHeight()
    });
    return false;
});

$(document).on("mouseout", ".tree-view-leaf label", function() //Event for hide highlight mask
{
    hideHighlightedMask();
}); 

function treeLeafOnDragstart(event) 
{ 
    const moved_id = $(event.target).attr("data-id");
    if($("#" + moved_id).hasClass("editor-element"))
    {
        event.dataTransfer.setData("moved_id", moved_id);
    }
    else
    {
        event.preventDefault();
    }
}

function treeLeafOnDragover(event) 
{
    event.preventDefault();
}

function treeLeafOnDrop(event) 
{ 
    event.preventDefault();
    event.stopPropagation();

    if (!("dataTransfer" in event)) 
    {
        event.dataTransfer = event.originalEvent.dataTransfer;
    }
    const moved_id      = event.dataTransfer.getData("moved_id");
    const parent_id     = $(event.currentTarget).attr("data-id");
    const moved_item    = $("#" + moved_id);
    const parent_item   = $("#" + parent_id);

    if(parent_item.closest("#" + moved_id).length == 0 && isDropZone(parent_item)) 
    {
        moved_item.attr("data-parent", parent_id);
        moved_item.css({ left: 0, top: 0 });
        parent_item.append(moved_item.get(0));

        reloadHiearchyView();
    }
}

$(document).on("click", "#op_align_left", function()
{
    const element = $(".editor-element.active");

    element.css({ left: 0 });
    element.click();
});

$(document).on("click", "#op_align_center_h", function()
{
    const element       = $(".editor-element.active");
    const parent        = $("#" + element.attr("data-parent"));
    const parent_rect   = parent.get(0).getBoundingClientRect();
    const element_rect  = element.get(0).getBoundingClientRect();

    element.css({ left: (parent_rect.width - element_rect.width) / 2 });
    element.click();
});

$(document).on("click", "#op_align_right", function()
{
    const element       = $(".editor-element.active");
    const parent        = $("#" + element.attr("data-parent"));
    const parent_rect   = parent.get(0).getBoundingClientRect();
    const element_rect  = element.get(0).getBoundingClientRect();

    element.css({ left: (parent_rect.width - element_rect.width) });
    element.click();
});

$(document).on("click", "#op_align_stretch_h", function()
{
    const element       = $(".editor-element.active");
    const parent        = $("#" + element.attr("data-parent"));
    const parent_rect   = parent.get(0).getBoundingClientRect();

    element.css({ left: 0, width: parent_rect.width });
    element.click();
});

$(document).on("click", "#op_align_top", function()
{
    const element = $(".editor-element.active");

    element.css({ top: 0 });
    element.click();
});

$(document).on("click", "#op_align_center_v", function()
{
    const element       = $(".editor-element.active");
    const parent        = $("#" + element.attr("data-parent"));
    const parent_rect   = parent.get(0).getBoundingClientRect();
    const element_rect  = element.get(0).getBoundingClientRect();

    element.css({ top: (parent_rect.height - element_rect.height) / 2 });
    element.click();
});

$(document).on("click", "#op_align_bottom", function()
{
    const element       = $(".editor-element.active");
    const parent        = $("#" + element.attr("data-parent"));
    const parent_rect   = parent.get(0).getBoundingClientRect();
    const element_rect  = element.get(0).getBoundingClientRect();

    element.css({ top: (parent_rect.height - element_rect.height) });
    element.click();
});

$(document).on("click", "#op_align_strech_v", function()
{
    const element       = $(".editor-element.active");
    const parent        = $("#" + element.attr("data-parent"));
    const parent_rect   = parent.get(0).getBoundingClientRect();

    element.css({ top: 0, height: parent_rect.height });
    element.click();
});

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------

//==============================================================================
//Editor bar events
//==============================================================================
$(document).on("click", "#add_new_a4", function() //Event for create new page
{
//    $("#page_container").append(tools_page_a4.tohtml({ id: "root_" + getUniqueId() }));
    $("#page_container").append(
        tools_page_a4.tohtml({ id: "page_" + getUniqueId() })
    );
    saveStack();
    reloadHiearchyView();
});

function componentOnDragstart(event) //Event for component panel drag new component
{
    const element_type = $(event.target).attr("data-type");

    event.dataTransfer.setData("element_id", element_type + "_" + getUniqueId());
    event.dataTransfer.setData("element_type", element_type);
}

function componentOnDragover(event) 
{
    event.preventDefault();
}

function componentOnDrop(event) //Event for drop a component to editor bar
{
    event.preventDefault();
    if (!("dataTransfer" in event)) 
    {
        event.dataTransfer = event.originalEvent.dataTransfer;
    }
    const element_id    = event.dataTransfer.getData("element_id");
    const element_type  = event.dataTransfer.getData("element_type");
    var parent          = $(event.target);
    const offset        = parent.offset();
    console.log('event', event.dataTransfer, element_id, element_type);

    if(element_id.length > 0)
    {
        while(parent.attr("id") == element_id && _isValid(parent.parent())) //Find immediate parent
        {
            parent = parent.parent();
        }
    
        if(isDropZone(parent))  //Create new element or component
        {
            const var_package = {
                id:     element_id,
                parent: parent.attr('id'),
                pos_x:  (event.pageX - offset.left) + "px",
                pos_y:  (event.pageY - offset.top) + "px"
            };

            if(element_type.charAt(0) != "_") //Element case
            {
                if(element_type == "image")
                {
                    createImageElement(parent, var_package);
                }
                else if(element_type == "text")
                {
                    createTextEditorElement(parent, var_package);
                }
                else
                {
                    parent.append(elements[element_type].tohtml(var_package));
                }
                $("#" + element_id).click(); //Set focus
            } 
            else //Component case
            {
                parent.append(component_list[element_type].data.tohtml());
                const $last_item = parent.children().last();
    
                $last_item.removeClass("active");
                $last_item.css({ top: var_package.pos_y, left: var_package.pos_x });
    
                regenerateId($last_item, element_type.substr(1));
                $last_item.click();
            }
            saveStack();
        }
    }
}

$(document).on("click", "#page_container, #top_bar", function() //Event for click neutral area of page
{
    setSelectedItem(null);
});

$(document).on("click", ".page-a4", function(event) //Event for click neutral area of page
{
    event.stopPropagation();
    setSelectedItem(this);
    
    const $prop_attr_name = $("#prop_attr_name");
    $prop_attr_name.val(getLeafLabel(this));
    $prop_attr_name.closest(".common-prop-group").show();
});

$(document).on("click", ".editor-element", function(event) //Event for click an available component
{
    if(!action_on_move)
    {
        event.stopPropagation();
        selectComponent(this);
    }
});

$(document).on("click", "a", function(event) 
{
    event.preventDefault();
});

$(document).on("mouseover", "#drag_zone", function(event) 
{ 
    event.stopPropagation();

    $(this).css({
        width:  "100%",
        height: "100%"
    });

    const $selected_item = $(getSelectedItem());
    $selected_item.css({ resize: "none" });
});

$(document).on("mousedown", "#drag_zone", function(event) 
{ 
    event.stopPropagation();

    action_on_move  = true;
    action_pick_x   = event.clientX;
    action_pick_y   = event.clientY;

    hideTextEditorToolbar();
});

$(document).on("mousemove", ".page-a4", function(event) 
{ 
    if(action_on_move)
    {
        mouse_x                 = event.clientX;
        mouse_y                 = event.clientY;
        translate_x             = (mouse_x - action_pick_x);
        translate_y             = (mouse_y - action_pick_y);
        const $selected_item    = $(getSelectedItem());
        const parent_array      = document.elementsFromPoint(event.clientX, event.clientY);
        var on_outside          = true;

        parent_array.forEach(parent => 
        {
            const $parent = $(parent);
            if(isDropZone($parent, $selected_item))
            {
                on_outside = false;
            }
        });

        if(on_outside)
        {
            $selected_item.css({ transform: "" });
            action_on_move = false;
        }
        else
        {
            $selected_item.css({ 
                transform: "translate(" + translate_x + "px," + translate_y + "px)" 
            });

            showHelpLinesLayer(); 
            tryAlign();
        }
    }
});

$(document).on("mouseup", ".page-a4", function(event) 
{ 
    const $selected_item = $(getSelectedItem());
    if($selected_item.length > 0)
    {
        if(action_on_move)
        {
            event.preventDefault();
            event.stopPropagation();

            const position      = $selected_item.offset();
            const parent_array  = document.elementsFromPoint(event.clientX, event.clientY);
            var direct_parent   = null;

            parent_array.forEach(parent => 
            {
                const $parent = $(parent);
                if(direct_parent === null && isDropZone($parent, $selected_item))
                {
                    direct_parent = parent;
                }
            });

            if(direct_parent !== null)
            {
                if(direct_parent.getAttribute("id") != $selected_item.attr("data-parent"))
                {
                    $selected_item.attr("data-parent", direct_parent.getAttribute("id"));
                    direct_parent.append($selected_item.get(0));
                }
                const offset = $(direct_parent).offset();
                $selected_item.css({
                    left:       (position.left - offset.left) + "px",
                    top:        (position.top - offset.top) + "px",
                    transform:  "" 
                });

                selectComponent($selected_item.get(0));
                reloadHiearchyView();
            }
            showTextEditorToolbar();
            hideHelperLines();
            saveStack();

            event.preventDefault();
            event.stopPropagation();
            action_on_move = false;
        }
        else
        {
            if(last_width != $selected_item.width() || last_height != $selected_item.height())
            {
                saveStack();
            }
        }
        $selected_item.css({ resize: "" });
    }
});

function isDropZone($parent, $node)
{
    if(_isUndefined($node))
    {
        return $parent.prop("tagName").toLowerCase() == "div" && 
            ($parent.hasClass("page-a4") || $parent.hasClass("editor-element")) &&
            !$parent.hasClass("image-container") &&
            !$parent.hasClass("text-editor-container");    
    }
    else
    {
        return $parent.attr("id") != $node.attr("id") && 
            $node.find("#" + $parent.attr("id")).length == 0 && 
            isDropZone($parent);
    }
}

function selectComponent(component) 
{
    setSelectedItem(component);

    const attr_package  = attributeLoader(component); //Get selected css and prop data
    const style_package = styleLoader(component); //Get selected css and prop data

    $.each(attr_package, function(key, value) 
    {
        const $item = $("#prop_attr_" + key);
        if(value !== null)
        {
            $item.val(value); //Show attributes on right side bar
            $item.closest(".common-prop-field").show();
            $item.closest(".common-prop-group").show(); //Show panel
        }
        else
        {
            $item.closest(".common-prop-field").hide();
        }
    });
    $.each(style_package, function(key, value) 
    {
        const $item = $("#prop_style_" + key);
        if(value !== null)
        {
            $item.val(value); //Show styles on right side bar
            $item.closest(".common-prop-field").show();
            $item.closest(".common-prop-group").show(); //Show panel
        }
        else
        {
            $item.closest(".common-prop-field").hide();
        }
    });

    showTextEditorToolbar(); //Show editor toolbar if is an text editor container
    $(component).append(drag_zone.tohtml()); //Create new drag zone
}

function attributeLoader(node) //Create data package by selected component
{
    const $node = $(node);
    switch(node.tagName.toLowerCase())
    {
        case "h1":
        case "h2":
        case "h3":
        case "h4":
        case "h5":
        case "h6":
            return {
                name:           getLeafLabel(node),
                text_content:   $node.find(".text-container").html()
            };
        case "div":
            if($node.hasClass("image-container"))
            {
                return {
                    name:   getLeafLabel(node),
                    src:    $node.find("img").attr("src")
                };
            }
            else if($node.hasClass("text-editor-container"))
            {
                return {
                    name: getLeafLabel(node)
                };
            }
            else
            {
                return {
                    name: getLeafLabel(node)
                };
            }
        case "a":
            return {
                name:           getLeafLabel(node),
                href:           $node.attr("href"),
                text_content:   $node.find(".text-container").html()
            };
        default:
            return {};
    }
}

function styleLoader(node) //Create data package by selected component
{
    var text_align = node.style.textAlign;
    if(text_align.length == 0) 
    {
        text_align = "initial";
    }
    const $item             = $(node);
    var left                = node.style.left;
    var top                 = node.style.top;
    var width               = node.style.width;
    var height              = node.style.height;

    var background_image    =  $item.css("background-image");
    var background_position = node.style.backgroundPosition;
    var background_size     =  $item.css("background-size");
    var background_repeat   =  $item.css("background-repeat");

    var left_unit           = left.instr("%") ? "%" : "px";
    var top_unit            = top.instr("%") ? "%" : "px";
    var width_unit          = width.instr("%") ? "%" : "px";
    var height_unit         = height.instr("%") ? "%" : "px";

    background_image = background_image
        .replace("url", "")
        .replace("(", "")
        .replace(")", "")
        .replaceAll("'", "")
        .replaceAll('"', "");

    switch(node.tagName.toLowerCase())
    {
        case "a":
        case "h1":
        case "h2":
        case "h3":
        case "h4":
        case "h5":
        case "h6":
                background_image    = null;
                background_position = null;
                background_size     = null;
                background_repeat   = null;
        case "div":
            return {
                left:                   left.length > 0 ? left.toNumber() :  $item.position().left,
                top:                    top.length > 0 ? top.toNumber() :  $item.position().top,
                width:                  width.length > 0 ? width.toNumber() :  $item.width(),
                height:                 height.length > 0 ? height.toNumber() :  $item.height(),
                color:                  $item.css("color").rgbToHexa(),
                background_color:       $item.css("background-color").rgbToHexa(),
                background_image:       background_image,
                background_position:    background_position,
                background_size:        background_size,
                background_repeat:      background_repeat,
                border_style:           node.style.borderStyle == undefined || node.style.borderStyle == '' ? 'solid' : node.style.borderStyle,
                border_width:           node.style.borderWidth.toNumber(0),
                border_radius:          node.style.borderRadius.toNumber(0),
                border_color:           node.style.borderColor == undefined || node.style.borderColor == '' ? ('rgb(220, 220, 220)').rgbToHexa() : node.style.borderColor.rgbToHexa(),
                text_align:             text_align,
                font_weight:            $item.css("font-weight"),
                font_family:            node.style.fontFamily,
                font_size:              $item.css("font-size").toNumber(1),
                line_height:            $item.css("line-height").toNumber(1),
                letter_spacing:         $item.css("letter-spacing").toNumber(0),
                opacity:                $item.css("opacity").toNumber(1),
                padding_top:            $item.css("padding-top").toNumber(1),
                padding_bottom:         $item.css("padding-bottom").toNumber(1),
                padding_left:           $item.css("padding-left").toNumber(1),
                padding_right:          $item.css("padding-right").toNumber(1),

                left_unit:              left_unit,
                top_unit:               top_unit,
                width_unit:             width_unit,
                height_unit:            height_unit
            };
        case "img":
            return {
                left:                   left.length > 0 ? left.toNumber() :  $item.position().left,
                top:                    top.length > 0 ? top.toNumber() :  $item.position().top,
                width:                  width.length > 0 ? width.toNumber() :  $item.width(),
                height:                 height.length > 0 ? height.toNumber() :  $item.height(),
                color:                  $item.css("color").rgbToHexa(),
                background_color:       $item.css("background-color").rgbToHexa(),
                border_style:           node.style.borderStyle == undefined || node.style.borderStyle == '' ? 'solid' : node.style.borderStyle,
                border_width:           node.style.borderWidth.toNumber(0),
                border_radius:          node.style.borderRadius.toNumber(0),
                border_color:           node.style.borderColor == undefined || node.style.borderColor == '' ? ('rgb(220, 220, 220)').rgbToHexa() : node.style.borderColor.rgbToHexa(),
                text_align:             text_align,
                opacity:                $item.css("opacity"),
                padding_top:            $item.css("padding-top").toNumber(1),
                padding_bottom:         $item.css("padding-bottom").toNumber(1),
                padding_left:           $item.css("padding-left").toNumber(1),
                padding_right:          $item.css("padding-right").toNumber(1),

                left_unit:              left_unit,
                top_unit:               top_unit,
                width_unit:             width_unit,
                height_unit:            height_unit
            };
        default:
            return {};
    }
}

function hideHighlightedMask()
{
    $("#highlighted_mask").hide();
}

function hideBlocksOnRightSideBar()
{
    $("#right_side_bar .common-prop-group").hide();
}

function hideTextEditorToolbar()
{
    const $selected_item = $(getSelectedItem());
    if($selected_item.length > 0)
    {
        $selected_item.find(".ql-toolbar").hide();
    }
}

function showTextEditorToolbar()
{
    const $selected_item = $(getSelectedItem());
    if($selected_item.length > 0)
    {
        $selected_item.find(".ql-toolbar").show();
    }
}

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------

function tryAlign()
{
    const $selected_item = $(getSelectedItem());
    if($selected_item.length > 0)
    {
        const $line_left            = $("#helper_line_left");
        const $line_right           = $("#helper_line_right");
        const $line_top             = $("#helper_line_top");
        const $line_bottom          = $("#helper_line_bottom");
        const $line_vertical        = $("#helper_line_vertical");
        const $line_horizontal      = $("#helper_line_horizontal");
        const client_rect           = $selected_item.get(0).getBoundingClientRect();
        const stride                = 8;

        const border_left           = $selected_item.position().left;
        const border_right          = border_left + client_rect.width;
        const border_top            = $selected_item.position().top;
        const border_bottom         = border_top + client_rect.height;

        var need_vertical_align     = true;
        var need_horizontal_align   = true;
    
        if($line_left.length > 0 && Math.abs(border_left - $line_left.position().left) < stride)
        {
            translate_x = $line_left.position().left - +$selected_item.css("left").toNumber();
        }
        else if($line_left.length > 0 && Math.abs(border_right - $line_left.position().left) < stride)
        {
            translate_x = $line_left.position().left - (+$selected_item.css("left").toNumber() + client_rect.width);
        }
        else if($line_right.length > 0 && Math.abs(border_left - $line_right.position().left) < stride)
        {
            translate_x = $line_right.position().left - +$selected_item.css("left").toNumber();
        }
        else if($line_right.length > 0 && Math.abs(border_right - $line_right.position().left) < stride)
        {
            translate_x = $line_right.position().left - (+$selected_item.css("left").toNumber() + client_rect.width);
        }
        else if($line_vertical.length > 0 && Math.abs(border_left - $line_vertical.position().left) < stride)
        {
            translate_x = $line_vertical.position().left - +$selected_item.css("left").toNumber();
        }
        else if($line_vertical.length > 0 && Math.abs(border_right - $line_vertical.position().left) < stride)
        {
            translate_x = $line_vertical.position().left - (+$selected_item.css("left").toNumber() + client_rect.width);
        }
        else
        {
            need_vertical_align = false;
        }
    
        if($line_top.length > 0 && Math.abs(border_top - $line_top.position().top) < stride)
        {
            translate_y = $line_top.position().top - +$selected_item.css("top").toNumber();
        }
        else if($line_top.length > 0 && Math.abs(border_bottom - $line_top.position().top) < stride)
        {
            translate_y = $line_top.position().top - (+$selected_item.css("top").toNumber() + client_rect.height);
        }
        else if($line_bottom.length > 0 && Math.abs(border_top - $line_bottom.position().top) < stride)
        {
            translate_y = $line_bottom.position().top - +$selected_item.css("top").toNumber();
        }
        else if($line_bottom.length > 0 && Math.abs(border_bottom - $line_bottom.position().top) < stride)
        {
            translate_y = $line_bottom.position().top - (+$selected_item.css("top").toNumber() + client_rect.height);
        }
        else if($line_horizontal.length > 0 && Math.abs(border_top - $line_horizontal.position().top) < stride)
        {
            translate_y = $line_horizontal.position().top - +$selected_item.css("top").toNumber();
        }
        else if($line_horizontal.length > 0 && Math.abs(border_bottom - $line_horizontal.position().top) < stride)
        {
            translate_y = $line_horizontal.position().top - (+$selected_item.css("top").toNumber() + client_rect.height);
        }
        else
        {
            need_horizontal_align = false;
        }
    
        if(need_vertical_align || need_horizontal_align)
        {
            const translate_style = "translate(" + translate_x + "px," + translate_y + "px)";
            $selected_item.css({
                transform:          translate_style,
                webkitTransform:    translate_style
            });
        }
    }
}

function showHelpLinesLayer() 
{
    const $selected_item    = $(getSelectedItem());
    const $page_item        = $selected_item.closest(".page-a4");
    var helper_lines_str    = "";

    $page_item.find(".editor-element").each(function(key, item) 
    {
        const $item = $(item);
        if($item.attr("data-parent") == $selected_item.attr("data-parent") && $item.attr("id") != $selected_item.attr("id")) 
        {
            const rect = item.getBoundingClientRect();
            if(mouse_x >= rect.left && mouse_x <= rect.right && mouse_y >= rect.top && mouse_y <= rect.bottom)
            {
                hideHelperLines();
                helper_lines_str += helper_line_vertical.tohtml(
                    {
                        id:     "helper_line_left",
                        offset: $item.position().left + "px"
                    }
                ) + 
                helper_line_vertical.tohtml(
                    {
                        id:     "helper_line_right",
                        offset: ($item.position().left + rect.width) + "px"
                    }
                ) + 
                helper_line_vertical.tohtml(
                    {
                        id:     "helper_line_vertical",
                        offset: ($item.position().left + (rect.width / 2)) + "px"
                    }
                ) + 
                helper_line_horizontal.tohtml(
                    {
                        id:     "helper_line_top",
                        offset: $item.position().top + "px"
                    }
                ) + 
                helper_line_horizontal.tohtml(
                    {
                        id:     "helper_line_bottom",
                        offset: ($item.position().top + rect.height) + "px"
                    }
                ) + 
                helper_line_horizontal.tohtml(
                    {
                        id:     "helper_line_horizontal",
                        offset: ($item.position().top + (rect.height / 2)) + "px"
                    }
                );
                $("#" + $item.attr("data-parent")).append(helper_lines_str);
                $("#helper_line_vertical, #helper_line_horizontal").addClass("dashed")
            }
        }
    });
}

function hideHelperLines()
{
    $(".helper-line").remove();
}

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------

//==============================================================================
//Right side bar css style modification
//==============================================================================
$(document).ready(function()
{
    $(".common-prop-group.style").append('<i class="fa fa-toggle-on toggle"></i>');
});

$(document).on("click", ".common-prop-group.style .toggle", function(event)
{
    event.preventDefault();

    const $common_prop_group = $(this).closest(".common-prop-group");
    if($common_prop_group.hasClass("opened"))
    {
        this.className = "fa fa-toggle-off toggle";
        $common_prop_group.find(".wrapper").slideUp(200);
        $common_prop_group.removeClass("opened");
    }
    else
    {
        this.className = "fa fa-toggle-on toggle";
        $common_prop_group.find(".wrapper").slideDown(200);
        $common_prop_group.addClass("opened");
    }
});

$(document).on("change", ".common-prop-field.attr input", function(event) //Change attribute value
{
    event.preventDefault();
    reloadComponentAttr(this);

    if(this.id == "prop_attr_name")
    {
        reloadHiearchyView();
    }
    return false;
});

$(document).on("change", ".common-prop-field.attr select", function() //Change attribute value
{
    reloadComponentAttr(this);
    return false;
});

$(document).on("change", ".common-prop-field.style input", function() 
{
    if(this.type == "text" && !_isTrue(this.getAttribute("data-alphanumeric")))
    {
        this.value = this.value.toNumber(); //Disable non numeric chars
    }
    reloadComponentStyles(this);

    return false;
});

$(document).on("change", ".common-prop-field.style select", function() 
{
    reloadComponentStyles(this);
    return false;
});

$(document).on("change", ".common-prop-field.set select, .common-prop-field select.set", function() //Refresh after change unit set
{
    $("#" + this.getAttribute("id").replace("_unit", "")).trigger("change");
});

function reloadComponentAttr(prop) 
{
    const $selected_item = $(getSelectedItem());
    if($selected_item.length > 0) 
    {
        const prop_name = prop.id.replace("prop_attr_", "").replaceAll("_", "-");
        if(prop.id == "prop_attr_text_content") //Special case for text fields.
        {
            $selected_item.find(".text-container").html(prop.value);
        }
        else if(prop.id == "prop_attr_src") //Special case for background image url.
        {
            $selected_item.find("img").attr(prop_name, prop.value);
        }
        else //Default case for base props
        {
            $selected_item.attr(prop_name, prop.value);
        }
        saveStack();
    }
}

function reloadComponentStyles(prop) 
{
    const $selected_item = $(getSelectedItem());
    if($selected_item.length > 0) 
    {
        const style_package = {};
        const prop_name = prop.id
            .replace("prop_style_", "")
            .replaceAll("_", "-");

        if(prop.id == "prop_style_background_image") //Special case for background image url.
        {
            style_package[prop_name] = (prop.value.length > 0 ? "url('" + prop.value + "')" : "");
        }
        else //Default case for base props
        {
            const data_set = prop.getAttribute("data-set");
            if(_isValid(data_set))
            {
                style_package[prop_name] = prop.value + $(data_set).val();
            }
            else
            {
                style_package[prop_name] = prop.value;
            }
        }
        $selected_item.css(style_package);
        saveStack();
    }
}


//------------------------------------------------------------------------------
//------------------------------------------------------------------------------

//==============================================================================
//Component modal
//==============================================================================
$(document).on("click", "#create_component", function() 
{
    const $selected_item = $(getSelectedItem());
    $selected_item.find('#drag_zone').remove();
    console.log($selected_item);
    if($selected_item.length > 0 && $selected_item.hasClass("editor-element"))
    {
        const component_name = $("#component_editor_name").val();

        if($(".component-element[data-type='_" + component_name + "']").length == 0)
        {
            const component_label   = $("#component_editor_label").val();
            const clone             = $selected_item.get(0).cloneNode(true);
        
//            $(clone).find(".ql-container").each(function(key, item) //Can't clone editor toolbar, only nested data
//            {
//                $(item).closest(".text-editor-container").html(
//                    $(item).find(".ql-editor").html()
//                );
//            });

            $(clone).find(".ql-toolbar").remove(); //Can't clone editor toolbar, only nested data
        
            component_list["_" + component_name] = {
                label:  component_label, 
                data:   encodeURI(clone.outerHTML)
            };
            reloadComponentView();
            $('#component_editor_modal').modal('hide');
            toastr("The component is created", "success");
            
            // Set element id
            const src = document.querySelector("#" + $selected_item.attr('id'));
            
            // Create canvas place
            $('#thumbnails').append('<div id="canvas-' + component_name + '"></div>');
            const img = document.getElementById('canvas-' + $selected_item.attr('id'));
            
            // Generate canvas
            html2canvas(document.querySelector("#" + $selected_item.attr('id')), {
                allowTaint: true,
                useCORS: true,
                scale: 1
            }).then(function (canvas) {
                document.body.appendChild(canvas);
                $('#canvas-' + component_name).html(canvas);
            });
        }
        else
        {
            toastr("Exist name", "warning");
        }
    }
    else
    {
        toastr("Select a component", "warning");
    }
});

function reloadComponentView(saved_list) //Component panel show current clonable components
{
    $("#component_panel").html(
        stamp_create_component.tohtml()
    );

    if(_isUndefined(saved_list)) //From db
    {;
        $.each(component_list, function(key, item) 
        {
            const operation_icon = ("hash" in item ? btn_delete_component.tohtml() : btn_save_component.tohtml());
            if (item.thumbnail != '') {
                $("#component_panel").append(
                    stamp_element_bg.tohtml({ 
                        type:           key, 
                        name:           item.label, 
                        operation_icon: operation_icon,
                        blank:          "false",
                        background:     item.thumbnail
                    })
                );
            } else {
                $("#component_panel").append(
                    stamp_element.tohtml({ 
                        type:           key, 
                        name:           item.label, 
                        operation_icon: operation_icon,
                        blank:          "false",
                        tooltip: false,
                        tooltip_text: '',
                        icon: ''
                    })
                );
            }
        });
    }
    else
    {
        console.log(saved_list);
        $.each(saved_list, function(key, item) 
        {
//            if(item.name.charAt(0) == '_' && item.content.length > 0)
            if(item.name.charAt(0) == '_'&& item.content != null && item.content.length > 0)
            {
//                $("#component_panel").append(
//                    stamp_element.tohtml({ 
//                        type:           item.name, 
//                        name:           item.label, 
//                        operation_icon: btn_delete_component.tohtml(),
//                        blank:          "false" ,
//                        tooltip: false,
//                        tooltip_text: '',
//                        icon: ''
//                    }).replace(/\n/g, '')
//                );
                if (item.thumbnail != '') {
                    $("#component_panel").append(
                        stamp_element_bg.tohtml({ 
                            type:           item.name, 
                            name:           item.label, 
                            operation_icon: btn_delete_component.tohtml(),
                            blank:          "false",
                            background:     item.thumbnail
                        }).replace(/\n/g, '')
                    );
                } else {
                    $("#component_panel").append(
                        stamp_element.tohtml({ 
                            type:           item.name, 
                            name:           item.label, 
                            operation_icon: btn_delete_component.tohtml(),
                            blank:          "false",
                            tooltip: false,
                            tooltip_text: '',
                            icon: ''
                        }).replace(/\n/g, '')
                    );
                }
                component_list[item.name] = {
                    hash:   item.hash,
                    label:  item.label, 
                    data:   item.content,
                    thumbnail: item.thumbnail
                };
            }
        });
    }
}

function regenerateId($node, prefix) //Cloned components need to new unique id
{
    $node.attr("id", prefix + "_" + getUniqueId(true));
//    $node.attr("id", prefix + "_" + hashids.encode(1));
    $node.attr("name", null); //Remove old name

    if(!$node.hasClass("image-container") && !$node.hasClass("text-editor-container")) //Images and text editor nested elements cant't get unque id
    {    
        $.each($node.children(), function(key, children) 
        {
            regenerateId($(children), prefix);
        });
    }
}

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
function createImageElement($parent, var_package)
{
    if($parent.hasClass("editor-element")) 
    {
        $parent.html(
            elements["image"].tohtml(var_package)
        );
        $parent.addClass("image-container");
        $parent.click();
    }
}

function createTextEditorElement($parent, var_package) 
{
    if($parent.hasClass("editor-element")) 
    {
        $parent.html(
            elements["text"].tohtml(var_package)
        );
        active_editor = new Quill("#" + $parent.attr("id") + " div", {
            theme: "snow",
            placeholder: 'Ide írhatod a szöveget...',
            modules: {
                toolbar: quillToolbarOptions
            }
        });
        $parent.addClass("text-editor-container");
        $parent.click();
    }
}

function initTextEditor(id) 
{
    let $element = $('#' + id);
    if($element.hasClass("text-editor-container")) 
    {
        let editor_content = JSON.parse($element.attr('data-content'));
        $element.html('<div></div>');
        active_editor = new Quill("#" + id + " div", {
            theme: "snow",
            placeholder: 'Ide írhatod a szöveget...',
            modules: {
                toolbar: quillToolbarOptions,
                history: {
                  delay: 1000,
                  maxStack: 500
                }
            }
        });
        active_editor.setContents(editor_content);
    }
    
}

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------


