

$(document).on("click", ".common-tab-pillow", function() 
{
    $(this).closest(".common-tab-bar").find(".common-tab-pillow").removeClass("active");
    $(this).addClass("active");

    const target = $(this).attr("data-target");
    $(target).closest(".common-tab-container").find(".common-tab-panel").removeClass("active");
    $(target).addClass("active");
});

var unique_index = 0;

function getUniqueId(with_counter) 
{
    var dateTime = new Date();

    if(_isTrue(with_counter)) 
    {
        var id = parseInt(dateTime.toLocaleString().replace(/\D/g, "")).toString(36) + dateTime.getMilliseconds().toString(36) + unique_index++;
        var hashids = new Hashids(id, 3);
        console.log('hash', hashids.encode(1));
        return hashids.encode(1);
    } 
    else 
    {
        var id = parseInt(dateTime.toLocaleString().replace(/\D/g, "")).toString(36) + dateTime.getMilliseconds().toString(36);
        var hashids = new Hashids(id, 3);
        unique_index = 0;
        console.log('hash', hashids.encode(1));
        return hashids.encode(1);
    }
}

String.prototype.tohtml = function(variables) 
{
    var html_str = this.uriparse();
    if(variables !== null && typeof variables === 'object') 
    {
        Object.keys(variables).map(function(key, index) 
        {
            const value = variables[key];
            html_str = html_str.replaceAll("[" + key + "]", value);
        });
    }
    return html_str;
}

String.prototype.jparse = function() 
{
    return JSON.parse(this);
}

String.prototype.uriparse = function() 
{
    return decodeURIComponent(this.replace(/\+/g, ' '));
}

String.prototype.replaceAll = function(search, replacement) 
{
    var target = this;
    return target.split(search).join(replacement);
}

$.fn.extend({
    success: function() {
        return "success" in this && _isTrue(this.is_success);
    },
    responseData: function() {
        return "result" in this && this.result;
    }
});

String.prototype.toResponse = function() 
{
    return JSON.parse(this);
}

function _isTrue(val) 
{
    return _isValid(val) && (val === true || val === "true" || val === 1 || val === "1");
}

function _isString(val) 
{
    return (typeof val === "string");
}

function _isObject(val) 
{
    return (val instanceof Object || typeof val === 'object');
}

function _isValid(val) 
{
    return !_isUndefined(val) && val !== null;
}

function _isUndefined(val) 
{
    return (typeof val === 'undefined');
}

String.prototype.instr = function(need)
{
    return this.indexOf(need) != -1;
}

String.prototype.toNumber = function(def)
{
    if(this.length == 0)
    {
        if(_isUndefined(def))
        {
            def = null;
        }
        return def;
    }
    else
    {
        return this.replace(/[^\d.-]/g, '');
    }
}

String.prototype.rgbToHexa=function() 
{
    if(this.indexOf("rgb(") != -1) 
    {
        const rgb_array = this.replace("rgb(", "").replace(")", "").replace(";", "").split(",");
        var result      = "#";

        $.each(rgb_array, function(key, item) 
        {
            const hex = parseInt(item.replace(/\s/g, '')).toString(16);
            result += (hex.length == 1 ? "0" + hex : hex);
        });
        return result;
    } 
    else 
    {
        return this;
    }
}

