<?php

/**
 * @file API functions.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */

/**
 * Select template to create new proposal
 * @param mixed $form
 * @param mixed $form_state
 * @return $form
 */
function propeditor_template_select_form($form, &$form_state, $uid = '') {

    global $user;
    if (empty($uid)) {
        $uid = $user->uid;
    }

    $templates = propeditor_get_templates($uid);

    $basics = '
                    <div class="col-4">
                      <div class="card b template-box" id="template-0" data-tid="0" style="height: calc(100% - 1.25rem);">
                        <div class="portlet-handler" style="height: 100%;">
                           <div class="row row-flush" style="height: 100%;">
                              <div class="col-5 bg-gray text-center d-flex align-items-center justify-content-center rounded-left">
                                 <em class="fa-5x far fa-file-image"></em>
                              </div>
                              <div class="col-7">
                                 <div class="card-body text-center">
                                    <h4 class="mt-0">' . t('Üres') . '</h4>
                                    <div class="checkbox c-checkbox mr-0">
                                        <label class="p-0">
                                           <input type="checkbox" id="check-0" name="check-0" value="0">
                                           <span class="fa fa-check m-0"></span></label>
                                    </div>
                                 </div>
                              </div>
                           </div>
                        </div>
                      </div>
                    </div>';
    $basics_count = 0;
    $customs = '';
    $customs_count = 0;
    foreach ($templates as $template) {
        $thumbnail = !empty($template->thumbnail) ? file_create_url($template->thumbnail) : 'https://placehold.it/210x297';
        if ($template->uid == 0) {
            $basics .= '
                    <div class="col-4">
                      <div class="card b template-box" id="template-' . $template->hash . '" data-tid="' . $template->hash . '">
                        <div class="portlet-handler">
                           <div class="row row-flush">
                              <div class="col-5 bg-gray text-center d-flex align-items-center justify-content-center rounded-left">
                                 <img src="' . $thumbnail . '" class="img-fluid rounded-left">
                              </div>
                              <div class="col-7">
                                 <div class="card-body text-center">
                                    <h4 class="mt-0">' . $template->title . ' <small><a href="/template/' . $template->hash . '/rename" class="edit-template"><em class="fas fa-pencil-alt"></em></a></small></h4>
                                    <div class="checkbox c-checkbox mr-0">
                                        <label class="p-0">
                                           <input type="checkbox" id="check-' . $template->hash . '" name="check-' . $template->hash . '" value="' . $template->hash . '">
                                           <span class="fa fa-check m-0"></span></label>
                                    </div>
                                 </div>
                              </div>
                           </div>
                        </div>
                      </div>
                    </div>';
            $basics_count++;
        } else {
            $customs .= '
                    <div class="col-4">
                      <div class="card b template-box" id="template-' . $template->hash . '" data-tid="' . $template->hash . '">
                        <div class="portlet-handler">
                           <div class="row row-flush">
                              <div class="col-5 bg-gray text-center d-flex align-items-center justify-content-center rounded-left">
                                 <img src="' . $thumbnail . '" class="img-fluid rounded-left">
                              </div>
                              <div class="col-7">
                                 <div class="card-body text-center">
                                    <h4 class="mt-0">' . $template->title . ' <small><a href="/template/' . $template->hash . '/rename" class="edit-template"><em class="fas fa-pencil-alt"></em></a></small></h4>
                                    <div class="checkbox c-checkbox mr-0">
                                        <label class="p-0">
                                           <input type="checkbox" id="check-' . $template->hash . '" name="check-' . $template->hash . '" value="' . $template->hash . '">
                                           <span class="fa fa-check m-0"></span></label>
                                    </div>
                                 </div>
                              </div>
                           </div>
                        </div>
                      </div>
                    </div>';
            $customs_count++;
        }
    }


    $form = array();

    $html = '
  <div class=" b card pt-3 px-3 pb-0">
    <div class="tab-content p-0" id="v-pills-tabContent">
      <div class="tab-pane fade active in" id="all" role="tabpanel" aria-labelledby="basic-tab">
        <div class="row row-eq-height">
        ' . $basics . $customs . '
        </div>
      </div>
      <div class="tab-pane fade" id="basic" role="tabpanel" aria-labelledby="basic-tab">
        <div class="row row-eq-height">
        ' . $basics . '
        </div>
      </div>
      <div class="tab-pane fade" id="custom" role="tabpanel" aria-labelledby="custom-tab">
        <div class="row row-eq-height">
        ' . $customs . '
        </div>
      </div>
    </div>
  </div>'
            . '</div>';

    $left = '<div class="card b">
                <div class="card-body">
                   <strong class="text-muted text-uppercase">' . t('Sablonok') . '</strong>
                </div>
                <ul class="list-group">
                    <li class="list-group-item rounded-0 active">
                        <a class="list-group-item-action d-flex justify-content-between align-items-center rounded-0" href="#all" data-toggle="tab">
                           <span class="circle bg-warning mr-2"></span>
                           <span>' . t('Összes') . '</span>
                           <span class="ml-auto badge">' . ($basics_count + $customs_count + 1) . '</span>
                        </a>
                    </li>
                    <li class="list-group-item rounded-0">
                        <a class="list-group-item-action d-flex justify-content-between align-items-center rounded-0" href="#basic" data-toggle="tab">
                           <span class="circle bg-purple mr-2"></span>
                           <span>' . t('Alap') . '</span>
                           <span class="ml-auto badge">' . ($basics_count + 1) . '</span>
                        </a>
                    </li>
                    <li class="list-group-item">
                        <a class="list-group-item-action d-flex justify-content-between align-items-center" href="#custom" data-toggle="tab">
                           <span class="circle bg-green mr-2"></span>
                           <span>' . t('Saját') . '</span>
                           <span class="ml-auto badge">' . $customs_count . '</span>
                        </a>
                    </li>
                </div>
             </div>';

    $script = '<script>(function ($) {'
            . '$("#templateBrowser").on("click", ".checkbox", function(){
            var value = $(this).find("input:checked").val();
            $(\'#templateBrowser input[type="checkbox"]:not([value="\' + value + \'"])\').prop("checked", false);
            $(\'input[type="hidden"][name="hash"]\').val(value);
            if ($(\'input[type="hidden"][name="hash"]\').val() == "") {
                $("#edit-submit").attr("disabled", "disabled");
            } else {
                $("#edit-submit").removeAttr("disabled");
            }
        });
    })(jQuery);'
            . '</script>';

    $form['leftside'] = array(
        '#markup' => $left,
        '#prefix' => '<div class="row" id="templateBrowser"><div class="col-3">',
        '#suffix' => '',
    );

    $form['title'] = array(
        '#title' => t('Ajánlat címe'),
//        '#description' => t('Fontos, hogy valós email címet adj meg, hogy az ajánlatod ne menjen mellé.'),
        '#type' => 'textfield',
        '#required' => TRUE,
        '#prefix' => '<div class="col-9"><div class="pb-4">',
        '#suffix' => '</div>',
    );

    $form['browser'] = array(
        '#markup' => $html,
        '#prefix' => '',
        '#suffix' => '</div></div>',
    );

    $form['hash'] = array(
        '#type' => 'hidden',
        '#value' => '',
        '#required' => TRUE,
    );

    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => t('Mentés, folytatás'),
        '#attributes' => array('disabled' => 'disabled'),
        '#prefix' => '<div class="row my-4"><div class="col-sm-12 text-right">',
        '#suffix' => '</div></div>',
    );

    $form['script'] = array(
        '#markup' => $script,
        '#prefix' => '',
        '#suffix' => '',
    );

    return $form;
}

/**
 * Edit proposal tokens submit
 * @param mixed $form
 * @param mixed $form_state
 * @param number $prid
 * @return $form
 */
function propeditor_template_select_form_submit($form, &$form_state) {
    global $user;

    // Get hash
    $hash = check_plain(trim($form_state['values']['hash']));
    if ($hash == 0) {
        // Create template
        $template_hash = propeditor_get_template_unique_hash();
        $fields = [
            'uid' => $user->uid,
            'hash' => $template_hash,
            'title' => check_plain(trim($form_state['values']['title'])) . ' - ' . t('sablon'),
            'content' => '',
            'status' => 1,
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s'),
        ];
    } else {
        $template = propeditor_get_template($hash, 'hash');

        // Create template
        $template_hash = propeditor_get_template_unique_hash();
        $fields = [
            'uid' => $user->uid,
            'hash' => $template_hash,
            'title' => check_plain(trim($form_state['values']['title'])) . ' - ' . t('sablon'),
            'content' => $template->content,
            'status' => 1,
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s'),
        ];
    }

    // Insert component if it is created
    $tid = db_insert('propeditor_templates')
            ->fields($fields)
            ->execute();

    // Create new proposal
    $proposal_hash = propeditor_get_proposals_unique_hash();
    $emails = [
        'first' => [],
        'second' => [],
        'third' => [],
        'reciever' => ''
    ];
    $props = [
        'uid' => $user->uid,
        'tid' => $tid,
        'hash' => $proposal_hash,
        'title' => check_plain(trim($form_state['values']['title'])),
        'description' => '',
        'tokens' => serialize([]),
        'emails' => serialize($emails),
        'is_active' => 0,
        'is_sent' => 0,
        'created_at' => date('Y-m-d H:i:s'),
        'updated_at' => date('Y-m-d H:i:s'),
    ];

    // Merge component if it is created
    $prid = db_insert('propeditor_proposals')
            ->fields($props)
            ->execute();

    // Átirányítás a token oldalra.
    $form_state['redirect'] = array('scenario/proposal/' . $proposal_hash . '/tokens/', array('query' => '', 'fragment' => '',),);

    // Üzenet kiírása az oldalon.
    drupal_set_message(t('Adatok frissítése sikeres.'));

    // Save to watchdog.
    watchdog('propeditor', 'Ajánlat létrehozva. Ajánlat hash: %prid', array('%prid' => $proposal_hash), WATCHDOG_INFO);
}

/**
 * Template rename
 * @param type $form
 * @param type $form_state
 * @param number $hash Template hash.
 * @return type
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_template_rename_form($form, &$form_state, $hash) {

    $form = array();

    $template = propeditor_get_template(check_plain(trim($hash)), 'hash');

    $form['rename'] = array(
        '#title' => t('Sablon neve'),
        '#description' => t('Érdemes rövid könnyen felismerhető nevet adnod a sablonnak, ami kapcsolódik az azt használó ajánlathoz.'),
        '#type' => 'textfield',
        '#default_value' => $template->title,
        '#required' => TRUE,
        '#prefix' => '',
        '#suffix' => '',
    );

    $form['hash'] = array(
        '#type' => 'hidden',
        '#value' => $hash,
    );

    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => t('Átnevezés'),
        '#attributes' => array('class' => array('btn-success')),
        '#submit' => array('propeditor_template_rename_form_submit'),
    );

    $form['cancel'] = array(
        '#type' => 'submit',
        '#value' => t('Mégse'),
        '#attributes' => array('class' => array('btn-secondary')),
        '#submit' => array('propeditor_template_rename_form_cancel'),
    );

    return $form;
}

/**
 * Delete proposal form cancel.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_template_rename_form_cancel(&$form, &$form_state) {

    $form_state['redirect'] = array('scenario/proposal/add', array('query' => '', 'fragment' => '',),);
}

/**
 * Delete proposal form submit.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_template_rename_form_submit(&$form, &$form_state) {
    global $user;

    // Insert order
    if (!empty($form_state['values']['hash'])) {

        $hash = check_plain(trim($form_state['values']['hash']));
        $template = propeditor_get_template($hash, 'hash');

        // Update template
        db_update('propeditor_templates')
                ->condition('tid', $template->tid)
                ->fields(array('title' => check_plain(trim($form_state['values']['rename']))))
                ->execute();

        $form_state['redirect'] = array('scenario/proposal/add', array('query' => '', 'fragment' => '',),);

        drupal_set_message(t('%title sablon sikeresen átnevezve.', array('%title' => $template->title)));
    } else {
        drupal_set_message('<strong>Hiba:</strong> Hibás adatok! Nem létező sablon.', 'error');
    }

    // Save to watchdog.
    watchdog('propoeditor', '%hash - %title sablon átnevezve erre: %new, %user által.', array(
        '%hash' => $template->hash,
        '%title' => $template->title,
        '%new' => check_plain(trim($form_state['values']['rename'])),
        '%user' => $user->name,
        WATCHDOG_INFO));
}
