<?php

/**
 * @file API functions.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */

/**
 * Image pixel in emails.
 * @param string $hash
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_email_image($hash) {

    global $base_url;

    $stat = propeditor_get_email_stat($hash, 'hash');

    $log = unserialize($stat->opens_log);
    $log[] = date('Y-m-d H:i:s');

    $fields = [
        'updated_at' => date('Y-m-d H:i:s'),
        'opens' => (int) $stat->opens + 1,
        'opens_log' => serialize($log)
    ];

    // Update proposal
    db_update('propeditor_stat_emails')
            ->condition('esid', $stat->esid)
            ->fields($fields)
            ->execute();

    $link = $base_url . '/' . drupal_get_path('module', 'propeditor') . '/assets/img/pixel.jpg';

    if (ini_get('allow_url_fopen')) {
        $imgPath = $link;
    } else {
        $imgPath = realpath($_SERVER['DOCUMENT_ROOT'] . '/' . drupal_get_path('module', 'propeditor') . '/assets/img/pixel.jpg');
    }
    $image = file_get_contents($imgPath);

    // no-cache headers - complete set
    // these copied from [php.net/header][1], tested myself - works
    header("Expires: Sat, 26 Jul 1997 05:00:00 GMT"); // Some time in the past
    header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
    header("Cache-Control: no-store, no-cache, must-revalidate");
    header("Cache-Control: post-check=0, pre-check=0", false);
    header("Pragma: no-cache");

    // image related headers
    header('Accept-Ranges: bytes');
    header('Content-type: image/jpeg;');
    header("Content-Length: " . strlen($image));
    echo $image;

    exit();

//    return $link;
}

/**
 * Image pixel on pages.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_session_log() {

    global $base_url;
    global $_REQUEST;

    $post = propeditor_clean_array($_REQUEST);
    $referer = $_REQUEST['rl'];
    $page = $_REQUEST['dl'];
    $args = explode('/', str_replace('http://', '', str_replace('https://', '', $page)));

    $hash = $args[2];
    $proposal = propeditor_get_proposal($hash, 'hash');
    $ed = json_decode(str_replace('&quot;', '"', $post['ed']));
    $page_id = isset($ed->page_id) ? $ed->page_id : null;

    $enc = [
        'event' => $post['ev'],
        'post[ed]' => $post['ed'],
        '$ed' => $ed,
    ];
    watchdog('propeditor', 'Debug: %prid', array('%prid' => json_encode($enc)), WATCHDOG_INFO);

    if ($post['ev'] === 'heat') {

        $fields = [
            'idsite' => $proposal->prid,
            'idvisitor' => $post['uid'],
            'event' => $post['ev'],
            'event_data' => json_encode($ed),
            'page_id' => $page_id,
            'mobil' => (int) $post['md'],
            'document_link' => $post['dl'],
            'document_title' => $post['dt'],
            'client_timestamp' => $post['ts'],
            'user_agent' => $post['ua'],
            'viewport_resolution' => $post['vp'],
            'screen_resolution' => $post['sr'],
        ];

        // Update proposal
        $ssid = db_insert('propeditor_stat_heats')
                ->fields($fields)
                ->execute();
    } else {

        $fields = [
            'idsite' => $proposal->prid,
            'idvisitor' => $post['uid'],
            'created_at' => date('Y-m-d H:i:s'),
            'event' => $post['ev'],
            'event_data' => json_encode($ed),
            'document_link' => $post['dl'],
            'page_id' => $page_id,
            'mobil' => (int) $post['md'],
            'document_title' => $post['dt'],
            'client_timestamp' => $post['ts'],
            'utm_source' => $post['utm_source'],
            'utm_medium' => $post['utm_medium'],
            'utm_term' => $post['utm_term'],
            'utm_content' => $post['utm_content'],
            'utm_campaign' => $post['utm_campaign'],
            'user_agent' => $post['ua'],
            'encoding' => $post['de'],
            'referer_url' => $referer,
            'viewport_resolution' => $post['vp'],
            'screen_resolution' => $post['sr'],
            'full_log' => serialize($_REQUEST),
        ];

        // Update proposal
        $ssid = db_insert('propeditor_stat_sessions')
                ->fields($fields)
                ->execute();
    }
    // Output
    $link = $base_url . '/' . drupal_get_path('module', 'propeditor') . '/assets/img/pixel.jpg';

    if (ini_get('allow_url_fopen')) {
        $imgPath = $link;
    } else {
        $imgPath = realpath($_SERVER['DOCUMENT_ROOT'] . '/' . drupal_get_path('module', 'propeditor') . '/assets/img/pixel.jpg');
    }
    $image = file_get_contents($imgPath);

    // no-cache headers - complete set
    header("Expires: Sat, 26 Jul 1997 05:00:00 GMT"); // Some time in the past
    header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
    header("Cache-Control: no-store, no-cache, must-revalidate");
    header("Cache-Control: post-check=0, pre-check=0", false);
    header("Pragma: no-cache");

    // image related headers
    header('Accept-Ranges: bytes');
    header('Content-type: image/jpeg;');
    header("Content-Length: " . strlen($image));
    echo $image;

    exit();
}

/**
 * Proposal statistics
 * @param type $hash
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_proposal_stat_page($hash) {

    $proposal = propeditor_get_proposal(check_plain(trim($hash)), 'hash');
    $events_log = [];
    $users = [];
    $event_texts = [
        0 => t('Email kiküldés'),
        1 => t('Email megnyitás'),
        'loginload' => t('Érkező oldal megnyitás'),
        'loginclose' => t('Érkező oldal elhagyás'),
        'viewload' => t('Ajánlat megnyitás'),
        'viewclose' => t('Ajánlat elhagyás'),
        'accept' => t('Ajánlat elfogadás'),
    ];
    $login_stat = [
        'visits' => [],
        'unique' => [],
        'returns' => 0,
        'times' => [],
        'time_avg' => 0,
    ];
    $view_stat = [
        'visits' => [],
        'unique' => [],
        'returns' => 0,
        'times' => [],
        'time_avg' => 0,
    ];
    $today = date('Y-m-d');

    // Collect emails data
    $emails = db_select('propeditor_stat_emails', 's')
            ->condition('s.prid', $proposal->prid)
            ->fields('s')
            ->execute()
            ->fetchAll();

    $e = 1;
    foreach ($emails as $email) {
        $log = unserialize($email->opens_log);
        $data = [];
        for ($i = 0; $i < 21; $i++) {
            $data[] = 0;
        }
        // Add to log
        $events_log[$email->sent_at . '_' . count($events_log)] = ['at' => $email->sent_at, 'text' => $e . '. ' . $event_texts[0], 'user' => t('Rendszer'), 'site' => $e . '. email', 'icon' => 'fa fa-envelope-o text-warning'];

        foreach ($log as $date) {
            $diff = propeditor_get_date_difference_days($today, $date);
            $length = count($data);
            $sum = $length - $diff;

            if ($sum >= 0) {
                $data[$length - $diff] ++;
            }
            // Add to log
            $events_log[$date . '_' . count($events_log)] = ['at' => $date, 'text' => $e . '. ' . $event_texts[1], 'user' => '', 'site' => $e . '. email', 'icon' => 'fa fa-envelope-open-o text-success'];
        }
        $email->opens_list = implode(',', $data);
        $e++;
    }

    // Collect sessions and events
    $sessions = db_select('propeditor_stat_sessions', 's')
            ->condition('s.idsite', $proposal->prid)
            ->fields('s')
            ->execute()
            ->fetchAll();
    $logins = db_select('propeditor_stat_sessions', 's')
            ->condition('s.idsite', $proposal->prid)
            ->condition('s.page_id', 'login')
            ->fields('s')
            ->execute()
            ->fetchAll();
    $views = db_select('propeditor_stat_sessions', 's')
            ->condition('s.idsite', $proposal->prid)
            ->condition('s.page_id', 'view')
            ->fields('s')
            ->execute()
            ->fetchAll();

    foreach ($sessions as $k => $session) {
        // Add to log
        $at = date('Y-m-d H:i:s', $session->client_timestamp / 1000);
        if (in_array($session->idvisitor, $users)) {
            $visitor = (int) array_search($session->idvisitor, $users) + 1;
        } else {
            $users[] = $session->idvisitor;
            $visitor = count($users);
        }
        switch ($session->event) {
            case 'pageload':
                $text = $session->page_id == 'login' ? $event_texts['loginload'] : $event_texts['viewload'];
                $icon = $session->page_id == 'login' ? 'la la-unlock-alt text-primary' : 'la la-sign-in text-info';
                $events_log[$at . '_' . count($events_log)] = [
                    'at' => $at,
                    'text' => $text,
                    'user' => $visitor . '.',
                    'site' => $e . '. email',
                    'icon' => $icon];
                break;
            case 'pageclose':
                $text = $session->page_id == 'login' ? $event_texts['loginclose'] : $event_texts['viewclose'];
                $icon = $session->page_id == 'login' ? 'la la-sign-out text-success' : 'la la-sign-out text-danger';
                $events_log[$at . '_' . count($events_log)] = [
                    'at' => $at,
                    'text' => $text,
                    'user' => $visitor . '.',
                    'site' => $e . '. email',
                    'icon' => $icon];
                break;
        }
    }


    // Set chart
    $login_times_data = [];
    $login_visits_data = [];
    $view_times_data = [];
    $view_visits_data = [];
    for ($i = 0; $i < 21; $i++) {
        $login_times_data[] = 0;
        $login_visits_data[] = 0;
        $login_returns_data[] = 0;
        $login_uniques_data[] = 0;

        $view_times_data[] = 0;
        $view_visits_data[] = 0;
        $view_returns_data[] = 0;
        $view_uniques_data[] = 0;
    }
    foreach ($logins as $k => $login) {
        // Count opens
        if ($login->event == 'pageload') { // Ha login megnyitás
            if (isset($logins[$k + 1]) && $logins[$k + 1]->event == 'pageclose') { // És a következő login bezárás
                $interval = ($logins[$k + 1]->client_timestamp / 1000) - ($login->client_timestamp / 1000);
                if (!empty($login_stat['times'])) { // Ellenőrizzük hogy csak frissítést nyomott-e
                    $before = ($login->client_timestamp / 1000) - ($logins[$k - 1]->client_timestamp / 1000);
                    if ($before <= 2000) {
                        $login_stat['times'][count($login_stat['times']) - 1] += $interval;
                    } else {
                        $login_stat['times'][] = $interval;
                        $login_stat['visits'][] = $login->client_timestamp / 1000;

                        $diff = propeditor_get_date_difference_days($today, date('Y-m-d H:i:s', $login->client_timestamp / 1000));
                        $length = count($login_visits_data);
                        $index = $length - $diff;
                        if ($index >= 0) {
                            $login_visits_data[$index] ++;
                        }

                        if (in_array($login->idvisitor, $login_stat['unique'])) {
                            $login_stat['returns'] ++;
                            if ($index >= 0) {
                                $login_returns_data[$index] ++;
                            }
                        } else {
                            $login_stat['unique'][] = $login->idvisitor;
                            if ($index >= 0) {
                                $login_uniques_data[$index] ++;
                            }
                        }
                    }
                } else {
                    $login_stat['times'][] = $interval;
                    $login_stat['visits'][] = $login->client_timestamp / 1000;

                    $diff = propeditor_get_date_difference_days($today, date('Y-m-d H:i:s', $login->client_timestamp / 1000));
                    $length = count($login_visits_data);
                    $index = $length - $diff;
                    if ($index >= 0) {
                        $login_visits_data[$index] ++;
                    }

                    if (in_array($login->idvisitor, $login_stat['unique'])) {
                        $login_stat['returns'] ++;
                        if ($index >= 0) {
                            $login_returns_data[$index] ++;
                        }
                    } else {
                        $login_stat['unique'][] = $login->idvisitor;
                        if ($index >= 0) {
                            $login_uniques_data[$index] ++;
                        }
                    }
                }
                $diff = propeditor_get_date_difference_days($today, date('Y-m-d H:i:s', $login->client_timestamp / 1000));
                $length = count($login_times_data);
                $index = $length - $diff;
                if ($index >= 0) {
                    $login_times_data[$index] += round($interval, 1);
                }
            }
        }
    }
    $login_stat['times_data'] = implode(',', $login_times_data);
    $login_stat['visits_data'] = implode(',', $login_visits_data);
    $login_stat['returns_data'] = implode(',', $login_returns_data);
    $login_stat['uniques_data'] = implode(',', $login_uniques_data);

    foreach ($views as $k => $view) {
        // Count opens
        if ($view->event == 'pageload') { // Ha login megnyitás
            if (isset($views[$k + 1]) && $views[$k + 1]->event == 'pageclose') { // És a következő login bezárás
                $interval = ($views[$k + 1]->client_timestamp / 1000) - ($view->client_timestamp / 1000);
                if (!empty($view_stat['times'])) { // Ellenőrizzük hogy csak frissítést nyomott-e
                    $before = ($view->client_timestamp / 1000) - ($views[$k - 1]->client_timestamp / 1000);
                    if ($before < 2000) {
                        $view_stat['times'][count($view_stat['times']) - 1] += $interval;
                    } else {
                        $view_stat['times'][] = $interval;
                        $view_stat['visits'][] = $view->client_timestamp / 1000;

                        $diff = propeditor_get_date_difference_days($today, date('Y-m-d H:i:s', $view->client_timestamp / 1000));
                        $length = count($view_visits_data);
                        $index = $length - $diff;
                        if ($index >= 0) {
                            $view_visits_data[$index] ++;
                        }

                        if (in_array($view->idvisitor, $view_stat['unique'])) {
                            $view_stat['returns'] ++;
                            if ($index >= 0) {
                                $view_returns_data[$index] ++;
                            }
                        } else {
                            $view_stat['unique'][] = $view->idvisitor;
                            if ($index >= 0) {
                                $view_uniques_data[$index] ++;
                            }
                        }
                    }
                } else {
                    $view_stat['times'][] = $interval;
                    $view_stat['visits'][] = $view->client_timestamp / 1000;

                    $diff = propeditor_get_date_difference_days($today, date('Y-m-d H:i:s', $view->client_timestamp / 1000));
                    $length = count($view_visits_data);
                    $index = $length - $diff;
                    if ($index >= 0) {
                        $view_visits_data[$index] ++;
                    }

                    if (in_array($view->idvisitor, $view_stat['unique'])) {
                        $view_stat['returns'] ++;
                        if ($index >= 0) {
                            $view_returns_data[$length - $diff] ++;
                        }
                    } else {
                        $view_stat['unique'][] = $view->idvisitor;
                        if ($index >= 0) {
                            $view_uniques_data[$length - $diff] ++;
                        }
                    }
                }
                $diff = propeditor_get_date_difference_days($today, date('Y-m-d H:i:s', $view->client_timestamp / 1000));
                $length = count($view_times_data);
                $index = $length - $diff;
                if ($index >= 0) {
                    $view_times_data[$length - $diff] += round($interval, 1);
                }
            }
        }
    }
    $view_stat['times_data'] = implode(',', $view_times_data);
    $view_stat['visits_data'] = implode(',', $view_visits_data);
    $view_stat['returns_data'] = implode(',', $view_returns_data);
    $view_stat['uniques_data'] = implode(',', $view_uniques_data);

    if ($proposal->accepted_at != null) {
        $events_log[$proposal->accepted_at . '_' . count($events_log)] = ['at' => $proposal->accepted_at, 'text' => $event_texts['accept'], 'user' => '', 'site' => '', 'icon' => 'fa fa-check text-success'];
    }

    ksort($events_log);

    // Get heatmap datas
//    $width_groups = [320, 360, 480, 600, 640, 900, 960, 1024, 1200, 1280, 1366, 1440, 1600, 1680, 1920, 2560];
    $width_groups = [600, 1520, 2560];
//    $width_groups = [2560];
    $container_width = 1092;
    $screen_width = 0;
    $scale = 1;
    $cmax = 0;
    $mmax = 0;
    $max_all = 0;
    $all_moves = [];
    $all_clicks = [];
    $clicks = [];
    $moves = [];
    $records = db_select('propeditor_stat_heats', 's')
            ->condition('s.idsite', $proposal->prid)
            ->condition('s.page_id', 'view')
            ->fields('s')
            ->execute()
            ->fetchAll();

    foreach ($records as $row) {
        $data = json_decode($row->event_data);
        $screen_width = (int) explode('x', $row->screen_resolution)[0];
        $scale = $container_width / $screen_width;
        $width = 0;
        for ($g = 0; $g < count($width_groups); $g++) {
            if ($g === 0 && $screen_width < $width_groups[$g]) {
                $width = $width_groups[$g];
            } else if ($g > 0 && $screen_width > $width_groups[$g - 1] && $screen_width <= $width_groups[$g]) {
                $width = $width_groups[$g];
            }
        }
        $scale = $width / $screen_width;
        $scale_all = 992 / $screen_width;

        foreach ($data->clicks as $click) {
            $x_all = round($click->x * $scale_all);
            $y_all = round($click->y * $scale_all);
            $click_all = clone $click;
            $x = round($click->x * $scale);
            $y = round($click->y);
            if (isset($clicks[$width][$x . '_' . $y])) {
                $clicks[$width][$x . '_' . $y]->value ++;
            } else {
                $clicks[$width][$x . '_' . $y] = $click;
                $clicks[$width][$x . '_' . $y]->x = $x;
            }
            if ($clicks[$width][$x . '_' . $y]->value > $cmax ||
                    (isset($clicks[$width]['max']) && $clicks[$width][$x . '_' . $y]->value > $clicks[$width]['max'])) {
                $cmax = $clicks[$width][$x . '_' . $y]->value;
                $clicks[$width]['max'] = $clicks[$width][$x . '_' . $y]->value;
            }

            if (isset($clicks[992][$x_all . '_' . $y_all])) {
                $clicks[992][$x_all . '_' . $y_all]->value ++;
            } else {
                $clicks[992][$x_all . '_' . $y_all] = $click_all;
                $clicks[992][$x_all . '_' . $y_all]->x = $x_all;
            }
            if ($clicks[992][$x_all . '_' . $y_all]->value > $max_all ||
                    (isset($clicks[992]['max']) && $clicks[992][$x_all . '_' . $y_all]->value > $clicks[992]['max'])) {
                $max_all = $clicks[992][$x_all . '_' . $y_all]->value;
                $clicks[992]['max'] = $clicks[992][$x_all . '_' . $y_all]->value;
            }
        }

//        $max_all = 0;
        foreach ($data->moves as $move) {
            $x_all = round($move->x * $scale_all);
            $y_all = round($move->y * $scale_all);
            $move_all = clone $move;
            $x = round($move->x * $scale);
            $y = round($move->y * $scale);
            if (isset($moves[$width][$x . '_' . $y])) {
                $moves[$width][$x . '_' . $y]->value ++;
            } else {
                $moves[$width][$x . '_' . $y] = $move;
                $moves[$width][$x . '_' . $y]->x = $x;
            }
            if ($moves[$width][$x . '_' . $y]->value > $mmax ||
                    (isset($moves[$width]['max']) && $moves[$width][$x . '_' . $y]->value > $moves[$width]['max'])) {
                $mmax = $moves[$width][$x . '_' . $y]->value;
                $moves[$width]['max'] = $moves[$width][$x . '_' . $y]->value;
            }

            if (isset($moves[992][$x_all . '_' . $y_all])) {
                $moves[992][$x_all . '_' . $y_all]->value ++;
            } else {
                $moves[992][$x_all . '_' . $y_all] = $move_all;
                $moves[992][$x_all . '_' . $y_all]->x = $x_all;
            }
            if ($moves[992][$x_all . '_' . $y_all]->value > $max_all ||
                    (isset($moves[992]['max']) && $moves[992][$x_all . '_' . $y_all]->value > $moves[992]['max'])) {
                $max_all = $moves[992][$x_all . '_' . $y_all]->value;
                $moves[992]['max'] = $moves[992][$x_all . '_' . $y_all]->value;
            }
        }
    }

//    pdd([$all_moves, $scale, $scale_all], true);

    return theme('stat', array(
        'proposal' => $proposal,
        'emails' => $emails,
        'sessions' => $sessions,
        'events_log' => $events_log,
        'login_stat' => $login_stat,
        'view_stat' => $view_stat,
        'groups' => $width_groups,
        'moves' => $moves,
        'clicks' => $clicks
    ));
}
