<?php

/**
 * @file Barion API settings.
 * @package Barion
 * @author Kulcsár Balázs
 */

/**
 * Creates the main settings form.
 * @param type $form
 * @param type $form_state
 * @return $form
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_settings_form($form, &$form_state) {

    global $base_url;
    $module_path = drupal_get_path('module', 'propeditor');

    $form = array();

    $form['overview'] = array(
        '#markup' => t('Admininstrators can set the main settings of the propeditor system.'),
        '#prefix' => '<p>',
        '#suffix' => '</p>',
    );

    // Company settings
    $form['customer'] = array(
        '#type' => 'fieldset',
        '#title' => t('Customer side settings'),
        '#collapsible' => TRUE,
        '#collapsed' => FALSE,
    );

    $form['customer']['propeditor_sender_email'] = array(
        '#title' => t('Küldő email címe'),
        '#description' => t('Erről az email címről küldi a rendszer a címzettnek a 3 levelet.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('propeditor_sender_email', ''),
        '#required' => TRUE,
        '#element_validate' => array('propeditor_element_validate_email'),
    );

    $form['customer']['propeditor_sender_name'] = array(
        '#title' => t('Küldő neve'),
        '#description' => t('Ez a név lesz csatolva a küldő email címhez.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('propeditor_sender_name', ''),
        '#required' => TRUE,
    );

    $form['customer']['propeditor_gdpr_text'] = array(
        '#title' => t('GDPR szöveg'),
        '#description' => t('Az ajánlat megtekintése előtt ez a tájékoztató szöveg fogadja a látogatót.'),
        '#type' => 'text_format',
        '#format' => variable_get('propeditor_gdpr_text', array('format' => 'plain'))['format'],
        '#rows' => 10,
        '#default_value' => variable_get('propeditor_gdpr_text')['value'],
        '#required' => TRUE,
    );
//    pdd(variable_get('propeditor_gdpr_text', ''), true);
    // Company settings
    $form['file'] = array(
        '#type' => 'fieldset',
        '#title' => t('File kezelés'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );

    $form['file']['propeditor_image_types'] = array(
        '#title' => t('Kép formátumok'),
        '#description' => t('Ajánlat szerkesztésekor feltölthető képformátumok.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('propeditor_image_types'),
        '#required' => TRUE,
    );

    $form['file']['propeditor_image_size'] = array(
        '#title' => t('Maximális fájlméret'),
        '#description' => t('Ajánlat szerkesztésekor feltölthető maximális fájlméret MB-ban megadva.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('propeditor_image_size'),
        '#required' => TRUE,
    );

    return system_settings_form($form);
}

/**
 * After submit settings form merge emails into database and set all the variables.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
/*function propeditor_settings_form_submit($form, &$form_state){

    // Save emails
    foreach($form['email']['emails'] as $k => $v){
        if(strpos($k, 'certify_mail') !== false){
            $subject = $k . '_subject';
            $body = $k . '_body';
            $fields = array(
                'variable' => $k,
                'subject'  => $form_state['values'][$subject],
                'body'     => $form_state['values'][$body]
            );
            db_merge('certify_default_emails')->key(array('variable' => $k))->fields($fields)->execute();
        }
    }
    // Exclude unnecessary elements.
    form_state_values_clean($form_state);

    // Set variables.
    certify_variable_set_from_form($form_state);

    // Save to watchdog.
    watchdog('certify', 'Settings and default emails has been refreshed.', array('certify_settings_form' => 'emails', WATCHDOG_NOTICE));
}
*/
