<?php

/**
 * @file API functions.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */

/**
 * Get all components.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_user_proposals_form($form, &$form_state, $account = '') {
    global $user;

    if (empty($account)) {
        $uid = $user->uid;
    } else {
        $uid = $account->uid;
    }

    if ($uid != $user->uid || user_access('administer propeditor')) {

        $form = array();
//
//        $form['submit'] = array(
//            '#type' => 'submit',
//            '#submit' => array('membership_user_data_form_submit'),
//            '#attributes' => array('class' => array(variable_get('membership_class_own_data_edit_button'))),
//            '#value' => 'Szerkesztés',
//        );
//        mdd(variable_get('membership_class_own_data_edit_button'));

        $add_proposal = '<a href="/scenario/proposal/add" class="btn-success btn mb-2 form-submit" >Ajánlat létrehozása</a>';

        $form['link'] = array(
            '#type' => 'item',
            '#markup' => $add_proposal,
        );

        // Tábla elkészítése
        $header = array(
            array('data' => t('Azonosító'), 'field' => 'p.hash'),
            array('data' => t('Ajánlat'), 'field' => 'p.title'),
            array('data' => t('Ügyfélnek látható'), 'field' => 'p.is_active'),
            array('data' => t('Kiküldve'), 'field' => 'p.is_sent'),
            array('data' => t('Elfogadva'), 'field' => 'p.accepted_at'),
            array('data' => t('Módosítva'), 'field' => 'p.updated_at', 'sort' => 'desc'),
            array('data' => t('Műveletek')),
        );

        $query = db_select('propeditor_proposals', 'p');
        $query->leftJoin('propeditor_templates', 't', '(p.tid = t.tid)');
        $query->fields('t', array('thumbnail'));
        $query->condition('p.uid', $uid);
        $query->fields('p');
        $result = $query->extend('PagerDefault')
                ->limit(25)
                ->extend('TableSort')
                ->orderByHeader($header)
                ->execute();

        $rows = array();

        // Állapotok és műveletek beállítása.
        foreach ($result as $value) {
            // Preview link
            $thumbnail = !empty($value->thumbnail) ? file_create_url($value->thumbnail) : 'https://placehold.it/210x297';
            $preview_attributes = array(
                'target' => '_blank',
                'class' => 'btn btn-sm btn-outline-dark',
                'data-trigger' => "hover",
                'data-html' => "true",
                'data-toggle' => "popover",
                'data-placement' => "left",
                'data-content' => '<div class="template-thumbnail"><img src="' . $thumbnail . '" /></div>',
                'disabled' => true
            );
            $links = l('<i class="fa fa-lg fa-eye" title="' . t('Preview') . '"></i>', "proposal/$value->hash/preview", array('html' => true, 'attributes' => $preview_attributes)) . '&nbsp;&nbsp;';
            // Edit link
            $edit_attributes = array(
                'target' => '_blank',
                'class' => 'btn btn-sm btn-outline-primary' . ($value->accepted != null ? ' disabled' : ''));
            $value->accepted != null ? $edit_attributes['disabled'] = true : '';
            $links .= l('<i class="fa fa-lg fa-edit" title="' . t('Szerkesztés') . '"></i>', "proposal/$value->hash/editor", array('html' => true, 'attributes' => $edit_attributes)) . '&nbsp;&nbsp;';
            // Details link
            $links .= l('<i class="fa fa-lg fa-address-card" title="' . t('Törzsadatok') . '"></i>', "proposal/$value->hash/tokens", array('html' => true, 'attributes' => array('target' => '_blank', 'class' => 'btn btn-sm btn-outline-info'))) . '&nbsp;&nbsp;';
            // Emails link
            $links .= l('<i class="fa fa-lg fa-envelope-o" title="' . t('Emailek') . '"></i>', "proposal/$value->hash/emails", array('html' => true, 'attributes' => array('target' => '_blank', 'class' => 'btn btn-sm btn-outline-green'))) . '&nbsp;&nbsp;';
            // Statistics link
            $links .= l('<i class="fa fa-lg fa-bar-chart" title="' . t('Statisztikák') . '"></i>', "proposal/$value->hash/stat", array('html' => true, 'attributes' => array('target' => '_blank', 'class' => 'btn btn-sm btn-outline-success'))) . '&nbsp;&nbsp;';
            // Duplicate link
            $links .= l('<i class="fa fa-lg fa-copy" title="' . t('Másolás') . '"></i>', "proposal/$value->hash/duplicate", array('html' => true, 'attributes' => array('class' => 'btn btn-sm btn-outline-warning'))) . '&nbsp;&nbsp;';
            // Delete link
            $delete_attributes = array('class' => 'btn btn-sm btn-outline-purple' . ($value->accepted != null ? ' disabled' : ''));
            $value->accepted != null ? $delete_attributes['disabled'] = true : '';
            $links .= l('<i class="fa fa-lg fa-trash" title="' . t('Törlés') . '"></i>', "proposal/$value->hash/delete", array('html' => true, 'attributes' => $delete_attributes)) . '&nbsp;&nbsp;';
            // Activate link
            if ($value->is_active != 0) {
                $activate_attributes = array('class' => 'btn btn-sm btn-outline-inverse', 'title' => t('Inaktiválás'));
                $icon = '<i class="la fa-lg la-ban"></i>';
            } else {
                $activate_attributes = array('class' => 'btn btn-sm btn-outline-danger', 'title' => t('Aktiválás'));
                $icon = '<i class="la fa-lg la-rocket"></i>';
            }
            $links .= l($icon, "proposal/$value->hash/activate", array('html' => true, 'attributes' => $activate_attributes));

            // Accepted content
            if ($value->accepted != null) {
                $signature = '<div class=\'signature\'><img src=\'' . $value->accepted . '\' /></div><div class=\'accepted-at\'>' . $value->accepted_at . '</div>';
                $accepted = '<div class="text-center" data-trigger="hover" data-html="true" data-toggle="popover" data-placement="top" data-content="' . $signature . '"><div class="circle circle-lg bg-success"></div></div>';
            } else {
                $accepted = '<div class="text-center"><div class="circle circle-lg bg-default" data-toggle="tooltip" data-placement="top" data-title="' . t('Nincs elfogadva') . '" data-original-title="" title=""></div></div>';
            }

            // Active content
            if ($value->is_active != 0) {
                $active = '<div class="text-center"><div class="circle circle-lg bg-success" data-toggle="tooltip" data-placement="top" data-title="' . t('Ügyfélnek látható') . '" data-original-title="" title=""></div></div>';
            } else {
                $active = '<div class="text-center"><div class="circle circle-lg bg-danger" data-toggle="tooltip" data-placement="top" data-title="' . t('Ügyfélnek nem látható') . '" data-original-title="" title=""></div></div>';
            }

            $rows[] = array(
                'data' => array(
                    $value->hash,
                    $value->title,
                    $active,
                    $value->is_sent,
                    $accepted,
                    $value->updated_at,
                    $links,
                )
            );
        }

//        $form['tooltip'] = array(
//            '#markup' => '<script></script>',
//        );

        $form['table'] = array(
            '#theme' => 'table',
            '#header' => $header,
            '#rows' => $rows,
            '#empty' => t('Nincsenek ajánlatok.'),
            '#attributes' => array('class' => array('table table-striped table-bordered'))
        );
        $form['pager'] = array('#markup' => theme('pager'));
    } else {
        // Ha nem azonosított látogató a biztonság kedvért hibaüzenetet adunk.
        drupal_set_message(t('Az adatok megtekintésére csak a tagoknak van jogosultságuk.'), 'error');
    }

    return $form;
}

/**
 * Edit proposal tokens
 * @param mixed $form
 * @param mixed $form_state
 * @param number $hash
 * @return $form
 */
function propeditor_proposal_tokens_form($form, &$form_state, $hash, $scenario = '') {

    $proposal = propeditor_get_proposal($hash, 'hash');

    $db_or = db_or();
    $db_or->condition('uid', $proposal->uid);
    $db_or->condition('uid', 0);
    $token_list = db_select('propeditor_tokens', 't')
            ->condition($db_or)
            ->fields('t', array('token'))
            ->execute()
            ->fetchAllKeyed(0, 0);
    $token_keys = array_keys($token_list);

    if (!is_array($proposal->tokens)) {
        $proposal->tokens = [];
    }
    foreach ($proposal->tokens as $key => $value) {
        $token = '%' . strtoupper(_propeditor_change_letters(trim($key))) . '%';
        if (!in_array($key, $token_keys) && !in_array($token, $token_keys)) {
            $key = propeditor_token_merge($token, $proposal->uid, 'full')['token'];
        }
        $token_list[$key] = $value;
    }

    $form = array();

    $form['overview'] = array(
        '#markup' => t('Törzsadatok szerkesztése'),
        '#prefix' => '<h2 class="text-center mt-3 mb-4">',
        '#suffix' => '</h2><div class="row justify-content-center"><div class="col-sm-6 text-center">',
    );

    $i = 0;
    foreach ($token_list as $key => $value) {

//        foreach ($tokens as $k => $v) {
//            if ($v->token == $key) {
        if ($i == 0) {
            $id = str_replace('%', '', $key);
            $form['token_key_' . $id] = array(
                '#title' => t('Helykitöltő'),
                '#type' => 'textfield',
                '#default_value' => $key,
                '#required' => TRUE,
                '#disabled' => TRUE,
                '#prefix' => '<div class="row"><div class="col-sm-6"><div class="key">',
                '#suffix' => '</div></div>',
            );

            $form['token_value_' . $id] = array(
                '#title' => t('Érték'),
                '#type' => 'textfield',
                '#default_value' => $value,
                '#required' => FALSE,
                '#prefix' => '<div class="col-sm-6">',
                '#suffix' => '</div></div>',
            );
        } else {

            $id = str_replace('%', '', $key);
            $form['token_key_' . $id] = array(
                '#type' => 'textfield',
                '#default_value' => $key,
                '#required' => TRUE,
                '#disabled' => TRUE,
                '#prefix' => '<div class="row mt-2"><div class="col-sm-6"><div class="key">',
                '#suffix' => '</div></div>',
            );

            $form['token_value_' . $id] = array(
                '#type' => 'textfield',
                '#default_value' => $value,
                '#required' => FALSE,
                '#prefix' => '<div class="col-sm-6">',
                '#suffix' => '</div></div>',
            );
        }

        $i++;
//            }
//        }
    }

    $form['token_key_new'] = array(
        '#type' => 'textfield',
        '#default_value' => '',
        '#required' => FALSE,
        '#prefix' => '<div class="row mt-2 new-token"><div class="col-sm-6"><div class="key">%',
        '#suffix' => '%</div></div>',
    );

    $form['token_value_new'] = array(
        '#type' => 'textfield',
        '#default_value' => '',
        '#required' => FALSE,
        '#prefix' => '<div class="col-sm-6">',
        '#suffix' => '</div></div>',
    );

    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => t('Mentés, folytatás'),
        '#submit' => array('propeditor_proposal_tokens_form_submit'),
        '#prefix' => '<div class="row my-4"><div class="col-sm-12 text-center">',
        '#suffix' => $scenario == 'scenario' ? '' : '</div></div>',
    );

    if ($scenario == 'scenario') {
        $form['cancel'] = array(
            '#type' => 'submit',
            '#value' => t('Kilépés'),
            '#attributes' => array('class' => array('btn btn-secondary')),
            '#prefix' => '',
            '#suffix' => '</div></div>',
            '#submit' => array('propeditor_proposal_tokens_form_cancel'),
        );
    }

    $form['hash'] = array(
        '#type' => 'hidden',
        '#value' => $hash,
    );

    $form['scenario'] = array(
        '#type' => 'hidden',
        '#value' => $scenario,
    );

    $form['close'] = array(
        '#prefix' => '</div></div>',
        '#suffix' => '',
    );

    return $form;
}

/**
 * Edit proposal tokens form cancel.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_proposal_tokens_form_cancel(&$form, &$form_state) {
    $form_state['redirect'] = array('/my-proposals', array('query' => '', 'fragment' => '',),);
}

/**
 * Edit proposal tokens submit
 * @param mixed $form
 * @param mixed $form_state
 * @param number $prid
 * @return $form
 */
function propeditor_proposal_tokens_form_submit($form, &$form_state) {

    // Get hash
    $hash = check_plain(trim($form_state['values']['hash']));

    // Get tokens, from to array
    $tokens = [];
    foreach ($form_state['values'] as $key => $value) {
        $parts = explode('_', $key);
        if ($parts[0] == 'token') {
            if ($parts[2] != 'new') {
                if ($parts[1] !== 'key') {
                    $tokens['%' . $parts[2] . '%'] = $value;
                }
            }
        }
    }
    if (!empty($form_state['values']['token_key_new'])) {
        $tokens[strtoupper(_propeditor_change_letters(trim($form_state['values']['token_key_new'])))] = $form_state['values']['token_value_new'];
    }

    $proposal = propeditor_get_proposal($hash, 'hash');

    $db_or = db_or();
    $db_or->condition('uid', $proposal->uid);
    $db_or->condition('uid', 0);
    $token_list = db_select('propeditor_tokens', 't')
            ->condition($db_or)
            ->fields('t', array('token'))
            ->execute()
            ->fetchAllKeyed(0, 0);
    $token_keys = array_keys($token_list);

    foreach ($tokens as $key => $value) {
        $token = '%' . strtoupper(_propeditor_change_letters(trim($key))) . '%';
        if (!in_array($key, $token_keys) && !in_array($token, $token_keys)) {
            $key = propeditor_token_merge($token, $proposal->uid, 'full')['token'];
        }
        $token_list[$key] = $value;
    }

    // Update proposal
    db_update('propeditor_proposals')
            ->condition('prid', $proposal->prid)
            ->fields(array('tokens' => serialize($token_list)))
            ->execute();

    // Átirányítás az emailek oldalra.
    if ($form_state['values']['scenario'] == 'scenario') {
        $form_state['redirect'] = array('scenario/proposal/' . $proposal->hash . '/emails/', array('query' => '', 'fragment' => '',),);
    }
    // Üzenet kiírása az oldalon.
    drupal_set_message(t('Adatok frissítése sikeres.'));

    // Save to watchdog.
    watchdog('propeditor', 'Token adatok frissítve. Ajánlat hash: %prid', array('%prid' => $hash), WATCHDOG_INFO);
}

/**
 * Edit proposal emails
 * @param mixed $form
 * @param mixed $form_state
 * @param number $hash
 * @return $form
 */
function propeditor_proposal_emails_form($form, &$form_state, $hash, $scenario = '') {

    $proposal = propeditor_get_proposal($hash, 'hash');

    $form = array();

    $form['overview'] = array(
        '#markup' => t('Értesítések szerkesztése'),
        '#prefix' => '<h2 class="text-center mt-3 mb-4">',
        '#suffix' => '</h2>',
    );

    $email_token_help = implode(', ', is_array($proposal->tokens) ? array_keys($proposal->tokens) : []) . ', %LINK%' . t(' - ez az ajánlat linkje');

    // Email form
    $form['reciever_tab'] = array(
        '#markup' => '<li class="nav-item active" role="presentation">'
        . '<a class="nav-link" data-toggle="tab" href="#reciever" role="tab">' . t('Címzett') . '</a></li>',
        '#prefix' => '<div class="row"><div class="col-sm-12" role="tabpanel"><ul class="nav nav-tabs" role="tablist">',
        '#suffix' => '',
    );
    $form['fieldset_1'] = array(
        '#markup' => '<li class="nav-item" role="presentation">'
        . '<a class="nav-link" data-toggle="tab" href="#v-pills-first" role="tab">' . t('Első email') . '</a></li>',
        '#prefix' => '',
        '#suffix' => '',
    );
    $form['fieldset_2'] = array(
        '#markup' => '<li class="nav-item" role="presentation">'
        . '<a class="nav-link" data-toggle="tab" href="#v-pills-second" role="tab">' . t('3. napos email') . '</a></li>',
        '#prefix' => '',
        '#suffix' => '',
    );
    $form['fieldset_3'] = array(
        '#markup' => '<li class="nav-item" role="presentation">'
        . '<a class="nav-link" data-toggle="tab" href="#v-pills-third" role="tab">' . t('7. napos email') . '</a></li>',
        '#prefix' => '',
        '#suffix' => '</ul>'
        . '<div class="tab-content" id="v-pills-tabContent">',
    );

    $form['reciever_header'] = array(
        '#type' => 'item',
        '#markup' => '<h3>' . t('Címzett') . '</h3><p>' . t('Erre az email címre kerül kiküldésre az itt beállítható összes email.') . '</p>',
        '#prefix' => '<div class="tab-pane active" id="reciever" role="tabpanel">',
        '#suffix' => '',
    );

    $form['reciever_name'] = array(
        '#title' => t('Címzett neve'),
        '#description' => t('Ez kerül az email címe elé, pl.: <em>Példa János <pelda@pelda.com></em>'),
        '#type' => 'textfield',
        '#default_value' => isset($proposal->emails['reciever_name']) ? $proposal->emails['reciever_name'] : '',
        '#required' => TRUE,
        '#prefix' => '',
        '#suffix' => '',
    );

    $form['reciever'] = array(
        '#title' => t('Címzett email címe'),
        '#description' => t('Fontos, hogy valós email címet adj meg, hogy az ajánlatod ne menjen mellé.'),
        '#type' => 'textfield',
        '#default_value' => isset($proposal->emails['reciever']) ? $proposal->emails['reciever'] : '',
        '#required' => TRUE,
        '#element_validate' => array('propeditor_element_validate_email'),
        '#prefix' => '',
        '#suffix' => '</div>',
    );

    $form['email_first'] = array(
        '#type' => 'item',
        '#markup' => '<h3>' . t('Első email') . '</h3>'
        . t('<p>Ajánlat élesítésekor ez az email megy az ki a címzett(ek)nek a Proposeasy által. '
                . 'Az alábbi helykitöltőket tudod használni az emailben is:') . '<br>' . $email_token_help . '</p>',
        '#prefix' => '<div class="tab-pane" id="v-pills-first" role="tabpanel">',
        '#suffix' => '',
    );

    $form['email_first_subject'] = array(
        '#type' => 'textfield',
        '#title' => t('Tárgy'),
        '#default_value' => isset($proposal->emails['first']) && isset($proposal->emails['first']['subject']) ? $proposal->emails['first']['subject'] : '',
        '#maxlength' => 180,
    );
    $form['email_first_body'] = array(
        '#type' => 'text_format',
        '#title' => t('Üzenet'),
        '#default_value' => isset($proposal->emails['first']) && isset($proposal->emails['first']['body']) && !empty($proposal->emails['second']['body']) ? $proposal->emails['first']['body'] : '<table border="0" cellpadding="0" cellspacing="0" width="100%"><tbody><tr><td style="padding: 10px 0 30px 0;"><table align="center" border="0" cellpadding="0" cellspacing="0" style="border: 1px solid #cccccc; border-collapse: collapse;" width="600"><tbody><tr><td style="padding: 15px 30px; color: rgb(21, 54, 67); font-size: 28px; font-weight: normal; line-height: 30px; font-family: Arial, sans-serif; background-color: rgb(35, 183, 229);"><img alt="" height="30" src="https://proposeasy.dev.vallalatiszoftver.hu/sites/default/files/logo-xs.png" style="margin-right:5px; float:left" width="27"/><span style="color:#FFFFFF;"><span style="font-size:16px;vertical-align: bottom; line-height: 30px;"> Proposeasy.com</span></span></td></tr><tr><td bgcolor="#ffffff" style="padding: 40px 30px 40px 30px;"><table border="0" cellpadding="0" cellspacing="0" width="100%"><tbody><tr><td style="color: #153643; font-family: Arial, sans-serif; font-size: 24px;"><b>Tisztelt %LASTNAME% %FIRSTNAME%!</b></td></tr><tr><td style="padding: 10px 0 10px 0; color: #153643; font-family: Arial, sans-serif; font-size: 16px; line-height: 20px;"><p>Kérem, tekintse meg az Ön megkeresése alapján összeállított ajánlatunkat az alábbi gombra kattinva!</p><table align="left" border="0" cellpadding="0" cellspacing="0" height="43" style="color: rgb(255, 255, 255);" width="202"><tbody><tr><td style="padding: 10px 20px; background-color: rgb(39, 194, 76); white-space: nowrap;"><a href="%LINK%"><span style="color:#FFFFFF;">Ajánlat megtekintése &gt;&gt;</span></a></td></tr></tbody></table><p>&nbsp;</p><p><br/>Bármilyen kérdés esetén, kérem lépjen kapcsolatba velem!</p></td></tr><tr><td><p style="color: #153643; font-family: Arial, sans-serif; font-size: 16px;">Tisztelettel:<br/><em>Kapcsolattartó név<br/><span style="font-size:14px;">Cégnév<br/>Email<br/>Telefonszám</span></em></p></td></tr></tbody></table></td></tr><tr><td bgcolor="#23b7e5" style="padding: 30px 30px 30px 30px;"><table border="0" cellpadding="0" cellspacing="0" width="100%"><tbody><tr><td style="color: rgb(255, 255, 255); font-family: Arial, sans-serif; font-size: 14px; width: 398px;" width="75%"><span style="font-size:11px;">® Proposeasy.com, 2019-2020</span></td><td align="right" style="width: 135px;" width="25%"><p>&nbsp;</p></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table>',
        '#rows' => 15,
        '#format' => 'ckeditor',
        '#prefix' => '',
        '#suffix' => '</div>',
    );


    $form['email_second'] = array(
        '#type' => 'item',
        '#markup' => '<h3>' . t('3. napos email') . '</h3>'
        . t('<p>Ajánlat élesítésétől ez az email megy a 3. napon megy ki a címzett(ek)nek a Proposeasy által emlékeztetőül, '
                . 'ha nem nyitották meg az előzőt, vagy nem reagáltak az ajánlatra. '
                . 'Az alábbi helykitöltőket tudod használni az emailben is:') . '<br>' . $email_token_help . '</p>',
        '#prefix' => '<div class="tab-pane" id="v-pills-second" role="tabpanel">',
        '#suffix' => '',
    );

    $form['email_second_subject'] = array(
        '#type' => 'textfield',
        '#title' => t('Tárgy'),
        '#default_value' => isset($proposal->emails['second']) && isset($proposal->emails['second']['subject']) ? $proposal->emails['second']['subject'] : '',
        '#maxlength' => 180,
    );
    $form['email_second_body'] = array(
        '#type' => 'text_format',
        '#title' => t('Üzenet'),
        '#default_value' => isset($proposal->emails['second']) && isset($proposal->emails['second']['body']) && !empty($proposal->emails['second']['body']) ? $proposal->emails['second']['body'] : '<table border="0" cellpadding="0" cellspacing="0" width="100%"><tbody><tr><td style="padding: 10px 0 30px 0;"><table align="center" border="0" cellpadding="0" cellspacing="0" style="border: 1px solid #cccccc; border-collapse: collapse;" width="600"><tbody><tr><td style="padding: 15px 30px; color: rgb(21, 54, 67); font-size: 28px; font-weight: normal; line-height: 30px; font-family: Arial, sans-serif; background-color: rgb(35, 183, 229);"><img alt="" height="30" src="https://proposeasy.dev.vallalatiszoftver.hu/sites/default/files/logo-xs.png" style="margin-right:5px; float:left" width="27"/><span style="color:#FFFFFF;"><span style="font-size:16px;vertical-align: bottom; line-height: 30px;"> Proposeasy.com</span></span></td></tr><tr><td bgcolor="#ffffff" style="padding: 40px 30px 40px 30px;"><table border="0" cellpadding="0" cellspacing="0" width="100%"><tbody><tr><td style="color: #153643; font-family: Arial, sans-serif; font-size: 24px;"><b>Tisztelt %LASTNAME% %FIRSTNAME%!</b></td></tr><tr><td style="padding: 10px 0 10px 0; color: #153643; font-family: Arial, sans-serif; font-size: 16px; line-height: 20px;"><p>Lehet elkerülte figyelmét korábbi levelünk, melyben az Önnek összeállított ajánlatot küldtük.</p><p>Kérem, tekintse meg ajánlatunkat az alábbi gombra kattinva!</p><table align="left" border="0" cellpadding="0" cellspacing="0" height="43" style="color: rgb(255, 255, 255);" width="202"><tbody><tr><td style="padding: 10px 20px; background-color: rgb(39, 194, 76); white-space: nowrap;"><a href="%LINK%"><span style="color:#FFFFFF;">Ajánlat megtekintése &gt;&gt;</span></a></td></tr></tbody></table><p>&nbsp;</p><p><br/>Bármilyen kérdés esetén, kérem lépjen kapcsolatba velem!</p></td></tr><tr><td><p style="color: #153643; font-family: Arial, sans-serif; font-size: 16px;">Tisztelettel:<br/><em>Kapcsolattartó név<br/><span style="font-size:14px;">Cégnév<br/>Email<br/>Telefonszám</span></em></p></td></tr></tbody></table></td></tr><tr><td bgcolor="#23b7e5" style="padding: 30px 30px 30px 30px;"><table border="0" cellpadding="0" cellspacing="0" width="100%"><tbody><tr><td style="color: rgb(255, 255, 255); font-family: Arial, sans-serif; font-size: 14px; width: 398px;" width="75%"><span style="font-size:11px;">® Proposeasy.com, 2019-2020</span></td><td align="right" style="width: 135px;" width="25%"><p>&nbsp;</p></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table>',
        '#rows' => 15,
        '#format' => 'ckeditor',
        '#prefix' => '',
        '#suffix' => '</div>',
    );


    $form['email_third'] = array(
        '#type' => 'item',
        '#markup' => '<h3>' . t('7. napos email') . '</h3>'
        . t('<p>Ajánlat élesítésétől ez az email megy a 7. napon megy ki a címzett(ek)nek a Proposeasy által emlékeztetőül, '
                . 'ha nem nyitották meg az előzőt, vagy nem reagáltak az ajánlatra. '
                . 'Az alábbi helykitöltőket tudod használni az emailben is:') . '<br>' . $email_token_help . '</p>',
        '#prefix' => '<div class="tab-pane" id="v-pills-third" role="tabpanel">',
        '#suffix' => '',
    );

    $form['email_third_subject'] = array(
        '#type' => 'textfield',
        '#title' => t('Tárgy'),
        '#default_value' => isset($proposal->emails['third']) && isset($proposal->emails['third']['subject']) ? $proposal->emails['third']['subject'] : '',
        '#maxlength' => 180,
    );
    $form['email_third_body'] = array(
        '#type' => 'text_format',
        '#title' => t('Üzenet'),
        '#default_value' => isset($proposal->emails['third']) && isset($proposal->emails['third']['body']) && !empty($proposal->emails['third']['body']) ? $proposal->emails['third']['body'] : '<table border="0" cellpadding="0" cellspacing="0" width="100%"><tbody><tr><td style="padding: 10px 0 30px 0;"><table align="center" border="0" cellpadding="0" cellspacing="0" style="border: 1px solid #cccccc; border-collapse: collapse;" width="600"><tbody><tr><td style="padding: 15px 30px; color: rgb(21, 54, 67); font-size: 28px; font-weight: normal; line-height: 30px; font-family: Arial, sans-serif; background-color: rgb(35, 183, 229);"><img alt="" height="30" src="https://proposeasy.dev.vallalatiszoftver.hu/sites/default/files/logo-xs.png" style="margin-right:5px; float:left" width="27"/><span style="color:#FFFFFF;"><span style="font-size:16px;vertical-align: bottom; line-height: 30px;"> Proposeasy.com</span></span></td></tr><tr><td bgcolor="#ffffff" style="padding: 40px 30px 40px 30px;"><table border="0" cellpadding="0" cellspacing="0" width="100%"><tbody><tr><td style="color: #153643; font-family: Arial, sans-serif; font-size: 24px;"><b>Tisztelt %LASTNAME% %FIRSTNAME%!</b></td></tr><tr><td style="padding: 10px 0 10px 0; color: #153643; font-family: Arial, sans-serif; font-size: 16px; line-height: 20px;"><p>Lehet elkerülték figyelmét a korábbi leveleink, melyben az Önnek összeállított ajánlatot küldtük.</p><p>Sebaj, még mindig nem maradt le semmiröl, de az ajánlatunknak az érvényességi ideje miatt érdemes lesz mielöbb idöt szánnia rá!</p><table align="left" border="0" cellpadding="0" cellspacing="0" height="43" style="color: rgb(255, 255, 255);" width="202"><tbody><tr><td style="padding: 10px 20px; background-color: rgb(39, 194, 76); white-space: nowrap;"><a href="%LINK%"><span style="color:#FFFFFF;">Ajánlat megtekintése &gt;&gt;</span></a></td></tr></tbody></table><p>&nbsp;</p><p><br/>Bármilyen kérdés esetén, kérem lépjen kapcsolatba velem!</p></td></tr><tr><td><p style="color: #153643; font-family: Arial, sans-serif; font-size: 16px;">Tisztelettel:<br/><em>Kapcsolattartó név<br/><span style="font-size:14px;">Cégnév<br/>Email<br/>Telefonszám</span></em></p></td></tr></tbody></table></td></tr><tr><td bgcolor="#23b7e5" style="padding: 30px 30px 30px 30px;"><table border="0" cellpadding="0" cellspacing="0" width="100%"><tbody><tr><td style="color: rgb(255, 255, 255); font-family: Arial, sans-serif; font-size: 14px; width: 398px;" width="75%"><span style="font-size:11px;">® Proposeasy.com, 2019-2020</span></td><td align="right" style="width: 135px;" width="25%"><p>&nbsp;</p></td></tr></tbody></table></td></tr></tbody></table></td></tr></tbody></table>',
        '#rows' => 15,
        '#format' => 'ckeditor',
        '#prefix' => '',
        '#suffix' => '</div></div></div></div>',
    );

    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => t('Mentés, folytatás'),
        '#submit' => array('propeditor_proposal_emails_form_submit'),
        '#prefix' => '<div class="row my-4"><div class="col-sm-12">',
        '#suffix' => $scenario == 'scenario' ? '' : '</div></div>',
    );

    if ($scenario == 'scenario') {
        $form['cancel'] = array(
            '#type' => 'submit',
            '#value' => t('Mentés, kilépés'),
            '#attributes' => array('class' => array('btn btn-secondary')),
            '#prefix' => '',
            '#suffix' => '</div></div>',
            '#submit' => array('propeditor_proposal_emails_form_cancel'),
        );
    }

    $form['hash'] = array(
        '#type' => 'hidden',
        '#value' => $hash,
    );

    $form['scenario'] = array(
        '#type' => 'hidden',
        '#value' => $scenario,
    );

    $form['close'] = array(
        '#prefix' => '</div></div>',
        '#suffix' => '',
    );

    return $form;
}

/**
 * Edit proposal emails form validation.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
//function propeditor_proposal_emails_form_validate($form, &$form_state) {
//
//    $email = trim($form_state['values']['reciever']);
//    if (!propeditor_is_valid_email($email)) {
//        form_set_error('reciever', t('Email címnek valósnak kell lennie!'));
//    }
//}

/**
 * Edit proposal emails form cancel.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_proposal_emails_form_cancel(&$form, &$form_state) {

    // Get hash
    $hash = check_plain(trim($form_state['values']['hash']));

    // Get tokens, from to array
    $emails = [
        'first' => [],
        'second' => [],
        'third' => []
    ];
    foreach ($form_state['values'] as $key => $value) {
        $parts = explode('_', $key);
        if ($parts[0] == 'email') {
            if (isset($parts[2]) && $parts[2] == 'body') {
                $emails[$parts[1]]['body'] = $value['value'];
            } else if (isset($parts[2]) && $parts[2] == 'subject') {
                $emails[$parts[1]]['subject'] = $value;
            }
        }
    }
    $emails['reciever'] = $form_state['values']['reciever'];

    $proposal = propeditor_get_proposal($hash, 'hash');

    // Update proposal
    db_update('propeditor_proposals')
            ->condition('prid', $proposal->prid)
            ->fields(array('emails' => serialize($emails)))
            ->execute();

    // Átirányítás az emailek oldalra.
    $form_state['redirect'] = array('/my-proposals', array('query' => '', 'fragment' => '',),);

    // Üzenet kiírása az oldalon.
    drupal_set_message(t('Adatok frissítése sikeres.'));

    // Save to watchdog.
    watchdog('propeditor', 'Email adatok frissítve. Ajánlat hash: %prid', array('%prid' => $hash), WATCHDOG_INFO);
}

/**
 * Edit proposal tokens submit
 * @param mixed $form
 * @param mixed $form_state
 * @param number $prid
 * @return $form
 */
function propeditor_proposal_emails_form_submit($form, &$form_state) {

    // Get hash
    $hash = check_plain(trim($form_state['values']['hash']));

    // Get tokens, from to array
    $emails = [
        'first' => [],
        'second' => [],
        'third' => []
    ];
    foreach ($form_state['values'] as $key => $value) {
        $parts = explode('_', $key);
        if ($parts[0] == 'email') {
            if (isset($parts[2]) && $parts[2] == 'body') {
                $emails[$parts[1]]['body'] = $value['value'];
            } else if (isset($parts[2]) && $parts[2] == 'subject') {
                $emails[$parts[1]]['subject'] = $value;
            }
        }
    }
    $emails['reciever_name'] = $form_state['values']['reciever_name'];
    $emails['reciever'] = $form_state['values']['reciever'];

    $proposal = propeditor_get_proposal($hash, 'hash');

    // Update proposal
    db_update('propeditor_proposals')
            ->condition('prid', $proposal->prid)
            ->fields(array('emails' => serialize($emails)))
            ->execute();

    // Átirányítás az emailek oldalra.
    if ($form_state['values']['scenario'] == 'scenario') {
        $form_state['redirect'] = array('proposal/' . $proposal->hash . '/editor/', array('query' => '', 'fragment' => '',),);
    }
    // Üzenet kiírása az oldalon.
    drupal_set_message(t('Adatok frissítése sikeres.'));

    // Save to watchdog.
    watchdog('propeditor', 'Email adatok frissítve. Ajánlat hash: %prid', array('%prid' => $hash), WATCHDOG_INFO);
}

/**
 * Duplicate proposal
 * @param type $form
 * @param type $form_state
 * @param number $hash Proposal id.
 * @return type
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_proposal_duplicate_form($form, &$form_state, $hash) {

    $form = array();

    $proposal = propeditor_get_proposal(check_plain(trim($hash)), 'hash');
    $confirm = '<h2>' . t('Biztosan duplikálod az ajánlatot?') . '</h2><br>';
    $confirm .= "<h3>$proposal->title</h3>";
    $confirm .= "<p><img src='https://placehold.it/140x198/27c2be' /></p>";
//    $confirm .= "<p>$order->oid ⇒ <strong>$order->name:</strong> " . _membership_format_price($order->price) . "</p>";

    $form['header_data'] = array(
        '#type' => 'item',
        '#markup' => $confirm,
    );

    $form['hash'] = array(
        '#type' => 'hidden',
        '#value' => $hash,
    );

    $form['uid'] = array(
        '#type' => 'hidden',
        '#value' => $proposal->uid,
    );

    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => t('Igen, folytatás'),
        '#attributes' => array('class' => array('btn-success')),
        '#submit' => array('propeditor_proposal_duplicate_form_submit'),
    );

    $form['cancel'] = array(
        '#type' => 'submit',
        '#value' => t('Mégse'),
        '#attributes' => array('class' => array('btn-secondary')),
        '#submit' => array('propeditor_proposal_duplicate_form_cancel'),
    );

    return $form;
}

/**
 * Duplicate proposal form cancel.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_proposal_duplicate_form_cancel(&$form, &$form_state) {

    $form_state['redirect'] = array('user/' . $form_state['values']['uid'] . '/proposals', array('query' => '', 'fragment' => '',),);
}

/**
 * Duplicate proposal form submit.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_proposal_duplicate_form_submit(&$form, &$form_state) {
    global $user;

    // Insert order
    if (!empty($form_state['values']['hash'])) {

        $hash = check_plain(trim($form_state['values']['hash']));
        $proposal = propeditor_get_proposal($hash, 'hash');
        $template = propeditor_get_template($proposal->tid);

        // Create template
        $template_hash = propeditor_get_template_unique_hash();
        $fields = [
            'uid' => $proposal->uid,
            'hash' => $template_hash,
            'title' => $template->title,
            'content' => $template->content,
            'status' => $template->status,
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s'),
        ];

        // Insert component if it is created
        $tid = db_insert('propeditor_templates')
                ->fields($fields)
                ->execute();

        // Create new proposal
        $proposal_hash = propeditor_get_proposals_unique_hash();
        $props = [
            'uid' => $proposal->uid,
            'tid' => $tid,
            'hash' => $proposal_hash,
            'title' => $proposal->title . ' - ' . t('másolat'),
            'description' => $proposal->description,
            'tokens' => serialize($proposal->tokens),
            'emails' => serialize($proposal->emails),
            'is_active' => 0,
            'is_sent' => 0,
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s'),
        ];

        // Merge component if it is created
        $prid = db_insert('propeditor_proposals')
                ->fields($props)
                ->execute();

        $form_state['redirect'] = array('user/' . $proposal->uid . '/proposals', array('query' => '', 'fragment' => '',),);

        drupal_set_message(t('%title ajánlat másolata elkészült.', array('%title' => $proposal->title)));
    } else {
        drupal_set_message('<strong>Hiba:</strong> Hibás adatok! Nem létező ajánlat.', 'error');
    }

    // Redirect.
    // $form_state['redirect'] = array('certify/companies', array('query' => array(),'fragment' => '',),);
    // Print a message.
    // drupal_set_message(t('<em>Megrendelés</em> létrehozása sikeres.'));
    // Save to watchdog.
    watchdog('propoeditor', '%hash ajánlat duplikálva %user által.', array('%hash' => $proposal->hash, '%user' => $user->name, WATCHDOG_INFO));
}

/**
 * Delete proposal
 * @param type $form
 * @param type $form_state
 * @param number $hash Proposal id.
 * @return type
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_proposal_delete_form($form, &$form_state, $hash) {

    $form = array();

    $proposal = propeditor_get_proposal(check_plain(trim($hash)), 'hash');
    $confirm = '<p><img src="https://placehold.it/210x297" style="max-width: 140px;" class="float-left mr-3" /></p>';
    $confirm .= '<h2>' . t('Biztosan törlöd az ajánlatot?') . '</h2><br>';
    $confirm .= "<h3><em>$proposal->title</em></h3>";
    $confirm .= "<p>" . t('Ne feledd, ez a művelet nem vonható vissza!') . "</p>";

    $form['header_data'] = array(
        '#type' => 'item',
        '#markup' => $confirm,
    );

    $form['hash'] = array(
        '#type' => 'hidden',
        '#value' => $hash,
    );

    $form['uid'] = array(
        '#type' => 'hidden',
        '#value' => $proposal->uid,
    );

    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => t('Igen, folytatás'),
        '#attributes' => array('class' => array('btn-danger')),
        '#submit' => array('propeditor_proposal_delete_form_submit'),
    );

    $form['cancel'] = array(
        '#type' => 'submit',
        '#value' => t('Mégse'),
        '#attributes' => array('class' => array('btn-secondary')),
        '#submit' => array('propeditor_proposal_delete_form_cancel'),
    );
//    }

    return $form;
}

/**
 * Delete proposal form cancel.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_proposal_delete_form_cancel(&$form, &$form_state) {

    $form_state['redirect'] = array('user/' . $form_state['values']['uid'] . '/proposals', array('query' => '', 'fragment' => '',),);
}

/**
 * Delete proposal form submit.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_proposal_delete_form_submit(&$form, &$form_state) {
    global $user;

    // Insert order
    if (!empty($form_state['values']['hash'])) {

        $hash = check_plain(trim($form_state['values']['hash']));
        $proposal = propeditor_get_proposal($hash, 'hash');

        // Delete proposal
        db_delete('propeditor_proposals')
                ->condition('prid', $proposal->prid)
                ->execute();

        // Delete template if it is own
        db_delete('propeditor_templates')
                ->condition('uid', $proposal->uid)
                ->condition('uid', 0, '!=')
                ->condition('tid', $proposal->tid)
                ->execute();

        $form_state['redirect'] = array('user/' . $proposal->uid . '/proposals', array('query' => '', 'fragment' => '',),);

        drupal_set_message(t('%title ajánlat sikeresen törölve.', array('%title' => $proposal->title)));
    } else {
        drupal_set_message('<strong>Hiba:</strong> Hibás adatok! Nem létező ajánlat.', 'error');
    }

    // Redirect.
    // $form_state['redirect'] = array('certify/companies', array('query' => array(),'fragment' => '',),);
    // Print a message.
    // drupal_set_message(t('<em>Megrendelés</em> létrehozása sikeres.'));
    // Save to watchdog.
    watchdog('propoeditor', '%hash - %title ajánlat törölve %user által.', array('%hash' => $proposal->hash, '%title' => $proposal->title, '%user' => $user->name, WATCHDOG_INFO));
}

/**
 * Delete proposal
 * @param type $form
 * @param type $form_state
 * @param number $hash Proposal id.
 * @return type
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_proposal_activate_form($form, &$form_state, $hash) {

    $form = array();

    $proposal = propeditor_get_proposal(check_plain(trim($hash)), 'hash');
    $thumbnail = !empty($proposal->thumbnail) ? file_create_url($proposal->thumbnail) : 'https://placehold.it/210x297';

    if ($proposal->is_active == 1) {
        $confirm = '<p><img src="' . $thumbnail . '" style="max-width: 140px;" class="float-left mr-3" /></p>';
        $confirm .= '<h2>' . t('Biztosan inaktiválod az ajánlatot?') . '</h2><br>';
        $confirm .= "<h3><em>$proposal->title</em></h3>";
        $confirm .= "<p>" . t('A művelet után nem megy ki több email, és nem lesz látható az ajánlat a címzett számára sem!') . "</p>";
    } else if ($proposal->activated_at != null) {
        $confirm = '<p><img src="' . $thumbnail . '" style="max-width: 140px;" class="float-left mr-3" /></p>';
        $confirm .= '<h2>' . t('Biztosan újra aktiválod az ajánlatot?') . '</h2><br>';
        $confirm .= "<h3><em>$proposal->title</em></h3>";
        $confirm .= "<p>" . t('A művelet után a még ki nem küldött emailek a megfelelő időközökkel kiküldésre kerülnek!') . "</p>";
    } else {
        $confirm = '<p><img src="' . $thumbnail . '" style="max-width: 140px;" class="float-left mr-3" /></p>';
        $confirm .= '<h2>' . t('Biztosan kiküldöd az ajánlatot?') . '</h2><br>';
        $confirm .= "<h3><em>$proposal->title</em></h3>";
        $confirm .= "<p>" . t('A címzett azonnal emailt kap a rendszertől. Ez a művelet nem vonható vissza, de a további láthatóságot inaktiválással megszüntetheted!') . "</p>";
    }

    $form['header_data'] = array(
        '#type' => 'item',
        '#markup' => $confirm,
    );

    $form['hash'] = array(
        '#type' => 'hidden',
        '#value' => $hash,
    );

    $form['uid'] = array(
        '#type' => 'hidden',
        '#value' => $proposal->uid,
    );

    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => t('Igen, folytatás'),
        '#attributes' => array('class' => array('btn-success')),
        '#submit' => array('propeditor_proposal_activate_form_submit'),
    );

    $form['cancel'] = array(
        '#type' => 'submit',
        '#value' => t('Mégse'),
        '#attributes' => array('class' => array('btn-secondary')),
        '#submit' => array('propeditor_proposal_activate_form_cancel'),
    );
//    }

    return $form;
}

/**
 * Delete proposal form cancel.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_proposal_activate_form_cancel(&$form, &$form_state) {

    $form_state['redirect'] = array('user/' . $form_state['values']['uid'] . '/proposals', array('query' => '', 'fragment' => '',),);
}

/**
 * Delete proposal form submit.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_proposal_activate_form_submit(&$form, &$form_state) {
    global $user;
    global $base_url;

    // Insert order
    if (!empty($form_state['values']['hash'])) {

        $hash = check_plain(trim($form_state['values']['hash']));
        $proposal = propeditor_get_proposal($hash, 'hash');

        if ($proposal->is_active == 1) {

            // Inactivate proposal
            db_update('propeditor_proposals')
                    ->condition('hash', $hash)
                    ->fields(array('is_active' => 0))
                    ->execute();

            $form_state['redirect'] = array('user/' . $proposal->uid . '/proposals', array('query' => '', 'fragment' => '',),);

            drupal_set_message(t('%title ajánlat inactiválva.', array('%title' => $proposal->title)));
        } else if ($proposal->activated_at != null) {

            // Reactivate proposal
            db_update('propeditor_proposals')
                    ->condition('hash', $hash)
                    ->fields(array('is_active' => 1))
                    ->execute();

            $form_state['redirect'] = array('user/' . $proposal->uid . '/proposals', array('query' => '', 'fragment' => '',),);

            drupal_set_message(t('%title ajánlat sikeresen újra aktiválva.', array('%title' => $proposal->title)));
        } else {

            $proposal->tokens['%LINK%'] = $base_url . '/proposal/' . $hash . '/view?customer=' . $proposal->emails['reciever'];
            $to_name = $proposal->emails['reciever_name'];
            $to_mail = $proposal->emails['reciever'];
            $subject = changeTokens($proposal->emails['first']['subject'], $proposal->tokens);
            $body = changeTokens($proposal->emails['first']['body'], $proposal->tokens);

            // Generate stat record
            $email_hash = propeditor_generate_email_stat($proposal->prid, 1, $subject, $body, $to_name, $to_mail);
            if ($email_hash != false) {
                $body .= '<img src="' . $base_url . '/propeditor/s/' . $email_hash . '" width="0" height="0" alt="" />';
                $body .= '<img src="https://www.google-analytics.com/collect?v=1&tid=UA-148996857-1&cid=555&aip=1&t=event&ec=email&ea=open&dp=%2Femail%2Fnewsletter&dt=' . $email_hash . '">';
            }

            $data = propeditor_html_email_send($to_name, $to_mail, $subject, $body);

            if ($data == TRUE) {
                // Activate proposal
                db_update('propeditor_proposals')
                        ->condition('hash', $hash)
                        ->fields(array(
                            'is_sent' => 1,
                            'next_send' => date('Y-m-d H:i:s', strtotime('+3 days')),
                            'activated_at' => date('Y-m-d H:i:s'),
                            'is_active' => 1))
                        ->execute();

                $form_state['redirect'] = array('user/' . $proposal->uid . '/proposals', array('query' => '', 'fragment' => '',),);

                drupal_set_message(t('%title ajánlat sikeresen kiküldve.', array('%title' => $proposal->title)));
            } else {
                drupal_set_message('<strong>Hiba:</strong> Az ajánlat kiküldése sikertelen.', 'error');
            }
        }
    } else {
        drupal_set_message('<strong>Hiba:</strong> Hibás adatok! Nem létező ajánlat.', 'error');
    }

    // Redirect.
    // $form_state['redirect'] = array('certify/companies', array('query' => array(),'fragment' => '',),);
    // Print a message.
    // drupal_set_message(t('<em>Megrendelés</em> létrehozása sikeres.'));
    // Save to watchdog.
    watchdog('propoeditor', '%hash - %title ajánlat kiküldve, aktiválva.', array('%hash' => $proposal->hash, '%title' => $proposal->title, '%user' => $user->name, WATCHDOG_INFO));
}
