<?php

/**
 * @file API functions.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */

/**
 * Proposal editor page.
 * @param type $hash
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_editor_page($hash) {

    $proposal = propeditor_get_proposal(check_plain(trim($hash)), 'hash');

    return theme('editor', array(
        'proposal' => $proposal,
    ));
}

/**
 * Proposal editor page.
 * @param type $hash
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_preview_page($hash) {

    $proposal = propeditor_get_proposal(check_plain(trim($hash)), 'hash');
    $template = propeditor_get_template($proposal->tid);

    return theme('preview', array(
        'proposal' => $proposal,
        'template' => $template,
    ));
}
