<?php

/**
 * @file API functions.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */

/**
 * Login form to view proposal.
 * @param type $form
 * @param type $form_state
 * @param type $hash
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_customer_login_form($form, &$form_state, $hash) {
    global $_REQUEST;
    global $base_url;

    $form = array();

    if (!isset($form_state['storage']['loggedin'])) {

        // Create a form.
        $form['overview'] = array(
            '#markup' => '<h1 class="text-center">' . t('Ajánlata érkezett!') . '</h1><br>',
        );

        $html = '';
        $html .= '<div class="row justify-content-center">';
        $html .= '<div class="col-sm-12 text-justify mt-3">';
//    $html .= t('<h1 class="text-center">@name</h1><br>', array('@name' => $company));
        $html .= t(variable_get('propeditor_gdpr_text')['value']);
        $html .= '</div>';
        $html .= '</div>';

        $form['html'] = array(
            '#type' => 'markup',
            '#markup' => $html,
        );

        $form['email'] = array(
            '#attributes' => array('placeholder' => array(t('Ajánlat címzettje'))),
            '#type' => 'textfield',
            '#size' => 12,
            '#maxlength' => 512,
            '#required' => TRUE,
            '#default_value' => isset($_REQUEST['customer']) ? check_plain(trim($_REQUEST['customer'])) : '',
            '#prefix' => '<div class="row justify-content-center mt-3"><div class="col-sm-12">',
            '#suffix' => '</div>'
        );

        $form['gdpr'] = array(
            '#type' => 'checkbox',
            '#title' => t('A fenti információkat elolvastam, megértettem és elfogadom.'),
            '#required' => TRUE,
            '#default_value' => 0,
//            '#attributes' => array('class' => array('c-checkbox')),
            '#prefix' => '<div class="col-sm-12 mt-3">',
            '#suffix' => '</div>'
        );

        $form['hash'] = array(
            '#type' => 'hidden',
            '#value' => $hash,
        );

//        $form['captcha'] = array(
//            '#type' => 'captcha',
//            '#captcha_type' => 'recaptcha/reCAPTCHA',
//            '#prefix' => '<div class="col-sm-10 mt-3">',
//            '#suffix' => '</div>'
//        );

        $form['submit'] = array(
            '#type' => 'submit',
            '#value' => t('Ajánlat megtekintése'),
            '#submit' => array('propeditor_customer_login_form_submit'),
            '#attributes' => array('class' => array('btn-success', 'mt-3')),
            '#prefix' => '<div class="col-sm-12">',
            '#suffix' => '</div></div>'
        );

        $ga = explode('-', variable_get('googleanalytics_account', 'UA-12365478-1'))[1];

        $form['script'] = array(
            '#markup' => '
<!-- Start Open Pixel Snippet -->
<script>
!function(e,t,o,p,s,i,a,n,r){e[s]||((a=e[s]=function(){a.process?a.process.apply(a,arguments):a.queue.push(arguments)}).queue=[],a.t=1*new Date,(n=t.createElement(o)).async=1,n.src="' . $base_url . '/sites/all/modules/dev/propeditor/libraries/opix/v1/openpixel.js?t="+864e5*Math.ceil(new Date/864e5),(r=t.getElementsByTagName(o)[0]).parentNode.insertBefore(n,r))}(window,document,"script",0,"opix"),opix("init","ID-' . $ga . '"),opix("close",{"page_id": "login"}),opix("event","pageload", {"page_id": "login"});
</script>
<!-- End Open Pixel Snippet -->',
        );

        $form['#theme'] = array('login');
//        pdd($form_state['storage'], true);

        return $form;
    } else {

//        pdd($form_state['storage'], true);

        $form['canvas'] = array(
            '#type' => 'hidden',
            '#attributes' => array(
                'id' => 'signature',
            ),
        );

        $form['hash'] = array(
            '#type' => 'hidden',
            '#value' => $hash,
        );

        $form['submit'] = array(
            '#type' => 'submit',
            '#value' => t('Elfogadom'),
            '#submit' => array('propeditor_customer_login_form_submit'),
            '#attributes' => array('class' => array('btn-success')),
            '#prefix' => '',
            '#suffix' => ''
        );

        $proposal = propeditor_get_proposal(check_plain(trim($hash)), 'hash');
        $template = propeditor_get_template($proposal->tid);

        $form['proposal'] = array(
            '#type' => 'item',
            '#value' => $proposal,
        );
        $form['template'] = array(
            '#type' => 'item',
            '#value' => $template,
        );

        $form['script'] = array(
            '#markup' => '
<!-- Start Open Pixel Snippet -->
<script>
!function(e,t,o,p,s,i,a,n,r){e[s]||((a=e[s]=function(){a.process?a.process.apply(a,arguments):a.queue.push(arguments)}).queue=[],a.t=1*new Date,(n=t.createElement(o)).async=1,n.src="' . $base_url . '/sites/all/modules/dev/propeditor/libraries/opix/v1/openpixel.js?t="+864e5*Math.ceil(new Date/864e5),(r=t.getElementsByTagName(o)[0]).parentNode.insertBefore(n,r))}(window,document,"script",0,"opix"),opix("init","ID-' . $ga . '"),opix("close",{"page_id": "view"}),opix("event","pageload", {"page_id": "view"});
</script>
<!-- End Open Pixel Snippet -->',
        );

        $form['#theme'] = array('view');

        return $form;
    }
}

/**
 * Submit login form.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_customer_login_form_submit($form, &$form_state) {

//    pdd($form_state, true);
    if (!isset($form_state['storage']['loggedin'])) {

        // Get hash value
        $hash = check_plain(trim($form_state['values']['hash']));

        // Get hash value
        $email = check_plain(trim($form_state['values']['email']));

        // Get hash value
        $gdpr = check_plain(trim($form_state['values']['gdpr']));

        // Get test data.
        $proposal = propeditor_get_proposal($hash, 'hash');

        if ($gdpr == 1) {
            $form_state['storage']['loggedin'] = true;
            $form_state['storage']['proposal'] = $proposal;
        } else {
            $form_state['storage']['loggedin'] = false;
            $form_state['storage']['proposal'] = $proposal;
        }
        $form_state['rebuild'] = true;

        /*
         * @TODO: Opening analytics
         */
    } else {

        /*
         * @TODO: Viewing analytics, but not unique
         */
        try {
            // Update proposal
            $signature = check_plain(trim($form_state['values']['canvas']));
            db_update('propeditor_proposals')
                    ->fields(['accepted' => $signature, 'accepted_at' => date('Y-m-d H:i:s')])
                    ->condition('hash', $form_state['storage']['proposal']->hash)
                    ->execute();
        } catch (exception $e) {
            // Save to watchdog
            watchdog('propeditor', '"%hash" proposal accepting failed. Error: %error', array('%hash' => $form_state['storage']['proposal']->hash, '%error' => json_encode($e), WATCHDOG_NOTICE));
        }
        // Save to watchdog
        watchdog('propeditor', '"%hash" proposal accepted successful.', array('%hash' => $form_state['storage']['proposal']->hash, WATCHDOG_NOTICE));

        $form_state['storage']['proposal']->accepted = $signature;
        $form_state['storage']['accepted'] = true;
        $form_state['rebuild'] = true;
    }

    // Redirect after the save.
//    $form_state['redirect'] = propeditor_candidate_redirect_to_test($value);
    // Print a message.
//  drupal_set_message(t('Login successful, good luck for the test.'));
    // Save to watchdog.
//    watchdog('propeditor', '"%cid" candidate login to fill test: %tid.', array('%cid' => $test['cid'], '%tid' => $test['tid'], WATCHDOG_NOTICE));
}
