<?php

/**
 * @file Cron functions.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */

/**
 * Promotions cron job
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_cron_sender($emails = 5) {

    global $base_url;

    // Get candidate test assigns from queue
    $queue = DrupalQueue::get('propeditor_proposal_emails');

    //Pull items out one at a time.
    $i = 0;
    $n = 0;
    $max = (int) $emails;
    while ($item = $queue->claimItem()) {

        watchdog('propeditor', 'Ajánlat email kiküldve: %options.', array('%options' => json_encode($item), WATCHDOG_NOTICE));

        if ($item != FALSE) {

            // Get email data
            $to_name = $item->data['to_name'];
            $to_mail = $item->data['to_mail'];
            $subject = $item->data['subject'];
            $body = $item->data['body'];
            $hash = $item->data['hash'];
            $sent_value = $item->data['sent_value'];
            $next_date = $item->data['next_date'];

            $prid = propeditor_get_proposal($hash, 'hash')->prid;

            // Generate stat record
            $email_hash = propeditor_generate_email_stat($prid, $sent_value, $subject, $body, $to_name, $to_mail);
            if ($email_hash != false) {
                $body .= '<img src="' . $base_url . '/propeditor/s/' . $email_hash . '" width="0" height="0" alt="" />';
                $body .= '<img src="https://www.google-analytics.com/collect?v=1&tid=UA-148996857-1&cid=555&aip=1&t=event&ec=email&ea=open&dp=%2Femail%2Fnewsletter&dt=' . $email_hash . '">';
            }

            // Send email
            $data = propeditor_html_email_send($to_name, $to_mail, $subject, $body);

            if ($data === TRUE) {

                propeditor_proposal_set_email_send($hash, (int) $sent_value, $next_date);

                //Good, we succeeded.  Delete the item as it is no longer needed.
                $queue->deleteItem($item);
            } else {
                $n++;
            }
        }
        if ($i < $max) {
            $i++;
        } else {
            break;
        }
    }

    watchdog('propeditor', t('Email sender cron lefutott. Végrehajtott akciók: %actions; Hibák kiküldés közben: %errors'), array('%errors' => $n, '%actions' => $i, WATCHDOG_NOTICE));
}

/**
 * Collect sendable emails and put them to queue
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_cron_mail_collector() {

    global $base_url;

    $queued = 0;
    $errors = 0;

    // Get all active promotion
    $proposals = db_select('propeditor_proposals', 'p')
            ->condition('p.is_active', 1)
            ->condition('p.accepted', null)
            ->condition('p.is_sent', 3, '<')
            ->condition('p.next_send', date('Y-m-d H:i:s'), '<')
            ->condition('p.next_send', null, 'IS NOT')
            ->condition('p.queued', 0)
            ->fields('p')
            ->orderBy('p.updated_at', 'asc')
            ->execute()
            ->fetchAll();
    $all = count($proposals);

    foreach ($proposals as $proposal) {

        $proposal->tokens = propeditor_get_proposal_token_list($proposal);
        $proposal->emails = unserialize($proposal->emails);

        try {
            $fields['hash'] = $proposal->hash;
            $fields['to_name'] = $proposal->emails['reciever_name'];
            $fields['to_mail'] = $proposal->emails['reciever'];

            switch ($proposal->is_sent) {
                case 0:
//                    $fields['subject'] = changeTokens($proposal->emails['first']['subject'], $proposal->tokens);
//                    $fields['body'] = changeTokens($proposal->emails['first']['body'], $proposal->tokens);
//                    $fields['sent_value'] = 1;
//                    $fields['next_date'] = date('Y-m-d H:i:s', strtotime('+3 days'));
                    break;
                case 1:
                    $proposal->tokens['%LINK%'] = $base_url . '/proposal/' . $proposal->hash . '/view?customer=' . $proposal->emails['reciever'];
                    $fields['subject'] = changeTokens($proposal->emails['second']['subject'], $proposal->tokens);
                    $fields['body'] = changeTokens($proposal->emails['second']['body'], $proposal->tokens);
                    $fields['sent_value'] = 2;
                    $fields['next_date'] = date('Y-m-d H:i:s', strtotime('+4 days'));
                    break;
                case 2:
                    $proposal->tokens['%LINK%'] = $base_url . '/proposal/' . $proposal->hash . '/view?customer=' . $proposal->emails['reciever'];
                    $fields['subject'] = changeTokens($proposal->emails['third']['subject'], $proposal->tokens);
                    $fields['body'] = changeTokens($proposal->emails['third']['body'], $proposal->tokens);
                    $fields['sent_value'] = 3;
                    $fields['next_date'] = null;
                    break;
            }

            $queue = DrupalQueue::get('propeditor_proposal_emails');
            $queue->createItem($fields);

            // Set queued
            db_update('propeditor_proposals')
                    ->condition('hash', $proposal->hash)
                    ->fields(array('queued' => 1))
                    ->execute();

            $queued++;
        } catch (Exception $e) {
            watchdog('propeditor', 'Ajánlat email összeállítása sikertelen. Error: %options.', array('%options' => json_encode([$e, $proposal->hash]), WATCHDOG_WARNING));
            $errors++;
        }
    }

    watchdog('propeditor', t('Email collector cron lefutott. Összes aktív nem teljesen kiküldött ajánlat: %all; Emailek sorbaállítva: %queued; Hibás akciók: %errors'), array('%all' => $all, '%queued' => $queued, '%errors' => $errors, WATCHDOG_NOTICE));
}
