<?php

/**
 * @file API functions.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */

/**
 * Get all components.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_get_all_component() {

    global $user;
    global $_REQUEST; // $_POST
    // Debug
//    $user = user_load(1);

    $post = propeditor_clean_array($_REQUEST);

    if (!$user->uid) {
        return [
            'request' => $post,
            'result' => [
                'msg' => 'Missing authetication!'
            ],
            'success' => false
        ];
    }

    $db_or = db_or();
    $db_or->condition('uid', $user->uid);
    $db_or->condition('uid', 0);

    $components = db_select('propeditor_components', 'c')
            ->condition($db_or)
            ->fields('c')
            ->execute()
            ->fetchAll();

    foreach ($components as $component) {
        $component->thumbnail = !empty($component->thumbnail) ? file_create_url($component->thumbnail) : '';
    }

    return [
        'request' => $post,
        'result' => $components,
        'success' => true
    ];
}

/**
 * Get all components.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_component_save() {

    global $user;
    global $_REQUEST; // $_POST
    // Debug
//    $user = user_load(1);

    $post = propeditor_clean_array($_REQUEST);

    if (!$user->uid) {
        return [
            'request' => $post,
            'result' => [
                'msg' => 'Missing authetication!'
            ],
            'success' => false
        ];
    }

    // Check whether component exists
    $component = null;
    if (isset($post['hash']) && !empty($post['hash'])) {
        $component = propeditor_get_component($post['hash'], 'hash');
    }

    if (empty($component) && (
            !isset($post['name']) ||
            !isset($post['label']) ||
            !isset($post['content'])
            )) {
        return [
            'request' => $post,
            'result' => [
                'msg' => 'Missing data!'
            ],
            'success' => false
        ];
    }

    // Make fields
    $hash = propeditor_get_component_unique_hash();
    $fields = [
        'uid' => !empty($component) ? $component->uid : $user->uid,
        'name' => empty($component) ? _propeditor_change_letters($post['name']) . '-' . $hash : $component->name,
        'hash' => !empty($component) ? $component->hash : $hash,
        'label' => isset($post['label']) ? $post['label'] : $component->label,
        'content' => isset($_REQUEST['content']) ? $_REQUEST['content'] : $component->content,
        'status' => isset($post['status']) ? $post['status'] : 1,
        'created_at' => !empty($component) ? $component->created_at : date('Y-m-d H:i:s'),
        'updated_at' => date('Y-m-d H:i:s'),
    ];

    // Prepare file directory
    $user_dir = variable_get('propeditor_file_path') . '/components/';
    file_prepare_directory($user_dir, FILE_CREATE_DIRECTORY | FILE_MODIFY_PERMISSIONS);

    // Create file
    $jpeg_string = propeditor_clean_base64($_POST['thumbnail']);
    list($type, $jpeg_string) = explode(';', $jpeg_string);
    list(, $jpeg_string) = explode(',', $jpeg_string);
    $data = base64_decode($jpeg_string);

    $filename = $user_dir . $fields['name'] . '.jpeg';

    $file = file_save_data($data, $filename, FILE_EXISTS_REPLACE);

    $fields['thumbnail'] = $file !== false ? $filename : null;

    // Merge component if it is created
    $cid = !empty($component) ? $component->cid : 0;
    $result = db_merge('propeditor_components')
            ->key(['cid' => $cid])
            ->fields($fields)
            ->execute();

    $component = db_select('propeditor_components', 'c')
            ->condition('hash', !empty($component) ? $component->hash : $hash)
            ->fields('c')
            ->execute()
            ->fetchObject();

    return [
        'request' => $post,
        'result' => $component,
        'success' => true
    ];
}

/**
 * Get all components.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_component_delete() {

    global $user;
    global $_REQUEST; // $_POST
    // Debug
//    $user = user_load(1);

    $post = propeditor_clean_array($_REQUEST);

    if (!$user->uid) {
        return [
            'request' => $post,
            'result' => [
                'msg' => 'Missing authetication!'
            ],
            'success' => false
        ];
    } else if (!isset($post['hash']) || empty($post['hash'])) {
        return [
            'request' => $post,
            'result' => [
                'msg' => 'Missing component identifier!'
            ],
            'success' => false
        ];
    }

    // Check whether component exists
    $component = propeditor_get_component($post['hash'], 'hash');

    if (!empty($component)) {
        db_delete('propeditor_components')
                ->condition('cid', $component->cid)
                ->execute();
        return [
            'request' => $post,
            'result' => $component,
            'success' => true
        ];
    }

    return [
        'request' => $post,
        'result' => [
            'msg' => 'Missing component!'
        ],
        'success' => false
    ];
}

/**
 * Image Upload.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_image_upload() {

    global $user;
    global $_REQUEST; // $_POST
    global $_FILES;

    // Debug
//    $user = user_load(1);

    $post = propeditor_clean_array($_REQUEST);
    $file = $_FILES['uploaded_img'];

    if (!$user->uid) {
        return [
            'request' => $post,
            'result' => [
                'msg' => 'Missing authetication!'
            ],
            'success' => false
        ];
    } else if (
            empty($file)
    ) {
        return [
            'request' => $post,
            'result' => [
                'msg' => 'Missing data!'
            ],
            'success' => false
        ];
    }

    //Get allowed extensions from my_module settings
    $upload_extensions = variable_get('propeditor_image_types', 'jpeg jpg gif png');
    //Get max upload size in MB from my_module settings. Default is 1MB
    $upload_max_size = variable_get('propeditor_image_size', '1');

    // Ext validation before upload
    $file_ext = pathinfo($file['name'], PATHINFO_EXTENSION);
    $valid_ext = strpos($upload_extensions, $file_ext);
    if ($valid_ext === false) {
        return [
            'request' => $post,
            'result' => [
                'msg' => 'Invalid file extension!'
            ],
            'success' => false
        ];
    }

    $validators = array(
        'file_validate_extensions' => array($upload_extensions),
        'file_validate_size' => array($upload_max_size * 1024 * 1024),
    );

    // Prepare file directory
    $user_dir = 'public://propeditor/' . $user->uid;
    file_prepare_directory($user_dir, FILE_CREATE_DIRECTORY | FILE_MODIFY_PERMISSIONS);

    // Create file
    if (isset($post['filename'])) {
        $filename = $user_dir . '/' . _propeditor_change_letters($post['filename']) . '.' . $file_ext;
    } else {
        $filename = $user_dir . '/' . _propeditor_change_letters($file['name']);
    }
    $file = file_save_data(file_get_contents($file['tmp_name']), $filename);
    $validation = file_validate($file, $validators);

    if (!empty($validation)) {
        $result = file_delete($file, TRUE);
        return [
            'request' => $post,
            'result' => [
                'msg' => 'Invalid file!',
                'errors' => $validation
            ],
            'success' => false
        ];
    } else {
        return [
            'request' => $post,
            'result' => file_create_url($file->uri),
            'success' => true
        ];
    }
}

/**
 * Get all files of a user.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_get_all_file() {

    global $user;
    global $_REQUEST; // $_POST
    // Debug
//    $user = user_load(1);

    $post = propeditor_clean_array($_REQUEST);

    if (!$user->uid) {
        return [
            'request' => $post,
            'result' => [
                'msg' => 'Missing authetication!'
            ],
            'success' => false
        ];
    }

    $user_dir = 'public://propeditor/' . $user->uid;
    $files = file_scan_directory($user_dir, '/.*/', array('nomask'));

    return [
        'request' => $post,
        'result' => $files,
        'success' => true
    ];
}

/**
 * Get template by hash.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_template_load() {

    global $user;
    global $_REQUEST; // $_POST
    // Debug
//    $user = user_load(1);

    $post = propeditor_clean_array($_REQUEST);

    if (!$user->uid) {
        return [
            'request' => $post,
            'result' => [
                'msg' => 'Missing authetication!'
            ],
            'success' => false
        ];
    }

    // Check whether component exists
    $template = null;
    if (isset($post['hash']) && !empty($post['hash'])) {
        $template = propeditor_get_template($post['hash'], 'hash');
    } else {
        return [
            'request' => $post,
            'result' => [
                'msg' => 'Missing identifier!'
            ],
            'success' => false
        ];
    }

    return [
        'request' => $post,
        'result' => $template,
        'success' => true
    ];
}

/**
 * Update or create template.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_template_save() {

    global $user;
    global $_REQUEST; // $_POST
    // Debug
//    $user = user_load(1);

    $post = propeditor_clean_array($_REQUEST);

    if (!$user->uid) {
        return [
            'request' => $post,
            'result' => [
                'msg' => 'Missing authetication!'
            ],
            'success' => false
        ];
    }

    // Check whether component exists
    $template = null;
    if (isset($post['hash']) && !empty($post['hash'])) {
        $template = propeditor_get_template($post['hash'], 'hash');
    }

    if (empty($template) && (
            !isset($post['title']) ||
            !isset($post['content'])
            )) {
        return [
            'request' => $post,
            'result' => [
                'msg' => 'Missing data!'
            ],
            'success' => false
        ];
    }

    // Make fields
    $hash = propeditor_get_template_unique_hash();
    $fields = [
        'uid' => !empty($template) ? $template->uid : $user->uid,
        'hash' => !empty($template) ? $template->hash : $hash,
        'title' => isset($post['title']) ? $post['title'] : $template->title,
        'content' => isset($_REQUEST['content']) ? $_REQUEST['content'] : $template->content,
        'status' => isset($post['status']) ? $post['status'] : 1,
        'created_at' => !empty($template) ? $template->created_at : date('Y-m-d H:i:s'),
        'updated_at' => date('Y-m-d H:i:s'),
    ];

    // Merge component if it is created
    $tid = !empty($template) ? $template->tid : 0;
    db_merge('propeditor_templates')
            ->key(['tid' => $tid])
            ->fields($fields)
            ->execute();

    $template = db_select('propeditor_templates', 't')
            ->condition('hash', !empty($template) ? $template->hash : $hash)
            ->fields('t')
            ->execute()
            ->fetchObject();

    return [
        'request' => $post,
        'result' => $template,
        'success' => true
    ];
}

/**
 * Update template thumbnail.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_thumbnail_save() {

    global $user;
    global $base_url;
    global $_REQUEST; // $_POST

    $account = $user;

    // Debug
//    $account = user_load(1);

    $post = propeditor_clean_array($_REQUEST);

    if (!$account->uid) {
        return [
            'request' => $post,
            'result' => [
                'msg' => 'Missing authetication!'
            ],
            'success' => false
        ];
    }

    // Check whether component exists
    $template = null;
    if (isset($post['hash']) && !empty($post['hash'])) {
        $template = propeditor_get_template($post['hash'], 'hash');
    }

    if (empty($template) || !isset($_POST['thumbnail'])) {
        return [
            'request' => $post,
            'result' => [
                'msg' => 'Missing data!'
            ],
            'success' => false
        ];
    }

    // Prepare file directory
    $user_dir = variable_get('propeditor_file_path') . '/' . $account->uid . '/templates/' . $post['hash'] . '/';
    file_prepare_directory($user_dir, FILE_CREATE_DIRECTORY | FILE_MODIFY_PERMISSIONS);

    // Create file
    $jpeg_string = propeditor_clean_base64($_POST['thumbnail']);
    list($type, $jpeg_string) = explode(';', $jpeg_string);
    list(, $jpeg_string) = explode(',', $jpeg_string);
    $data = base64_decode($jpeg_string);

    $filename = $user_dir . 'thumbnail.jpeg';

    $file = file_save_data($data, $filename, FILE_EXISTS_REPLACE);

    if ($file !== FALSE) {
        // Make fields
        $fields = [
            'thumbnail' => $filename,
            'updated_at' => date('Y-m-d H:i:s'),
        ];

        // Merge component if it is created
        db_update('propeditor_templates')
                ->condition('tid', $template->tid)
                ->fields($fields)
                ->execute();

        return [
            'request' => $post,
            'result' => 'Thumbnail created!',
            'success' => true
        ];
    } else {

        return [
            'request' => $post,
            'result' => 'Thumbnail creating failed!',
            'success' => false
        ];
    }
}

/**
 * Get all token.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_get_all_token() {

    global $user;
    global $_REQUEST; // $_POST
    // Debug
//    $user = user_load(1);

    $post = propeditor_clean_array($_REQUEST);

    if (!$user->uid) {
        return [
            'request' => $post,
            'result' => [
                'msg' => 'Missing authetication!'
            ],
            'success' => false
        ];
    }

    $tokens = propeditor_get_token_list($user->uid);

    return [
        'request' => $post,
        'result' => $tokens,
        'success' => true
    ];
}

/**
 * Create token.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_token_save() {

    global $user;
    global $_REQUEST; // $_POST
    // Debug
//    $user = user_load(1);

    $post = propeditor_clean_array($_REQUEST);

    if (!$user->uid) {
        return [
            'request' => $post,
            'result' => [
                'msg' => 'Missing authetication!'
            ],
            'success' => false
        ];
    } else if (!isset($post['token'])) {
        return [
            'request' => $post,
            'result' => [
                'msg' => 'Missing data!'
            ],
            'success' => false
        ];
    }

    return propeditor_token_create($post['token'], $user->uid);
}

/**
 * Delete token.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_token_delete() {

    global $user;
    global $_REQUEST; // $_POST
    // Debug
//    $user = user_load(1);

    $post = propeditor_clean_array($_REQUEST);

    if (!$user->uid) {
        return [
            'request' => $post,
            'result' => [
                'msg' => 'Missing authetication!'
            ],
            'success' => false
        ];
    } else if (!isset($post['token'])) {
        return [
            'request' => $post,
            'result' => [
                'msg' => 'Missing data!'
            ],
            'success' => false
        ];
    }

    return propeditor_token_destroy($post['token'], 'plain', $user->uid);
}

/**
 * Get template by hash.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_proposal_load() {

    global $user;
    global $_REQUEST; // $_POST
    // Debug
//    $user = user_load(1);

    $post = propeditor_clean_array($_REQUEST);

    if (!$user->uid) {
        return [
            'request' => $post,
            'result' => [
                'msg' => 'Missing authetication!'
            ],
            'success' => false
        ];
    }

    // Check whether component exists
    if (isset($post['hash']) && !empty($post['hash'])) {
//        $proposal = propeditor_get_proposal($post['hash'], 'hash');
        $proposal = propeditor_get_proposal_edit($post['hash'], 'hash');
    } else {
        return [
            'request' => $post,
            'result' => [
                'msg' => 'Missing identifier!'
            ],
            'success' => false
        ];
    }

    return [
        'request' => $post,
        'result' => $proposal,
        'success' => true
    ];
}

/**
 * Create token.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function propeditor_masterdata_save() {

    global $user;
    global $_REQUEST; // $_POST
    // Debug
//    $user = user_load(1);

    $post = propeditor_clean_array($_REQUEST);

    if (!$user->uid) {
        return [
            'request' => $post,
            'result' => [
                'msg' => 'Missing authetication!'
            ],
            'success' => false
        ];
    } else if (
            !isset($post['proposal_hash']) ||
            !isset($post['tokens']) ||
            empty($post['tokens'])
    ) {
        return [
            'request' => $post,
            'result' => [
                'check' => empty($post['tokens']),
                'msg' => 'Missing data!'
            ],
            'success' => false
        ];
    }

    $proposal = propeditor_get_proposal($post['proposal_hash'], 'hash');

    $db_or = db_or();
    $db_or->condition('uid', $proposal->uid);
    $db_or->condition('uid', 0);
    $token_list = db_select('propeditor_tokens', 't')
            ->condition($db_or)
            ->fields('t', array('token'))
            ->execute()
            ->fetchAllKeyed(0, 0);
    $token_keys = array_keys($token_list);

    foreach ($post['tokens'] as $key => $value) {
        $token = '%' . strtoupper(_propeditor_change_letters(trim($key))) . '%';
        if (!in_array($key, $token_keys) && !in_array($token, $token_keys)) {
            $key = propeditor_token_merge($token, $proposal->uid)['token'];
        }
        $token_list[$key] = $value;
    }

    // Update proposal
    db_update('propeditor_proposals')
            ->condition('prid', $proposal->prid)
            ->fields(array('tokens' => serialize($token_list)))
            ->execute();

    $proposal = propeditor_get_proposal($proposal->prid, 'prid');

    return [
        'request' => $post,
        'result' => $proposal,
        'success' => true
    ];
}
