<?php

/**
 * @file Cron functions.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */

/**
 * Promotions cron job
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function ownership_cron_balance() {

    // Get totals
    $orders = ownership_get_orders_sum_per_vat();
    $periods = ownership_get_period_orders_sum_per_vat();
    $costs = ownership_get_costs_sum();
    $withdrawals = ownership_get_withdrawals_sum();
    
    $income = 0;
    $orderVats = 0;
    $periodVats = 0;
    foreach($orders as $order) {
        $income += (int) $order->total;
        $orderVats += $order->total * ($order->vat / 100);
    }
    foreach($periods as $period) {
        $income += (int) $period->total;
        $periodVats += $period->total * ($period->vat / 100);
    }
    
    $accounts = ownership_get_account_list();
    $balances = [];

    foreach ($accounts as $account) {
        $balance = ownership_get_current_balance($account->aid);
        !isset($costs[$account->aid]) ? $costs[$account->aid] = 0 : '';
        !isset($withdrawals[$account->aid]) ? $withdrawals[$account->aid] = 0 : '';

        // Close balance if expired
        $balance_month = date('Y-m', strtotime($balance->created_at));
        if ($balance_month < date('Y-m')) {
            $bid = ownership_close_balance($balance->bid);
        } else {
            $bid = $balance->bid;
        }

        // Update amount of balance
        if ($account->priority == 0) { // Összes Profitból számított
            $fields = [
                'amount' => ($income - (double) $costs[$account->aid] - (double) $withdrawals[$account->aid]) * ($account->percent / 100),
                'updated_at' => date('Y-m-d H:i:s')
            ];
            // Get all not 0 priority balance
            $query = db_select('ownership_balances', 'b')
                    ->condition('b.closed_at', null);
            $query->leftJoin('ownership_accounts', 'a', 'a.aid = b.aid');
            $query->condition('a.priority', 0, '!=');
            $query->fields('b', ['amount', 'aid']);
            $expenses = $query->execute()->fetchAll();
            $taxes = 0;
            foreach ($expenses as $row) {
                $taxes = $taxes + $row->amount;
            }
            $fields['amount'] = round(($income - $taxes) * ($account->percent / 100) - (double) $costs[$account->aid] - (double) $withdrawals[$account->aid], 2);
        } else if ($account->priority == 2) { // Áfa
            $fields = [
                'amount' => round(($orderVats + $periodVats) - (double) $withdrawals[$account->aid], 2),
                'updated_at' => date('Y-m-d H:i:s')
            ];
        } else if ($account->priority == 3) { // Termék profitból számított
            $productAmount = 0;
            $in = 0;
            $products = !empty($account->products) ? unserialize($account->products) : null;
            $all_order = ownership_get_orders_and_periods_sum_by_pids_per_vat($products);
            foreach($all_order as $v) {
                $in += $v->total;
                $productAmount += $v->total * (1 - ($v->vat / 100));
            }
            
            $fields = [
                'amount' => round($productAmount * ($account->percent / 100), 2),
                'updated_at' => date('Y-m-d H:i:s')
            ];
        } else { // Bevételből számított
            $fields = [
                'amount' => round(($income * ($account->percent / 100)) - (double) $costs[$account->aid] - (double) $withdrawals[$account->aid], 2),
                'updated_at' => date('Y-m-d H:i:s')
            ];
        }

        db_update('ownership_balances')
                ->fields($fields)
                ->condition('bid', $bid)
                ->execute();
        $balances[$account->aid] = $fields;
    }

    watchdog('ownership', t('Egyenlegek frissítve. Egyenlegek: %balances'), array('%balances' => json_encode($balances), WATCHDOG_INFO));
}
