<?php

/**
 * @file Ownership Module functions for Balances.
 * @author Ferentzi, Sándor <sandor.ferentzi@gmail.com>
 */

/**
 * Balances listing.
 * @return type html table of Balances.
 * @author Ferentzi, Sándor <sandor.ferentzi@gmail.com>
 */
function ownership_balance_list() {
    $html = '';

    $orders = ownership_get_orders_sum_per_vat();
    $periods = ownership_get_period_orders_sum_per_vat();
    
    $all_income = 0;
    $orderVats = 0;
    $periodVats = 0;
    foreach($orders as $order) {
        $all_income += (int) $order->total;
        $orderVats += $order->total * ($order->vat / 100);
    }
    foreach($periods as $period) {
        $all_income += (int) $period->total;
        $periodVats += $period->total * ($period->vat / 100);
    }
//    $orders = ownership_get_orders_sum();
//    $periods = ownership_get_period_orders_sum();
    $income = _ownership_format_price($all_income);
    $cash = 0;
    $profit = 0;

    $header = array(
        array('data' => t('BID'), 'field' => 'bid', 'sort' => 'desc'),
        array('data' => t('Számla neve'), 'field' => 'name'),
        array('data' => t('Nyitó egyneleg'), 'field' => 'open_amount'),
        array('data' => t('Aktuális egyenleg'), 'field' => 'amount'),
        array('data' => t('Létrehozva'), 'field' => 'created_at'),
        array('data' => t('Utoljára frissítve'), 'field' => 'update_at'),
        array('data' => t('Zárás'), 'field' => 'closed_at'),
    );

    $query = db_select('ownership_balances', 'ob');
    $query->join('ownership_accounts', 'oa', 'oa.aid = ob.aid');
    $query->fields('oa');
    $query->fields('ob');
    $result = $query->extend('PagerDefault')
            ->limit(25)
            ->extend('TableSort')
            ->orderByHeader($header)
            ->execute();


    $rows = array();

    foreach ($result as $value) {

        if (empty($value->closed_at)) {
            $cash += $value->amount;

            if ($value->priority == 0 || $value->priority == 3) {
                $profit += $value->amount;
            }
        }

        $rows[] = array(
            'data' => array(
                $value->bid, // . ' - ' . $value->priority
                $value->name . ' <small>(' . $value->percent . '%)</small>',
                _ownership_format_price($value->open_amount),
                _ownership_format_price($value->amount),
                $value->created_at,
                $value->updated_at,
                $value->closed_at,
            )
        );
    }

    $cash = _ownership_format_price($cash);
    $profit = _ownership_format_price($profit);
    $html .= "<h2>Aktuális statisztika</h2>"
            . "<p><strong>Összes befizetés:</strong> $income<br>"
            . "<strong>Összes készpénz:</strong> $cash<br>"
            . "<strong>Lehívható profit:</strong> <u>$profit</u></p><br>";

    $html .= theme('table', array(
        'header' => $header,
        'rows' => $rows,
        'caption' => '<h2>' . t('Egyenelegek listája') . '</h2>',
        'sticky' => TRUE,
        'empty' => t('Még nincsenek Egyenelegek létrehozva.'),
    ));

    $html .= theme('pager', array('tags' => array()));

    return $html;
}

function ownership_balance_refresh() {

    ownership_cron_balance();

    // Message for the User.
    drupal_set_message(t('Egyenleg frissítve!'));

    drupal_goto('/admin/config/ownership/balance');
}
