<?php

/**
 * @file
 * A bellítások űrlap
 */

/**
 * Implements hook_forms().
 */
function membership_admin_settings_form($form, &$form_state) {
    $form = array();

    $form['overview'] = array(
        '#markup' => t('Ezen a felületen állíthaják be az adminisztrátorok a tagsági rendszer alapvető adatait.'),
        '#prefix' => '<p>',
        '#suffix' => '</p>',
    );

    $form['contact'] = array(
        '#type' => 'fieldset',
        '#title' => t('Cégadatok'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );

    $form['contact']['membership_firm_name'] = array(
        '#title' => t('Cégnév'),
        '#description' => t('A cég neve, ami a weboldalt üzemelteti és a számlát kiállítja.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_firm_name'),
        '#required' => TRUE,
    );

    $form['contact']['membership_firm_city'] = array(
        '#title' => t('Város'),
        '#description' => t('A cég bejegyzésének a városa.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_firm_city'),
        '#required' => TRUE,
    );

    $form['contact']['membership_firm_street_name'] = array(
        '#title' => t('Utca név'),
        '#description' => t('A cég bejegyzésének az utcája, házszám és közetrület típus nélkül.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_firm_street_name'),
        '#required' => TRUE,
    );

    $form['contact']['membership_firm_street_type'] = array(
        '#title' => t('Közterület'),
        '#description' => t('A közterület típusa, pl. út.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_firm_street_type'),
        '#required' => TRUE,
    );

    $form['contact']['membership_firm_street_no'] = array(
        '#title' => t('Házszám, emelet/ajtó'),
        '#description' => t('A cég házszáma, plusz emelet/ajtó ha van.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_firm_street_no'),
        '#required' => TRUE,
    );

    $form['contact']['membership_firm_zip'] = array(
        '#title' => t('Irányítószám'),
        '#description' => t('A cég címének irányítószáma.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_firm_zip'),
        '#required' => TRUE,
    );

    $form['contact']['membership_firm_country'] = array(
        '#title' => t('Ország'),
        '#description' => t('A cég címének országa.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_firm_country'),
        '#required' => TRUE,
    );

    $form['contact']['membership_firm_taxid'] = array(
        '#title' => t('Adószám'),
        '#description' => t('A cég adószáma.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_firm_taxid'),
        '#required' => TRUE,
    );

    $form['contact']['membership_firm_account_holder'] = array(
        '#title' => t('Számlavezető bank'),
        '#description' => t('A bank neve, amelyiknél a cég a bankszámlaszámát vezeti.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_firm_account_holder'),
        '#required' => TRUE,
    );

    $form['contact']['membership_firm_account'] = array(
        '#title' => t('Bankszámlaszám'),
        '#description' => t('A cég bankszámlaszáma.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_firm_account'),
        '#required' => TRUE,
    );

    $form['invoice'] = array(
        '#type' => 'fieldset',
        '#title' => t('Számlázási adatok'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );

    $form['invoice']['membership_firm_invoice_prefix'] = array(
        '#title' => t('Számla előtag'),
        '#description' => t('A számlaszám előtagja.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_firm_invoice_prefix'),
        '#required' => TRUE,
    );

    $form['invoice']['membership_firm_invoice_next_number'] = array(
        '#title' => t('A számla következő sorszáma'),
        '#description' => t('A következő számlaszám. FIGYELEM! A mező csak az első beállításra szolgál!'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_firm_invoice_next_number'),
        '#required' => TRUE,
    );

    $form['invoice']['membership_firm_invoice_payment_deadline'] = array(
        '#title' => t('A fizetési határidő'),
        '#description' => t('A megadott fizetési határidő napokban!'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_firm_invoice_payment_deadline'),
        '#required' => TRUE,
    );

    $form['invoice']['membership_firm_invoice_vat'] = array(
        '#title' => t('ÁFA'),
        '#description' => t('Az általános forgalmi adó százalékban.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_firm_invoice_vat'),
        '#required' => TRUE,
    );

    $form['invoice']['membership_promotion_period_price'] = array(
        '#title' => t('Bankkártya validációs összeg (Ft)'),
        '#description' => t('A megrendeléskor ezzel az összeggel ellenőrizzük a bankkártyát, amit a promóciós időszak végén megterhelünk a megrendelés összegével.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_promotion_period_price', 200),
        '#element_validate' => array('membership_element_validate_positive_number'),
        '#required' => TRUE,
    );

//  $form['email'] = array(
//    '#type' => 'fieldset',
//    '#title' => t('Az Intelligent Mailer beállításai'),
//    '#collapsible' => TRUE,
//    '#collapsed' => TRUE,
//  );
//
//  $form['email']['membership_im_username'] = array(
//    '#title' => t('Az Intelligent Mailer felhasználó azonosítója'),
//    '#description' => t('A saját profilban található.'),
//    '#type' => 'textfield',
//    '#default_value' => variable_get('membership_im_username'),
//    '#required' => TRUE,
//  );
//
//
//  $form['email']['membership_im_secret'] = array(
//    '#title' => t('Az Intelligent Mailer titkos kódja'),
//    '#description' => t('A beállítások alatt található meg.'),
//    '#type' => 'textfield',
//    '#default_value' => variable_get('membership_im_secret'),
//    '#required' => TRUE,
//  );

    $form['display'] = array(
        '#type' => 'fieldset',
        '#title' => t('A megjelenítések beállításai'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );

    $form['display']['membership_list_limit_product_group'] = array(
        '#title' => t('A listázandó elemek száma a termékcsoportoknál'),
        '#description' => t('Ennyi elem jelenik meg egyszerre a termékcsoportok oldalon listázáskor.'),
        '#type' => 'select',
        '#options' => array(5 => '5', 10 => '10', 25 => '25', 50 => '50', 100 => '100'),
        '#default_value' => variable_get('membership_list_limit_product_group'),
        '#required' => TRUE,
    );

    $form['display']['membership_list_limit_product'] = array(
        '#title' => t('A listázandó elemek száma a terméknél'),
        '#description' => t('Ennyi elem jelenik meg egyszerre a termékek oldalon listázáskor.'),
        '#type' => 'select',
        '#options' => array(5 => '5', 10 => '10', 25 => '25', 50 => '50', 100 => '100'),
        '#default_value' => variable_get('membership_list_limit_product'),
        '#required' => TRUE,
    );

    $form['display']['membership_list_limit_sales'] = array(
        '#title' => t('A listázandó elemek száma a sales-eknél'),
        '#description' => t('Ennyi elem jelenik meg egyszerre a sales-ek oldalon listázáskor.'),
        '#type' => 'select',
        '#options' => array(5 => '5', 10 => '10', 25 => '25', 50 => '50', 100 => '100'),
        '#default_value' => variable_get('membership_list_limit_sales'),
        '#required' => TRUE,
    );

    $form['display']['membership_list_limit_users'] = array(
        '#title' => t('A listázandó elemek száma a felhasználóknál.'),
        '#description' => t('Ennyi elem jelenik meg egyszerre listázás oldalon listázáskor.'),
        '#type' => 'select',
        '#options' => array(5 => '5', 10 => '10', 25 => '25', 50 => '50', 100 => '100'),
        '#default_value' => variable_get('membership_list_limit_sales'),
        '#required' => TRUE,
    );

    $form['other'] = array(
        '#type' => 'fieldset',
        '#title' => t('Egyéb beállítások'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );

    $form['other']['membership_site_name'] = array(
        '#title' => t('A weboldal neve'),
        '#description' => t('Ez fog megjelenni a Google Analytics e-kereskedelmi követő kódjában, mint <em>store name</em>'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_site_name'),
        '#required' => TRUE,
    );

    $form['other']['membership_thankyou_link'] = array(
        '#title' => t('A megrendelés utáni köszönöm oldal linkje'),
        '#description' => t('A linknek a domainen belülre kell mutatnia, és nem kell megadni a domain nevet. Pl.: <em>node/64</em>.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_thankyou_link'),
        '#required' => TRUE,
    );

    $form['other']['membership_mail_from_name'] = array(
        '#title' => t('Erről a névről küldünk e-mailt a felhasználónak'),
        '#description' => t('Az email küldő neve.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_mail_from_name'),
        '#required' => TRUE,
    );

    $form['other']['membership_mail_from_email'] = array(
        '#title' => t('Erről az e-mail címről küldünk üzenetet a felhasználónak.'),
        '#description' => t('E-mail cím.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_mail_from_email'),
        '#required' => TRUE,
    );

    $form['other']['membership_terms_conditions'] = array(
        '#title' => t('ÁSZF'),
        '#description' => t('Ez a szöveg jelenik meg a megrendelés gomb alatt.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_terms_conditions', 'A Megrendelés gombra kattintással elfogadod az <a href="#" target="_blank" >Általános szerződési feltételeineket</a>.'),
        '#required' => TRUE,
        '#size' => 150
    );

    $form['css'] = array(
        '#type' => 'fieldset',
        '#title' => t('CSS osztályok'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );

    $form['css']['membership_class_order_yes_button'] = array(
        '#title' => t('A rendelési űrlap „Igen” gombja'),
        '#description' => t('Azoknak a felhasználóknak, akik már rendeltek az oldalon, nem kell megadniuka újra az adataikat. Amikor helyesnek találják a megadottakat, erre a gombra kattintva léphetnek tovább.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_class_order_yes_button'),
    );

    $form['css']['membership_class_order_no_button'] = array(
        '#title' => t('A rendelési űrlap „Nem” gombja'),
        '#description' => t('Azoknak a felhasználóknak, akik már rendeltek az oldalon, nem kell megadniuka újra az adataikat. Amikor helytelennek találják a megadottakat, erre a gombra kattintva szerkeszthetik az adataikat.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_class_order_no_button'),
    );

    $form['css']['membership_class_order_order_button'] = array(
        '#title' => t('A „Megrendelés” gomb'),
        '#description' => t('A megrendelés gomb'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_class_order_order_button'),
    );

    $form['css']['membership_class_own_data_edit_button'] = array(
        '#title' => t('A saját adatok oldalon a „Szerkesztés” gomb.'),
        '#description' => t('A saját adatokat áttekintve a felhasználó szerksztheti azokat erre a gombra kattintva.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_class_own_data_edit_button'),
    );

    $form['css']['membership_class_own_data_save_button'] = array(
        '#title' => t('A saját adatok szerkesztése oldalon az „Adatok mentése” gomb.'),
        '#description' => t('A saját adatok szerkesztésekor a felhasználó ezzel a gombbal menti el az új adatit.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_class_own_data_save_button'),
    );

    $form['css']['membership_class_own_data_invoiced_status_text'] = array(
        '#title' => t('A kiszámlázott rendelések formátuma'),
        '#description' => t('A saját adatok oldalon lévő táblázatban a kiszámlázott tételeknél megjelenő szöveg formátuma.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_class_own_data_invoiced_status_text'),
    );

    $form['css']['membership_class_own_data_waiting_for_invoice_status_text'] = array(
        '#title' => t('Az aktivált, de még számlázásra váró rendelések formátuma'),
        '#description' => t('A saját adatok oldalon lévő táblázatban az akitivált, de még számlázásra váró tételeknél megjelenő szöveg formátuma.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_class_own_data_waiting_for_invoice_status_text'),
    );

    $form['css']['membership_class_own_data_waiting_for_payment_status_text'] = array(
        '#title' => t('A befizetésre váró megrendelt tételek formátuma'),
        '#description' => t('A saját adatok oldalon lévő táblázatban befieztésre váró tételeknél megjelenő szöveg formátuma.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_class_own_data_waiting_for_payment_status_text'),
    );

    $form['css']['membership_class_own_data_sent_status_text'] = array(
        '#title' => t('A kiküldött befizetési csekkek (vagy futár) formátuma'),
        '#description' => t('A saját adatok oldalon lévő táblázatban a csekkes vagy futárszolgálatos tételeknél megjelenő szöveg formátuma, ha az már úton van.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_class_own_data_sent_status_text'),
    );

    $form['css']['membership_class_own_data_waiting_for_send_status_text'] = array(
        '#title' => t('A kiküldésre váró csekkek (vagy futár) formátuma'),
        '#description' => t('A saját adatok oldalon lévő táblázatban a csekkes vagy futárszolgálatos tételeknél megjelenő szöveg formátuma, ha az kiküldésre vár.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_class_own_data_waiting_for_send_status_text'),
    );


    $form['ac'] = array(
        '#type' => 'fieldset',
        '#title' => t('Active Campaign'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );

    $form['ac']['membership_ac_api_url'] = array(
        '#title' => t('Active Campaigan API URL'),
        '#description' => t('Active Campaigan API URL'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_ac_api_url'),
        '#required' => TRUE,
    );

    $form['ac']['membership_ac_api_key'] = array(
        '#title' => t('Active Campaigan API Key'),
        '#description' => t('Active Campaigan API kulcs.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('membership_ac_api_key'),
        '#required' => TRUE,
    );
    return system_settings_form($form);
}

/**
 * Email create.
 * @param type array $fields email fields.
 * @param type number $eid email id.
 * @return mixed Order object.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_email_merge($fields, $eid = null, $assoc = false) {
    // Base fields
    $email = membership_get_email_object($eid);
    if (empty($email)) {
        $base = array(
//            'eid' => isset($fields['eid']) ? $fields['eid'] : $eid,
            'slug' => $fields['slug'],
            'subject' => $fields['subject'],
            'content' => $fields['content'],
            'is_active' => 1,
            'php' => $fields['php'],
            'created_at' => date('Y-m-d H:i:s'),
            'updated_at' => date('Y-m-d H:i:s'),
        );
        $eid = db_insert('membership_emails')->fields($base)->execute();
    } else {
        db_merge('membership_emails')->key(['eid' => $eid])->fields($fields)->execute();
    }
    if ($assoc) {
        return membership_get_email_assoc($eid);
    } else {
        return membership_get_email_object($eid);
    }
}

/**
 * Add new or edit membership emails.
 * @param type $form
 * @param type $form_state
 * @return type
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_email_form($form, &$form_state) {

    //  Show tokens for emails
    $email_token_help = t('Elérhető változók: [site:name], [site:url], [site:login-url], [site:url-brief], [membership:product_name], [membership:proforma_link], [membership:user_password], [membership:user_name], [membership:invoice_link].');
    $email_token_help_user = t('Elérhető változók: [site:name], [site:url], [site:login-url], [site:url-brief], [membership:user_password], [membership:user_name].');
    $email_token_help_invoice = t('Elérhető változók: [site:name], [site:url], [site:login-url], [site:url-brief], [membership:invoice_link].');
    $email_token_help_activate = t('Elérhető változók: [site:name], [site:url], [site:login-url], [site:url-brief], [membership:product_name].');
    $email_token_help_renew = t('Elérhető változók: [site:name], [site:url], [site:login-url], [site:url-brief], [membership:product_name].');
    $email_token_help_order = t('Elérhető változók: [site:name], [site:url], [site:login-url], [site:url-brief], [membership:product_name], [membership:proforma_link].');

    $emails = membership_get_email_list();

    $form = array();

    // Email settings
//    $form['email'] = array(
//        '#type' => 'fieldset',
//        '#title' => t('Emails'),
//        '#collapsible' => TRUE,
//        '#collapsed' => TRUE
//    );

    $form['email']['email_title'] = array(
        '#type' => 'item',
        '#title' => t('Default e-mails'),
    );

    $form['email']['emails'] = array(
        '#type' => 'vertical_tabs',
        '#group' => 'email'
    );

    foreach ($emails as $key => $value) {
        // Email forms
        $form['email']['emails'][$key] = array(
            '#type' => 'fieldset',
            '#title' => $value->slug,
            '#collapsible' => TRUE,
            '#collapsed' => TRUE,
            '#description' => '<small>' . $email_token_help . '</small>'
        );
        if ($value->slug == 'new-user') {
            $form['email']['emails'][$key]['#description'] = '<small>' . $email_token_help_user . '</small>';
        } else if ($value->slug == 'invoice') {
            $form['email']['emails'][$key]['#description'] = '<small>' . $email_token_help_invoice . '</small>';
        } else if ($value->slug == 'activate-email') {
            $form['email']['emails'][$key]['#description'] = '<small>' . $email_token_help_activate . '</small>';
        } else if ($value->slug == 'period-order-renew') {
            $form['email']['emails'][$key]['#description'] = '<small>' . $email_token_help_renew . '</small>';
        } else if (
                $value->slug == 'order-email-bank-transfer' ||
                $value->slug == 'order-email-yellow-check' ||
                $value->slug == 'order-email-pink-check' ||
                $value->slug == 'order-email-messenger'
        ) {
            $form['email']['emails'][$key]['#description'] = '<small>' . $email_token_help_renew . '</small>';
        }
        $form['email']['emails'][$key]['email_slug_' . $key] = array(
            '#type' => 'textfield',
            '#title' => t('Logikai név'),
            '#default_value' => $value->slug,
            '#maxlength' => 128,
            '#required' => TRUE,
            '#attributes' => array('readonly' => true),
        );
        $form['email']['emails'][$key]['email_subject_' . $key] = array(
            '#type' => 'textfield',
            '#title' => t('Tárgy'),
            '#default_value' => $value->subject,
            '#maxlength' => 180,
            '#required' => TRUE
        );
        $form['email']['emails'][$key]['email_content_' . $key] = array(
            '#type' => 'textarea',
            '#title' => t('Tartalom'),
            '#default_value' => $value->content,
            '#rows' => 15
        );
        $form['email']['emails'][$key]['email_active_' . $key] = array(
            '#type' => 'checkbox',
            '#title' => t('Aktív'),
            '#default_value' => $value->is_active,
        );
        $form['email']['emails'][$key]['email_php_' . $key] = array(
            '#type' => 'checkbox',
            '#title' => t('PHP tartalom'),
            '#default_value' => $value->php,
        );
        $form['email']['emails'][$key]['email_eid_' . $key] = array(
            '#type' => 'hidden',
            '#value' => $value->eid,
        );
        $form['email']['emails'][$key]['example'] = array(
            '#markup' => '<a href="/admin/config/membership/settings/send/' . $value->slug . '">Minta email küldése</a>',
        );
    }

    // New email form
    if (isset($_GET['titkos-kod']) && $_GET['titkos-kod'] == 'kbalazs') {
        $form['email']['emails']['new'] = array(
            '#type' => 'fieldset',
            '#title' => t('Email hozzádaása'),
            '#collapsible' => TRUE,
            '#collapsed' => TRUE,
            '#description' => t('<small>Edit the credit card order e-mail message sent to user.') . '<br>' . $email_token_help . '</small>'
        );
        $form['email']['emails']['new']['email_slug_new'] = array(
            '#type' => 'textfield',
            '#title' => t('Logikai név'),
            '#maxlength' => 128
        );
        $form['email']['emails']['new']['email_subject_new'] = array(
            '#type' => 'textfield',
            '#title' => t('Tárgy'),
            '#maxlength' => 180
        );
        $form['email']['emails']['new']['email_content_new'] = array(
            '#type' => 'textarea',
            '#title' => t('Tartalom'),
            '#rows' => 15
        );
        $form['email']['emails']['new']['email_active_new'] = array(
            '#type' => 'checkbox',
            '#title' => t('Aktív'),
        );
        $form['email']['emails']['new']['email_php_new'] = array(
            '#type' => 'checkbox',
            '#title' => t('PHP tartalom'),
        );
    }

    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => t('Emailek mentése'),
    );

    return $form;
}

/**
 * Add order form submit.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_email_form_submit(&$form, &$form_state) {
    global $user;

    $records = [
        'new' => []
    ];
    foreach ($form_state['values'] as $key => $value) {
        $keys = explode('_', $key);
        if (count($keys) == 3 && $keys[0] == 'email') {
            if ($key[2] == 'new') {
                if ($keys[1] == 'active') {
                    $records['new']['is_active'] = $value;
                } else {
                    $records['new'][$keys[1]] = $value;
                }
            } else {
                if (!isset($records[$keys[2]])) {
                    $records[$keys[2]] = [
                        'eid' => '',
                        'slug' => '',
                        'subject' => '',
                        'content' => '',
                        'is_active' => 1,
                        'php' => 1,
                    ];
                }
                if ($keys[1] == 'active') {
                    $records[$keys[2]]['is_active'] = $value;
                } else {
                    $records[$keys[2]][$keys[1]] = $value;
                }
            }
        }
    }

//    mdd($records, true);

    foreach ($records as $key => $value) {
        $fields = array();
        if ($key !== 'new') {
            // Merge email
            $fields = array(
                'eid' => $value['eid'],
                'slug' => _slugify($value['slug']),
                'subject' => $value['subject'],
                'content' => $value['content'],
                'is_active' => $value['is_active'],
                'php' => $value['php'],
            );
            $email = membership_email_merge($fields, $fields['eid']);
        } else if (!empty($value['slug']) && !empty($value['subject']) && !empty($value['content'])) {
            $fields = array(
                'slug' => _slugify($value['slug']),
                'subject' => $value['subject'],
                'content' => $value['content'],
                'is_active' => $value['is_active'],
                'php' => $value['php'],
            );
            $email = membership_email_merge($fields);
        }
    }

    drupal_set_message('Emailek beküldve.');

    // Redirect.
    // $form_state['redirect'] = array('certify/companies', array('query' => array(),'fragment' => '',),);
    // Print a message.
    // drupal_set_message(t('<em>Megrendelés</em> létrehozása sikeres.'));
    // Save to watchdog.
    watchdog('membership', 'Emailek frissítve %user által.', array('%user' => $user->name, WATCHDOG_INFO));
}

/**
 * Add new or edit membership emails.
 * @param type $form
 * @param type $form_state
 * @return type
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_email_send_example_form($form, &$form_state, $slug) {

    $emails = membership_get_email_list();

    $form = array();

    // Email settings

    $form['to_name'] = array(
        '#type' => 'textfield',
        '#title' => t('Címzett neve'),
        '#default_value' => variable_get('membership_mail_from_name'),
        '#required' => TRUE,
    );

    $form['to_mail'] = array(
        '#type' => 'textfield',
        '#title' => t('Címzett email címe'),
        '#default_value' => variable_get('membership_mail_from_email'),
        '#element_validate' => array('membership_element_validate_email'),
        '#required' => TRUE,
    );

    $form['slug'] = array(
        '#type' => 'hidden',
        '#value' => $slug,
    );

    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => t('Küldés'),
    );

    return $form;
}

/**
 * Add order form submit.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_email_send_example_form_submit(&$form, &$form_state) {
    global $user;
    global $base_url;

    $email = membership_get_email_object($form_state['values']['slug'], 'slug');

    switch ($email->slug):
        case 'activate-email':
            _activate_email_send($form_state['values']['to_name'], $form_state['values']['to_mail'], 'TERMÉKNÉV');
            break;
        case 'period-order-renew':
            _period_order_renew_email_send($form_state['values']['to_name'], $form_state['values']['to_mail'], 'TERMÉKNÉV');
            break;
        case 'new-user':
            _new_user_email_send($form_state['values']['to_name'], $form_state['values']['to_mail'], 'FELHASZNÁLÓNÉV', 'JELSZÓ123');
            break;
        case 'invoice':
            $invoice = membership_invoice_get(1);
            _invoice_send(1, $invoice->hash, $form_state['values']['to_mail'], $form_state['values']['to_name']);
            break;
        case 'order-email-bank-transfer':
            $payment = 2;
            $user_data = db_query_range('SELECT hash FROM {membership_users} WHERE id = :id', 0, 1, array(':id' => 1))->fetchObject();
            $proforma_link = "$base_url/dijbekero-level/?oid=1&hash=$user_data->hash";
            _order_email_send($form_state['values']['to_name'], $form_state['values']['to_mail'], 'TERMÉKNÉV', $payment, $proforma_link);
            break;
        case 'order-email-yellow-check':
            $payment = 3;
            $user_data = db_query_range('SELECT hash FROM {membership_users} WHERE id = :id', 0, 1, array(':id' => 1))->fetchObject();
            $proforma_link = "$base_url/dijbekero-level/?oid=1&hash=$user_data->hash";
            _order_email_send($form_state['values']['to_name'], $form_state['values']['to_mail'], 'TERMÉKNÉV', $payment, $proforma_link);
            break;
        case 'order-email-pink-check':
            $payment = 4;
            $user_data = db_query_range('SELECT hash FROM {membership_users} WHERE id = :id', 0, 1, array(':id' => 1))->fetchObject();
            $proforma_link = "$base_url/dijbekero-level/?oid=1&hash=$user_data->hash";
            _order_email_send($form_state['values']['to_name'], $form_state['values']['to_mail'], 'TERMÉKNÉV', $payment, $proforma_link);
            break;
        case 'order-email-messenger':
            $payment = 6;
            $user_data = db_query_range('SELECT hash FROM {membership_users} WHERE id = :id', 0, 1, array(':id' => 1))->fetchObject();
            $proforma_link = "$base_url/dijbekero-level/?oid=1&hash=$user_data->hash";
            _order_email_send($form_state['values']['to_name'], $form_state['values']['to_mail'], 'TERMÉKNÉV', $payment, $proforma_link);
            break;

    endswitch;

    drupal_set_message(t('%subject(%slug) email minta küldése sikeres.', array('%subject' => $email->subject, '%slug' => $email->slug)));

    $form_state['redirect'] = array('/admin/config/membership/settings/emails',
        array(
            'query' => array(),
            'fragment' => '',
        ),
    );

    // Save to watchdog.
    watchdog('membership', '%subject(%slug) mint email kiküldve %user által erre a címre: %name <%mail>', array(
        '%user' => $user->name,
        '%subject' => $email->subject,
        '%slug' => $email->slug,
        '%name' => $form_state['values']['to_name'],
        '%mail' => $form_state['values']['to_mail'],
        WATCHDOG_INFO));
}
