<?php
/**
 * @file
 * A termékcsoportok adminisztrálása
 */

/**
 * Termékcsoportok adminisztrálása - Listázás
 */
function membership_product_group_list() {
  $html = '';
    
  $header = array(
    array('data' => 'pgid', 'field' => 'pgid', 'sort' => 'asc'),
    array('data' => t('Termékcsoport neve'), 'field' => 'name'),
    array('data' => t('Műveletek')),
  );
  
  $result = db_select('membership_product_groups', 'pg')
    ->extend('PagerDefault')
    ->limit(variable_get('membership_list_limit_product_group'))
    ->extend('TableSort')
    ->orderByHeader($header)
    ->fields('pg', array('pgid','name'))
    ->execute();
           
  $rows = array();
  
  foreach ($result as $value) {
    $links = l(t('Edit'), "admin/config/membership/product_groups/edit/$value->pgid").
      '&nbsp;&nbsp;'.
      l(t('Delete'), "admin/config/membership/product_groups/delete/$value->pgid"
    );
    
    $rows[]= array(
      'data' => array(
        $value->pgid,
        $value->name,
        $links,
      )
    );
  }  

  $html .= theme('table', array(
    'header' => $header,
    'rows'=>$rows,
    'caption' => t('Termékcsoportok tábalája'),
    'sticky' => TRUE,                        
    'empty' => t('Nincsenek még termékcsoportok.'),
  ));
     
  $html .= theme('pager',array('tags' => array()));

  return $html;
} 


/**
 * Az űrlap alapvelő mezőit határozza meg.
 *
 * @return array
 * Az összeállított űrlap.
 */
 
function membership_product_group_create_form() {
  $form['overview'] = array(
    '#prefix' => '<p>',
    '#suffix' => '</p>',
  );
  
  $form['name'] = array(
    '#title' => t('Termék csoport neve'),
    '#description' => t('A termékcsoport neve.'),
    '#type' => 'textfield',
    '#required' => TRUE,
  );
  
  $form['submit'] = array(
    '#type' => 'submit',
    '#value' => 'Termékcsoport mentése',
  );
  
  return $form;
}

/**
 * Implements hook_form().
 * Termékcsoportok adminisztrálása - Hozzáadás.
 */
function membership_product_group_add_form($form, &$form_state) {
  $form = membership_product_group_create_form();
  $form['overview']['#markup'] = t('Ezen a felületen lehet hozzáadni új termékcsoportot.');
  return $form;
}

function membership_product_group_add_form_validate($form, &$form_state) {
  $name = $form_state['values']['name'];
  $row = db_query('SELECT pgid FROM {membership_product_groups} WHERE name = :name', array(':name' => $name))->fetchObject();
  if(isset($row->pgid)) {
    form_set_error('name', t('Ezen a néven már létezik termékcsoport a rendszerben.'));
  } 
}

function membership_product_group_add_form_submit($form, &$form_state) {
  $pg_fields = array('name' => trim($form_state['values']['name']),);
  $pgid = db_insert('membership_product_groups')->fields($pg_fields)->execute();
  
  // Átirányítás a listázás oldalra.
  $form_state['redirect'] = array('admin/config/membership/product_groups',
    array(
      'query' => array(),
      'fragment' => '',
    ),
  );
  
  // Üzenet kiírása az oldalon és az esemény rögzítése a watchdog-ba.
  drupal_set_message(t('<em>@name</em> nevű termékcsoport belüldve.', array('@name' => $pg_fields['name'])));
  watchdog('membership', t('<em>@name</em> nevű termékcsoport beküldve.', array('@name' => $pg_fields['name'])), WATCHDOG_NOTICE);
}
 
/**
 * Implements hook_form().
 * Termékcsoportok adminisztrálása - Szerkesztés.
 */
function membership_product_group_edit_form($form, &$form_state, $pgid) {
  $result = db_query_range("SELECT name FROM {membership_product_groups} WHERE pgid = :pgid", 0, 1, array(':pgid' => $pgid))->fetchField();
    drupal_set_message(t('PgID: <em>@name</em> - @result', array('@name' => $pgid, '@result' => $result)));  
  
  $form = membership_product_group_create_form();
  
  $form['overview']['#markup'] = t('Ezen a felületen lehet szerkeszteni a termékcsoportot.');
  $form['name']['#default_value'] = $result;
    
  // A termékcsoport régi nevét megtartjuk, hogy a watchdog-ba rögzíteni lehessen.
  $form['old_name'] = array(
    '#type' => 'hidden',
    '#default_value' => $result,
  );
  return $form;
}

function membership_product_group_edit_form_validate($form, &$form_state) {
  $name = $form_state['values']['name'];
  $pgid = $form_state['build_info']['args'][0];  
  $row = db_query('SELECT pgid FROM {membership_product_groups} WHERE name = :name AND pgid != :pgid', array(':name' => $name, ':pgid' => $pgid,))->fetchObject();
  if(isset($row->pgid)) {
    form_set_error('name', t('Ezen a néven már létezik termékcsoport a rendszerben.'));
  } 
}

function membership_product_group_edit_form_submit($form, &$form_state) {
  $pg_fields = array('name' => trim($form_state['values']['name']),);
  $pgid = $form_state['build_info']['args'][0];
  
  $num_updated = db_update('membership_product_groups')->fields($pg_fields)->condition('pgid', $pgid, '=')->execute();
  
  // Átirányítás a listázás oldalra.
  $form_state['redirect'] = array('admin/config/membership/product_groups',
    array(
      'query' => array(),
      'fragment' => '',
    ),
  );
  
  // Üzenet kiírása az oldalon és az esemény rögzítése a watchdog-ba.
  drupal_set_message(t('A termékcsoport neve sikeresen megváltozott. Az új név: <em>@name</em>', array('@name' => $pg_fields['name'])));
  watchdog('membership', 'A termékcsoport neve megváltozott. Régi név: <em>@old_name</em> Az új név: <em>@name</em>', 
    array('@old_name' => $form_state['values']['old_name'], '@name' => $pg_fields['name']), WATCHDOG_NOTICE);
}
 
/**
 * Implements hook_form()
 * Termékcsoportok adminisztrálása - Törlés.
 */
function membership_product_group_delete_form($form, &$form_state, $pgid) {
  $result = db_query_range("SELECT name FROM {membership_product_groups} WHERE pgid = :pgid", 0, 1, array(':pgid' => $pgid))->fetchField();  
    
  $form = array();  
  $form['pgid'] = array(
    '#type' => 'value',
    '#value' => $pgid,
  );
  
  // A termékcsoport régi nevét megtartjuk, hogy a watchdog-ba rögzíteni lehessen.
  $form['name'] = array(
    '#type' => 'hidden',
    '#default_value' => $result,
  );
  return confirm_form(
    $form,
    t('<em>"'.$result.'"</em> biztosan törölhető?'),
    'admin/config/membership/product_groups',
    t('Ez a művelet nem vonható vissza.'),
    t('Delete'),
    t('Cancel')
  );
}

function membership_product_group_delete_form_submit($form, &$form_state) {
  $pgid= array('name' => $form_state['values']['pgid']);
    
  $num_deleted = db_delete('membership_product_groups')->condition('pgid', $pgid, '=')->execute();
     
  // Átirányítás a listázás oldalra.
  $form_state['redirect'] = array('admin/config/membership/product_groups',
    array(
      'query' => array(),
      'fragment' => '',
    ),
  );
  
  // Üzenet kiírása az oldalon és az esemény rögzítése a watchdog-ba.
  drupal_set_message(t('A termékcsoport sikeresen törölve.'));
  watchdog('membership', '<em>@name</em> nevű termékcsoport törölve lett.', array('@name' => $form_state['values']['name']), WATCHDOG_NOTICE);
}
