<?php

/**
 * @file
 * A megrendelési űrlap és a megrendelések fogadása.
 *
 * @TODO Ha kiválasztotta a céges adatokat, jelenjen meg a piros csillag, mint kötelező mező.
 *
 */
// Az általános ellenőrző és átalakító függvények betöltése.
require_once 'lib.php';
require_once('ac_api/includes/ActiveCampaign.class.php');

/**
 * After payment callback page.
 * @param type integer $oid Order id.
 * @param type integer $payment_id Payment id.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_period_promo_payment_in($promo_id = '', $payment_id = '') {

    global $user;

    // Get arguments
    $oid = check_plain(trim($promo_id));

    if ($payment_id == '' && isset($_GET['paymentId'])) {
        $payment_id = check_plain($_GET['paymentId']);
    }

    // Get order details
    if ($oid == '' && $payment_id != '') {
        $payment = barion_api_get_payment($payment_id);
        $oid = $payment['oid'];

        // Print a message.
//        drupal_set_message(t('Missing values.'));
    }

    // Build payment details
    $order = membership_period_promo_get_details_assoc($oid);

    // Thank you link
    $thank_you_link = !empty($order['thank_you']) ? $order['thank_you'] : variable_get('membership_thankyou_link');

    if ($payment_id != '') { // Bankkártya esetén
        // Get payment details
        $payment = barion_api_get_payment($payment_id);

        // Generate invoice
        if ($payment['status'] == 1) {

            // Get token id
            $token = db_select('barion_api_tokens', 't')
                    ->fields('t', array('id'))
                    ->condition('t.token', $payment['token'])
                    ->execute()
                    ->fetchField();

            // Update order
            db_update('membership_orders')->fields(array('payment_id' => $payment_id, 'token' => $token))->condition('oid', $oid)->execute();

            // Activate order
            $activate = membership_period_promo_activate($oid);
            if (!$activate) {
                // Save to watchdog.
                watchdog('membership', '"%oid" order promo activation failed.', array('%oid' => $oid, WATCHDOG_NOTICE));

                // Print a message.
                drupal_set_message(t('Order promo activation <em>failed</em>.'), 'error');
            }

            // Print a message.
            drupal_set_message(t('Checkout finished <em>success</em>.'));

            // Save to watchdog.
            watchdog('membership', '"%oid" checkout finished with Barion payment.', array('%oid' => $oid, WATCHDOG_NOTICE));

            // Redirect to thank you page
            membership_redirect_to_thank_you($oid, $thank_you_link);
        } else {

            // Save to watchdog.
            watchdog('barion_api', '"%oid" order is failed. Payment id: %pid', array('%oid' => $oid, '%pid' => $payment_id, WATCHDOG_NOTICE));

            // Print a message.
            drupal_set_message(t('A fizetés sajnos <em>nem sikerült.</em> Kérlek próbáld meg újra.'), 'warning');

            // Delete membership user and order.
            db_delete('membership_period_orders')
                    ->condition('poid', $order['poid'])
                    ->execute();

            db_delete('membership_period_promotions')
                    ->condition('promo_id', $order['promo_id'])
                    ->execute();

            db_delete('membership_users')
                    ->condition('id', $order['id'])
                    ->condition('uid', '0')
                    ->execute();

            // Redirect to thank you page
            $pid = $order['pid'];
            membership_redirect_to_period_order_form($pid);
        }
    } else {

        // Drupal set message
        drupal_set_message(t('Error! Something went wrong with pay "%oid" order. Please try again.', array('@oid' => $order['oid'])));

        // Save to watchdog.
        watchdog('membership', 'Error! Something went wrong with pay "%oid" order.<br>Token id: %token', array('%oid' => $order['oid'], '%token' => $token, WATCHDOG_NOTICE));

        // Redirect to order start
        drupal_goto('/payment/out/' . $oid);
    }
}

/**
 * Prepare Barion payment.
 * @param type integer $oid Order id
 * @param type integer $token Used card token id
 * @return integer or array Percentage level.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_period_promo_payment_out($promo_id, $token = '') {

    global $user;

    // Get arguments
    $oid = check_plain(trim($promo_id));
    $token = check_plain(trim($token));

    // Get order details
    if ($oid == '') {

        // Print a message.
        drupal_set_message(t('Missing order id.'));

        // Redirect to order start
        // drupal_goto('certify/order/1');
        echo '<script>history.back()</script>';
    }

    // Build payment details
    $order = membership_period_promo_get_details_assoc($oid);

    if ($token == '') {
        $token = $order['token'];
    }

    if ($order['is_firm_invoice'] === 1) {
//        $address = $order['firm_city'] . ', ' . $order['firm_address'];
        $address = [
            'country' => $order['country'],
            'city' => $order['firm_city'],
            'zip' => $order['firm_zip'],
            'street' => substr($order['firm_address'], 0, 49)
        ];
    } else {
        $address = [
            'country' => $order['country'],
            'city' => $order['city'],
            'zip' => $order['zip'],
            'street' => substr($order['address'], 0, 49)
        ];
    }

    $payment['oid'] = $order['promo_id'];
    $payment['order_table'] = 'membership_period_promotions';
    $payment['uid'] = $order['id'];
    $payment['item'] = array(
        'name' => $order['name'],
        'description' => $order['proforma_name'],
        'quantity' => 1,
        'unit' => t('db'),
        'unitprice' => intval($order['price']),
        'itemtotal' => intval($order['price']),
        'sku' => 'ITEM-' . $order['pid'] . '-' . $order['hash']
    );
    $payment['transaction'] = array(
        'title' => $order['name'],
        'total' => intval($order['price']),
        'hash' => 'TR-' . barion_api_get_transaction_unique_hash()
    );
    $payment['payment'] = array(
        'oid' => $order['promo_id'],
        'hash' => 'PR-' . barion_api_get_payment_unique_hash(),
        'usermail' => $order['email'],
        'shipping' => $address,
    );

    if ($token == '' || $token == null) { // Bankkártya esetén
        barion_api_payment_request($payment, false, function($myPayment) use ($order) {
            db_update('membership_period_promotions')
                    ->condition('promo_id', $order['promo_id'])
                    ->fields(['payment_id' => $myPayment->PaymentId])
                    ->execute();
        });
    } else { // One click esetén
        // Get token string
        $token = barion_api_get_token($token);

        barion_api_payment_request($payment, $token, function($myPayment) use ($order) {
            db_update('membership_period_promotions')
                    ->condition('promo_id', $order['promo_id'])
                    ->fields(['payment_id' => $myPayment->PaymentId])
                    ->execute();
        });
    }
}

/**
 * Period promotion create.
 * @param type array $fields order fields.
 * @param type number $poid order id.
 * @return mixed Order object.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_period_promo_merge($fields, $promo_id = null) {
    // Base fields
    $promo = membership_period_promo_get_details_object($promo_id);
    if (empty($promo)) {
        $product = membership_period_product_get_details_object($fields['pid']);
        $start = date('Y-m-d H:i:s');
        $end = date('Y-m-d H:i:s', _membership_add_time($start, 'days', (int) $product->promotime));
        $base = array(
            'id' => $fields['id'],
            'pid' => $fields['pid'],
            'poid' => $fields['poid'],
            'created' => REQUEST_TIME,
            'start_at' => isset($fields['start_at']) ? $fields['start_at'] : $start,
            'end_at' => isset($fields['end_at']) ? $fields['end_at'] : $end,
            'price' => variable_get('membership_element_validate_positive_number', 200),
            'payment_id' => isset($fields['payment_id']) ? $fields['payment_id'] : null,
            'token' => isset($fields['token']) ? $fields['token'] : null,
            'thank_you' => isset($fields['thank_you']) ? $fields['thank_you'] : $product->thank_you,
        );
        $promo_id = db_insert('membership_period_promotions')->fields($base)->execute();
    } else {
        db_merge('membership_period_promotions')->key('promo_id', $promo_id)->fields($fields)->execute();
    }
    return membership_period_promo_get_details_object($promo_id);
}

/**
 * Activate promo after success payment.
 * @param type integer $oid Promo id
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_period_promo_activate($oid) {

    // Megvizsgáljuk a megadott érték pozitív egész-e.
    if (!is_numeric($oid) || $oid < 1 || $oid != round($oid)) {
        // Save to watchdog.
        watchdog('membership', t('A rendelés azonosítónak pozitív egész számnak kell lennie. Oid: %oid'), array('%oid' => $oid, WATCHDOG_NOTICE));

        return FALSE;
    } else {
        // Ha pozitív egész, akkor megnézzük, hogy létezik-e a rendelés azonosító.
        $promo = membership_period_promo_get_details_object($oid);
        if (empty($promo)) {
            // Save to watchdog.
            watchdog('membership', t('Ilyen sorszámmal nem létezik rendelés a rendszerben. Promo id: %oid'), array('%oid' => $oid, WATCHDOG_NOTICE));

            return FALSE;
        } else {
            if ($promo->is_activated) {
                // Save to watchdog.
                watchdog('membership', t('Ez a megrendelés már aktiválva van. Promo id: %oid'), array('%oid' => $oid, WATCHDOG_NOTICE));

                return FALSE;
            }
        }
    }

    // Aktiváljuk a promot
    db_update('membership_period_promotions')
            ->condition('promo_id', $promo->promo_id)
            ->fields(['is_activated' => REQUEST_TIME])
            ->execute();

    $uid = $promo->uid;
    $username = $promo->lastname . ' ' . $promo->firstname;
    $email = $promo->email;
    $pid = $promo->pid;

    if (!$uid) {
        // Ha még nem aktivált felhasználó létrehozzunk az adatbázisban
        // és összekötjük a megerendelési adatokkal.
        $result = create_new_user($username, $email);

        $uid = $result['account']->uid;
        $num_updated = db_update('membership_users')->fields(array('uid' => $uid,))->condition('id', $invoice['id'], '=')->execute();

        // E-mail küldés az belépési adatokról.
        _new_user_email_send($username, $email, $result['username'], $result['password']);
    }

    // A szerepkörök, és hírvelek ki-be kikapcsolása.
    $product = membership_period_product_get_details_object($pid);

    // A szerepkörök törlése és hozzáadása.
    membership_period_promo_manipulate_roles($uid, $product, 'add');

    // Felhasználó törlése és hozzáadása a hírlevél listákhoz.
    //
      // E-mail küldés az aktiválásról
    _activate_email_send($username, $email, $product->name);

    // A felhasználó felcímkézése az IM-ben.
    // Az e-mailhez hozzáadjuk az aktivált címkét és eltávolítjuk a megrendelt és
    // lejárt címkéket. Ha a felhasználó nem létezik, nem történik semmi.
    $user_data = db_query_range('SELECT lastname, firstname, email, hash, phone FROM {membership_users} WHERE id = :id', 0, 1, array(':id' => $promo->id))->fetchObject();

    membership_period_promo_manipulate_ac($user_data, $product);

    // Ha az alert modul be van kapcsolva megnézi, hogy az illető rendelése
    // szerepel-e az alert_nopayers vagyis nem fizetők táblájában.
    if (module_exists('alert')) {
        $nonpayer = db_query_range('SELECT oid FROM {alert_nonpayers} WHERE oid = :oid', 0, 1, array(':oid' => $invoice['oid']))->fetchField();
        if (!empty($nonpayer)) {
            // Ha szerepel a táblában töröljük, hiszen az aktiválás bizonyítja, hogy
            // fizetett.
            db_delete('alert_nonpayers')->condition('oid', $nonpayer, '=')->execute();
        }
    }

    // Refund payment
    $transaction = db_select('barion_api_transactions', 't')
            ->fields('t')
            ->condition('oid', $promo->promo_id)
            ->condition('order_table', 'membership_period_promotions')
            ->execute()
            ->fetchObject();
    if (!empty($transaction)) {
        $refund = barion_api_refund_request($transaction->payment, 200, 'Refund: ' . $promo->promo_id);

        if ($refund->RequestSuccessful) {
            return TRUE;
        } else {

            watchdog('membership', t('Promo refund sikertelen. Result: %result'), array('%result' => json_encode($refund), WATCHDOG_ERROR));

            return FALSE;
        }
    }

    watchdog('membership', t('Promo Barion rekord üres. Promo id: %promo'), array('%promo' => $promo->promo_id, WATCHDOG_WARNING));

    return FALSE;
}
