<?php

/**
 * @file
 * Az előfizetéses termékek adminisztrálása.
 */

/**
 * Tlőfizetéses termékek adminisztrálása - Listázás.
 */
function membership_period_product_list() {
    $html = '';

    $header = array(
        array('data' => 'pid', 'field' => 'pid', 'sort' => 'asc'),
        array('data' => t('Termék neve'), 'field' => 'name'),
        array('data' => t('IM Címke'), 'field' => 'table_name'),
        array('data' => t('Ára'), 'field' => 'price'),
        array('data' => t('Hash'), 'field' => 'hash'),
        array('data' => t('Műveletek')),
    );

    $result = db_select('membership_period_products', 'p')
            ->extend('PagerDefault')
            ->limit(variable_get('membership_list_limit_product'))
            ->extend('TableSort')
            ->orderByHeader($header)
            ->fields('p', array('pid', 'name', 'table_name', 'price', 'hash'))
            ->execute();

    $rows = array();

    foreach ($result as $value) {
        $links = l(t('Edit'), "admin/config/membership/period/products/edit/$value->pid") .
                '&nbsp;&nbsp;' .
                l(t('Delete'), "admin/config/membership/period/products/delete/$value->pid") .
                '&nbsp;&nbsp;' .
                l(t('Megrendelés link'), "period/megrendeles/", array('query' => array('pid' => $value->pid, 'hash' => $value->hash,))
        );

        $rows[] = array(
            'data' => array(
                $value->pid,
                $value->name,
                $value->table_name,
                $value->price . ' Ft',
                $value->hash,
                $links,
            )
        );
    }

    $html .= theme('table', array(
        'header' => $header,
        'rows' => $rows,
        'caption' => t('Előfizetéses termékek táblája'),
        'sticky' => TRUE,
        'empty' => t('Még nincsenek előfizetéses termékek létrehozva.'),
    ));

    $html .= theme('pager', array('tags' => array()));

    return $html;
}

/**
 * Defines form elements, without separated dropping event definitions.
 *
 * @return $form
 * Form Part I.
 */
function membership_period_product_create_base_form($form, &$form_state, $mode = 'add') {

// A termékcsoportok beolvasása.
    $groups = db_query("SELECT pgid, name FROM {membership_product_groups}")->fetchAllKeyed();
    $period_products = db_query("SELECT pid, name FROM {membership_period_products}")->fetchAllKeyed();

// Az űrlap.
    $form = array();

    $form['overview'] = array(
        '#prefix' => '<p>',
        '#suffix' => '</p>',
    );

    $form['markup_site_one'] = array(
        '#markup' => t('1/2 oldal'),
        '#suffix' => '</br>',
    );

    $form['name'] = array(
        '#title' => t('Termék neve'),
        '#description' => t('A termék neve'),
        '#type' => 'textfield',
//        '#required' => TRUE,
    );

    $form['thank_you'] = array(
        '#title' => t('Köszönöm oldal'),
        '#description' => t('Megrendelés utáni érkező oldal.'),
        '#type' => 'textfield',
//        '#required' => TRUE,
        '#size' => 20,
        '#maxlength' => 256,
        '#default_value' => variable_get('membership_thankyou_link'),
    );

    $form['table_name'] = array(
        '#title' => t('Intelleigent Mailer címke'),
        '#description' => t('A termék ezen a néven fog szerepelni az Intelligent Mailerben. 3 előtagot kap: M_, F_, L_. FIGYELEM! Ha ez a mező meg lesz változtatva az IM-ben is át kell írni a címkéket, különben hibás lesz a teljes aktiválási folyamat!'),
        '#type' => 'textfield',
//        '#required' => TRUE,
    );

    $form['proforma_name'] = array(
        '#title' => t('Számla név'),
        '#description' => t('A termék neve, ami a proforma számlán fog megjelenni.'),
        '#type' => 'textfield',
        '#size' => 20,
        '#maxlength' => 16,
//        '#required' => TRUE,
    );

    $form['price'] = array(
        '#title' => t('Termék ára'),
        '#description' => t('A termék bruttó ára forintban.'),
        '#type' => 'textfield',
        '#size' => 12,
        '#maxlength' => 9,
//        '#required' => TRUE,
        '#field_suffix' => ' Ft',
        '#default_value' => 100,
    );

    $form['shipping'] = array(
        '#title' => t('Szállítás költség'),
        '#description' => t('A termék szállítási költsége forintban.'),
        '#type' => 'textfield',
        '#size' => 12,
        '#maxlength' => 9,
//        '#required' => TRUE,
        '#field_suffix' => ' Ft',
        '#default_value' => 100,
    );

    $form['vat'] = array(
        '#title' => t('ÁFA'),
        '#description' => t('Az általános forgalmi adó százalékban.'),
        '#type' => 'textfield',
        '#size' => 12,
        '#maxlength' => 9,
//        '#required' => TRUE,
        '#default_value' => variable_get('membership_firm_invoice_vat'),
        '#field_suffix' => ' %',
    );

    $form['pgid'] = array(
        '#title' => t('Termékcsoport'),
        '#description' => t('Az itt kiválasztott termékcsoportba fog a termék kerülni. Az egy csoportba tartozó termékek egy szűrés oldalon egyszerre jelennek meg.'),
        '#type' => 'select',
        '#options' => $groups,
//        '#required' => TRUE,
    );
    
    $form['replace_products'] = array(
        '#title' => t('Kiváltandó termékek'),
        '#description' => t('A rendelés során a kiválasztott termékekhez fűződő rendeléseket lezárja.'),
        '#type' => 'checkboxes',
        '#options' => $period_products,
//        '#required' => TRUE,
    );

    $form['promotime'] = array(
        '#title' => t('Promóciós időszak hossza'),
        '#description' => t('A termék promóciós időszakának hosszát adja meg napokban.'),
        '#type' => 'textfield',
        '#size' => 12,
        '#maxlength' => 3,
//        '#required' => TRUE,
        '#field_suffix' => 'nap',
    );

    $form['period_type'] = array(
        '#title' => t('Előfizetéses időszak típusa'),
        '#description' => t('Az előfizetés időszakának jellegét adja meg.'),
        '#type' => 'select',
        '#options' => array(
            '0' => t('Intervallum napokban'),
            '1' => t('Naptári hét'),
            '2' => t('Naptári hó'),
            '3' => t('Naptári év'),
        ),
//        '#size' => 12,
//        '#maxlength' => 3,
//        '#required' => TRUE,
    );

    $form['period_length'] = array(
        '#title' => t('Előfizetéses időszak hossza.'),
        '#description' => t('Az előfizetés időszak hosszát adja meg.'),
        '#type' => 'textfield',
        '#size' => 12,
        '#maxlength' => 3,
//        '#required' => TRUE,
    );

    $form['period_dropping'] = array(
        '#title' => t('Csepegtetések száma.'),
        '#description' => t('Az adott előfizetés csepegtetéseinek számát adja meg.'),
        '#type' => 'textfield',
        '#size' => 12,
        '#maxlength' => 3,
//        '#required' => TRUE,
        '#default_value' => 3,
    );

    $form['payment_modes'] = array(
        '#title' => 'Fizetési módok',
        '#description' => t('A lehetséges fizetési módok.'),
        '#type' => 'checkboxes',
        '#options' => variable_get('membership_payment_modes'),
    );

// Összállít egy asszociatív tömböt a role-okból.
    $roles = user_roles();

// Összeállít egy associatív tömböt a hírlevél listákból.

    $form['prerequisite'] = array(
        '#title' => t('Előfeltételek a rendeléshez'),
        '#description' => t('Azokat a szerepköröket kell bejelölni, amik nélkül, az adott termék nem rendelhető. Vagyis ezekkel rendelkeznie kell a felhazsnálónak, hogy meg tudja rendelni a terméket. Hogy egy termék bárki által rendelhetől legyen üresen kell hagyni.'),
        '#type' => 'checkboxes',
        '#options' => $roles,
    );

    $form['affiliate'] = array(
        '#type' => 'fieldset',
        '#title' => t('A partnerprogram'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );

    $form['affiliate']['commission'] = array(
        '#title' => t('A partner jutaléka'),
        '#description' => t('Ennyit fizetünk ki bruttó áron (ÁFÁs számla ellenében) a partnernek forintban, ha az ő ajánlására érkezett rendelés.'),
        '#type' => 'textfield',
        '#size' => 12,
        '#maxlength' => 9,
        '#required' => TRUE,
        '#default_value' => 0,
        '#field_suffix' => ' Ft',
    );

    $form['affiliate']['remark'] = array(
        '#title' => t('Megjegyzés'),
        '#description' => t('Megjegyzés a termékhez.'),
        '#type' => 'textfield',
        '#required' => FALSE,
    );

    $form['submitted'] = array(
        '#type' => 'hidden',
        '#value' => 'base',
    );

    $form['mode'] = array(
        '#type' => 'hidden',
        '#value' => $mode,
    );

    $form['submit_page_twoo'] = array(
        '#type' => 'submit',
        '#validate' => $mode == 'edit' ? array('membership_period_product_edit_form_validate') : array('membership_period_product_add_form_validate'),
        '#value' => t('Tovább >>'),
        '#submit' => array('membership_period_product_show_page_twoo'),
    );

    return $form;
}

/**
 * Defines form elements, withthe dropping event definitions.
 *
 * @return $form
 * Form Part II.
 */
function membership_period_product_create_dropping_form($form, &$form_state, $mode = 'add') {
//    mdd($form_state, true);
//    mdd($form_state['storage']['values']['period_dropping']);

    $form = array();

    $form['overview'] = array(
        '#prefix' => '<p>',
        '#suffix' => '</p>',
    );

    $form['markup_site_twoo'] = array(
        '#markup' => t('2/2 oldal'),
        '#suffix' => '</br>',
    );

    // Összállít egy asszociatív tömböt a role-okból.
    $roles = user_roles();

    $form['promo'] = array(
        '#type' => 'fieldset',
        '#title' => t('Promóciós időszak'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );

    $form['promo']['order_roles'] = array(
        '#type' => 'fieldset',
        '#title' => t('A sikeres rendeléskor történő, szerepkör események'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );

    $form['promo']['order_roles']['promo_roles_order_remove'] = array(
        '#title' => t('A szerepköröket törölni'),
        '#description' => t('Megrendeléskor ezeket a szerepköröket töröljük usertől, ha a kártyavalidáció sikeres volt és létrejött a felhasználó.'),
        '#type' => 'checkboxes',
        '#options' => $roles,
    );

    $form['promo']['order_roles']['promo_roles_order_add'] = array(
        '#title' => t('A szerepköröket hozzárendelni'),
        '#description' => t('Megrendeléskor ezeket a szerepköröket kapja meg a user, ha a kártyavalidáció sikeres volt és létrejött a felhasználó.'),
        '#type' => 'checkboxes',
        '#options' => $roles,
    );

    $form['promo']['promo_end_roles'] = array(
        '#type' => 'fieldset',
        '#title' => t('Promóciós időszak végén történő szerepkör módosítások.'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );

    $form['promo']['promo_end_roles']['promo_roles_end_remove'] = array(
        '#title' => t('A szerepköröket törölni'),
        '#description' => t('A promóciós időszak végén ezeket a szerepköröket töröljük a usertől.'),
        '#type' => 'checkboxes',
        '#options' => $roles,
    );

    $form['promo']['promo_end_roles']['promo_roles_end_add'] = array(
        '#title' => t('A szerepköröket hozzárendelni'),
        '#description' => t('A promóciós időszak végén ezeket a szerepköröket kapja meg a user.'),
        '#type' => 'checkboxes',
        '#options' => $roles,
    );

    $form['promo']['newsletter'] = array(
        '#type' => 'fieldset',
        '#title' => t('Hírlevél események '),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );

    $form['promo']['newsletter']['order_newsletter'] = array(
        '#type' => 'fieldset',
        '#title' => t('A rendeléskor történő, hírlevél események'),
        '#collapsible' => TRUE,
        '#collapsed' => FALSE,
    );

    $form['promo']['newsletter']['order_newsletter']['promo_ns_newsletter_order'] = array(
        '#title' => t('Rendelési szekvencia'),
        '#description' => t('Ezen a szekvencián indítjuk el a rendelése után.'),
        '#type' => 'textfield',
    );

    $form['promo']['newsletter']['order_newsletter']['promo_ns_order_tags_add'] = array(
        '#title' => t('Rendelési után ezeknek a címkék hozzáadása'),
        '#description' => t('Ezeket a címkéket adjuk hozzá rendelés után. Vesszővel elválasztva, szóköz nélkül. Pl: címke1,címke2,címke3. Az M_címke automatikusan hozzáadóik.'),
        '#type' => 'textfield',
    );

    $form['promo']['newsletter']['order_newsletter']['promo_ns_order_tags_remove'] = array(
        '#title' => t('Rendelési után ezeknek acímkék eltávollítása'),
        '#description' => t('Ezeket a címkéket távolítjuk el rendelés után. Vesszővel elválasztva, szóköz nélkül. Pl: címke1,címke2,címke3.'),
        '#type' => 'textfield',
    );

    $form['promo']['newsletter']['end_newsletter'] = array(
        '#type' => 'fieldset',
        '#title' => t('A promóció időszak végén történő, hírlevél események'),
        '#collapsible' => TRUE,
        '#collapsed' => FALSE,
    );


    $form['promo']['newsletter']['end_newsletter']['promo_ns_newsletter_end'] = array(
        '#title' => t('Promóció utáni szekvencia'),
        '#description' => t('Ezen a szekvencián indítjuk el a promóció utáni.'),
        '#type' => 'textfield',
    );

    $form['promo']['newsletter']['end_newsletter']['promo_ns_end_tags_add'] = array(
        '#title' => t('Promóció után ezeknek a címkéknek a hozzáadása'),
        '#description' => t('Ezeket a címkéket adjuk hozzá promóció után. Vesszővel elválasztva, szóköz nélkül. Pl: címke1,címke2,címke3. Az F_címke automatikusan hozzáadóik.'),
        '#type' => 'textfield',
    );

    $form['promo']['newsletter']['end_newsletter']['promo_ns_end_tags_remove'] = array(
        '#title' => t('Promóció után ezeknek a címkéknek az eltávollítása'),
        '#description' => t('Ezeket a címkéket távolítjuk el promóció után. Vesszővel elválasztva, szóköz nélkül. Pl: címke1,címke2,címke3. Az L_címke, V_címke, M_címke automatikusan eltávolítódik.'),
        '#type' => 'textfield',
    );

    for ($i = 0; $i < $form_state['storage']['values']['period_dropping']; $i++) {

        $form['period_dropping'][$i] = array(
            '#type' => 'fieldset',
            '#title' => t(':num. Csepegtetés', array(':num' => $i + 1)),
            '#collapsible' => TRUE,
            '#collapsed' => TRUE,
        );

        $form['period_dropping'][$i]['order_roles'] = array(
            '#type' => 'fieldset',
            '#title' => t('A rendeléskor történő, szerepkör események'),
            '#collapsible' => TRUE,
            '#collapsed' => TRUE,
        );

        $form['period_dropping'][$i]['order_roles']['dropping_roles_order_remove_' . $i] = array(
            '#title' => t('A szerepköröket törölni'),
            '#description' => t('A megrendelőt, amikor megrendelte a terméket, ezekről a szerepkörökről töröljük. Első rendelők esetén ez figyelmen kívül van hagyva, mert nem lehet jogosultságot állítani olyan felahsználó esetében, aki még nincs a Drupal user táblájában.'),
            '#type' => 'checkboxes',
            '#options' => $roles,
        );

        $form['period_dropping'][$i]['order_roles']['dropping_roles_order_add_' . $i] = array(
            '#title' => t('A szerepköröket hozzárendelni'),
            '#description' => t('A megrendelőt, amikor megrendelte a terméket, ezekhez a szerepkörökhöz adjuk hozzá. Első rendelők esetén ez figyelmen kívül van hagyva, mert nem lehet jogosultságot állítani olyan felahsználó esetében, aki még nincs a Drupal user táblájában.'),
            '#type' => 'checkboxes',
            '#options' => $roles,
        );

        $form['period_dropping'][$i]['resign_roles'] = array(
            '#type' => 'fieldset',
            '#title' => t('Az lemondáskor történő, szerepkör események '),
            '#collapsible' => TRUE,
            '#collapsed' => TRUE,
        );

        $form['period_dropping'][$i]['resign_roles']['dropping_roles_resign_remove_' . $i] = array(
            '#title' => t('A szerepköröket törölni'),
            '#description' => t('A megrendelőt, amikor lemondja a terméket, ezekről a szerepkörökről töröljük.'),
            '#type' => 'checkboxes',
            '#options' => $roles,
        );

        $form['period_dropping'][$i]['resign_roles']['dropping_roles_resign_add_' . $i] = array(
            '#title' => t('A szerepköröket hozzárendelni'),
            '#description' => t('A megrendelőt, amikor lemondja a terméket, ezekhez a szerepkörökhöz adjuk hozzá.'),
            '#type' => 'checkboxes',
            '#options' => $roles,
        );

        $form['period_dropping'][$i]['newsletter'] = array(
            '#type' => 'fieldset',
            '#title' => t('Hírlevél események '),
            '#collapsible' => TRUE,
            '#collapsed' => TRUE,
        );

        $form['period_dropping'][$i]['newsletter']['order_newsletter'] = array(
            '#type' => 'fieldset',
            '#title' => t('A rendeléskor történő, hírlevél események'),
            '#collapsible' => TRUE,
            '#collapsed' => FALSE,
        );

        $form['period_dropping'][$i]['newsletter']['order_newsletter']['dropping_ns_newsletter_order_' . $i] = array(
            '#title' => t('Rendelési szekvencia'),
            '#description' => t('Ezen a szekvencián indítjuk el a rendelése után.'),
            '#type' => 'textfield',
        );

        $form['period_dropping'][$i]['newsletter']['order_newsletter']['dropping_ns_order_tags_add_' . $i] = array(
            '#title' => t('Rendelési után ezeknek a címkék hozzáadása'),
            '#description' => t('Ezeket a címkéket adjuk hozzá rendelés után. Vesszővel elválasztva, szóköz nélkül. Pl: címke1,címke2,címke3. Az M_címke automatikusan hozzáadóik.'),
            '#type' => 'textfield',
        );

        $form['period_dropping'][$i]['newsletter']['order_newsletter']['dropping_ns_order_tags_remove_' . $i] = array(
            '#title' => t('Rendelési után ezeknek acímkék eltávollítása'),
            '#description' => t('Ezeket a címkéket távolítjuk el rendelés után. Vesszővel elválasztva, szóköz nélkül. Pl: címke1,címke2,címke3.'),
            '#type' => 'textfield',
        );

        $form['period_dropping'][$i]['newsletter']['resign_newsletter'] = array(
            '#type' => 'fieldset',
            '#title' => t('Az lemondáskor történő, hírlevél események'),
            '#collapsible' => TRUE,
            '#collapsed' => FALSE,
        );


        $form['period_dropping'][$i]['newsletter']['resign_newsletter']['dropping_ns_newsletter_resign_' . $i] = array(
            '#title' => t('Lemondási szekvencia'),
            '#description' => t('Ezen a szekvencián indítjuk el a lemondás után.'),
            '#type' => 'textfield',
        );

        $form['period_dropping'][$i]['newsletter']['resign_newsletter']['dropping_ns_resign_tags_add_' . $i] = array(
            '#title' => t('Lemondás után ezeknek  a címkék hozzáadása'),
            '#description' => t('Ezeket a címkéket adjuk hozzá lemondás után. Vesszővel elválasztva, szóköz nélkül. Pl: címke1,címke2,címke3. Az F_címke automatikusan hozzáadóik.'),
            '#type' => 'textfield',
        );

        $form['period_dropping'][$i]['newsletter']['resign_newsletter']['dropping_ns_resign_tags_remove_' . $i] = array(
            '#title' => t('Lemondás után ezeknek a címkék eltávollítása'),
            '#description' => t('Ezeket a címkéket távolítjuk el lemondás után. Vesszővel elválasztva, szóköz nélkül. Pl: címke1,címke2,címke3. Az L_címke, V_címke, M_címke automatikusan eltávolítódik.'),
            '#type' => 'textfield',
        );
    }

    $form['submitted'] = array(
        '#type' => 'hidden',
        '#value' => 'dropping',
    );

    $form['submit_page_one'] = array(
        '#type' => 'submit',
        '#value' => t('<< Vissza'),
        '#submit' => array('membership_period_product_show_page_one'),
    );

    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => t('Termék mentése'),
    );

    return $form;
}

/**
 * Az űrlap alapvelő mezőit határozza meg.
 *
 * @return array
 * Az összeállított űrlap.
 */
function membership_period_product_create_form($form, &$form_state, $mode = 'add') {

    if (isset($form_state['values']['submitted'])) {
        if ($form_state['values']['submitted'] == 'base') {
            $form = membership_period_product_create_dropping_form($form, $form_state, $mode);

            if ($mode == 'edit' && isset($form_state['storage']['values']['pid'])) {
                $product = db_query_range("SELECT * FROM {membership_period_products} WHERE pid = :pid", 0, 1, array(':pid' => check_plain($form_state['storage']['values']['pid'])))->fetchObject();

                $role_list = unserialize($product->roles);
                $nls = unserialize($product->newsletters);

                if (isset($role_list['promo'])) {
                    $form['promo']['order_roles']['promo_roles_order_remove']['#default_value'] = $role_list['promo']['roles_order_remove'];
                    $form['promo']['order_roles']['promo_roles_order_add']['#default_value'] = $role_list['promo']['roles_order_add'];
                    $form['promo']['promo_end_roles']['promo_roles_end_remove']['#default_value'] = $role_list['promo']['roles_end_remove'];
                    $form['promo']['promo_end_roles']['promo_roles_end_add']['#default_value'] = $role_list['promo']['roles_end_add'];
                }
                if (isset($nls['promo'])) {
                    $form['promo']['newsletter']['order_newsletter']['promo_ns_newsletter_order']['#default_value'] = $nls['promo']['newsletter_order'];
                    $form['promo']['newsletter']['order_newsletter']['promo_ns_order_tags_add']['#default_value'] = $nls['promo']['order_tags_add'];
                    $form['promo']['newsletter']['order_newsletter']['promo_ns_order_tags_remove']['#default_value'] = $nls['promo']['order_tags_remove'];
                    $form['promo']['newsletter']['end_newsletter']['promo_ns_newsletter_end']['#default_value'] = $nls['promo']['newsletter_end'];
                    $form['promo']['newsletter']['end_newsletter']['promo_ns_end_tags_add']['#default_value'] = $nls['promo']['end_tags_add'];
                    $form['promo']['newsletter']['end_newsletter']['promo_ns_end_tags_remove']['#default_value'] = $nls['promo']['end_tags_remove'];
                }

                for ($i = 0; $i < $form_state['storage']['values']['period_dropping']; $i++) {
                    if (isset($role_list[$i])) {
                        $form['period_dropping'][$i]['order_roles']['dropping_roles_order_remove_' . $i]['#default_value'] = $role_list[$i]['roles_order_remove'];
                        $form['period_dropping'][$i]['order_roles']['dropping_roles_order_add_' . $i]['#default_value'] = $role_list[$i]['roles_order_add'];
                        $form['period_dropping'][$i]['resign_roles']['dropping_roles_resign_remove_' . $i]['#default_value'] = $role_list[$i]['roles_resign_remove'];
                        $form['period_dropping'][$i]['resign_roles']['dropping_roles_resign_add_' . $i]['#default_value'] = $role_list[$i]['roles_resign_add'];
                    }
                    if (isset($nls[$i])) {
                        $form['period_dropping'][$i]['newsletter']['order_newsletter']['dropping_ns_newsletter_order_' . $i]['#default_value'] = $nls[$i]['newsletter_order'];
                        $form['period_dropping'][$i]['newsletter']['order_newsletter']['dropping_ns_order_tags_add_' . $i]['#default_value'] = $nls[$i]['order_tags_add'];
                        $form['period_dropping'][$i]['newsletter']['order_newsletter']['dropping_ns_order_tags_remove_' . $i]['#default_value'] = $nls[$i]['order_tags_remove'];
                        $form['period_dropping'][$i]['newsletter']['resign_newsletter']['dropping_ns_newsletter_resign_' . $i]['#default_value'] = $nls[$i]['newsletter_resign'];
                        $form['period_dropping'][$i]['newsletter']['resign_newsletter']['dropping_ns_resign_tags_add_' . $i]['#default_value'] = $nls[$i]['resign_tags_add'];
                        $form['period_dropping'][$i]['newsletter']['resign_newsletter']['dropping_ns_resign_tags_remove_' . $i]['#default_value'] = $nls[$i]['resign_tags_remove'];
                    }
                }
            }
            return $form;
        } else {
            $form = membership_period_product_create_base_form($form, $form_state, $mode);
            return $form;
        }
        // No Values
    } else {
        $form = membership_period_product_create_base_form($form, $form_state, $mode);
        return $form;
//        mdd($form_state, true);
    }
}

/**
 * Implements hook_form().
 * Előfizetéses termék adminisztrálása - Hozzáadás.
 */
function membership_period_product_add_form($form, &$form_state) {
    $form = membership_period_product_create_form($form, $form_state);
    $form['overview']['#markup'] = t('Ezen a felületen lehet hozzáadni új előfizetéses termékeket.');
    return $form;
}

/**
 * Implements hook_form_validate().
 * Előfizetéses Termék adminisztrálása - Hozzáadás form validálása.
 */
function membership_period_product_add_form_validate($form, &$form_state) {

    if ($form_state['values']['submitted'] == 'dropping') {

    } else {

        $name = $form_state['values']['name'];
        $table_name = $form_state['values']['table_name'];
        $proforma_name = $form_state['values']['proforma_name'];
        $price = $form_state['values']['price'];
        $shipping = $form_state['values']['shipping'];
        $commission = $form_state['values']['commission'];

        $name_row = db_query('SELECT pid FROM {membership_products} WHERE name = :name', array(':name' => $name))->fetchObject();
        $table_name_row = db_query('SELECT pid FROM {membership_products} WHERE table_name = :table_name', array(':table_name' => $table_name))->fetchObject();
        $proforma_name_row = db_query('SELECT pid FROM {membership_products} WHERE proforma_name = :proforma_name', array(':proforma_name' => $proforma_name,))->fetchObject();
// Ha létezik már ezen a néven termék a rendszerben, hibaüzenetet ad.
        if (!empty($name_row)) {
            form_set_error('name', t('Ezen a néven már létezik termék a rendszerben.'));
        }

// Ha létezik már ilyen néven tábla név a rendszerben hibaüzenetet ad.
        if (!empty($table_name_row)) {
            form_set_error('table_name', t('Ezen a néven már létezik címke a rendszerben.'));
        }

// A számlára kerülő nevek lehetnek ugyanazok
        // Ha létezik már ilyen néven számla név a rendszerben hibaüzenetet ad.
        if (!empty($proforma_name_row)) {
            form_set_error('proforma_name', t('Ezen a néven már létezik számla név a rendszerben.'));
        }

// Ha a szám (0-9) és 1-9 karakter hosszú és nagyobb mint nulla, akkor helyes. Ha ennek nem felel meg hibaüzenetet adunk.
        if (!((preg_match('{^[0-9]{1,9}$}', $price)) && ($price >= 0))) {
            form_set_error('price', t('Helytelen összeg. Az árnak pozitív egész számot adj meg, ami nem hosszabb 9 számegynél.'));
        }
        if (!((preg_match('{^[0-9]{1,9}$}', $shipping)) && ($shipping >= 0))) {
            form_set_error('shipping', t('Helytelen összeg. Az szállítási költségnek pozitív egész számot adj meg, ami nem hosszabb 9 számegynél.'));
        }
        if (!((preg_match('{^[0-9]{1,9}$}', $commission)) && ($commission >= 0))) {
            form_set_error('commission', t('Helytelen összeg. A jutaléknak pozitív egész számot adj meg, ami  nem hosszabb 9 számegynél.'));
        }
    }
}

/**
 * Implements hook_form_submit().
 * Előfizetéses Termék adminisztrálása - Hozzáadás form validálása.
 */
function membership_period_product_add_form_submit($form, &$form_state) {

    $p_fields = array(
        'pgid' => $form_state['storage']['values']['pgid'],
        'name' => trim($form_state['storage']['values']['name']),
        'thank_you' => trim($form_state['storage']['values']['thank_you']),
        'table_name' => trim($form_state['storage']['values']['table_name']),
        'proforma_name' => trim($form_state['storage']['values']['proforma_name']),
        'price' => (int) trim($form_state['storage']['values']['price']),
        'shipping' => (int) trim($form_state['storage']['values']['shipping']),
        'payment_modes' => serialize($form_state['storage']['values']['payment_modes']),
        'prerequisite' => serialize($form_state['storage']['values']['prerequisite']),
        'hash' => _make_hash(8),
        'commission' => (int) trim($form_state['storage']['values']['commission']),
        'vat' => (int) trim($form_state['storage']['values']['vat']),
        'remark' => trim($form_state['storage']['values']['remark']),
        'created' => REQUEST_TIME,
        'changed' => REQUEST_TIME,
        'promotime' => (int) trim($form_state['storage']['values']['promotime']),
        'period_type' => (int) trim($form_state['storage']['values']['period_type']),
        'period_length' => (int) trim($form_state['storage']['values']['period_length']),
        'period_dropping' => (int) trim($form_state['storage']['values']['period_dropping']),
        'replace_products' => serialize($form_state['storage']['values']['replace_products']),
    );
    $roles = [];
    $newsletter = [];
    foreach ($form_state['values'] as $key => $value) {
        $labels = explode('_', $key);
        if (strpos($key, 'promo_roles') !== FALSE) {
            $label = substr($key, strlen('promo_'));
            $roles[$labels[0]][$label] = $value;
        } else if (strpos($key, 'dropping_roles') !== FALSE) {
            $label = substr($key, strlen('dropping_'), -(strlen($labels[count($labels) - 1]) + 1));
            $roles[$labels[count($labels) - 1]][$label] = $value;
        }
        if (strpos($key, 'promo_ns') !== FALSE) {
            $label = substr($key, strlen('promo_ns_'));
            $newsletter[$labels[0]][$label] = $value;
        } else if (strpos($key, 'dropping_ns') !== FALSE) {
            $label = substr($key, strlen('dropping_ns_'), -(strlen($labels[count($labels) - 1]) + 1));
            $newsletter[$labels[count($labels) - 1]][$label] = $value;
        }
    }
    $p_fields['roles'] = serialize($roles);
    $p_fields['newsletters'] = serialize($newsletter);

    $pid = db_insert('membership_period_products')->fields($p_fields)->execute();

    $form_state['redirect'] = memebership_redirect_period_product_list();

// Üzenet kiírása az oldalon és az esemény rögzítése a watchdog-ba.
    drupal_set_message(t('<em>@name</em> nevű termék beküldve.', array('@name' => $p_fields['name'])));

// Save to watchdog.
    watchdog('membership', '@name nevű termék beküldve.', array('@name' => $p_fields['name'], WATCHDOG_NOTICE));
}

/**
 * Implements hook_form().
 * Előfizetése termék adminisztrálása - Szerkesztés.
 */
function membership_period_product_edit_form($form, &$form_state, $pid) {
    $product = db_query_range("SELECT * FROM {membership_period_products} WHERE pid = :pid", 0, 1, array(':pid' => check_plain($pid)))->fetchObject();
//    drupal_set_message(t('PID: <em>@name</em> - @result ', array('@name' => $pid, '@result' => $product->name)));
//    $upsell = db_query_range('SELECT * FROM {membership_upsell_products} WHERE pid = :pid AND status = 1', 0, 1, array(':pid' => $pid,))->fetchObject();
// Az űrlap feltöltése az adatbázisból kiolvasott értékekkel.
//    mdd(empty($product->replace_products), true);
    $form = membership_period_product_create_form($form, $form_state, 'edit');
    $form['overview']['#markup'] = t('Ezen a felületen lehet módosítani az előfizetéses termékeket.');
    $form['name']['#default_value'] = $product->name;
    $form['thank_you']['#default_value'] = $product->thank_you;
    $form['table_name']['#default_value'] = $product->table_name;
    $form['proforma_name']['#default_value'] = $product->proforma_name;
    $form['price']['#default_value'] = $product->price;
    $form['vat']['#default_value'] = $product->vat;
    $form['shipping']['#default_value'] = $product->shipping;
    $form['pgid']['#default_value'] = $product->pgid;
    $form['replace_products']['#default_value'] = !empty($product->replace_products) ? unserialize($product->replace_products) : [];
    $form['promotime']['#default_value'] = $product->promotime;
    $form['period_type']['#default_value'] = $product->period_type;
    $form['period_length']['#default_value'] = $product->period_length;
    $form['period_dropping']['#default_value'] = $product->period_dropping;
    $form['payment_modes']['#default_value'] = unserialize($product->payment_modes);
    $form['prerequisite']['#default_value'] = unserialize($product->prerequisite);

    $form['pid'] = array(
        '#type' => 'hidden',
        '#value' => check_plain($pid),
    );

    $form['affiliate']['commission']['#default_value'] = $product->commission;
    $form['affiliate']['remark']['#default_value'] = $product->remark;

//    if ($upsell != null) {
//        $form['upsell']['upsell_product']['#default_value'] = $upsell->upid;
//        $form['upsell']['upsell_active']['#default_value'] = (bool) $upsell->status;
//        $form['upsell']['upsell_price']['#default_value'] = $upsell->price;
//        $form['upsell']['upsell_title']['#default_value'] = $upsell->title;
//        $form['upsell']['upsell_description']['#default_value'] = $upsell->description;
//    }
    return $form;
}

/**
 * Implements hook_form_validate().
 * Előfizetése termék adminisztrálása - Szerkesztés - validálás.
 */
function membership_period_product_edit_form_validate($form, &$form_state) {

    if (isset($form_state['values']['submitted']) && $form_state['values']['submitted'] == 'dropping') {
        // Do nothing
    } else {

        $name = $form_state['values']['name'];
        $table_name = $form_state['values']['table_name'];
        $proforma_name = $form_state['values']['proforma_name'];
        $price = $form_state['values']['price'];
        $shipping = $form_state['values']['shipping'];
        $pid = $form_state['build_info']['args'][0];
        $commission = $form_state['values']['commission'];

        $name_row = db_query('SELECT pid FROM {membership_products} WHERE name = :name AND pid != :pid', array(':name' => $name, ':pid' => $pid,))->fetchObject();
        $table_name_row = db_query('SELECT pid FROM {membership_products} WHERE table_name = :table_name AND pid != :pid', array(':table_name' => $table_name, ':pid' => $pid,))->fetchObject();
        $proforma_name_row = db_query('SELECT pid FROM {membership_products} WHERE proforma_name = :proforma_name AND pid != :pid', array(':proforma_name' => $proforma_name, ':pid' => $pid,))->fetchObject();
        // Ha létezik már ezen a néven termék a rendszerben, hibaüzenetet ad.
        if (!empty($name_row)) {
            form_set_error('name', t('Ezen a néven már létezik termék a rendszerben.'));
        }

        // Ha létezik már ilyen néven tábla név a rendszerben hibaüzenetet ad.
        if (!empty($table_name_row)) {
            form_set_error('table_name', t('Ezen a néven már létezik címke a rendszerben.'));
        }

        // Ha létezik már ilyen néven tábla név a rendszerben hibaüzenetet ad.
        if (!empty($proforma_name_row)) {
            form_set_error('proforma_name', t('Ezen a néven már létezik számla név a rendszerben.'));
        }

        // Ha a szám (0-9) és 1-9 karakter hosszú és nagyobb mint nulla, akkor helyes. Ha ennek nem felel meg hibaüzenetet adunk.
        if (!((preg_match('{^[0-9]{1,9}$}', $price)) && ($price >= 0))) {
            form_set_error('price_name', t('Helytelen összeg. Az árnak pozitív egész számot adj meg, ami nem hosszabb 9 számegynél.'));
        }
        if (!((preg_match('{^[0-9]{1,9}$}', $shipping)) && ($shipping >= 0))) {
            form_set_error('shipping_name', t('Helytelen összeg. A szállítási költségnek pozitív egész számot adj meg, nem hosszabb 9 számegynél.'));
        }
        if (!((preg_match('{^[0-9]{1,9}$}', $commission)) && ($commission >= 0))) {
            form_set_error('commission_name', t('Helytelen összeg. A jutaléknak pozitív egész számot adj meg, ami nem hosszabb 9 számegynél.'));
        }
    }
}

/**
 * Implements hook_form_submit().
 * Előfizetése termék adminisztrálása - Szerkesztés - mentés.
 */
function membership_period_product_edit_form_submit($form, &$form_state) {

    $p_fields = array(
        'pgid' => $form_state['storage']['values']['pgid'],
        'name' => trim($form_state['storage']['values']['name']),
        'thank_you' => trim($form_state['storage']['values']['thank_you']),
        'table_name' => trim($form_state['storage']['values']['table_name']),
        'proforma_name' => trim($form_state['storage']['values']['proforma_name']),
        'price' => (int) trim($form_state['storage']['values']['price']),
        'shipping' => (int) trim($form_state['storage']['values']['shipping']),
        'payment_modes' => serialize($form_state['storage']['values']['payment_modes']),
        'prerequisite' => serialize($form_state['storage']['values']['prerequisite']),
        'commission' => (int) trim($form_state['storage']['values']['commission']),
        'vat' => (int) trim($form_state['storage']['values']['vat']),
        'remark' => trim($form_state['storage']['values']['remark']),
        'changed' => REQUEST_TIME,
        'promotime' => (int) trim($form_state['storage']['values']['promotime']),
        'period_type' => (int) trim($form_state['storage']['values']['period_type']),
        'period_length' => (int) trim($form_state['storage']['values']['period_length']),
        'period_dropping' => (int) trim($form_state['storage']['values']['period_dropping']),
        'replace_products' => serialize($form_state['storage']['values']['replace_products']),
    );
    $roles = [];
    $newsletter = [];
    foreach ($form_state['values'] as $key => $value) {
        $labels = explode('_', $key);
        if (strpos($key, 'promo_roles') !== FALSE) {
            $label = substr($key, strlen('promo_'));
            $roles[$labels[0]][$label] = $value;
        } else if (strpos($key, 'dropping_roles') !== FALSE) {
            $label = substr($key, strlen('dropping_'), -(strlen($labels[count($labels) - 1]) + 1));
            $roles[$labels[count($labels) - 1]][$label] = $value;
        }
        if (strpos($key, 'promo_ns') !== FALSE) {
            $label = substr($key, strlen('promo_ns_'));
            $newsletter[$labels[0]][$label] = $value;
        } else if (strpos($key, 'dropping_ns') !== FALSE) {
            $label = substr($key, strlen('dropping_ns_'), -(strlen($labels[count($labels) - 1]) + 1));
            $newsletter[$labels[count($labels) - 1]][$label] = $value;
        }
    }
    $p_fields['roles'] = serialize($roles);
    $p_fields['newsletters'] = serialize($newsletter);
//    mdd([$p_fields, $roles, $newsletter, $form_state['values']], true);

    $pid = $form_state['build_info']['args'][0];

    $num_updated = db_update('membership_period_products')->fields($p_fields)->condition('pid', $pid, '=')->execute();

    $block_update = membership_update_analytics_block_pages($p_fields['thank_you']);

//    $up_fields = array(
//        'pid' => $pid,
//        'upid' => $form_state['values']['upsell_product'],
//        'title' => trim($form_state['values']['upsell_title']),
//        'description' => trim($form_state['values']['upsell_description']),
//        'status' => (int) $form_state['values']['upsell_active'],
//        'price' => (int) trim($form_state['values']['upsell_price'])
//    );
//    $upsell_merge = db_merge('membership_upsell_products')->fields($up_fields)->condition('pid', $pid, '=')->execute();
// Átirányítás a listázás oldalra.
    $form_state['redirect'] = membership_redirect_period_product_list();

// Üzenet kiírása az oldalon és az esemény rögzítése a watchdog-ba.
    drupal_set_message(t('<em>@name</em> nevű termék adatai sikeresen megváltoztak.', array('@name' => $p_fields['name'])));

// Save to watchdog.
    watchdog('membership', '@name nevű termék adatai sikeresen megváltoztak.', array('@name' => $p_fields['name'], WATCHDOG_NOTICE));
}

/**
 * Implements hook_form()
 * Termék csoportok adminisztrálása - Törlés.@name' => $p_fields['name'])), WATCHDOG_NOTICE);
 */
function membership_period_product_delete_form($form, &$form_state, $pid) {
    $result = db_query_range("SELECT name FROM {membership_period_products} WHERE pid = :pid", 0, 1, array(':pid' => $pid))->fetchField();

    $form = array();
    $form['pid'] = array(
        '#type' => 'value',
        '#value' => $pid,
    );

// A termék régi nevét megtartjuk, hogy a watchdog-ba rögzíteni lehessen.
    $form['name'] = array(
        '#type' => 'hidden',
        '#value' => $result,
    );

    return confirm_form(
            $form, t('<em>"' . $result . '"</em> biztosan törölhető?'), 'admin/config/membership/period/products', t('Ez a művelet nem vonható vissza.'), t('Delete'), t('Cancel')
    );
}

function membership_period_product_delete_form_submit($form, &$form_state) {
    $pid = array('name' => $form_state['values']['pid']);

    $num_deleted = db_delete('membership_period_products')->condition('pid', $pid, '=')->execute();

// Átirányítás a listázás oldalra.
    $form_state['redirect'] = membership_redirect_period_product_list();

// Üzenet kiírása az oldalon.
    drupal_set_message(t('A termék sikeresen törölve.'));

// Save to watchdog.
    watchdog('membership', 'Előfizetéses termék sikeresen törölve.', array(), WATCHDOG_NOTICE);
}

// A termék első oldalát mutató gomb
function membership_period_product_show_page_one($form, &$form_state) {
    if (!isset($form_state['storage']['confirm'])) {
        $form_state['storage']['values'] = $form_state['values'];
        $form_state['storage']['confirm'] = true;
        $form_state['storage']['page_number'] = 1;
        $form_state['rebuild'] = TRUE;

//      mdd ($form_state, true);
    } else {
//        $form_state['storage']['values'] = $form_state['values'];
        $form_state['storage']['values'] = $form_state['values'];
        $form_state['storage']['confirm'] = true;
        $form_state['storage']['page_number'] = 1;
        $form_state['rebuild'] = TRUE;
    }
}

// A termék második oldalát mutató gomb
function membership_period_product_show_page_twoo($form, &$form_state) {
    if (!isset($form_state['storage']['confirm'])) {
        $form_state['storage']['values'] = $form_state['values'];
        $form_state['storage']['confirm'] = true;
        $form_state['storage']['page_number'] = 2;
        $form_state['rebuild'] = TRUE;

//      mdd ($form_state, true);
    } else {
//        mdd($form_state, true);
    }
}
