<?php

/**
 * @file
 * A megrendelési űrlap és a megrendelések fogadása.
 *
 * @TODO Ha kiválasztotta a céges adatokat, jelenjen meg a piros csillag, mint kötelező mező.
 *
 */
// Az általános ellenőrző és átalakító függvények betöltése.
require_once 'lib.php';
require_once 'validate.php';
require_once 'membership.email.inc';
require_once 'membership.period_promo.inc';
require_once('ac_api/includes/ActiveCampaign.class.php');

/**
 * Összehasonlítja a meglévő szerepköröket a megadott előfeltételekkel.
 *   *
 * @param array $prerequisite
 * A előfeltételek amiknek meg kell lenniük.
 *
 * @return bool
 * TRUE, ha az előfeltételeknek megfelel, FALSE, ha nem.
 *
 */
function _period_is_prerequisite($prerequisite) {
    global $user;
    $roles = $user->roles;
    foreach ($prerequisite as $value) {
        if ($value != 0) {
            if (!array_key_exists($value, $roles)) {
                return FALSE;
            }
        }
    }
    return TRUE;
}

/**
 * Implements hook_form().
 * Megrendelési űrlap.
 */
function membership_period_order_form($form, &$form_state) {
    // Ha a tawk modul létezik, hozzáadjuk a chat ablakot az oldalhoz.
    if (module_exists('tawk')) {
        $tawk_js = drupal_add_js(variable_get('tawk_js'), 'inline');
    }

    // Megvizsgáljuk a paramétert.
    if (isset($_GET['pid']) && is_numeric($_GET['pid']) && isset($_GET['hash'])) {
        // Ha van megfelelő paraméter, megtisztitjuk, és megnézzük létezik-e az adatbázisban ilyen sorszámú termék.
        $pid = trim(check_plain($_GET['pid']));
        $hash = trim(check_plain($_GET['hash']));
        $product = db_query_range('SELECT * FROM {membership_period_products} WHERE pid = :pid AND hash = :hash', 0, 1, array(':pid' => $pid, ':hash' => $hash,))->fetchAssoc();
        $upsell = db_query_range('SELECT title, price, description FROM {membership_upsell_products} WHERE pid = :pid AND status = 1', 0, 1, array(':pid' => $pid,))->fetchAssoc();

        if (!$product) {
            // Ha nem létezik ilyen sorszámmal termék hibaüzenetet írunk ki.
//            drupal_goto('/');
            drupal_set_message(t('Hiba történt. Nincs ilyen termék jelenleg. Kérjük vedd fel a kapcsolatot az oldal adminisztrátorával.'), 'error');
        } else {
            // Ha létezik a termék.
            // Betöltjük az országok neveit
            $country = db_query('SELECT * FROM {membership_country} ORDER BY name ASC')->fetchAllKeyed();

            // Begyűjtjük az esetleges paramétereket.
            if (isset($_GET['sid']))
                $sid = trim(check_plain($_GET['sid']));
            else
                $sid = 0;
            if (isset($_GET['email']))
                $email = trim(check_plain($_GET['email']));
            else
                $email = '';
            if (isset($_GET['nickname']))
                $nickname = trim(check_plain($_GET['nickname']));
            else
                $nickname = '';

            // Kírjuka a fejlécet és az árat.
            $form = array();

            $header = '<h1>' . _a_az($product['name']) . ' <em>' . $product['name'] . '</em> megrendelése</h1>';
            $form['header'] = array(
                '#type' => 'item',
                '#markup' => $header,
            );
            $form['header_price'] = array(
                '#type' => 'item',
                '#markup' => '<p><strong>Ára:</strong> ' . _format_price($product['price']) . '</p>',
            );

            // A lehetséges fizetési módok beállítása a termékhez.
            $payment_modes = variable_get('membership_payment_modes');
            foreach (unserialize($product['payment_modes']) as $value) {
                if ($value != 0) {
                    if ($value == 7) {
                        if (module_exists('barion_api')) {
                            $possible_payments[$value] = $payment_modes[$value];
                        }
                    } else {
                        $possible_payments[$value] = $payment_modes[$value];
                    }
                }
            }

            // Leellenőrizzük, hogy azonosított felhasználóról van-e szó?
            global $user;

            if ($user->uid) {
                // Ha azonosított felhasználóról van szó.
                $user_row = db_query_range('SELECT * FROM {membership_users} WHERE uid = :uid', 0, 1, array(':uid' => $user->uid))->fetch();
            }

            if ($user->uid && !empty($user_row)) {

                // Megvan már neki már ez a termék?
                $is_activated = db_query_range('SELECT is_activated, closed FROM {membership_period_orders} WHERE id = :id AND pid = :pid AND end_at < :now AND closed = 0', 0, 1, array(':id' => $user_row->id, ':pid' => $pid, ':now' => date('Y-m-d H:i:s')))->fetchObject();

                if (!empty($is_activated) && $is_activated->is_activated) {
                    // Ha már megrendelte ezt a terméket.
//                    if ($is_activated->is_activated) {
//                        // Ha aktiválva van a hozzáférése.
//                        drupal_set_message(t('Nem rendelheted meg ezt a terméket mert jelenleg is elérhető számodra.<br>Az oldalon belépve meg fogod találni <a href="/sajat-adatok">a saját adatok oldalon.</a>'), 'error');
//                    } else {
                    // Ha már megrendelte, de még nincs aktiválva.
                    drupal_set_message(t('Ezt a terméket már megrendelted, de még nem érkezett be hozzánk az ára.<br>A díjbekérő leveleid és a rendeléseid <a href="/sajat-adatok">a saját adatok oldalon találod.</a>'), 'error');
//                    }
                } else {
                    // Ha még nem rendelte meg ezt a terméket.
                    // Teljesülnek az előfeltételek?
                    $prerequisite = unserialize($product['prerequisite']);
                    if (_period_is_prerequisite($prerequisite)) {
                        // Ha megefelel az előfeltételeknek.
                        // Ha még nem kattintottak egyik gombra sem, akkor jeleníti meg ezeket.
                        // A not_correctet azért nem ellenőrizzük mert az a saját adatok szerkesztése
                        // oldalra dobja a felhasználót.
                        if (empty($form_state['storage']['correct'])) {
                            $user_data = '<p><strong>Helyesek ezek az adatok?</strong><br>';
                            $user_data .= "$user_row->lastname $user_row->firstname<br>";
                            $user_data .= "$user_row->email<br>";
                            $user_data .= "$user_row->phone<br><br>";
                            $user_data .= '<strong>Számlázási adatok:</strong><br>';

                            if (!$user_row->is_firm_invoice) {
                                // Ha nem céges számla.
                                $user_data .= "$user_row->lastname $user_row->firstname<br>";
                                $user_data .= "$user_row->zip. $user_row->city, $user_row->address";
                                if ($user_row->country != 'HU') {
                                    // Ha nem magyarországi cím, akkor kiírjuk azt ország nevét is.
                                    $user_data .= '<br>' . $country[$user_row->country];
                                }
                                $user_data .= "</p>";
                            } else {
                                // Ha céges számla.
                                $user_data .= "$user_row->firm_name<br>";
                                $user_data .= "$user_row->firm_zip. $user_row->firm_city, $user_row->firm_address<br>";
                                $user_data .= "Adószám: $user_row->firm_taxid</p>";
                            }

                            $form['header_data'] = array(
                                '#type' => 'item',
                                '#markup' => $user_data,
                            );

                            $form['correct'] = array(
                                '#type' => 'submit',
                                '#value' => 'Igen',
                                '#attributes' => array('class' => array(variable_get('membership_class_order_yes_button'))),
                                '#suffix' => '&nbsp;&nbsp;&nbsp;',
                                '#validate' => array('_period_validate_correct'),
                            );

                            $form['not_correct'] = array(
                                '#type' => 'submit',
                                '#value' => 'Nem',
                                '#attributes' => array('class' => array(variable_get('membership_class_order_no_button'))),
                                '#submit' => array('membership_period_not_correct_submit'),
                            );
                        }

                        // Ha az adatok helyesek csak akkor jeleníti meg ezt.
                        if (isset($form_state['storage']['correct'])) {
                            // Beállítjuk a legutolsó választott fizetési módot, ha lehetséges.
                            $form['payment'] = array(
                                '#type' => 'radios',
                                '#title' => 'Fizetési mód',
                                '#description' => '',
                                '#required' => TRUE,
                                '#options' => $possible_payments,
                                '#default_value' => $user_row->last_payment_mode,
                            );

                            if (module_exists('barion_api')) {
                                $cards = membership_user_get_cards($user_row->id);

                                // Show bankcard list if payment method is bankcard
                                $form['card'] = array(
                                    '#type' => 'select',
                                    '#title' => 'Bankkártya',
                                    '#options' => $cards,
                                    '#default_value' => null,
                                    '#states' => array(
                                        'visible' => array(
                                            ':input[name="payment"]' => array('value' => 7),
                                        ),
                                    ),
                                );
                            }

                            if ($upsell != null) {

                                $upsell_prefix = '<div class="upsell-box">';
                                $upsell_suffix = '<div class="upsell-description">' . $upsell['description'] . '</div>'
                                        . '</div>';

                                $form['get_upsell'] = array(
                                    '#type' => 'checkbox',
                                    '#title' => $upsell['title'],
                                    '#attributes' => array('class' => array('upsell-title')),
                                    '#description' => '',
                                    '#required' => FALSE,
                                    '#default_value' => 0,
                                    '#prefix' => $upsell_prefix,
                                    '#suffix' => $upsell_suffix,
                                );
                            }

                            $form['id'] = array(
                                '#type' => 'hidden',
                                '#default_value' => $user_row->id,
                            );

                            $form['submit'] = array(
                                '#type' => 'submit',
                                '#value' => 'Megrendelem',
                                '#attributes' => array('class' => array(variable_get('membership_class_order_order_button'))),
                            );

                            // ÁSZF szöveg
                            $form['terms'] = array(
                                '#type' => 'item',
                                '#markup' => '<small>' . variable_get('membership_terms_conditions') . '</small>',
                            );
                        }
                    } else {
                        // Ha nem felel meg az előfeltételeknek.
                        drupal_set_message(t('Ezt a terméket jelenleg nem rendelheted meg, mert olyan előfeltételei vannak amikkel jelenleg nem rendelkezel.<br>Például egymásra épülő termékek esetén csak a soron következőt vásárolhatod meg. '), 'error');
                    }
                }
            } else {
                // Azonosítatlan látogatóról van szó.
                // Kiíratjuk a megrendelési űrlapot.
                $form['payment'] = array(
                    '#type' => 'radios',
                    '#title' => 'Fizetési mód',
                    '#description' => '',
                    '#required' => TRUE,
                    '#options' => $possible_payments,
                );

                $form['lastname'] = array(
                    '#type' => 'textfield',
                    '#title' => 'Vezetékneved',
                    '#required' => TRUE,
                    '#size' => 32,
                    '#maxlength' => 64,
                );

                $form['firstname'] = array(
                    '#type' => 'textfield',
                    '#title' => 'Utóneved',
                    '#required' => TRUE,
                    '#size' => 32,
                    '#maxlength' => 64,
                );
                $form['email'] = array(
                    '#type' => 'textfield',
                    '#title' => 'E-mail címed',
                    '#required' => TRUE,
                    '#size' => 32,
                    '#maxlength' => 254,
                    '#default_value' => $email,
                    '#element_validate' => array('_validate_email'),
                );
                $form['phone'] = array(
                    '#type' => 'textfield',
                    '#title' => 'Telefonszám',
                    '#required' => TRUE,
                    '#size' => 16,
                    '#maxlength' => 32,
                    '#element_validate' => array('_validate_phone'),
                );
                $form['city'] = array(
                    '#type' => 'textfield',
                    '#title' => 'Város',
                    '#required' => TRUE,
                    '#size' => 32,
                    '#maxlength' => 254,
                );
                $form['address'] = array(
                    '#type' => 'textfield',
                    '#title' => 'Utca és házszám',
                    '#required' => TRUE,
                    '#size' => 32,
                    '#maxlength' => 254,
                );

                $form['zip'] = array(
                    '#type' => 'textfield',
                    '#title' => 'Irányítószám',
                    '#required' => TRUE,
                    '#size' => 6,
                    '#maxlength' => 12,
                );

                $form['country'] = array(
                    '#type' => 'select',
                    '#title' => 'Ország',
                    '#options' => $country,
                    '#required' => TRUE,
                    '#default_value' => 'HU',
                );

                $form['is_not_firm_invoice'] = array(
                    '#type' => 'checkbox',
                    '#title' => 'A számlázási adataim megegyeznek a postázási adataimmal.',
                    '#description' => '',
                    '#required' => FALSE,
                    '#default_value' => 1,
                );

                // A számlázási adatok ha cégről van szó.
                $form['invoicing_data'] = array(
                    '#type' => 'fieldset',
                    '#title' => 'Számlázási adatok',
                    '#collapsible' => FALSE,
                    '#collapsed' => FALSE,
                    '#states' => array(
                        'visible' => array(
                            ':input[name="is_not_firm_invoice"]' => array('checked' => FALSE),
                        ),
                    ),
                );

                $form['invoicing_data']['firm_name'] = array(
                    '#type' => 'textfield',
                    '#title' => 'Cégnév',
                    '#required' => FALSE,
                    '#size' => 32,
                    '#maxlength' => 254,
                    '#element_validate' => array('_validate_firm'),
                );

                $form['invoicing_data']['firm_city'] = array(
                    '#type' => 'textfield',
                    '#title' => 'Város',
                    '#required' => FALSE,
                    '#size' => 32,
                    '#maxlength' => 254,
                    '#element_validate' => array('_validate_firm'),
                );

                $form['invoicing_data']['firm_address'] = array(
                    '#type' => 'textfield',
                    '#title' => 'Utca és házszám',
                    '#required' => FALSE,
                    '#size' => 32,
                    '#maxlength' => 254,
                    '#element_validate' => array('_validate_firm'),
                );

                $form['invoicing_data']['firm_zip'] = array(
                    '#type' => 'textfield',
                    '#title' => 'Irányítószám',
                    '#required' => FALSE,
                    '#size' => 6,
                    '#maxlength' => 12,
                    '#element_validate' => array('_validate_firm'),
                );

                $form['invoicing_data']['firm_taxid'] = array(
                    '#type' => 'textfield',
                    '#title' => 'Adószám',
                    '#required' => FALSE,
                    '#size' => 16,
                    '#maxlength' => 13,
                    '#element_validate' => array('_validate_taxid'),
                );

                if ($upsell != null) {

                    $upsell_prefix = '<div class="upsell-box">';
                    $upsell_suffix = '<div class="upsell-description">' . $upsell['description'] . '</div>'
                            . '</div>';

                    $form['get_upsell'] = array(
                        '#type' => 'checkbox',
                        '#title' => $upsell['title'],
                        '#attributes' => array('class' => array('upsell-title')),
                        '#description' => '',
                        '#required' => FALSE,
                        '#default_value' => 0,
                        '#prefix' => $upsell_prefix,
                        '#suffix' => $upsell_suffix,
                    );
                }

                $form['submit'] = array(
                    '#type' => 'submit',
                    '#value' => 'Megrendelem',
                    '#attributes' => array('class' => array('btn btn-primary btn-large')),
                );

                // ÁSZF szöveg
                $form['terms'] = array(
                    '#type' => 'item',
                    '#markup' => '<small>' . variable_get('membership_terms_conditions') . '</small>',
                );

                // A rejett mezők
                $form['nickname'] = array(
                    '#type' => 'hidden',
                    '#default_value' => $nickname,
                );
            }

            // Közös rejtett mezők. (Azonosított és azonoítatlan felhasználók estéeben is ugyanaz.)
            $form['sid'] = array(
                '#type' => 'hidden',
                '#default_value' => $sid,
            );

            $form['pid'] = array(
                '#type' => 'hidden',
                '#default_value' => $pid,
            );
            $form['hash'] = array(
                '#type' => 'hidden',
                '#default_value' => $hash,
            );

            $form['pgid'] = array(
                '#type' => 'hidden',
                '#default_value' => $product['pgid'],
            );

            $form['price'] = array(
                '#type' => 'hidden',
                '#default_value' => $product['price'],
            );

            $form['shipping'] = array(
                '#type' => 'hidden',
                '#default_value' => $product['shipping'],
            );

            $form['commission'] = array(
                '#type' => 'hidden',
                '#default_value' => $product['commission'],
            );

            $form['vat'] = array(
                '#type' => 'hidden',
                '#default_value' => $product['vat'],
            );
        }
    } else {
        // Ha az űrlap nem kapott megfelelő paramétert, hibaüzenetet írunk ki.
        drupal_goto('/');
        drupal_set_message(t('Hiba történt. A megrendelő űrlap nem kapott megfelelő paramétert. Kérjük vedd fel a kapcsolatot az oldal adminisztrátorával.'), 'error');
    }

    return $form;
}

function _period_validate_correct($element, &$form_state) {
    $form_state['storage']['correct'] = TRUE;
    $form_state['rebuild'] = TRUE;
}

//function membership_period_order_form_validate($form, &$form_state) {
//    global $user;
//    if (!$user->uid) {
//        // Ha nem azonosított felhasználó, akkor gondoskodunk róla, hogy ne adhasson le kétszer rendelést.
//        $email = trim($form_state['values']['email']);
//        $result = db_query('SELECT email FROM {membership_users} WHERE email = :email LIMIT 1', array(':email' => $email,))->fetchAll();
//        if (!empty($result)) {
//            $message = '<strong>Már tag vagy az oldalon!</strong><br><br>';
//            $message .= 'Fontos hogy mielőtt leadsz egy rendelést, <a href="/user">lépj be az oldalon itt</a>, hogy a rendelésed a tagságoddal össze tudjuk kötni.<br>';
//            $message .= 'A belépésed után kattints újra a linkre amivel ide jutottál.<br><br>';
//            $message .= 'Ha elfelejtetted a felhasználóneved vagy a jelszavad az email címed megadásával <a href="/user/password">ezen az oldalon tudsz újat kérni.</a><br>';
//            $message .= 'Ha bármilyen nehézséged van, <a href="/contact">vedd fel velünk a kapcsolatot itt!</a>';
//            form_set_error('email', $message);
//        }
//    }
//}

function membership_period_order_form_submit($form, &$form_state) {
    global $user, $base_url;

    // Ha be van lépve vagy már rendelt valamit...
    if ($user->uid) {
        // Ha azonosított felhasználóról van szó nem az űrlapról
        // hanem az adatbázisból gyűjtjük be az adatait.
        $user_fields = db_query_range('SELECT * FROM {membership_users} WHERE uid = :uid', 0, 1, array(':uid' => $user->uid))->fetchAssoc();

        if (empty($user_fields)) {
            $user_fields = array(
                'email' => isset($form_state['values']['email']) ? $form_state['values']['email'] : $user->mail,
                'uid' => $user->uid,
                'ip' => _get_real_ip(),
                'created' => REQUEST_TIME,
                'lastname' => _capitalize($form_state['values']['lastname']),
                'firstname' => _capitalize($form_state['values']['firstname']),
                'nickname' => ($form_state['values']['nickname'] == '') ? _capitalize($form_state['values']['firstname']) : _capitalize($form_state['values']['nickname']),
                'phone' => trim($form_state['values']['phone']),
                'last_payment_mode' => (int) $form_state['values']['payment'],
                'zip' => trim($form_state['values']['zip']),
                'city' => _capitalize($form_state['values']['city']),
                'address' => trim($form_state['values']['address']), // @TODO Az utcanévre csinálni egy specális kapitalizációs rutint.
                'country' => $form_state['values']['country'],
                'is_firm_invoice' => (int) $is_firm_invoice,
                'firm_name' => ($is_firm_invoice == TRUE) ? trim($form_state['values']['firm_name']) : '',
                'firm_zip' => ($is_firm_invoice == TRUE) ? trim($form_state['values']['firm_zip']) : '',
                'firm_city' => ($is_firm_invoice == TRUE) ? _capitalize($form_state['values']['firm_city']) : '',
                'firm_address' => ($is_firm_invoice == TRUE) ? trim($form_state['values']['firm_address']) : '',
                'firm_taxid' => ($is_firm_invoice == TRUE) ? trim($form_state['values']['firm_taxid']) : '',
                'hash' => _make_hash(),
            );
            $user_fields['id'] = db_insert('membership_users')
                    ->fields($user_fields)
                    ->execute();
        }

        // Beállítjuk a később használt mezőket.
        $id = $user_fields['id'];
        $uid = $user_fields['uid'];

        // Frissíti az utoló választott fizetési módot.
        $num_update = db_update('membership_users')
                ->fields(array('last_payment_mode' => $form_state['values']['payment'],))
                ->condition('id', $id, '=')
                ->execute();
    } else {
        // Ha nem azonosított felhasználóról van szó akkor frissítjük az adatait.
        $email = trim($form_state['values']['email']);
        $id = db_query_range('SELECT id FROM {membership_users} WHERE email = :email', 0, 1, array(':email' => $email,))->fetchField();

        // Ha a felhasználó most rendel először akkor az űrlapról
        // olvassuk be a személyes adatait és elhelyezzük az adatbázisban.
        // Ha céges számlát kér az $is_firm_invoice változót igazra álltjuk.
        if ((int) $form_state['values']['is_not_firm_invoice'] == 0) {
            $is_firm_invoice = TRUE;
        } else {
            $is_firm_invoice = FALSE;
        }
        $user_fields = array(
            'email' => $email,
            'ip' => _get_real_ip(),
            'created' => REQUEST_TIME,
            'lastname' => _capitalize($form_state['values']['lastname']),
            'firstname' => _capitalize($form_state['values']['firstname']),
            'nickname' => ($form_state['values']['nickname'] == '') ? _capitalize($form_state['values']['firstname']) : _capitalize($form_state['values']['nickname']),
            'phone' => trim($form_state['values']['phone']),
            'last_payment_mode' => (int) $form_state['values']['payment'],
            'zip' => trim($form_state['values']['zip']),
            'city' => _capitalize($form_state['values']['city']),
            'address' => trim($form_state['values']['address']), // @TODO Az utcanévre csinálni egy specális kapitalizációs rutint.
            'country' => $form_state['values']['country'],
            'is_firm_invoice' => (int) $is_firm_invoice,
            'firm_name' => ($is_firm_invoice == TRUE) ? trim($form_state['values']['firm_name']) : '',
            'firm_zip' => ($is_firm_invoice == TRUE) ? trim($form_state['values']['firm_zip']) : '',
            'firm_city' => ($is_firm_invoice == TRUE) ? _capitalize($form_state['values']['firm_city']) : '',
            'firm_address' => ($is_firm_invoice == TRUE) ? trim($form_state['values']['firm_address']) : '',
            'firm_taxid' => ($is_firm_invoice == TRUE) ? trim($form_state['values']['firm_taxid']) : '',
            'hash' => _make_hash(),
        );
        $uid = 0;

        if (empty($id)) {
            // Ha az id üres akkor beszúrjuk a user adatokat.
            $id = db_insert('membership_users')
                    ->fields($user_fields)
                    ->execute();
        } else {
            // Ha az Id nem üres a felhasználó nem most rendelt először. Ezért frissítjük az adatait.
            db_merge('membership_users')
                    ->key('id', $id)
                    ->fields($user_fields)
                    ->execute();
        }
    }

    // A megrendelés mezők azonosak mind régi és mind új felhasználók esetén
    // és a többi folyamat innentől kezdve teljesen ugyanaz.
    // Megnézzük, hogy postai küldeményről van-e szó, mert ha igen,
    // Az is_sent mezőt 0-ra kell állítani 3-as helyett.
    if (in_array($form_state['values']['payment'], array(3, 4, 6))) {
        $is_sent = 0;
    } else {
        $is_sent = 3;
    }

    // Check wether the user has previously ordered the product and use promotion term
    $user_used_promo = membership_period_promo_used_by_user($form_state['values']['pid']);

    // Create order
    $order_fields = array(
        'id' => $id,
        'pid' => (int) $form_state['values']['pid'],
        'created' => REQUEST_TIME,
        'ip' => $user_fields['ip'],
        'price' => $form_state['values']['price'],
        'shipping' => $form_state['values']['shipping'],
        'vat' => $form_state['values']['vat'],
        'token' => isset($form_state['values']['card']) && $form_state['values']['card'] != '' ? $form_state['values']['card'] : null,
        'is_sent' => $is_sent,
    );
    if ($user_used_promo) {
        $product = membership_period_product_get_details_object($form_state['values']['pid']);
        $start = date('Y-m-d H:i:s');
        $deadline = membership_get_period_deadline($product, $start);
        $end = $deadline !== null ? date('Y-m-d H:i:s', $deadline) : $deadline;
        $order_fields['start_at'] = $start;
        $order_fields['end_at'] = $end;
    }
    $order = membership_period_order_merge($order_fields);

    // Create promotion period
    if (!$user_used_promo) {
        $promo_fields = array(
            'id' => $id,
            'pid' => (int) $form_state['values']['pid'],
            'poid' => $order->poid,
            'created' => $order->created,
            'token' => $order->token,
            'thank_you' => $order->thank_you,
        );
        $promo = membership_period_promo_merge($promo_fields);
    }

    // Add upsell order
    if (isset($form_state['values']['get_upsell']) && $form_state['values']['get_upsell'] > 0) {
//
//        // Get upsell product
//        $upsell = membership_product_get_upsell_details_object((int) $form_state['values']['pid']);
//
//        // Create upsell order
//        $upsell_order_fields = array(
//            'id' => $id,
//            'pid' => $upsell->upid,
//            'created' => REQUEST_TIME,
//            'ip' => $user_fields['ip'],
//            'sid' => $form_state['values']['sid'],
//            'price' => $upsell->price,
//            'shipping' => $form_state['values']['shipping'],
//            'vat' => $upsell->vat,
//            'token' => isset($form_state['values']['card']) && $form_state['values']['card'] != '' ? $form_state['values']['card'] : null,
//            'is_sent' => $is_sent,
//            'uoid' => $oid,
//        );
//        $upsell_oid = db_insert('membership_orders')->fields($upsell_order_fields)->execute();
//        // A fizetés a korábbihoz hasonlóan fut, viszont az oid-hez lekérjük az upsellt ha van, és úgy rekjuk össze a fizetést
//        // Ha fizetett akkor a visszaérkezésnél ellenőrizzük az összeget, ellenőrizzük, hogy van e upsell termék és megkeressük a megfelelő rendelést
//        // Egyszerre aktiváljuk a két rendelést.
//        //
//        // A szerepkörök, és hírvelek ki-be kikapcsolása.
//        // A name mezőre később van szüksége amikor a Google Analytics e-kereskesdelmi követő
//        // kódjához a paramétereket átadjuk, de hatékonysági okokból itt olvassuk ki az adatbázisból.
//        $upsell_product = db_query('SELECT name, roles_order_add, roles_order_remove, newsletter_order, table_name FROM {membership_products} WHERE pid = :pid', array(':pid' => $upsell_order_fields['pid']))->fetchAssoc();
//
//        // A szerepkörök törlése és hozzáadása.
//        $upsell_roles_remove = unserialize($upsell_product['roles_order_remove']);
//        $upsell_rids = array();
//        foreach ($upsell_roles_remove as $role) {
//            if ($role != 0) {
//                $upsell_rids[] = $role;
//            }
//        }
//        _set_roles($uid, $upsell_rids, 'remove_role');
//
//        $upsell_roles_add = unserialize($upsell_product['roles_order_add']);
//        $upsell_rids = array();
//        foreach ($upsell_roles_add as $role) {
//            if ($role != 0) {
//                $upsell_rids[] = $role;
//            }
//        }
//        _set_roles($uid, $upsell_rids, 'add_role');
    }

    // A szerepkörök, és hírvelek ki-be kikapcsolása.
    // A name mezőre később van szüksége amikor a Google Analytics e-kereskesdelmi követő
    // kódjához a paramétereket átadjuk, de hatékonysági okokból itt olvassuk ki az adatbázisból.
    $product = membership_period_product_get_details_assoc($order_fields['pid']);

    // A szerepkörök törlése és hozzáadása.
//    $roles_manipulated = membership_period_order_manipulate_roles($uid, $product, 0);
    // Felhasználó törlése és hozzáadása a hírlevél listákhoz.
    //
    // Átiránytás beállítása, hogy a köszönöm oldalon a Google Analytics tudja rögzíteni az adatokat.
    $country = db_query('SELECT name FROM {membership_country} WHERE code = :code', array(':code' => $user_fields['country']))->fetchField();
    $product_name = $product['name'];
    $product_group_name = db_query('SELECT name FROM {membership_product_groups} WHERE pgid = :pgid', array(':pgid' => $form_state['values']['pgid']))->fetchField();

    // Redirect to payment out if, the payment method is bankcard
    if (!$user_used_promo) {
        $payment_out = $promo_fields['token'] != '' ? 'promo/payment/out/' . $promo->promo_id . '/' . $promo_fields['token'] : 'promo/payment/out/' . $promo->promo_id;
    } else {
        $payment_out = $order_fields['token'] != '' ? 'period/payment/out/' . $order->poid . '/' . $order_fields['token'] : 'period/payment/out/' . $order->poid;
    }
    $redirect_link = $form_state['values']['payment'] == 7 ? $payment_out : variable_get('membership_thankyou_link');

    $form_state['redirect'] = array($redirect_link,
        array(
            'query' => array(
                'transid' => $order->poid,
                'store' => variable_get('membership_site_name'),
                'total' => $order_fields['price'],
                'tax' => $order_fields['price'] * $order_fields['vat'] / 100,
                'shipping' => $order_fields['shipping'],
                'city' => $user_fields['city'],
                'state' => '',
                'country' => $country,
                'sku' => $order_fields['pid'],
                'name' => $product_name,
                'category' => $product_group_name,
            ),
            'fragment' => '',
        ),
    );

    // E-mail küldés.
    $user_data = db_query_range('SELECT lastname, firstname, email, hash, phone FROM {membership_users} WHERE id = :id', 0, 1, array(':id' => $id))->fetchObject();

    // A felhasználó szinkronizálása active campaign-ban.
//    $ac_response = membership_period_order_manipulate_ac($user_data, $product, 0);
    // Upsell order actions
    if (isset($form_state['values']['get_upsell']) && $form_state['values']['get_upsell'] > 0) {

        // A felhasználó felcímkézése az IM-ben.
        // Az e-mailhez hozzáadjuk a megrendelés címkét. Ha a felhasználó nem létezik,
        // nem történik semmi.
        // im_modifySubscriberLabels($user_data->email, array('M_' . $product['table_name']), array());
        //
        // A felhasználó szinkronizálása active campaign-ban.
        $ac = new ActiveCampaign(variable_get('membership_ac_api_url'), variable_get('membership_ac_api_key'));

        $nl_order = unserialize($upsell_product['newsletter_order']);

        // Címkék összerakása
        $tags_add = explode(',', $nl_order['order_tags_add']);
        $tags_add[] = 'M_' . $upsell_product['table_name'];
        $tags_remove = explode(',', $nl_order['order_tags_remove']);

        // Felhazsnáló és címkék szinkronoizálása.
        $contact = array(
            'email' => $user_data->email,
            'first_name' => $user_data->firstname,
            'last_name' => $user_data->lastname,
            'phone' => $user_data->phone,
            'tags' => $tags_add,
        );
        $contact_sync = $ac->api("contact/sync", $contact);

        // Címkék eltávolítása.
        $post_data = array(
            'email' => $user_data->email,
            'tags' => $tags_remove,
        );
        $response = $ac->api("contact/tag_remove", $post_data);

        // Elindítjuk a felhasználót egy automatizmuson.
        $post_data = array(
            'contact_email' => $user_data->email, // include this or contact_id
            'automation' => $nl_order['newsletter_order'], // one or more
        );

        $response = $ac->api("automation/contact/add", $post_data);
    }

    // Ellenőrizzük, hogy az alert modul be van-e kapcsolva. Ha igen, meghívjuk
    // az SMS küldő rutint, hogy SMS-t küldjünk a rendelésről az
    // ügyfélszolgálatos telefonszámra.
    if (module_exists('alert')) {
        $phone = db_query_range('SELECT phone FROM {membership_users} WHERE id = :id', 0, 1, array(':id' => $id))->fetchField();
        alert_order_sms($oid, "$user_data->lastname $user_data->firstname", $product_name, $phone);
    }

    // Ellenőrizzük, hogy az aff modul be van-e kapcsolva.
    if (module_exists('aff')) {
        // Meghívjuk a modult ami, feljegyzi a rendelést az partnerprogram
        // Adatbázisába, ha a rendelő gépén szerepel egy partner cookie-ja.
        aff_order($product_name, $form_state['values']['commission'], $oid);
    }
}

function membership_period_not_correct_submit($form, &$form_state) {
    $sid = $form_state['values']['sid'];
    $pid = $form_state['values']['pid'];
    $hash = $form_state['values']['hash'];

    $form_state['redirect'] = array('sajat-adatok/edit',
        array(
            'query' => array(
                'sid' => $sid,
                'pid' => $pid,
                'hash' => $hash,
            ),
            'fragment' => '',
        ),
    );
}

/**
 * After payment callback page.
 * @param type integer $oid Order id.
 * @param type integer $payment_id Payment id.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_period_order_payment_in($oid = '', $payment_id = '') {

    global $user;

    // Get arguments
    $oid = check_plain(trim($oid));

    if ($payment_id == '' && isset($_GET['paymentId'])) {
        $payment_id = check_plain($_GET['paymentId']);
    }

    // Get order details
    if ($oid == '' && $payment_id != '') {
        $payment = barion_api_get_payment($payment_id);
        $oid = $payment['oid'];

        // Print a message.
//        drupal_set_message(t('Missing values.'));
    }

    // Build payment details
    $order = membership_order_get_details($oid);
    $upsell_order = membership_upsell_order_get_details($oid);

    // Thank you link
    $thank_you_link = !empty($order['thank_you']) ? $order['thank_you'] : variable_get('membership_thankyou_link');

    if ($payment_id != '') { // Bankkártya esetén
        // Get payment details
        $payment = barion_api_get_payment($payment_id);

        // Generate invoice
        if ($payment['status'] == 1) {

            // Get token id
            $token = db_select('barion_api_tokens', 't')
                    ->fields('t', array('id'))
                    ->condition('t.token', $payment['token'])
                    ->execute()
                    ->fetchField();
//            mdd($payment, true);
            // Update order
            db_update('membership_orders')->fields(array('payment_id' => $payment_id, 'token' => $token))->condition('oid', $oid)->execute();

            // Activate order
            $activate = membership_period_order_activate($oid);

            // If upsell not empty
            if ($upsell_order != null) {
//                // Update order
//                db_update('membership_orders')->fields(array('payment_id' => $payment_id, 'token' => $token))->condition('oid', $upsell_order['oid'])->execute();
//
//                // Activate order
//                $activate_upsell = membership_period_order_activate($upsell_order['oid']);
//
//                if (!$activate_upsell) {
//                    // Save to watchdog.
//                    watchdog('membership', '"%oid" order activation failed.', array('%oid' => $upsell_order['oid'], WATCHDOG_NOTICE));
//
//                    // Print a message.
//                    drupal_set_message(t('Order activation <em>failed</em>.'), 'error');
//                }
            }

            if (!$activate) {
                // Save to watchdog.
                watchdog('membership', '"%oid" order activation failed.', array('%oid' => $oid, WATCHDOG_NOTICE));

                // Print a message.
                drupal_set_message(t('Order activation <em>failed</em>.'), 'error');
            }

            // Run Active Campaign sync
            // certify_ac_sync($order['uid'], 'activate');
            // Print a message.
            drupal_set_message(t('Checkout finished <em>success</em>.'));

            // Save to watchdog.
            watchdog('membership', '"%oid" checkout finished with Barion payment.', array('%oid' => $oid, WATCHDOG_NOTICE));

            // Redirect to thank you page
            membership_redirect_to_thank_you($oid, $thank_you_link);
        } else {

            // Save to watchdog.
            watchdog('barion_api', '"%oid" order is failed. Payment id: %pid', array('%oid' => $oid, '%pid' => $payment_id, WATCHDOG_NOTICE));

            // Print a message.
            drupal_set_message(t('A fizetés sajnos <em>nem sikerült.</em> Kérlek próbáld meg újra.'), 'warning');

            // Delete membership user and order.
            db_delete('membership_orders')
                    ->condition('oid', $oid)
                    ->execute();

            if ($upsell_order != null) {
                db_delete('membership_orders')
                        ->condition('oid', $upsell_order['oid'])
                        ->execute();
            }

            db_delete('membership_users')
                    ->condition('id', $order['id'])
                    ->condition('uid', '0')
                    ->execute();

            // Redirect to thank you page
            $pid = $order['pid'];
            membership_redirect_to_order_form($pid);
        }
    } else {

        // Drupal set message
        drupal_set_message(t('Error! Something went wrong with pay "%oid" order. Please try again.', array('@oid' => $order['oid'])));

        // Save to watchdog.
        watchdog('membership', 'Error! Something went wrong with pay "%oid" order.<br>Token id: %token', array('%oid' => $order['oid'], '%token' => $token, WATCHDOG_NOTICE));

        // Redirect to order start
        drupal_goto('/payment/out/' . $oid);
    }
}

/**
 * Prepare Barion payment.
 * @param type integer $poid Order id
 * @param type integer $token Used card token id
 * @return integer or array Percentage level.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_period_order_payment_out($poid, $token = '') {

    global $user;

    // Get arguments
    $oid = check_plain(trim($poid));
    $token = check_plain(trim($token));

    // Get order details
    if ($oid == '') {

        // Print a message.
        drupal_set_message(t('Missing order id.'));

        // Redirect to order start
        // drupal_goto('certify/order/1');
        echo '<script>history.back()</script>';
    }

    // Build payment details
    $order = membership_period_order_get_details_assoc($oid);

    if ($token == '') {
        $token = $order['token'];
    }

    if ($order['is_firm_invoice'] === 1) {
//        $address = $order['firm_city'] . ', ' . $order['firm_address'];
        $address = [
            'country' => $order['country'],
            'city' => $order['firm_city'],
            'zip' => $order['firm_zip'],
            'street' => substr($order['firm_address'], 0, 49)
        ];
    } else {
        $address = [
            'country' => $order['country'],
            'city' => $order['city'],
            'zip' => $order['zip'],
            'street' => substr($order['address'], 0, 49)
        ];
    }

    $payment['oid'] = $order['poid'];
    $payment['order_table'] = 'membership_period_orders';
    $payment['uid'] = $order['id'];
    $payment['item'] = array(
        'name' => $order['name'],
        'description' => $order['proforma_name'],
        'quantity' => 1,
        'unit' => t('db'),
        'unitprice' => intval($order['price']),
        'itemtotal' => intval($order['price']),
        'sku' => 'ITEM-' . $order['pid'] . '-' . $order['hash']
    );
    $payment['transaction'] = array(
        'title' => $order['name'],
        'total' => intval($order['price']),
        'hash' => 'TR-' . barion_api_get_transaction_unique_hash()
    );
    $payment['payment'] = array(
        'oid' => $order['poid'],
        'hash' => 'PR-' . barion_api_get_payment_unique_hash(),
        'usermail' => $order['email'],
        'shipping' => $address,
    );

    if ($token == '' || $token == null) { // Bankkártya esetén
        barion_api_payment_request($payment, false, function($myPayment) use ($order) {
            db_update('membership_period_orders')
                    ->condition('poid', $order['poid'])
                    ->fields(['payment_id' => $myPayment->PaymentId])
                    ->execute();
        });
    } else { // One click esetén
        // Get token string
        $token = barion_api_get_token($token);

        barion_api_payment_request($payment, $token, function($myPayment) use ($order) {
            db_update('membership_period_orders')
                    ->condition('poid', $order['poid'])
                    ->fields(['payment_id' => $myPayment->PaymentId])
                    ->execute();
        });
    }
}

/**
 * Add new order to user.
 * @param type $form
 * @param type $form_state
 * @return type
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_period_add_order_form($form, &$form_state, $account) {

    $user_data = membership_user_details_object_by_uid($account->uid);
    $products = membership_get_period_products_list();

    if (!isset($form_state['storage']['order_prepared'])) {

        $text = '<p>Add meg a felhasználó azonosítóját, válaszd ki a tananyagot, és add meg a tananyag árát! Akkor is meg kell adnod, ha az ár a régi maradt.</p>'
                . '<p>A rendszer létre fogja hozni a terméket. (Nem küld róla automatikusan e-mailt a felhasználónak.)</p>';

        $form['description'] = array(
            '#type' => 'item',
            '#markup' => $text,
        );

        $form['uid'] = array(
            '#title' => t('Felhasználó azonosító'),
            '#type' => 'textfield',
            '#maxlength' => 10,
            '#required' => TRUE,
            '#default_value' => $user_data->id,
            '#element_validate' => array('membership_element_validate_positive_number'),
        );

        $form['product'] = array(
            '#title' => t('Termék'),
            '#description' => t('Válassz terméket.'),
            '#type' => 'select',
            '#maxlength' => 6,
            '#options' => $products,
            '#required' => TRUE,
        );

        $form['price'] = array(
            '#title' => t('Ár(Ft)'),
            '#type' => 'textfield',
            '#maxlength' => 6,
            '#required' => TRUE,
            '#element_validate' => array('membership_element_validate_positive_number_or_zero'),
        );

        $form['submit'] = array(
            '#type' => 'submit',
            '#value' => 'Rendelés',
            '#validate' => array('membership_period_add_order_form_validate'),
            '#submit' => array('membership_period_add_order_form_confirm'),
        );
    } else {
        $product = $form_state['storage']['product'];
        $account = $form_state['storage']['user'];
        $confirm = '<h2>Helyesek ezek az adatok?</h2><br>';
        $confirm .= "<h3>$account->lastname $account->firstname ($account->email)</h3>";
        $confirm .= "<p><strong>$product->name:</strong> <s>$product->price Ft</s> ⇒ " . _membership_format_price($form_state['storage']['price']) . "</p>";

        $form['header_data'] = array(
            '#type' => 'item',
            '#markup' => $confirm,
        );

        $form['submit'] = array(
            '#type' => 'submit',
            '#value' => 'Igen, beküldés',
            '#attributes' => array('class' => array('btn-success')),
            '#submit' => array('membership_period_add_order_form_submit'),
        );
    }

    return $form;
}

/**
 * Validate order form.
 * @param type $form
 * @param type $form_state
 * @return type
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_period_add_order_form_validate($form, &$form_state) {
    $error = FALSE;
    if (!isset($form_state['storage']['order_prepared'])) {
        // Validate the form product id.
        if (empty($form_state['values']['uid']) || empty($form_state['values']['product']) || $form_state['values']['price'] == '') {
            $error = TRUE;
            form_set_error('price', t('Hiányzó paraméterek!'));
        }

        // Validate the form user id.
        $user = membership_user_details_object($form_state['values']['uid']);
        if (!$user) {
            $error = TRUE;
            form_set_error('uid', t('Nem létező felhasználó!'));
        }

        // Validate the form product id.
        $product = membership_period_product_get_details_object($form_state['values']['product']);
        if (!$product) {
            $error = TRUE;
            form_set_error('product', t('Nem létező termék!'));
        }
    }
}

/**
 * Confirm order form.
 * @param type $form
 * @param type $form_state
 * @return type
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_period_add_order_form_confirm($form, &$form_state) {

    $account = membership_user_details_object($form_state['values']['uid']);
    $product = membership_period_product_get_details_object($form_state['values']['product']);
    if (!isset($form_state['storage']['order_prepared'])) {
        $form_state['storage']['product'] = $product;
        $form_state['storage']['user'] = $account;
        $form_state['storage']['price'] = $form_state['values']['price'];
        $form_state['storage']['order_prepared'] = TRUE;
        $form_state['rebuild'] = TRUE;
    }
}

/**
 * Add order form submit.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_period_add_order_form_submit(&$form, &$form_state) {
    global $user;

    // Insert order
    if (!empty($form_state['storage']['product']) && !empty($form_state['storage']['user'])) {
        $fields = array(
            'id' => $form_state['storage']['user']->id,
            'pid' => $form_state['storage']['product']->pid,
            'created' => REQUEST_TIME,
            'ip' => _get_real_ip(),
            'price' => $form_state['storage']['price'],
            'shipping' => 0,
            'vat' => $form_state['storage']['product']->vat,
            'is_activated' => 0,
            'closed' => 0,
            'token' => isset($form_state['values']['card']) && $form_state['values']['card'] != '' ? $form_state['values']['card'] : null,
            'is_sent' => 3,
            'is_invoiced' => 0,
        );
        db_insert('membership_period_orders')->fields($fields)->execute();
        drupal_set_message('A rendelés beküldve.');
    } else {
        drupal_set_message('<strong>Hiba:</strong> Hibás adatok! Nem létező felhasználó vagy termék.', 'error');
    }

    // Redirect.
    // $form_state['redirect'] = array('certify/companies', array('query' => array(),'fragment' => '',),);
    // Print a message.
    // drupal_set_message(t('<em>Megrendelés</em> létrehozása sikeres.'));
    // Save to watchdog.
    watchdog('membership', '%product megrendelés létrehozva a %uid azonsítójú felhasználónak %user által.', array('%uid' => $form_state['storage']['user']->id,
        '%product' => $form_state['storage']['product']->name, '%user' => $user->name, WATCHDOG_NOTICE));
}

/**
 * Delete order.
 * @param type $form
 * @param type $form_state
 * @param type $oid Order id.
 * @return type
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_period_delete_order_form($form, &$form_state, $oid = '') {

    if (!isset($form_state['storage']['delete_prepared']) && $oid != '') {

        $query = db_select('membership_period_orders', 'o');
        $query->join('membership_users', 'u', 'o.id = u.id');
        $query->join('membership_period_products', 'p', 'o.pid = p.pid');
        $query->fields('o', array('price', 'is_activated', 'poid'));
        $query->fields('u', array('lastname', 'firstname', 'email'));
        $query->fields('p', array('name'));
        $query->condition('o.poid', check_plain($oid));
        $order_object = $query->execute()->fetchObject();

        $form_state['storage']['order'] = $order_object;
        $form_state['storage']['delete_prepared'] = TRUE;
        $form_state['rebuild'] = TRUE;
    }

    if (!isset($form_state['storage']['delete_prepared'])) {

        $text = '<p>Add meg a rendelés azonosítót a rendelés törléséhez.</p>';

        $form['description'] = array(
            '#type' => 'item',
            '#markup' => $text,
        );

        $form['poid'] = array(
            '#title' => t('Rendelés azonosító (poid)'),
            '#type' => 'textfield',
            '#maxlength' => 10,
            '#required' => TRUE,
            '#element_validate' => array('membership_element_validate_poid'),
        );

        $form['submit'] = array(
            '#type' => 'submit',
            '#value' => t('Keresés'),
            '#submit' => array('membership_period_delete_order_form_confirm'),
        );
    } else {

        $order = $form_state['storage']['order'];
        $confirm = '<h2>Biztosan törlöd a rendelést?</h2><br>';
        $confirm .= "<p>$order->lastname $order->firstname ($order->email)</p>";
        $confirm .= "<p>$order->poid ⇒ <strong>$order->name:</strong> " . _membership_format_price($order->price) . "</p>";

        $form['header_data'] = array(
            '#type' => 'item',
            '#markup' => $confirm,
        );

        $form['submit'] = array(
            '#type' => 'submit',
            '#value' => t('Igen, törlés'),
            '#attributes' => array('class' => array('btn-warning')),
            '#submit' => array('membership_period_delete_order_form_submit'),
        );
    }

    return $form;
}

/**
 * Confirm delete order.
 * @param type $form
 * @param type $form_state
 * @return type
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_period_delete_order_form_confirm($form, &$form_state) {

    if (!isset($form_state['storage']['delete_prepared'])) {

        $query = db_select('membership_period_orders', 'o');
        $query->join('membership_users', 'u', 'o.id = u.id');
        $query->join('membership_period_products', 'p', 'o.pid = p.pid');
        $query->fields('o', array('price', 'is_activated', 'poid'));
        $query->fields('u', array('lastname', 'firstname', 'email'));
        $query->fields('p', array('name'));
        $query->condition('o.poid', $form_state['values']['poid']);
        $order = $query->execute()->fetchObject();

        $form_state['storage']['order'] = $order;
        $form_state['storage']['delete_prepared'] = TRUE;
        $form_state['rebuild'] = TRUE;
    }
}

/**
 * Delete order form submit.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_period_delete_order_form_submit(&$form, &$form_state) {
    global $user;

    // Insert order
    if (!empty($form_state['storage']['order'])) {

        $order = membership_period_order_get_details_object($form_state['storage']['order']->poid);
        $muser = membership_user_details_object($order->id);

        db_delete('membership_period_orders')->condition('poid', $form_state['storage']['order']->poid)->execute();

        $form_state['redirect'] = array('user/' . $muser->uid . '/sajat-adatok', array('query' => '', 'fragment' => '',),);

        drupal_set_message('A rendelés törölve.');
    } else {
        drupal_set_message('<strong>Hiba:</strong> Hibás adatok! Nem létező megrendelés.', 'error');
    }

    // Redirect.
    // $form_state['redirect'] = array('certify/companies', array('query' => array(),'fragment' => '',),);
    // Print a message.
    // drupal_set_message(t('<em>Megrendelés</em> létrehozása sikeres.'));
    // Save to watchdog.
    watchdog('membership', '%oid előfizetés törölve %user által.', array('%oid' => $form_state['storage']['order']->poid, '%user' => $user->name, WATCHDOG_NOTICE));
}

/**
 * Period order close.
 * @param number $poid Order id.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_period_order_closing($poid) {
    $order = membership_period_order_get_details_object(check_plain($poid));
    if (empty($order)) {
        // Ha nincs id
        drupal_set_message('Hiányzó azonosító!', 'error');
    } else {
        membership_period_order_full_close($poid);
    }
    drupal_goto('user/' . $order->uid . '/sajat-adatok', array('query' => array()));
}
