<?php

/**
 * @file
 * A megrendelők listázása.
 *
 */

/**
 * A megrendelők listázása.
 */
function membership_user_list_form($form, &$form_state) {
    // A paraméterek beolvasása.
    if (isset($_GET['id']))
        $id = $_GET['id'];
    else
        $id = '';
    if (isset($_GET['lastname']))
        $lastname = $_GET['lastname'];
    else
        $lastname = '';
    if (isset($_GET['firstname']))
        $firstname = $_GET['firstname'];
    else
        $firstname = '';
    if (isset($_GET['firm_name']))
        $firm_name = $_GET['firm_name'];
    else
        $firm_name = '';
    if (isset($_GET['email']))
        $email = $_GET['email'];
    else
        $email = '';

    $form = array();

    $form['id'] = array(
        '#type' => 'textfield',
        '#title' => 'Azonosító',
        '#required' => FALSE,
        '#size' => 16,
        '#maxlength' => 10,
        '#prefix' => '<table><tr><td>',
        '#suffix' => '</td>',
        '#default_value' => $id,
    );

    $form['lastname'] = array(
        '#type' => 'textfield',
        '#title' => 'Vezetéknév',
        '#required' => FALSE,
        '#size' => 16,
        '#maxlength' => 64,
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#default_value' => $lastname,
    );

    $form['firstname'] = array(
        '#type' => 'textfield',
        '#title' => 'Utónév',
        '#required' => FALSE,
        '#size' => 16,
        '#maxlength' => 64,
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#default_value' => $firstname,
    );

    $form['firm_name'] = array(
        '#type' => 'textfield',
        '#title' => 'Cégnév',
        '#required' => FALSE,
        '#size' => 16,
        '#maxlength' => 254,
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#default_value' => $firm_name,
    );

    $form['email'] = array(
        '#type' => 'textfield',
        '#title' => 'E-mail cím',
        '#required' => FALSE,
        '#size' => 16,
        '#maxlength' => 254,
        '#prefix' => '<td>',
        '#suffix' => '</td></tr></table>',
        '#default_value' => $email,
    );

    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => 'Keresés',
    );

    // Tábla elkészítése
    $header = array(
        array('data' => t('Azonosító'), 'field' => 'id', 'sort' => 'asc'),
        array('data' => t('Vezetéknév'), 'field' => 'lastname', 'sort' => 'asc'),
        array('data' => t('Utónév'), 'field' => 'firstname', 'sort' => 'asc'),
        array('data' => t('Cégnév'), 'field' => 'firm_name', 'sort' => 'asc'),
        array('data' => t('E-mail cím'), 'field' => 'email', 'sort' => 'asc'),
        array('data' => t('Műveletek')),
    );

    $users = db_select('membership_users', 'u')
            ->fields('u', array('id', 'lastname', 'firstname', 'firm_name', 'email'))
            ->condition('id', "%$id%", 'LIKE')
            ->condition('lastname', "%$lastname%", 'LIKE')
            ->condition('firstname', "%$firstname%", 'LIKE')
            ->condition('firm_name', "%$firm_name%", 'LIKE')
            ->condition('email', "%$email%", 'LIKE')
            ->extend('PagerDefault')
            ->limit(variable_get('membership_list_limit_users'))
            ->extend('TableSort')
            ->orderByHeader($header)
            ->execute();

    $rows = array();

    foreach ($users as $value) {
        $links = l(t('Saját Adatok'), 'sajat-adatok', array('query' => array('id' => $value->id)));

        $rows[] = array(
            'data' => array(
                $value->id,
                $value->lastname,
                $value->firstname,
                $value->firm_name,
                $value->email,
                $links,
            )
        );
    }

    $form['table'] = array(
        '#theme' => 'table',
        '#header' => $header,
        '#rows' => $rows,
        '#empty' => t('Nincsenek találatok.'),
        '#attributes' => array('class' => array('table table-striped table-bordered table-condensed'))
    );
    $form['pager'] = array('#markup' => theme('pager'));

    return $form;
}

function membership_user_list_form_submit($form, &$form_state) {
    $form_state['redirect'] = array('admin/config/membership/list',
        array('query' => array(
                'id' => $form_state['values']['id'],
                'lastname' => $form_state['values']['lastname'],
                'firstname' => $form_state['values']['firstname'],
                'firm_name' => $form_state['values']['firm_name'],
                'email' => $form_state['values']['email'],
            ),
            'fragment' => '',),
    );
}

/**
 * A megrendelők listázása.
 */
function membership_order_list_form($form, &$form_state) {
    // A paraméterek beolvasása.
    if (isset($_GET['id']))
        $id = $_GET['id'];
    else
        $id = '';
    if (isset($_GET['lastname']))
        $lastname = $_GET['lastname'];
    else
        $lastname = '';
    if (isset($_GET['firstname']))
        $firstname = $_GET['firstname'];
    else
        $firstname = '';
    if (isset($_GET['email']))
        $email = $_GET['email'];
    else
        $email = '';
    if (isset($_GET['from']))
        $from = $_GET['from'];
    else
        $from = '';
    if (isset($_GET['to']))
        $to = $_GET['to'];
    else
        $to = '';
    if (isset($_GET['product']))
        $product = $_GET['product'];
    else
        $product = '';
    if (isset($_GET['is_activated']))
        $is_activated = $_GET['is_activated'];
    else
        $is_activated = '';

    // Beolvassa a termékek listáját
    $products = db_query('SELECT pid, name FROM {membership_products}')->fetchAllKeyed();
    $products[0] = '- Összes termék -';
    ksort($products);

    $form = array();

    $form['id'] = array(
        '#type' => 'textfield',
        '#title' => 'Azonosító',
        '#required' => FALSE,
        '#size' => 16,
        '#maxlength' => 10,
        '#prefix' => '<table><tr><td>',
        '#suffix' => '</td>',
        '#default_value' => $id,
    );

    $form['lastname'] = array(
        '#type' => 'textfield',
        '#title' => 'Vezetéknév',
        '#required' => FALSE,
        '#size' => 16,
        '#maxlength' => 64,
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#default_value' => $lastname,
    );

    $form['firstname'] = array(
        '#type' => 'textfield',
        '#title' => 'Utónév',
        '#required' => FALSE,
        '#size' => 16,
        '#maxlength' => 64,
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#default_value' => $firstname,
    );

    $form['email'] = array(
        '#type' => 'textfield',
        '#title' => 'E-mail cím',
        '#required' => FALSE,
        '#size' => 16,
        '#maxlength' => 254,
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#default_value' => $email,
    );

    $form['from'] = array(
        '#type' => 'textfield',
        '#title' => 'Ettől a dátumtól',
        '#required' => FALSE,
        '#size' => 16,
        '#maxlength' => 64,
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#default_value' => $from,
    );

    $form['to'] = array(
        '#type' => 'textfield',
        '#title' => 'Eddig a dátumig',
        '#required' => FALSE,
        '#size' => 16,
        '#maxlength' => 64,
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#default_value' => $to,
    );

    $form['product'] = array(
        '#type' => 'select',
        '#title' => 'Termék',
        '#prefix' => '<td>',
        '#options' => $products,
    );

    $form['is_activated'] = array(
        '#type' => 'select',
        '#title' => 'Aktiváva van',
        '#prefix' => '<td>',
        '#suffix' => '</td></tr></table>',
        '#options' => array(0 => 'Nem', 1 => 'Igen'),
        '#default_value' => $is_activated,
    );

    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => 'Keresés',
    );

    // Tábla elkészítése
    $header = array(
        array('data' => t('Azonosító'), 'field' => 'id',),
        array('data' => t('Vezetéknév'), 'field' => 'lastname',),
        array('data' => t('Utónév'), 'field' => 'firstname',),
        array('data' => t('E-mail cím'), 'field' => 'email',),
        array('data' => t('Termék'), 'field' => 'product',),
        array('data' => t('Ára'), 'field' => 'price',),
        array('data' => t('Rendelés dátuma'), 'field' => 'created', 'sort' => 'desc'),
        array('data' => t('Aktiválva'), 'field' => 'is_active'),
        array('data' => t('Csekk küldés'), 'field' => 'is_sent'),
        array('data' => t('Műveletek')),
    );

    $tsfrom = strtotime($from);
    $tsto = strtotime($to);

    $query = db_select('membership_users', 'u');
    $query->join('membership_orders', 'o', 'u.id = o.id');
    $query->fields('u', array('id', 'lastname', 'firstname', 'email'))
            ->fields('o', array('id', 'pid', 'created', 'price', 'is_activated', 'is_sent'))
            ->condition('u.id', "%$id%", 'LIKE')
            ->condition('lastname', "%$lastname%", 'LIKE')
            ->condition('firstname', "%$firstname%", 'LIKE')
            ->condition('email', "%$email%", 'LIKE');
    if ($from != '') {
        $query->condition('created', $tsfrom, '<');
    }
    if ($to != '') {
        $query->condition('created', $tsto, '>');
    }
    if ($product != '') {
        $query->condition('pid', $product, '=');
    }
    if ($is_activated != '') {
        if ($is_activated == 0) {
            $query->condition('is_activated', 0, '=');
        } else {
            $query->condition('is_activated', $is_activated, '<');
        }
    }
    $users = $query->extend('PagerDefault')
            ->limit(variable_get('membership_list_limit_users'))
            ->extend('TableSort')
            ->orderByHeader($header)
            ->execute();

    $page = membership_get_page();
    $rows = array();

    foreach ($users as $value) {
        $links = l(t('Saját Adatok'), 'sajat-adatok', array('query' => array('id' => $value->id)));

        switch ($value->is_sent) {
            case 0:
                //$is_sent = 'Kiküldésre vár';
                $is_sent = l(t('Kiküldésre vár'), 'admin/config/membership/change_check', array('query' => array('id' => $value->id, 'page' => $page)));
                break;
            case 1:
                //$is_sent = 'Kiküldve';
                $is_sent = l(t('Kiküldve'), 'admin/config/membership/change_check', array('query' => array('id' => $value->id, 'page' => $page)));
                break;
            case 3:
                $is_sent = 'Nem csekkes';
                break;
        }
        $rows[] = array(
            'data' => array(
                $value->id,
                $value->lastname,
                $value->firstname,
                $value->email,
                isset($products[$value->pid]) ? $products[$value->pid] : '',
                ($value->price != 0) ? $value->price . ' Ft' : '-',
                date('Y-m-d | H:i:s', $value->created),
                ($value->is_activated != 0) ? date('Y-m-d H:i:s', $value->is_activated) : 'Nem',
                $is_sent,
                $links,
            )
        );
    }

    $form['table'] = array(
        '#theme' => 'table',
        '#header' => $header,
        '#rows' => $rows,
        '#empty' => t('Nincsenek találatok.'),
        '#attributes' => array('class' => array('table table-striped table-bordered table-condensed'))
    );
    $form['pager'] = array('#markup' => theme('pager'));

    return $form;
}

function membership_order_list_form_submit($form, &$form_state) {
    $form_state['redirect'] = array('admin/config/membership/order_list',
        array('query' => array(
                'id' => $form_state['values']['id'],
                'lastname' => $form_state['values']['lastname'],
                'firstname' => $form_state['values']['firstname'],
                'email' => $form_state['values']['email'],
                'from' => $form_state['values']['from'],
                'to' => $form_state['values']['to'],
                'product' => ($form_state['values']['product'] == 0) ? '' : $form_state['values']['product'],
                'is_activated' => $form_state['values']['is_activated'],
            ),
            'fragment' => '',),
    );
}

function membership_change_check() {
    $page = membership_get_page();
    if (!isset($_GET['id'])) {
        // Ha nincs id
        drupal_set_message('Hiányzó azonosító!', 'error');
    } else {
        $id = trim(check_plain($_GET['id']));
        $order = db_query_range('SELECT id, is_sent FROM {membership_orders} WHERE id = :id', 0, 1, array(':id' => $id))->fetchObject();
        if (empty($order)) {
            drupal_set_message('hibás azonosító!', 'error');
        } else {
            if ($order->is_sent == 0) {
                $order->is_sent = 1;
            } else {
                $order->is_sent = 0;
            }
            db_update('membership_orders')->fields(array('is_sent' => $order->is_sent))->condition('id', $id, '=')->execute();
        }
    }
    drupal_goto('admin/config/membership/order_list', array('page' => $page));
}

function membership_change_close() {
    $page = membership_get_page();
    if (!isset($_GET['poid'])) {
        // Ha nincs id
        drupal_set_message('Hiányzó azonosító!', 'error');
    } else {
        $poid = trim(check_plain($_GET['poid']));
        $order = db_query_range('SELECT poid, closed FROM {membership_period_orders} WHERE poid = :poid', 0, 1, array(':poid' => $poid))->fetchObject();
        if (empty($order)) {
            drupal_set_message('hibás azonosító!', 'error');
        } else {
            if ($order->closed == 0) {
                $order->closed = 1;
            } else {
                $order->closed = 0;
            }
            db_update('membership_period_orders')->fields(array('closed' => $order->closed))->condition('poid', $poid, '=')->execute();
        }
    }
    drupal_goto('admin/config/membership/period/orders', array('query' => array('page' => $page)));
}

/**
 * Beoldvassa a lapozó paramétert az oldalról (page) és visszaadja tisztítás
 * után.
 *
 * @return string
 * Az olal azonosító sorszáma.
 */
function membership_get_page() {
    if (isset($_GET['page'])) {
        $page = trim(check_plain($_GET['page']));
    } else {
        $page = '';
    }
    return $page;
}

/**
 * Az előfizetéses megrendelések listázása.
 */
function membership_period_order_list_form($form, &$form_state) {
    // A paraméterek beolvasása.
    if (isset($_GET['poid']))
        $poid = $_GET['poid'];
    else
        $poid = '';
    if (isset($_GET['id']))
        $id = $_GET['id'];
    else
        $id = '';
    if (isset($_GET['lastname']))
        $lastname = $_GET['lastname'];
    else
        $lastname = '';
    if (isset($_GET['firstname']))
        $firstname = $_GET['firstname'];
    else
        $firstname = '';
    if (isset($_GET['email']))
        $email = $_GET['email'];
    else
        $email = '';
    if (isset($_GET['from']))
        $from = $_GET['from'];
    else
        $from = '';
    if (isset($_GET['to']))
        $to = $_GET['to'];
    else
        $to = '';
    if (isset($_GET['product']))
        $product = $_GET['product'];
    else
        $product = '';
    if (isset($_GET['is_activated']))
        $is_activated = $_GET['is_activated'];
    else
        $is_activated = '';

    // Beolvassa a termékek listáját
    $products = db_query('SELECT pid, name FROM {membership_period_products}')->fetchAllKeyed();
    $products[0] = '- Összes termék -';
    ksort($products);

    $form = array();

    $form['poid'] = array(
        '#type' => 'textfield',
        '#title' => 'POID',
        '#required' => FALSE,
        '#size' => 5,
        '#maxlength' => 10,
        '#prefix' => '<table><tr><td>',
        '#suffix' => '</td>',
        '#default_value' => $poid,
    );

    $form['id'] = array(
        '#type' => 'textfield',
        '#title' => 'MUID',
        '#required' => FALSE,
        '#size' => 5,
        '#maxlength' => 10,
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#default_value' => $id,
    );

    $form['lastname'] = array(
        '#type' => 'textfield',
        '#title' => 'Vezetéknév',
        '#required' => FALSE,
        '#size' => 16,
        '#maxlength' => 64,
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#default_value' => $lastname,
    );

    $form['firstname'] = array(
        '#type' => 'textfield',
        '#title' => 'Utónév',
        '#required' => FALSE,
        '#size' => 16,
        '#maxlength' => 64,
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#default_value' => $firstname,
    );

    $form['email'] = array(
        '#type' => 'textfield',
        '#title' => 'E-mail cím',
        '#required' => FALSE,
        '#size' => 16,
        '#maxlength' => 254,
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#default_value' => $email,
    );

    $form['from'] = array(
        '#type' => 'textfield',
        '#title' => 'Ettől a dátumtól',
        '#required' => FALSE,
        '#size' => 16,
        '#maxlength' => 64,
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#default_value' => $from,
    );

    $form['to'] = array(
        '#type' => 'textfield',
        '#title' => 'Eddig a dátumig',
        '#required' => FALSE,
        '#size' => 16,
        '#maxlength' => 64,
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#default_value' => $to,
    );

    $form['product'] = array(
        '#type' => 'select',
        '#title' => 'Termék',
        '#prefix' => '<td>',
        '#options' => $products,
    );

    $form['is_activated'] = array(
        '#type' => 'select',
        '#title' => 'Aktiváva van',
        '#prefix' => '<td>',
        '#suffix' => '</td></tr></table>',
        '#options' => array(0 => 'Nem', 1 => 'Igen'),
        '#default_value' => $is_activated,
    );

    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => 'Keresés',
    );

    // Tábla elkészítése
    $header = array(
        array('data' => t('POID'), 'field' => 'poid',),
        array('data' => t('MUID'), 'field' => 'id',),
        array('data' => t('Vezetéknév'), 'field' => 'lastname',),
        array('data' => t('Utónév'), 'field' => 'firstname',),
        array('data' => t('E-mail cím'), 'field' => 'email',),
        array('data' => t('Termék'), 'field' => 'product',),
        array('data' => t('Ára'), 'field' => 'price',),
        array('data' => t('Rendelés dátuma'), 'field' => 'created', 'sort' => 'desc'),
        array('data' => t('Aktiválva'), 'field' => 'is_active'),
        array('data' => t('Lezárt'), 'field' => 'closed'),
        array('data' => t('Műveletek')),
    );

    $tsfrom = strtotime($from);
    $tsto = strtotime($to);

    $query = db_select('membership_users', 'u');
    $query->join('membership_period_orders', 'o', 'u.id = o.id');
    $query->fields('u', array('id', 'lastname', 'firstname', 'email', 'uid'))
            ->fields('o', array('poid', 'id', 'pid', 'created', 'price', 'is_activated', 'closed', 'start_at', 'end_at'))
            ->condition('o.poid', "%$poid%", 'LIKE')
            ->condition('u.id', "%$id%", 'LIKE')
            ->condition('lastname', "%$lastname%", 'LIKE')
            ->condition('firstname', "%$firstname%", 'LIKE')
            ->condition('email', "%$email%", 'LIKE');
    if ($from != '') {
        $query->condition('o.created', $tsfrom, '<');
    }
    if ($to != '') {
        $query->condition('o.created', $tsto, '>');
    }
    if ($product != '') {
        $query->condition('o.pid', $product, '=');
    }
    if ($is_activated != '') {
        if ($is_activated == 0) {
            $query->condition('o.is_activated', 0, '=');
        } else {
            $query->condition('o.is_activated', 0, '!=');
        }
    }
    $users = $query->extend('PagerDefault')
            ->limit(variable_get('membership_list_limit_users'))
            ->extend('TableSort')
            ->orderByHeader($header)
            ->execute();

    $page = membership_get_page();
    $rows = array();

    foreach ($users as $value) {
        if ($value->uid != 0) {
            $links = l(t('Saját Adatok'), 'user/' . $value->uid . '/sajat-adatok', array('query' => array('id' => $value->id)));
        } else {
            $links = l(t('Saját Adatok'), 'sajat-adatok', array('query' => array('id' => $value->id)));
        }

        switch ($value->closed) {
            case 0:
                $closed = l(t('Folyamatban'), 'admin/config/membership/period/change_close', array('query' => array('poid' => $value->poid, 'page' => $page)));
                break;
            case 1:
                $closed = l(t('Lezárt'), 'admin/config/membership/period/change_close', array('query' => array('poid' => $value->poid, 'page' => $page)));
                break;
        }
        $rows[] = array(
            'data' => array(
                $value->poid,
                $value->id,
                $value->lastname,
                $value->firstname,
                $value->email,
                isset($products[$value->pid]) ? $products[$value->pid] : '',
                ($value->price != 0) ? $value->price . ' Ft' : '-',
                date('Y-m-d | H:i:s', $value->created),
                ($value->is_activated != 0) ? date('Y-m-d H:i:s', $value->is_activated) : 'Nem',
                $closed,
                $links,
            )
        );
    }

    $form['table'] = array(
        '#theme' => 'table',
        '#header' => $header,
        '#rows' => $rows,
        '#empty' => t('Nincsenek találatok.'),
        '#attributes' => array('class' => array('table table-striped table-bordered table-condensed'))
    );
    $form['pager'] = array('#markup' => theme('pager'));

    return $form;
}

function membership_period_order_list_form_submit($form, &$form_state) {
    $form_state['redirect'] = array('admin/config/membership/period/orders',
        array('query' => array(
                'poid' => $form_state['values']['poid'],
                'id' => $form_state['values']['id'],
                'lastname' => $form_state['values']['lastname'],
                'firstname' => $form_state['values']['firstname'],
                'email' => $form_state['values']['email'],
                'from' => $form_state['values']['from'],
                'to' => $form_state['values']['to'],
                'product' => ($form_state['values']['product'] == 0) ? '' : $form_state['values']['product'],
                'is_activated' => $form_state['values']['is_activated'],
            ),
            'fragment' => '',),
    );
}

/**
 * A megrendelők listázása.
 */
function membership_period_promo_list_form($form, &$form_state) {
    // A paraméterek beolvasása.
    isset($_GET['promo_id']) ? $promo_id = $_GET['promo_id'] : $promo_id = '';
    isset($_GET['poid']) ? $poid = $_GET['poid'] : $poid = '';
    isset($_GET['id']) ? $id = $_GET['id'] : $id = '';
    isset($_GET['lastname']) ? $lastname = $_GET['lastname'] : $lastname = '';
    isset($_GET['firstname']) ? $firstname = $_GET['firstname'] : $firstname = '';
    isset($_GET['email']) ? $email = $_GET['email'] : $email = '';
    isset($_GET['from']) ? $from = $_GET['from'] : $from = '';
    isset($_GET['to']) ? $to = $_GET['to'] : $to = '';
    isset($_GET['product']) ? $product = $_GET['product'] : $product = '';
    isset($_GET['is_activated']) ? $is_activated = $_GET['is_activated'] : $is_activated = '';

    // Beolvassa a termékek listáját
    $products = db_query('SELECT pid, name FROM {membership_period_products}')->fetchAllKeyed();
    $products[0] = '- Összes termék -';
    ksort($products);

    $form = array();

    $form['promo_id'] = array(
        '#type' => 'textfield',
        '#title' => 'ID',
        '#required' => FALSE,
        '#size' => 5,
        '#maxlength' => 10,
        '#prefix' => '<table><tr><td>',
        '#suffix' => '</td>',
        '#default_value' => $promo_id,
    );

    $form['poid'] = array(
        '#type' => 'textfield',
        '#title' => 'POID',
        '#required' => FALSE,
        '#size' => 5,
        '#maxlength' => 10,
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#default_value' => $poid,
    );

    $form['id'] = array(
        '#type' => 'textfield',
        '#title' => 'MUID',
        '#required' => FALSE,
        '#size' => 5,
        '#maxlength' => 10,
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#default_value' => $id,
    );

    $form['lastname'] = array(
        '#type' => 'textfield',
        '#title' => 'Vezetéknév',
        '#required' => FALSE,
        '#size' => 16,
        '#maxlength' => 64,
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#default_value' => $lastname,
    );

    $form['firstname'] = array(
        '#type' => 'textfield',
        '#title' => 'Utónév',
        '#required' => FALSE,
        '#size' => 16,
        '#maxlength' => 64,
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#default_value' => $firstname,
    );

    $form['email'] = array(
        '#type' => 'textfield',
        '#title' => 'E-mail cím',
        '#required' => FALSE,
        '#size' => 16,
        '#maxlength' => 254,
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#default_value' => $email,
    );

    $form['from'] = array(
        '#type' => 'textfield',
        '#title' => 'Ettől a dátumtól',
        '#required' => FALSE,
        '#size' => 16,
        '#maxlength' => 64,
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#default_value' => $from,
    );

    $form['to'] = array(
        '#type' => 'textfield',
        '#title' => 'Eddig a dátumig',
        '#required' => FALSE,
        '#size' => 16,
        '#maxlength' => 64,
        '#prefix' => '<td>',
        '#suffix' => '</td>',
        '#default_value' => $to,
    );
//    mdd([$products, $product]);
    $form['product'] = array(
        '#type' => 'select',
        '#title' => 'Termék',
        '#prefix' => '<td>',
        '#options' => $products,
        '#default_value' => $product,
    );

    $form['is_activated'] = array(
        '#type' => 'select',
        '#title' => 'Aktiváva van',
        '#prefix' => '<td>',
        '#suffix' => '</td></tr></table>',
        '#options' => array('' => 'Összes', 0 => 'Nem', 1 => 'Igen'),
        '#default_value' => $is_activated,
    );

    $form['submit'] = array(
        '#type' => 'submit',
        '#value' => 'Keresés',
    );

    // Tábla elkészítése
    $header = array(
        array('data' => 'ID', 'field' => 'promo_id', 'sort' => 'desc'),
        array('data' => t('POID'), 'field' => 'poid',),
        array('data' => t('MUID'), 'field' => 'id',),
        array('data' => t('Vezetéknév'), 'field' => 'lastname',),
        array('data' => t('Utónév'), 'field' => 'firstname',),
        array('data' => t('E-mail cím'), 'field' => 'email',),
        array('data' => t('Termék'), 'field' => 'product',),
        array('data' => t('Kezdete'), 'field' => 'start_at'),
        array('data' => t('Vége'), 'field' => 'end_at'),
        array('data' => t('Aktiválva'), 'field' => 'is_active'),
        array('data' => t('Lezárt'), 'field' => 'closed'),
        array('data' => t('Műveletek')),
    );

    $tsfrom = strtotime($from);
    $tsto = strtotime($to);

    $query = db_select('membership_users', 'u');
    $query->join('membership_period_promotions', 'o', 'u.id = o.id');
    $query->fields('u', array('id', 'lastname', 'firstname', 'email', 'uid'))
            ->fields('o', array('promo_id', 'poid', 'id', 'pid', 'is_activated', 'closed', 'start_at', 'end_at'))
            ->condition('o.promo_id', "%$promo_id%", 'LIKE')
            ->condition('o.poid', "%$poid%", 'LIKE')
            ->condition('u.id', "%$id%", 'LIKE')
            ->condition('lastname', "%$lastname%", 'LIKE')
            ->condition('firstname', "%$firstname%", 'LIKE')
            ->condition('email', "%$email%", 'LIKE');
    if ($from != '') {
        $query->condition('o.start_at', $tsfrom, '>');
    }
    if ($to != '') {
        $query->condition('o.end_at', $tsto, '<');
    }
    if ($product != '') {
        $query->condition('o.pid', $product, '=');
    }
    if ($is_activated != '') {
        if ($is_activated == 0) {
            $query->condition('o.is_activated', 0, '=');
        } else {
            $query->condition('o.is_activated', 0, '!=');
        }
    }
    $users = $query->extend('PagerDefault')
            ->limit(variable_get('membership_list_limit_users'))
            ->extend('TableSort')
            ->orderByHeader($header)
            ->execute();

    $page = membership_get_page();
    $rows = array();

    foreach ($users as $value) {
        if ($value->uid != 0) {
            $links = l(t('Saját Adatok'), 'user/' . $value->uid . '/sajat-adatok', array('query' => array('id' => $value->id)));
        } else {
            $links = l(t('Saját Adatok'), 'sajat-adatok', array('query' => array('id' => $value->id)));
        }

//        switch ($value->closed) {
//            case 0:
//                $closed = l(t('Folyamatban'), 'admin/config/membership/period/change_close', array('query' => array('poid' => $value->poid, 'page' => $page)));
//                break;
//            case 1:
//                $closed = l(t('Lezárt'), 'admin/config/membership/period/change_close', array('query' => array('poid' => $value->poid, 'page' => $page)));
//                break;
//        }
        $rows[] = array(
            'data' => array(
                $value->promo_id,
                $value->poid,
                $value->id,
                $value->lastname,
                $value->firstname,
                $value->email,
                isset($products[$value->pid]) ? $products[$value->pid] : '',
                $value->start_at,
                $value->end_at,
                ($value->is_activated != 0) ? date('Y-m-d H:i:s', $value->is_activated) : 'Nem',
                ($value->closed == 0) ? 'Aktív' : 'Lejárt',
                $links,
            )
        );
    }

    $form['table'] = array(
        '#theme' => 'table',
        '#header' => $header,
        '#rows' => $rows,
        '#empty' => t('Nincsenek találatok.'),
        '#attributes' => array('class' => array('table table-striped table-bordered table-condensed'))
    );
    $form['pager'] = array('#markup' => theme('pager'));

    return $form;
}

function membership_period_promo_list_form_submit($form, &$form_state) {
    $form_state['redirect'] = array('admin/config/membership/period/promotions',
        array('query' => array(
                'promo_id' => $form_state['values']['promo_id'],
                'poid' => $form_state['values']['poid'],
                'id' => $form_state['values']['id'],
                'lastname' => $form_state['values']['lastname'],
                'firstname' => $form_state['values']['firstname'],
                'email' => $form_state['values']['email'],
                'from' => $form_state['values']['from'],
                'to' => $form_state['values']['to'],
                'product' => ($form_state['values']['product'] == 0) ? '' : $form_state['values']['product'],
                'is_activated' => $form_state['values']['is_activated'],
            ),
            'fragment' => '',),
    );
}
