<?php
/**
 * @file
 * Függvények, amiket általánosan használunk az űrlapoknál, átalkításra, ellenőrzésre.
 * 
 */
 
/**
 * Kiválasztja a helyes névelőt a szövegek és a számok elé.
 * A számok 99-ig működnek.
 * 
 * @param string $str
 * A szöveg amiről el akarjuk dönteni, hogy milyen névelő kell elé.
 * 
 * @return string
 * A helyes névelő.
 *  
 */
function _a_az($str) {
  $vowel = 'aáeéiíoóöőuúüű51';
  $char = strtolower($str[0]);
  $pos = strpos($vowel, $char);
  if ($pos === false) return 'A'; else return 'Az';
}
 
/**
 * Ellenőrzi az e-mail címet, és hogy az e-mail, domainja létezik-e. 
 * 
 * @param string $email
 * Az email cím (nyers input).
 * 
 * @return boolean
 * TRUE-t ad vissza, ha jó az e-mail formát és azt, hogy a domain létezik.
 * 
 */
function _is_valid_email($email) {
  $isValid = true;
  $atIndex = strrpos($email, "@");
  if (is_bool($atIndex) && !$atIndex) {
    $isValid = false;
  } else {
    $domain = substr($email, $atIndex+1);
    $local = substr($email, 0, $atIndex);
    $localLen = strlen($local);
    $domainLen = strlen($domain);
    if ($localLen < 1 || $localLen > 64){
      // Local part length exceeded.
      $isValid = false;
    } else if ($domainLen < 1 || $domainLen > 255) {
      // Domain part length exceeded.
      $isValid = false;
    } else if ($local[0] == '.' || $local[$localLen-1] == '.') {
      // Local part starts or ends with '.'.
      $isValid = false;
    } else if (preg_match('/\\.\\./', $local)) {
      // Local part has two consecutive dots.
      $isValid = false;
    } else if (!preg_match('/^[A-Za-z0-9\\-\\.]+$/', $domain)) {
      // Character not valid in domain part.
      $isValid = false;
    } else if (preg_match('/\\.\\./', $domain)) {
      // Domain part has two consecutive dots.
      $isValid = false;
    } else if(!preg_match('/^(\\\\.|[A-Za-z0-9!#%&`_=\\/$\'*+?^{}|~.-])+$/', str_replace("\\\\","",$local))) {
      // Character not valid in local part unless local part is quoted.
      if (!preg_match('/^"(\\\\"|[^"])+"$/', str_replace("\\\\","",$local))) {
          $isValid = false;
      }
    }
    if ($isValid && !(checkdnsrr($domain,"MX") || checkdnsrr($domain,"A"))) {
      // Domain not found in DNS.
      $isValid = false;
    }
  }
  return $isValid;
}

/**
 * Ellenőrzi, hogy a telefonszám megadásához csak az engedélyezett
 * karakterek vannak-e használva.
 * 
 * @param string $phone
 * A telefonszám szöveges formátumban.
 * 
 * @return boolean
 * TRUE ha a telefonszám nem tartalmaz illegális karaktereket.
 */
function _is_valid_phone($phone) {
  $valid_chars = "0123456789-/()+ ";
  $is_phone = TRUE;
  $text = trim($phone);
  for ($i = 0; $i < strlen($text) && $is_phone == TRUE; $i++) {
    $char = $text[$i];
    $pos = strpos($valid_chars, $char);
    if ($pos===FALSE) $is_phone = FALSE;
  }
  return $is_phone;
}

/**
 * Ellenőrzi, hogy az adószáma a megfeleő formátumban van-e.
 * 
 * @param string $taxid
 * Az adószám szöveges formátumban.
 * 
 * @return boolean
 * TRUE ha az adószám helyes.
 */
function _is_valid_taxid($taxid){
//  if(preg_match('/^[0-9]{8}\-[0-9]{1}\-[0-9]{2}$/',$taxid)) {
    return TRUE;
//  } else {
//    return FALSE; 
//  }
}

/**
 * Véletlen (alfa)numerikus sztringet hoz létre a megadott hosszban.
 * 
 * @param integer $lenth
 * A karakterlánc hossza.
 * 
 * @param boolean $alfanumeric
 * Ha TRUE kis és nagy betűket, ha FALSE csak számokból hozza létre a kódot.
 * 
 * @return string
 * Visszaadja a véletlen karakterekből álló stringet.
 *  
 */
function _make_hash($lenth = 32, $alfanumeric = TRUE) { 
  mt_srand ((double) microtime() * 1000000);
  if ($alfanumeric == TRUE) {
      $aZ09 = array_merge(range('A', 'Z'), range('a', 'z'),range(0, 9));
  } else {
    $aZ09 = array_merge(range(0, 9));
  }
  $hash ='';
  for($c=0;$c < $lenth;$c++) {
     $hash .= $aZ09[mt_rand(0,count($aZ09)-1)];
  }
  return $hash;
}

/**
 * Ha valódi az IP cím visszaadja, különben üres stringet kapunk.
 * 
 * @return string
 * A visszadott ip cím, vagy üres string.
 * 
 */
function _get_real_ip() {
  $ip = $_SERVER['REMOTE_ADDR'];
  $ip = ip2long($ip);
  if ($ip !== false && $ip !== -1 && $ip !== 0) {
      $ip = long2ip($ip);
  } else {
      $ip = '';
  }
  return $ip;
}

/**
 * A telefonszámot (ha lehet) egy nemzetközi stílusú integerré alakítja,
 * hogy alkalamas legyen sms küldésre.
 * 
 * @param string $str_phone
 * A telefonszám string formátumban.
 * 
 * @return integer
 * A telefonszám nemzetközi formátumban integerként.
 * 
 */
function _phone_to_int($str_phone) {
  $phone = $number = preg_replace("/[^0-9]/", '', $str_phone);
  $len = strlen($phone);
  if ($len==9 || $len==11) { // ha megfelelő a hossza
    if ($len==11) $phone = substr($phone, 2, 100);
    $phone = '36' . $phone;
  } else {
    $phone = '';
  }
  return $phone;
}

/**
 * Nagybetűvé alakítja az első betűt, a többit kicsivé, és levágja a felesleges
 * szóközöket a szöveg elejéről és végéről.
 * 
 * @param string $str
 * Az átalakítandó szöveg.
 * 
 * @return string
 * A nagybetűvel kezdődő és végig kisbetűs szöveg.
 */
function _capitalize($str) {
  return drupal_ucwords(drupal_strtolower(trim($str)));
}

/**
 * A számot formázza, hogy árként jelenjen meg.
 *
 * @param integer $number
 * A formázandó szám integer formátumban,
 *  
 * @return string
 * A szám ezres elválasztóval, hozzáfűzve a Ft pénznem.
 *   
 */
function _format_price($number) {
  return number_format($number, 0, ',', ' ') . ' Ft';
}

/**
 * Kezeli a felhasználó szerepköreit.
 * 
 * @param int $uid
 * A felhasználó Drupal beli azonosítója.
 * 
 * @param array $rids
 * A role-ok sorszámai amiket hozzáadni vagy törölni kell.
 * 
 * @param string $operation
 * Milyen akciót kell végrehajtani? Hozzásadás(add_role), törlés (remove_role).
 *
 * @return void
 */
function _set_roles($uid, $rids, $operation) {
  // Ha szerepel az illető az adatbázisban, vagyis nem olyan felhasználóról van szó, aki most
  // regisztrált elsőnek, hiszen, ez esetben nem lehet hozzárendelni ez esetben semmilyen szerepkört. 
  if ($uid>0) {
    // Végigmegyünk a $rids tömbön, hogy minden szerepkört hozzárendeljünk a felhasználóhoz.
    foreach ($rids as $rid) {
      if ($role = user_role_load($rid)) {
        user_multiple_role_edit(array($uid), $operation, $role->rid);
      }
    }
  }
}

/**
 * Kezeli a hírlevél listákra fel- és leiratást.
 * 
 * @param string $nickname
 * A felhasználó utóneve.
 * 
 * @param string $email
 * A felhasználó email címe.
 * 
 * @param array $listids
 * A listák azonosítói amikhez hozzáadni vagy törölni kell.
 * 
 * @param string $operation
 * Milyen akciót kell végrehajtani? Hozzáadás(add_list), törlés (remove_list).
 * 
 * @return void
 * 
 */
//function _set_mailing_lists($nickname, $email, $listids, $operation) {
//    
//  switch ($operation) {
//    case 'add_list':
//      foreach ($listids as $listid) {
//        $subscriber = array(
//          'emailaddress' => $email,
//          'mailinglist'  => $listid,
//          'format'       => 'text',  // html vagy text
//          'confirmed'    => 'yes',   // (yes, 1, true) vagy (no, 0, false)
//          'customfields' => array(   // items
//            array('fieldid' => variable_get('membership_em_nickname'), 'value' => $nickname),
//            array('fieldid' => variable_get('membership_em_hash'),     'value' => md5(md5($email))),
//            array('fieldid' => variable_get('membership_em_unsublink'),'value' => variable_get('membership_em_unsubpath').'?em='.$email.'&ha='.md5(md5($email))),
//          ),
//        );
//        em_add_subscriber_to_list($subscriber);
//      }
//      break;
//    case 'remove_list':
//      foreach ($listids as $listid) {
//        em_delete_subscriber($email, $listid);    
//      }
//      break;
//  }
//}

function drupal_ucwords($text) {
  $upper_words = array();
  $words = explode(" ", $text);

  foreach ($words as $word) {
    $upper_words[] = drupal_ucfirst($word);
  }

  return implode(" ", $upper_words);
}