<?php

/**
 * @file The global functions for the Certify module.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */

/**
 * Validates e-mail in the Drupal Form API fields.
 * @param type $element
 * @param type $form_state
 * @author Müller Péter <egyeves@gmail.com>
 */
function membership_element_validate_email($element, &$form_state) {
    $value = trim($element['#value']);
    if (!_is_valid_email($value)) {
        form_error($element, t('%name must be an email.', array('%name' => $element['#title'])));
    }
}

/**
 * Validates phone in the Drupal Form API fields.
 * @param type $element
 * @param type $form_state
 * @author Müller Péter <egyeves@gmail.com>
 */
function membership_element_validate_phone($element, &$form_state) {
    $value = trim($element['#value']);
    if (!certify_is_valid_phone($value)) {
        form_error($element, t('%name must be a phone number.', array('%name' => $element['#title'])));
    }
}

/**
 * Validate form element to a positive number.
 * @param type $element
 * @param type $form_state
 * @return type
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_element_validate_positive_number($element, &$form_state) {
    if ($element['#value'] === '' || $element['#value'] < 0 || !_membership_is_int($element['#value'])) {
        form_error($element, t('%name mezőnek pozitív számnak kell lennie.', array('%name' => $element['#title'])));
    }
}

/**
 * Validate form element to a positive number.
 * @param type $element
 * @param type $form_state
 * @return type
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_element_validate_positive_number_or_zero($element, &$form_state) {
    if ($element['#value'] === '' || $element['#value'] < 0 || !_membership_is_int($element['#value'])) {
        form_error($element, t('%name mezőnek pozitív számnak kell lennie.', array('%name' => $element['#title'])));
    }
}

/**
 * Validate order id field.
 * @param type $element
 * @param type $form_state
 * @return type
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_element_validate_oid($element, &$form_state) {
    if ($element['#value'] == '' || $element['#value'] < 0 || !_membership_is_int($element['#value'])) {
        form_error($element, t('%name mezőnek pozitív számnak kell lennie.', array('%name' => $element['#title'])));
    } else {
        $query = db_select('membership_orders', 'o');
        $query->join('membership_users', 'u', 'o.id = u.id');
        $query->join('membership_products', 'p', 'o.pid = p.pid');
        $query->fields('o', array('price', 'is_activated'));
        $query->fields('u', array('lastname', 'firstname', 'email'));
        $query->fields('p', array('name'));
        $query->condition('o.oid', $element['#value']);
        $order = $query->execute()->fetchObject();

        if (empty($order)) {
            form_error($element, t('%oid számú megrendelés nem létezik.', array('%oid' => $element['#value'])));
        } else if ($order->is_activated != 0) {
            form_error($element, t('%oid számú megrendelés már aktiválva van, ezért nem törölhető!', array('%oid' => $element['#value'])));
        }
    }
}

/**
 * Validate period order id field.
 * @param type $element
 * @param type $form_state
 * @return type
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_element_validate_poid($element, &$form_state) {
    if ($element['#value'] == '' || $element['#value'] < 0 || !_membership_is_int($element['#value'])) {
        form_error($element, t('%name mezőnek pozitív számnak kell lennie.', array('%name' => $element['#title'])));
    } else {
        $query = db_select('membership_period_orders', 'o');
        $query->fields('o', array('price', 'is_activated'));
        $query->condition('o.poid', $element['#value']);
        $order = $query->execute()->fetchObject();

        if (empty($order)) {
            form_error($element, t('%oid számú megrendelés nem létezik.', array('%oid' => $element['#value'])));
        } else if ($order->is_activated != 0) {
            form_error($element, t('%oid számú megrendelés már aktiválva van, ezért nem törölhető!', array('%oid' => $element['#value'])));
        }
    }
}
