<?php

/**
 * @file Cron functions.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */

/**
 * Promotions cron job
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_cron_promo() {

    $promo_count = 0;
    $actions = 0;
    $deletes = 0;
    $activates = [];

    // Get all active promotion
    $promos = db_select('membership_period_promotions', 'p')
            ->condition('p.is_activated', 1)
            ->condition('p.closed', 0)
            ->condition('p.end_at', date('Y-m-d H:i:s'), '<')
            ->fields('p')
            ->orderBy('p.created', 'desc')
            ->execute()
            ->fetchAll();
    $promo_count = count($promos);

    // If promo expired pay period order
    foreach ($promos as $promo) {
        $response = null;

        // Get order
        $order = membership_period_order_get_details_assoc($promo->poid);
        $period_id = $order['id'] . '_' . $order['pid'];

        // Check order
        if (in_array($period_id, $activates)) {
            $activates[] = $period_id;

            db_delete('membership_period_orders')->condition('poid', $order['poid'])->execute();

            watchdog('membership', '"%oid" period order deleted by cron, becouse it was a duplication. Details: %order', array('%oid' => $promo->poid, '%order' => json_encode($order), WATCHDOG_NOTICE));

            $deletes++;
            $actions++;
        } else if ($order['is_activated'] == 0) {

            // Pay order
            // Get token by id
            $token = barion_api_get_token($order['token']);

            // Build payment object
            if ($order['is_firm_invoice'] === 1) {
                $address = [
                    'country' => $order['country'],
                    'city' => $order['firm_city'],
                    'zip' => $order['firm_zip'],
                    'street' => substr($order['firm_address'], 0, 49)
                ];
            } else {
                $address = [
                    'country' => $order['country'],
                    'city' => $order['city'],
                    'zip' => $order['zip'],
                    'street' => substr($order['address'], 0, 49)
                ];
            }

            $payment['oid'] = $order['poid'];
            $payment['order_table'] = 'membership_period_orders';
            $payment['uid'] = $order['id'];
            $payment['item'] = array(
                'name' => $order['name'],
                'description' => $order['proforma_name'],
                'quantity' => 1,
                'unit' => t('db'),
                'unitprice' => intval($order['price']),
                'itemtotal' => intval($order['price']),
                'sku' => 'ITEM-' . $order['pid'] . '-' . $order['hash']
            );
            $payment['transaction'] = array(
                'title' => $order['name'],
                'total' => intval($order['price']),
                'hash' => 'TR-' . barion_api_get_transaction_unique_hash()
            );
            $payment['payment'] = array(
                'oid' => $order['poid'],
                'hash' => 'PR-' . barion_api_get_payment_unique_hash(),
                'usermail' => $order['email'],
                'shipping' => $address,
            );

            barion_api_payment_request($payment, $token, function($myPayment) use ($order) {
                db_update('membership_period_orders')
                        ->condition('poid', $order['poid'])
                        ->fields(['payment_id' => $myPayment->PaymentId])
                        ->execute();
            }, true);

            // Check payment
            $paymentId = db_select('membership_period_orders', 'p')
                    ->condition('p.poid', $promo->poid)
                    ->fields('p', array('payment_id'))
                    ->execute()
                    ->fetchField();

            if (!empty($paymentId)) {
                $response = barion_api_get_payment($paymentId);

                // Activate order
                if (!empty($response) && $response['status'] == 1) {
                    $activate = membership_period_order_activate($promo->poid);

                    $actions++;

                    if (!$activate) {
                        // Save to watchdog.
                        watchdog('membership', '"%oid" period order activation failed by cron.', array('%oid' => $promo->poid, WATCHDOG_INFO));
                    } else {
                        // Close promotion
                        membership_period_promo_close($promo->promo_id);
                    }
                } else {
                    // Close promotion
                    membership_period_promo_close($promo->promo_id);

                    watchdog('membership', '"%oid" period order payment is failed by cron.', array('%oid' => $promo->poid, WATCHDOG_NOTICE));
                }
            } else {
                // Close promotion
                membership_period_promo_close($promo->promo_id);

                watchdog('membership', '"%oid" period order payment is failed by cron.', array('%oid' => $promo->poid, WATCHDOG_NOTICE));
            }
        } else {
            // Close promotion
            membership_period_promo_close($promo->promo_id);

            watchdog('membership', '"%oid" period order cron job skipped because order is activated.', array('%oid' => $promo->poid, WATCHDOG_INFO));
        }
    }


    watchdog('membership', t('Promo cron lefutott.
Aktív promóciók: %promo_count;
Végrehajtott akciók: %actions
Törölt rendelések: %deletes'), array('%promo_count' => $promo_count, '%actions' => $actions, '%deletes' => $deletes, WATCHDOG_NOTICE));
}

/**
 * Promotions cron job
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_cron_period() {

    $period_count = 0;
    $actions = 0;
    $deletes = 0;
    $duplicates = [];

    // Get all active promotion
    $periods = db_select('membership_period_orders', 'p')
            ->condition('p.is_activated', 0, '!=')
            ->condition('p.closed', 0)
            ->condition('p.end_at', date('Y-m-d H:i:s'), '<')
            ->fields('p')
            ->orderBy('p.created', 'desc')
            ->execute()
            ->fetchAll(PDO::FETCH_ASSOC);
    $period_count = count($periods);

    // Renew all period
    foreach ($periods as $prev) {

        // Get order
        $period_id = $prev['id'] . '_' . $prev['pid'];

        // Check order
        if (in_array($period_id, $duplicates)) {
            $duplicates[] = $period_id;

            db_delete('membership_period_orders')->condition('poid', $prev['poid'])->execute();

            watchdog('membership', '"%oid" period order deleted by cron, becouse it was a duplication. Details: %order', array('%oid' => $prev['poid'], '%order' => json_encode($prev), WATCHDOG_NOTICE));

            $deletes++;
            $actions++;
        } else {
            // Close previous order
            membership_period_order_close($prev['poid']);

            // Get product
            $product = membership_period_product_get_details_object($prev['pid']);

            // Get start
            $start = $prev['end_at'];

            // Calculate end
            $deadline = membership_get_period_deadline($product, $start);
            $end = $deadline !== null ? date('Y-m-d H:i:s', $deadline) : $deadline;

            // Create order
            $fields = array(
                'id' => $prev['id'],
                'pid' => $prev['pid'],
                'start_at' => $start,
                'end_at' => $end,
                'price' => $product->price,
                'shipping' => $product->shipping,
                'vat' => $product->vat,
                'is_activated' => 0,
                'is_sent' => 3,
                'is_invoiced' => 0,
                'payment_id' => null,
                'token' => $prev['token'],
                'thank_you' => $prev['thank_you'],
            );
            $order = membership_period_order_merge($fields, null, true);

            // Pay order
            // Get token by id
            $token = barion_api_get_token($order['token']);

            // Build payment object
            if ($order['is_firm_invoice'] === 1) {
                $address = [
                    'country' => $order['country'],
                    'city' => $order['firm_city'],
                    'zip' => $order['firm_zip'],
                    'street' => substr($order['firm_address'], 0, 49)
                ];
            } else {
                $address = [
                    'country' => $order['country'],
                    'city' => $order['city'],
                    'zip' => $order['zip'],
                    'street' => substr($order['address'], 0, 49)
                ];
            }

            $payment['oid'] = $order['poid'];
            $payment['order_table'] = 'membership_period_orders';
            $payment['uid'] = $order['id'];
            $payment['item'] = array(
                'name' => $order['name'],
                'description' => $order['proforma_name'],
                'quantity' => 1,
                'unit' => t('db'),
                'unitprice' => intval($order['price']),
                'itemtotal' => intval($order['price']),
                'sku' => 'ITEM-' . $order['pid'] . '-' . $order['hash']
            );
            $payment['transaction'] = array(
                'title' => $order['name'],
                'total' => intval($order['price']),
                'hash' => 'TR-' . barion_api_get_transaction_unique_hash()
            );
            $payment['payment'] = array(
                'oid' => $order['poid'],
                'hash' => 'PR-' . barion_api_get_payment_unique_hash(),
                'usermail' => $order['email'],
                'shipping' => $address,
            );

            barion_api_payment_request($payment, $token, function($myPayment) use ($order) {
                db_update('membership_period_orders')
                        ->condition('poid', $order['poid'])
                        ->fields(['payment_id' => $myPayment->PaymentId])
                        ->execute();
            }, true);

            // Check payment
            $paymentId = db_select('membership_period_orders', 'p')
                    ->condition('p.poid', $order['poid'])
                    ->fields('p', array('payment_id'))
                    ->execute()
                    ->fetchField();

            if (!empty($paymentId)) {
                $response = barion_api_get_payment($paymentId);

                // Activate order
                if (!empty($response) && $response['status'] == 1) {
                    $activate = membership_period_order_activate($order['poid'], TRUE);

                    $actions++;

                    if (!$activate) {
                        // Save to watchdog.
                        watchdog('membership', '"%oid" period order activation failed by cron.', array('%oid' => $order['poid'], WATCHDOG_INFO));
                    } else {
                        // Close previous order
                        membership_period_order_full_close($prev['poid']);
                    }
                } else {
                    // Close previous order
                    membership_period_order_full_close($prev['poid']);

                    watchdog('membership', '"%oid" period order payment is failed by cron.', array('%oid' => $order['poid'], WATCHDOG_NOTICE));
                }
            } else {
                // Close previous order
                membership_period_order_full_close($prev['poid']);

                watchdog('membership', '"%oid" period order payment is failed by cron.', array('%oid' => $order['poid'], WATCHDOG_NOTICE));
            }
        }
    }

    watchdog('membership', t('Period cron lefutott.
Aktív promóciók: %promo_count;
Végrehajtott akciók: %actions
Törölt rendelések: %deletes'), array('%promo_count' => $period_count, '%actions' => $actions, '%deletes' => $deletes, WATCHDOG_NOTICE));
}
