<?php

/**
 * @file Billingo API settings.
 * @package Billingo
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */

/**
 * Creates the main settings form.
 * @param type $form
 * @param type $form_state
 * @return $form
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function billingo_api_settings_form($form, &$form_state) {
  
  global $base_url;
  $module_path  = drupal_get_path('module', 'billingo_api');
    
  $form = array();
  
  $form['overview'] = array(
    '#markup' => t('Admininstrators can set the main settings of the billingo_api system.'),
    '#prefix' => '<p>',
    '#suffix' => '</p>',
  );

  // Company settings
  $form['api'] = array(
    '#type' => 'fieldset',
    '#title' => t('API settings'),
    '#collapsible' => TRUE,
    '#collapsed' => FALSE,
  );

  $form['api']['billingo_api_public_key'] = array(
    '#title' => t('Public key'),
    '#description' => t('Elfogadóhely nyilvános azonosítója.'),
    '#type' => 'textfield',
    '#default_value' => variable_get('billingo_api_public_key'),
    '#required' => TRUE,
  );
  
  $form['api']['billingo_api_private_key'] = array(
    '#title' => t('Private key'),
    '#description' => t('Elfogadóhely azonosítója.'),
    '#type' => 'textfield',
    '#default_value' => variable_get('billingo_api_private_key'),
    '#required' => TRUE,
  );

  $form['api']['billingo_api_mode'] = array(
    '#title' => t('API mode'),
    '#description' => t('In test mode, you can contact to test server to make test invoices.'),
    '#type' => 'radios',
    '#default_value' => variable_get('billingo_api_mode'),
    '#required' => TRUE,
    '#options' => array(
        1 => t('Test'),
        2 => t('Production')
    ),
  );
  
  $form['api']['billingo_api_currency'] = array(
    '#title' => t('Currency'),
    '#description' => t('Currency what you use.'),
    '#type' => 'select',
    '#default_value' => variable_get('billingo_api_currency'),
    '#required' => TRUE,
    '#options' => array(
        'HUF' => t('HUF'),
        'EUR' => t('EUR'),
        'USD' => t('USD')
    ),
  );
  
  if(count(variable_get('billingo_api_vat_list')) <= 2){
      billingo_api_get_vat_list();
  }
  
  $form['api']['billingo_api_vat'] = array(
    '#title' => t('VAT'),
    '#description' => t('VAT what you use.'),
    '#type' => 'select',
    '#default_value' => variable_get('billingo_api_vat'),
    '#required' => TRUE,
    '#options' => variable_get('billingo_api_vat_list'),
  );
  
  
  $form['api']['billingo_api_due_date'] = array(
    '#title' => t('Due date'),
    '#description' => t('Due date in days!'),
    '#type' => 'textfield',
    '#default_value' => variable_get('billingo_api_due_date'),
    '#required' => TRUE,
  );
  
  return system_settings_form($form);

}
