<?php

/**
 * @file Barion API settings.
 * @package Barion
 * @author Kulcsár Balázs
 */

/**
 * Creates the main settings form.
 * @param type $form
 * @param type $form_state
 * @return $form
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function barion_api_settings_form($form, &$form_state) {

    global $base_url;
    $module_path = drupal_get_path('module', 'barion_api');
    $sources = barion_api_sources();

    $form = array();

    $form['overview'] = array(
        '#markup' => t('Admininstrators can set the main settings of the barion_api system.'),
        '#prefix' => '<p>',
        '#suffix' => '</p>',
    );

    // Company settings
    $form['api'] = array(
        '#type' => 'fieldset',
        '#title' => t('API settings'),
        '#collapsible' => TRUE,
        '#collapsed' => FALSE,
    );

    $form['api']['barion_api_public_key'] = array(
        '#title' => t('Public key'),
        '#description' => t('Elfogadóhely nyilvános azonosítója.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('barion_api_public_key'),
        '#required' => TRUE,
    );

    $form['api']['barion_api_pos_key'] = array(
        '#title' => t('POS key'),
        '#description' => t('Elfogadóhely azonosítója.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('barion_api_pos_key'),
        '#required' => TRUE,
    );

    $form['api']['barion_api_email'] = array(
        '#title' => t('Email'),
        '#description' => t('Email cím, amire a Barion fiókot regisztráltad.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('barion_api_email'),
        '#required' => TRUE,
        '#element_validate' => array('barion_api_is_valid_email_inform'),
    );

    $form['api']['barion_api_redirect'] = array(
        '#title' => t('Redirect URL'),
        '#description' => t('Thank you page after payment.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('barion_api_redirect'),
        '#required' => TRUE,
    );

    $form['api']['barion_api_callback'] = array(
        '#title' => t('Callback URL'),
        '#description' => t('Callback after pay.'),
        '#type' => 'textfield',
        '#default_value' => variable_get('barion_api_callback'),
        '#required' => TRUE,
    );

    $form['api']['barion_api_mode'] = array(
        '#title' => t('API mode'),
        '#description' => t('In test mode, you can contact to test server to make test payments.'),
        '#type' => 'radios',
        '#default_value' => variable_get('barion_api_mode'),
        '#required' => TRUE,
        '#options' => array(
            1 => t('Test'),
            2 => t('Production')
        ),
    );

    $form['api']['barion_api_currency'] = array(
        '#title' => t('Currency'),
        '#description' => t('Currency what you use.'),
        '#type' => 'select',
        '#default_value' => variable_get('barion_api_currency'),
        '#required' => TRUE,
        '#options' => array(
            1 => t('HUF'),
            2 => t('EUR'),
            3 => t('USD')
        ),
    );

    $form['api']['barion_api_locale'] = array(
        '#title' => t('Locale'),
        '#description' => t('Language of Barion.'),
        '#type' => 'select',
        '#default_value' => variable_get('barion_api_locale'),
        '#required' => TRUE,
        '#options' => array(
            1 => t('EN'),
            2 => t('HU'),
            3 => t('DE'),
            4 => t('SL'),
            5 => t('SK'),
            6 => t('FR'),
        ),
    );

    // Design elements
    $form['designs'] = array(
        '#type' => 'fieldset',
        '#title' => t('All design element'),
        '#collapsible' => TRUE,
        '#collapsed' => TRUE,
    );

    foreach ($sources as $k => $v) {

        $html = '<img src="' . $base_url . '/' . $module_path . '/' . $v . '" style="max-width: 800px; width: auto"/><br>';
        $html .= '<span>Name: ' . $k . '</span><br>';
        $html .= '<span class="text-muted">Link: <em>' . $base_url . '/' . $module_path . '/' . $v . '</em></span><br><br>';

        $form['designs'][$k] = array(
            '#markup' => $html,
            '#prefix' => '<p>',
            '#suffix' => '</p>',
        );
    }

    return system_settings_form($form);
}

/**
 * After submit settings form merge emails into database and set all the variables.
 * @param type $form
 * @param type $form_state
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
/*function barion_api_settings_form_submit($form, &$form_state){

    // Save emails
    foreach($form['email']['emails'] as $k => $v){
        if(strpos($k, 'certify_mail') !== false){
            $subject = $k . '_subject';
            $body = $k . '_body';
            $fields = array(
                'variable' => $k,
                'subject'  => $form_state['values'][$subject],
                'body'     => $form_state['values'][$body]
            );
            db_merge('certify_default_emails')->key(array('variable' => $k))->fields($fields)->execute();
        }
    }
    // Exclude unnecessary elements.
    form_state_values_clean($form_state);

    // Set variables.
    certify_variable_set_from_form($form_state);

    // Save to watchdog.
    watchdog('certify', 'Settings and default emails has been refreshed.', array('certify_settings_form' => 'emails', WATCHDOG_NOTICE));
}
*/
