<?php
/**
 * Piwik - free/libre analytics platform
 *
 * @link http://        '
 * @license http://www.gnu.org/licenses/gpl-3.0.html GPL v3 or later
 *
 */
namespace Piwik\Plugins\VisitorGenerator\Faker;

use Piwik\Plugins\UserCountry\LocationProvider\GeoIp;

include_once __DIR__ . '/../libs/Faker/autoload.php';

class Request extends \Faker\Provider\Base
{
    protected static $pageUrls = array(
        '/',
        '/faq',
        '/faq/mobile',
        '/contact',
        '/contact/email',
        '/contact/website',
        '/info',
        '/features/list/?pk_campaign=Email-Nov2011&pk_kwd=LearnMore',
        '/download-started/',
        'http://piwik.org',
        'http://dev.piwik.org',
        'http://forums.piwik.org',
        'http://developer.piwik.org',
        'http://github.com',
        'http://piwik.org',
        'http://dev.piwik.org',
        'http://forums.piwik.org',
        'http://developer.piwik.org',
        'http://github.com/piwik',
        'http://plugins.piwik.org',
        'http://themes.piwik.org',
        'http://forums.piwik.org',
        'http://developer.piwik.org',
        'http://plugins.piwik.org',
        'http://piwik.org',
        'http://dev.piwik.org',
        'http://forums.piwik.org',
        'http://developer.piwik.org',
        'http://github.com/piwik/piwik',
        'http://themes.piwik.org',
        'http://forums.piwik.org',
        'http://developer.piwik.org',
        'http://plugins.piwik.org',
        'http://piwik.org',
        'http://dev.piwik.org',
        'http://forums.piwik.org',
        'http://developer.piwik.org',
        'http://github.com',
        'http://dev.piwik.org',
        'http://forums.piwik.org',
        'http://developer.piwik.org',
        'http://github.com/piwik/piwik',
        'http://github.com/piwik/piwik',
        'http://github.com/piwik/piwik',
        'http://github.com/piwik/piwik-mobile',
        'http://github.com/piwik/piwik-mobile-2',
        'http://github.com/piwik/piwik-mobile-2',
        'http://github.com/piwik/piwik-mobile',
        'http://piwik.org',
        'http://dev.piwik.org',
        'http://forums.piwik.org',
        'http://developer.piwik.org',
        'http://github.com',
        'http://plugins.piwik.org',
        'http://themes.piwik.org',
        'http://forums.piwik.org',
        'http://developer.piwik.org',
        'http://plugins.piwik.org',
        'http://piwik.org',
        'http://dev.piwik.org',
        'http://forums.piwik.org',
        'http://developer.piwik.org',
        'http://github.com',
        'http://themes.piwik.org',
        'http://forums.piwik.org',
        'http://developer.piwik.org',
        'http://plugins.piwik.org',
        'http://piwik.org',
        'http://dev.piwik.org',
        'http://forums.piwik.org',
        'http://developer.piwik.org',
        'http://github.com',
        '/faq/how-to/',
        '/faq/troubleshooting/',
        '/docs/update/',
        '/docs/piwik-tour/',
        '/docs/analytics-api/tutorials-examples/',
        '/faq/new-to-piwik/',
        '/docs/',
        '/docs/custom-variables/',
        '/piwik日本ユーザー会について',
        '/フォーム',
        '/技術文書',
        '/技術文書',
        '/技術文書',
        '/技術文書',
        '/技術文書',
        '/技術文書',
        '/piwikとは',
        '/piwikとは',
        '/piwikとは',
        '/piwikとは',
        '/piwikとは',
        '/piwikとは',
        '/piwikとは',
        '/piwikとは',
        '/piwikとは',
        '/機能説明/4682',
        '/機能説明/3985#01',
        '/機能説明/4800',
        '/機能説明/4800',
        '/機能説明/4800',
        '/機能説明/4800',
        '/機能説明/3985#02',
        '/機能説明/3985#03',
        '/機能説明/3986',
        '/機能説明',
        '/機能説明/2014/02/test',
        '/機能説明/2014/02/test2',
        '/機能説明/2014/02/4',
        '/faq/general/',
        '/docs/plugins/',
        '/participate/development-process/',
        '/docs/tracking-api/',
        '/participate/',
        '/blog/2012/06/piwik-ecommerce-extension-for-magento/',
        '/docs/geo-locate/',
        '/download-piwik/',
        '/faq/how-to-install/',
        '/about/',
        '/docs/installation/',
        '/blog/2012/04/how-to-use-piwik-to-track-mobile-apps-activity-clicks-phones-errors-etc/',
        '/features/',
        '/user-guide/',
        '/docs/javascript-tracking/',
        '/docs/plugins/database-schema/',
        '/log-analytics/',
        '/docs/tracking-campaigns/',
        '/docs/data-limits/',
        '/blog/2011/02/exporting-google-analytics-to-piwik-google2piwik/',
        '/docs/ecommerce-analytics/',
        '/roadmap/',
        '/the-piwik-team/',
        '/faq/',
        '/docs/analytics-api/metadata/',
        '/docs/tracking-goals-web-analytics/',
        '/docs/analytics-api/segmentation/',
        '/mobile/',
        '/contribute/',
        '/docs/analytics-api/reference/',
        '/blog/',
        '/thank-you-all/',
        '/blog/2013/02/clearcode-development-company-doing-business-with-piwik/',
        '/docs/analytics-api/',
        '/docs/segmentation/',
        '/hosting/',
        '/docs/tracking-campaigns/url-builder/',
        '/docs/site-search/',
        '/about/sponsors/',
        '/docs/manage-users/',
        '/docs/requirements/',
        '/log-analytics/how-to/',
        '/intranet-analytics/',
        '/faq/openx/',
        '/participate/coding-standards/',
        '/docs/plugins/security-checklist/',
        '/mobile/faq/',
        '/changelog/',
        '/blog/2008/11/piwik-plugin-for-drupal/',
        '/privacy/',
        '/docs/page-overlay/',
        '/blog/2009/01/using-the-piwik-api-and-google-spreadsheet-to-generate-excel-like-custom-reports/',
        '/docs/installation-optimization/',
        '/integrate/',
        '/docs/integration/',
        '/faq/phpmyvisites/',
        '/docs/real-time/',
        '/blog/category/videos/',
        '/blog/2012/12/learn-all-about-piwiks-analytics-features-9-minutes-video-tutorial/',
        '/blog/2013/02/piwik-is-on-github/',
        '/blog/2013/04/piwik-speaks-your-language/',
        '/docs/visitors-map/',
        '/blog/2008/01/how-to-setup-eclipse-php-debugging-on-windows/',
        '/docs/setup-auto-archiving/',
        '/docs/tracking-api/reference/',
        '/faq/plugins/',
        '/download-guide/',
        '/blog/2011/06/import-log-files-piwik/',
        '/docs/manage-websites/',
        '/blog/2012/12/piwik-how-to-videos/',
        '/blog/2012/10/welcome-to-piwik-analytics-video/',
        '/docs/analytics-api/calling-techniques/',
        '/blog/2009/04/if-you-need-to-serve-ads-on-your-website-check-out-openx-ad-server-28/',
        '/blog/2008/01/how-to-design-an-api-best-practises-concepts-technical-aspects/',
        '/consulting/',
        '/blog/2012/10/how-to-install-piwik-analytics-video/',
        '/search/',
        '/blog/2012/10/how-to-setup-piwik-analytics-video/',
        '/blog/2012/10/custom-variable-case-study-divezone-net/',
        '/blog/category/development/',
        '/docs/optimize/',
        '/free-software/',
        '/security/',
        '/participate/user-feedback/',
        '/docs/embed-piwik-report/',
        '/blog/integrate/mantis-plugin-piwik/',
        '/blog/category/plugins/',
        '/blog/category/community/',
        '/blog/integrate/vbulletin-addon-to-integrate-piwik/',
        '/blog/author/admin-2/',
        '/blog/integrate/phpbb-setup-instructions-to-track-with-piwik/',
        '/docs/real-time/visitor-world-map/',
        '/blog/2010/03/softaculous-now-supports-piwik/',
        '/blog/2012/10/using-custom-variables-in-piwik-tutorial/',
        '/media/',
        '/docs/transitions/',
        '/donate/',
        '/docs/plugins/hooks/',
        '/blog/2013/05/piwik-1-12/',
        '/blog/2008/06/new-plugin-wordpress-piwik-integration/',
        '/blog/2012/11/piwik-web-analytics-essentials-book-review/',
        '/blog/2008/06/new-plugin-typo3-integration/',
        '/blog/2012/08/google2piwik-update/',
        '/blog/2010/04/simplescripts-now-supports-piwik/',
        '/user-guide/video-tracking-goals/',
        '/docs/email-reports/',
        '/docs/optimize/how-to/',
        '/security/how-to-secure-piwik/',
        '/blog/2012/08/get-started-with-piwik-development-with-puppet-and-vagrant/',
        '/compare/',
        '/blog/2011/01/piwik-1-1-1/',
        '/docs/annotations/',
        '/blog/2013/03/new-v1-11-new-features-design-changes-overview-w-screenshots/',
        '/docs/page-speed/',
        '/press-review/',
        '/blog/2010/07/making-piwik-ui-faster/',
        '/blog/2013/05/last-piwik-1-x-release-v1-12-new-features-api-improvements-screenshots/',
        '/docs/include-piwik-in-your-project/',
        '/blog/2012/09/survey-results-thanks-for-the-feedback/',
        '/participate/user-interface/',
        '/blog/2012/01/piwik-best-alternative-to-urchin-web-analytics-via-log-files-import/',
        '/translations/',
        '/log-analytics/faq/',
        '/testimonials/',
        '/submit-testimonial/',
        '/log-analytics/web-hosting-use-case/',
        '/blog/2008/01/the-best-api-for-web-analytics/',
        '/blog/2013/03/piwik-at-the-2013-open-source-conference-in-japan/',
        '/blog/category/releases/',
        '/blog/2010/05/piwik-user-interface-new-design-give-your-feedback/',
        '/mobile/v2/',
        '/blog/2009/09/piwik-wins-best-of-open-source-enterprise-software-web-analytics/',
        '/faq/how-to-update/',
        '/blog/2008/10/using-the-piwik-api-and-adobe-air-interesting-use-cases/',
        '/blog/2010/01/plugin-piwik-inside-your-joomla-panel/',
        '/blog/2012/10/integrate-piwik-into-your-rails-application/',
        '/blog/2012/10/wordpress-integration-with-wp-piwik/',
        '/blog/2013/01/piwik-1-10/',
        '/user-guide/video-learn-about-your-website-visitors/',
        '/blog/category/about/',
        '/blog/2013/02/c-sharp-tracking-and-analytics-api/',
        '/blog/2012/06/piwik-1-8/',
        '/privacy/policy/',
        '/blog/2012/07/piwik-high-scale-performance-report-as-of-july-2012/',
        '/blog/2012/02/piwik-1-7-1/',
        '/blog/2012/12/happy-new-year/',
        '/docs/managing-your-databases-size/',
        '/PRIVACY/',
        '/shop/',
        '/?s=',
        '/docs/row-evolution/',
        '/blog/2009/06/7-reasons-why-your-commercial-site-needs-piwik/',
        '/blog/category/releases/page/2/',
        '/blog/2011/03/piwik-1-2-custom-variables-first-party-cookies-and-more/',
        '/participate/website-translations/instructions/',
        '/blog/category/piwik-mobile-changelog/page/2/',
        '/blog/2010/08/piwik-0-5-4-remix-by-parallels-security-advisory/',
        '/blog/2010/08/piwik-mobile-out-now/',
        '/changelog/?cat_ID=15',
        '/blog/2010/08/piwik-on-web-app-gallery/?pk_campaign=Email-Nov2011&pk_kwd=LearnMore',
        '/qa/',
        '/blog/2012/06/piwik-1-8-release-new-features-screenshots-overview/',
        '/blog/2011/06/piwik-innovative-with-javascript-canvas-chart-and-contributing-by-jqplot-creator/',
        '/participate/website-translations/',
        '/participate/website-translations/requirements/',
        '/blog/2013/03/install-piwik-with-1-click-using-installatron/',
        '/donate/thank-you/',
        '/blog/category/security/',
        '/blog/2008/06/german-video-tutorial-how-to-install-piwik/',
        '/shop/stickers/',
        '/blog/2012/07/best-alternative-yahoo-analytics/',
        '/docs/plugins/framework-overview/',
        '/blog/2010/03/piwik-irc-meetup-1/',
        '/blog/2013/06/piwik-mobile-2-preview-alpha-release/?pk_campaign=Email-Nov2011&pk_kwd=LearnMore',
        '/blog/2008/04/bloggers-blog-about-piwik-worldwide/',
        '/participate/contributing-with-git/',
        '/blog/2010/07/new-piwik-tracking-api-track-visits-from-mobile-apps-desktop-apps-anywhere/',
        '/blog/category/meta/',
        '/blog/2010/08/open-source-world-map-for-piwik/',
        '/blog/2013/01/web-analytics-governments/',
        '/user-guide/video-actions-reports-page-views-downloads-clicks/',
        '/user-guide/referrers-reports/',
        '/blog/2009/06/7-reasons-why-your-commercial-site-needs-piwik/)',
        '/blog/2009/02/software-geeks-how-piwik-automatically-generates-the-api-using-php-reflection/',
        '/blog/2013/04/piwik-mobile-1-9-5/',
        '/blog/2012/06/integrate-piwik-with-your-cms-ecommerce-framework-or-programming-language/',
        '/blog/2012/12/the-march-towards-piwik-2-0-and-crowdfunding/',
        '/blog/tasks/add-system-check-page-in-admin-section/',
        '/blog/category/piwik-mobile-changelog/',
        '/blog/2012/08/new-piwik-release-v1-8-3-features-overview-w-screenshots/',
        '/blog/2013/01/webinar-webstatistik-mit-piwik/',
        '/blog/2013/04/alwaysdata-web-hosting-piwik-org/',
        '/blog/2009/05/100000-downloads-milestone/',
        '/blog/page/2/',
        '/blog/page/3/',
        '/blog/2008/11/keep-track-of-new-piwik-versions-and-changes-with-the-changelog-page-and-feed/',
        '/blog/2012/10/new-piwik-release-v1-9-features-overview-w-screenshots/',
        '/blog/2008/11/new-version-of-piwik-why-you-should-upgrade/',
        '/blog/2013/07/first-beta-of-piwik-mobile-2-for-android/',
        '/blog/2012/10/analytics-data-your-way-free-with-piwik-analytics-brand-new-features-press-release/',
        '/blog/2013/01/new-piwik-release-v1-10-major-new-features-overview-w-screenshots-2/',
        '/integrate/how-to/',
        '/managing-your-databases-size/purge_schedule_period2/',
        '/blog/2010/12/new-version-of-piwik-mobile-released-screenshots/',
        '/user-guide/video-email-and-sms-reports/',
        '/blog/2012/04/urchin-is-discontinued-piwik-server-log-import-goes-live/',
        '/participate/licensing/',
        '/blog/2009/12/piwik-response-to-shocking-news-in-php-exploitation/',
        '/blog/2011/01/piwik-1-1-2/',
        '/blog/2011/03/piwik-can-be-used-in-compliance-with-data-protection-laws/',
        '/blog/2013/02/piwik-microsoft-windows-web-app-gallery/',
        '/blog/2008/12/piwik-0227/',
        '/blog/integrate/dnnp-dotnetnuke-plugin/',
        '/blog/2012/10/piwik-mobile-1-9-2/',
        '/free-software/bsd/',
        '/blog/2011/06/piwik-1-5-available-ecommerce-analytics/',
        '/blog/2008/07/new-plugin-piwik-dokuwiki-integration/',
        '/docs/plugins/functions/',
        '/blog/integrate/typo3-extension-piwik-integration/',
        '/blog/integrate/spip-contrib-piwik/',
        '/blog/2008/06/however-im-not-normal-so-piwik-has-made-me-sit-up-and-say-oooh/',
        '/blog/2009/11/piwik-goal-tracking-how-i-optimized-my-affiliate-income/',
        '/blog/2008/06/invitation-piwik-focus-group-in-london-on-saturday-july-5th/',
        '/blog/2011/06/piwik-1-5/',
        '/blog/integrate/oxid-analyse-plugin-for-piwik/',
        '/blog/2010/08/piwik-1-0/',
        '/blog/2010/12/better-piwik-forums/',
        '/blog/2011/02/piwik-1-2/',
        '/blog/2012/10/integrate-piwik-into-your-rails-application/piwik_site_id/',
        '/blog/2011/01/professional-security-audit-in-piwik/',
        '/blog/2011/01/piwik-mobile-1-0-0/',
        '/blog/2010/02/piwik-response-to-zend-framework-security-advisory-zf2010-01/',
        '/blog/tag/magento-extension/',
        '/blog/2008/05/spotitv-is-looking-to-hire-a-full-time-developer-to-make-piwik-scalable/',
        '/chanchelog/',
        '/docs/managing-your-databases-size/%27',
        '/blog/2008/06/new-plugin-mediawiki-piwik-integration/',
        '/blog/2012/10/piwik-1-9/',
        '/blog/2012/10/piwik-1-9-1/',
        '/blog/2012/11/conference-sur-piwik-le-samedi-24-novembre-a-supinfo-paris/',
        '/blog/2012/11/piwik-1-9-2/',
        '/blog/2012/11/piwik-mobile-1-9-3-2/',
        '/blog/2012/12/piwik-needs-your-help-now/',
        '/blog/2013/02/piwik-mobile-1-9-4/',
        '/blog/2013/03/quick-updates-google-beta-1-11-and-french-support/',
        '/blog/2013/03/piwik-1-11/',
        '/blog/category/press-release/',
        '/blog/2010/04/piwik-press-release/',
        '/blog/integrate/ecommerce-analytics-for-virtuemart/',
        '/API',
        '/blog/2008/03/welcome-piwik-beta-version/',
        '/blog/2008/04/have-you-got-a-website-with-more-than-10000-visits-per-day-you-can-help-us-test-piwik/',
        '/blog/integrate_categories/ecommerce-online-shops/',
        '/trademark/',
        '/blog/2010/07/piwik-0-7/',
        '/newsletter/',
        '/docs/custom-variables/google%20analytics',
        '/api',
        '/participate/agreement-form/',
        '/blog/page/8/',
        '/blog/page/28/',
        '/blog/page/18/',
        '/blog/page/10/',
        '/blog/page/16/',
        '/blog/page/14/',
        '/blog/page/12/',
        '/blog/2008/01/hello-the-web-analytics-world/',
        '/blog/integrate/laravel-piwik-bundle/',
        '/blog/2013/03/new-v1-12-new-features-design-changes-overview-w-screenshots/',
        '/blog/author/admin-2/page/3/',
        '/blog/2013/07/wanted-beta-testers-for-piwik-mobile-2-for-ios/',
        '/blog/2011/02/reshaping-piwik-documentation/?pk_campaign=Email-Nov2011&pk_kwd=OrderNow',
        '/blog/2009/04/piwik-response-to-cve-2009-1085/',
        '/blog/roadmap_categories/new-features-for-piwik/',
        '/mobile/v2/faq/',
        '/blog/2011/07/ecommerce-analytics-is-hard/?pk_campaign=Email-Nov2011&pk_kwd=OrderNow',
        '/blog/2011/09/announcing-piwik-meetup-in-munich-germany-on-oct-22nd-register-now-free/',
        '/blog/2009/06/new-piwik-javascript-tracking-api-how-we-designed-it/',
        '/docs/piwik-org',
        '/docs/requirements/%EF%BC%89',
        '/timeline/',
        '/shop/merchandise/',
        '/blog/2012/02/7775/',
        '/docs/setup-auto-archiving/%3cbr/',
        '/blog/2012/03/piwik-mobile-1-7/',
        '/blog/about-features/goal-conversion-tracking/',
        '/blog/users/',
        '/old-roadmap/',
        '/blog/integrate/roundcube-webmail-plugin-piwik-analytics/',
        '/blog/integrate/kooboo-piwik-plugin/',
        '/blog/about-features/domain-cookie-behaviour/?pk_campaign=Email-Nov2011&pk_kwd=OrderNow',
        '/blog/integrate/piwiktracker-for-objective-c/',
        '/blog/integrate_categories/programming-language/',
        '/blog/tasks/page-transitions-clickpath-to-show-previousnext-pages-for-any-selected-page-clickpath-page-analytics-now-available-since-piwik-1-9/',
        '/blog/2012/06/piwik-1-8-1/',
        '/docs/installation/%3C',
        '/blog/2011/07/how-can-we-improve-the-website-piwik-org-feedback-suggestions/',
        '/blog/tasks/open-source-svg-world-map-to-show-regions-and-cities-be-100-flash-free/',
        '/blog/2009/02/piwik-consulting-find-paid-support-custom-plugin-development-from-approved-piwik-consultants/',
        '/blog/2012/06/web-analytics-platform-reaches-1-million-downloads/',
        '/blog/2011/06/piwik-1-5-piwik-mobile-app-1-5-release-candidates-call-for-testers/',
        '/blog/2008/11/piwik-and-translations-update/',
        '/blog/tasks/piwik-as-the-ultimate-urchin-alternative-and-awstats-alternative-modern-web-analytics-from-server-logs-now-available-since-piwik-1-8/',
        '/blog/2012/02/new-features-in-piwik-1-7-screenshots/',
        '/blog/users/',
        '/blog/2011/11/piwik-mobile-1-6-2/',
        '/blog/2010/04/piwik-org-website-now-available-in-german/',
        '/blog/tasks/create-custom-alerts-on-any-piwik-reports-and-metrics-and-automatically-receive-an-email-when-they-are-triggered/',
        '/blog/2011/11/new-quality-piwik-t-shirts-now-available/',
        '/suggest-a-topic/',
        '/blog/2010/08/piwik-0-9-9/',
        '/blog/integrate/grails-plugin/',
        '/blog/2011/10/piwik-1-6/?pk_campaign=Email-Nov2011&pk_kwd=OrderNow',
        '/blog/2011/06/piwik-mobile-1-5/piwikmobile150ios3pages/',
        '/blog/2011/06/piwik-1-5-security-advisory/',
        '/blog/2011/04/piwik-1-3-released/',
        '/crowdfunding/',
        '/blog/2011/06/piwik-mobile-1-5/piwikmobile150ios4graphdetailview/',
        '/blog/2012/04/how-to-use-piwik-to-track-mobile-apps-activity-clicks-phones-errors-etc/piwik-optin-example-3/',
        '/blog/2009/06/piwik-04/',
        '/forum-header/',
        '/blog/2011/10/piwik-mobile-1-6/',
        '/blog/2010/07/new-piwik-design-screenshots/',
        '/blog/2009/09/piwik-is-sourceforge-project-of-the-month/',
        '/blog/integrate/knppiwikbundle-for-symfony2/',
        '/blog/2008/11/piwik-in-the-grand-canyon/',
        '/the-piwik-team/de/',
        '/blog/tag/rails/',
        '/blog/2011/02/should-we-offer-piwik-hosted/',
        '/blog/author/fabian/',
        '/blog/integrate/elgg-plugin-piwik/',
        '/i',
        '/blog/2008/02/why-is-piwik-better-than-the-competition/',
        '/blog/integrate_categories/integrate-category/?pk_campaign=Email-Nov2011&pk_kwd=OrderNow',
        '/blog/tasks/send-scheduled-reports-via-sms-text-message/',
        '/latest.zip',
        '/latest.zip',
        '/latest.zip',
        '/latest.zip',
        '/latest.zip',
        '/latest.zip',
        '/latest.zip',
        '/latest.zip',
        '/latest.zip',
        '/latest.zip',
        '/latest.zip',
        '/latest.zip?pk_campaign=Email-Nov2011&pk_kwd=OrderNow',
        '/latest.zip',
        '/latest.zip',
        '/latest.zip',
        '/latest.zip',
        '/latest.zip',
        '/latest.zip',
        '/latest.zip?pk_campaign=Email-Nov2011&pk_kwd=LearnMore',
        '/latest.zip',
        '/latest.zip',
        '/latest.zip',
        '/latest.zip',
        '/latest.zip',
        '/latest.zip',
        '/latest.zip',
        '/latest.zip',
        '/latest.zip',
        '/latest.zip',
        '/latest.zip',
        '/latest.zip',
        '/latest.zip',
        '/blog/2011/04/piwik-1-4/',
        '/blog/2012/07/piwik-japan-team-exhibited-at-the-interop-tokyo-2012-convention/',
        '/blog/2012/09/piwik-mobile-1-9-1/',
        '/docs/api',
        '/blog/tasks/support-5-custom-variables-at-the-visit-level-and-provide-new-reports-on-these-variables-now-available-in-piwik-1-1/',
        '/piwik-1.10-b2.zip',
        '/blog/2008/06/new-plugin-dotclear2-integration/',
        '/blog/2012/09/piwik-1-8-4/',
        '/user-guide/track-your-visitors/',
        '/blog/2009/10/piwik-response-to-secunia-advisory-sa37078/',
        '/blog/integrate/piwik-integration-for-ilias/',
        '/blog/integrate/piwik-integration-for-xenforo/?pk_campaign=Email-Nov2011&pk_kwd=LearnMore',
        '/blog/integrate/integrate-the-piwik-http-api-into-joomla/',
        '/blog/integrate/?pk_campaign=Email-Nov2011&pk_kwd=OrderNow',
        '/page/5',
        '/page/8',
        '/participate/development-metrics/',
        '/blog/2013/06/piwik-mobile-1-9-6/',
        '/blog/integrate/nodejs-piwik/?pk_campaign=Email-Nov2011&pk_kwd=OrderNow',
        '/blog/2010/03/piwik-irc-meetup-2/?pk_campaign=Email-Nov2011&pk_kwd=LearnMore',
        '/gmistudio',
        '/h72',
        '/user-guide/piwik-administration/',
        '/blog/tasks/show-graph-of-visitspages-over-the-last-30-days-for-a-specific-row-keyword-country-etc-see-the-new-row-evolution-screenshots/',
        '/blog/integrate/piwik-integration-for-drupal/',
        '/blog/2012/08/piwik-1-8-3/?pk_campaign=Email-Nov2011&pk_kwd=OrderNow',
        '/participate/website-translations/more-info/',
        '/blog/2012/10/using-custom-variables-in-piwik-tutorial/%C2%A0',
        '/localhost',
        '/blog/2012/09/new-piwik-release-v1-8-4-features-overview-w-screenshots/',
        '/blog/2009/04/piwik-0233/',
        '/docs/integration/integrate-piwik-with-your-cms-ecommerce-software-and-more/',
        '/blog/2010/04/piwik-0-6-security-advisory/',
        '/%20mobile/',
        '/wenmar',
        '/blog/category/community/page/2/?pk_campaign=Email-Nov2011&pk_kwd=LearnMore',
        '/blog/integrate/silverlight-piwik-tracking/',
        '/blog/integrate/symfony-piwik-plugin/',
        '/blog/2012/10/',
        '/log-%C2%AD%E2%80%90analytics/',
        '/blog/2011/06/piwik-mobile-1-5/',
        '/blog/2011/07/piwik-1-5-1/',
        '/blog/category/development/page/2/?pk_campaign=Email-Nov2011&pk_kwd=LearnMore',
        '/blog/integrate/zen-cart-plugin-for-piwik/',
        '/blog/tag/integration/',
        '/blog/integrate/codeigniter-library-for-piwik/',
        '/blog/integrate/ruby-on-rails-piwik-gem/',
        '/blog/integrate/c-client-for-analytics-api/',
        '/demo/libs/open-flash-chart/open-flash-chart.swf?v2i',
        '/demo/libs/open-flash-chart/open-flash-chart.swf',
        '/%5D',
        '/blog/2008/04/piwik-is-ready-to-be-translated-we-need-your-help/',
        '/blog/2012/09/piwik-mobile-1-9/',
        '/trac/login',
        '/blog/2010/04/call-to-beta-testers-piwik-0-6-rc1/',
        '/download-piwik',
        '/blog/2008/02/piwik-presentation/',
        '/t',
        '/blog/2010/03/piwik-055/',
        '/read.php?6,17251',
        '/blog/tasks/include-country-city-detection-via-geoip-database-in-core-geo-locate-your-visitors-is-now-available-since-piwik-1-9/',
        '/faq/how-to/freebsd%20php%20folder',
        '/docs/installation/?codekitCB=398967303.973608',
        '/blog/2011/03/piwik-1-2-1/',
        '/blog/integrate/php-client-for-tracking-api/?pk_campaign=Blog&pk_kwd=More',
        '/free-software/mobile/',
        '/blog-7/',
        '/blog/author/thomas/',
        '/logos-proposal/',
        '/blog/tasks/faster-reliable-tracking-piwik-php-asynchronous-tracking-import/',
        '/blog/tasks/asynchronous-javascript-tracking-code-for-faster-website-load-now-available-in-piwik-1-2/',
        '/blog/tasks/segmentation-implementation-ui-for-addingediting-and-switching-segments/',
        '/features/img/header/nav_background.png',
        '/img/header/nav_background.png',
        '/blog/author/marc/',
        '/log-in',
        '/blog/author/julien/',
        '/blog/integrate/jenkins-module/',
        '/blog/2013/08/piwik-at-free-and-open-source-software-conference/?pk_campaign=Blog&pk_kwd=More',
        '/404',
        '/blog/page/15/',
        '/blog/page/13/',
        '/blog/2011/04/piwik-1-4-released-html-reports-beta-ipv6-support-better-campaign-tracking/',
        '/blog/2011/02/piwik-mobile-1-2/',
        '/blog/2011/04/piwik-1-3/',
        '/analytics/cultizer',
        '/blog/2009/05/piwik-0235/',
        '/blog/2013/08/second-beta-of-piwik-mobile-2-for-android/',
        '/blog/2011/11/piwik-stickers-design-contest-prizes/?pk_campaign=Blog&pk_kwd=More',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/piwik-1.9.3-b10.zip',
        '/blog/integrate/page/4/',
        '/blog/integrate/joomla-extension/',
        '/blog/2010/06/piwik-0-6-3/',
        '/blog/author/admin-2/page/2/',
        '/download-started/img/icons/affix-arrows.png',
        '/participate/documentation/',
        '/features/IRANHACKTEAM',
        '/downloads',
        '/blog/cetgory/videos',
        '/%3Cbr%20/%3E',
        '/download-started/Piwik%20is%201.12',
        '/download-piwik/Piwik%20is%201.12.zip',
        '/download-piwik/Piwik%20is%201.12.zip',
        '/download-piwik/Piwik%20is%201.12.zip',
        '/download-piwik/Piwik%20is%201.12.zip',
        '/download-piwik/Piwik%20is%201.12.zip',
        '/download-piwik/Piwik%20is%201.12.zip',
        '/download-piwik/Piwik%20is%201.12.zip',
        '/download-piwik/Piwik%20is%201.12.zip',
        '/intgrated',
        '/?nr=0',
        '/docs/tracking-api/fail',
        '/img/backgrounds/pattern_top.png',
        '/blog/integrate/oscommerce-e-commerce-analytics/',
        '/blog/2012/02/new-features-in-piwik-1-7-screenshots/href=',
        '/forums',
        '/blog/about-features/custom-variables-tip/',
        '/blog/2011/10/piwik-mobile-1-6-1/',
        '/blog/integrate/gwt-wrapper-for-piwik/',
        '/docs/instalation',
        '/hosting/partners/',
        '/img/icons/quotation.png',
        '/blog/tasks/replace-flash-graphs-with-javascript-canvas-graphs-charts-now-available-in-piwik-1-5/',
        '/read.php?2,44701',
        '/blog/roadmap_categories/admin-settings/',
        '/moderation.php',
        '/blog/2012/08/piwik-linkedin-group-join-the-discussion/',
        '/free-software/bsd/%20Simplified%20BSD%20(also%20in%20js/LICENSE.txt)/',
        '/blog/integrate/piwik-mod-for-mybb/',
        '/blog/2012/03/piwik-mobile-1-7-1/',
        '/features/demo',
        '/blog/integrate_categories/content-management-systems/',
        '/blog/2010/06/piwik-press-release/',
        '/mta',
        '/blog/2011/06/piwik-community-survey-here-are-the-results/',
        '/blog/2011/06/piwik-mobile-1-5/piwikmobile150android2live/',
        '/?event=reg',
        '/blog/2012/11/piwik-1-9-2/?icl_string_track_value=Post+Comment&icl_string_track_context=theme',
        '/blog/2008/04/piwik-jobs/',
        '/blog/2009/02/piwik-0229/',
        '/blog/roadmap_categories/user-interface-improvements/',
        '/blog/feature_categories/live-map-preview/',
        '/blog/2012/05/piwik-response-to-zf2011-02-security-advisory/',
        '/%20mysql%20versions',
        '/blog/2010/05/release-of-piwik-0-6-2/',
        '/blog/users/matthieu-aubry/',
        '/blog/tasks/new-report-days-to-conversionpurchase-now-available-in-piwik-1-7/',
        '/faq/?search=',
        '/blog/2012/06/community-marketing-leader-wanted/',
        '/hosting',
        '/docs/themes/',
        '/docs/theme',
        '/DoC7Installaion',
        '/Doc/Installaion',
        '/Doc/installaion',
        '/blog/2009/04/piwik-0233-released-are-there-any-bug-left-in-piwik/',
        '/blog/2012/08/survey-your-opinion-matters/',
        '/blog/2008/05/piwik-is-looking-for-a-translator-coordinator-be-part-of-the-piwik-team/',
        '/blog/2008/02/welcome-japan/',
        '/download-piwik/*',
        '/blog/author/matt/',
        '/blog/tasks/make-row-evolution-feature-even-more-awesome/',
        '/blog/integrate/piwik-integration-for-cms-made-simple/',
        '/blog/2010/05/piwik-0-6-2/',
        '/submit-/',
        '/blog/users/piwik-team/',
        '/blog/users/noah-firth/',
        '/blog/users/benaka-m/',
        '/blog/users/adrian-speyer/',
        '/docs/installation-/',
        '/blog/2010/03/piwik-irc-meetup-3/',
        '/%20contao',
        '/security/%E2%80%8E',
        '/googlef808bef11519e880.html',
        '/blog/integrate/silex-plugin/',
        '/blog/category/about/page/2/',
        '/demo/themes/default/images/chart_bar.png%22=20',
        '/demo/libs/javascript/sprintf.js?piwik=3D0.4.3&quot;=20',
        '/blog/category/community/page/3/',
        '/demo/%22',
        '/participate/quality-assurance/',
        '/participate/translations-2/',
        '/blog/tasks/ecommerce-analytics-analytics-ecommerce-now-available-in-piwik-1-5/',
        '/blog/2012/03/piwik-mobile-1-7/iphone_5_summary/',
        '/blog/tasks/lock-down-accounts-by-ip-after-n-failed-attemps-at-logging/',
        '/blog/2011/04/new-piwik-mobile-app-released-also-piwik-1-3rc1-available-for-early-adopters/',
        '/blog/2008/11/sourceforge-offers-piwik-to-150000-open-source-projects/',
        '/blog/2009/06/piwik-041/',
        '/blog/integrate/vanilla-forum-piwik-analytics-plugin/',
        '/blog/2013/01/crowdfunding-success-for-svg-maps-up-next-custom-filter-editor/',
        '/blog/author/adrian/',
        '/blog/2013/09/piwik-mobile-1-9-7-brings-better-support-for-ios7/',
        '/one_oneisgreat',
        '/faq/how-to/fdjkghdkj',
        '/blog/author/admin-2/page/4/',
        '/LOGIN',
        '/changelog/%23',
        '/blog/2012/05/piwik-mobile-1-8/',
        '/nik',
        '/portal',
        '/docs/tracking.api/',
        '/docs/javascript-tracking/:',
        '/blog/2012/06/piwik-ecommerce-extension-for-magento/%3Cspan%20class=',
        '/blog/integrate/ez-publish-module/',
        '/docs/javascript-tracking/',
        '/blog/users/fabian-becker/',
        '/changelog/?cat_ID=%22&#039;%3CClV88%3E',
        '/docs/javascript-trackng/',
        '/blog/category/documentation/',
        '/register',
        '/signin',
        '/blog/integrate/python-client-for-tracking-api-and-analytics-api/',
        '/blog/2009/03/piwik-0232/',
        '/fixfocus',
        '/docs/custom-variables/:/',
        '/log-analytics/?r44b=no',
        '/faq/general/:/',
        '/%5DPiwik%5B/url%5D',
        '/img/numbers_sprite.png?pk_campaign=Email-Nov2011&pk_kwd=OrderNow',
        '/blog/2010/05/release-of-piwik-0-6-2/entry-pages/?pk_campaign=Blog&pk_kwd=More',
        '/docs/ecommerce-analytics/%23toc-tracking-ecommerce-orders-items-purchased-required',
        '/user-guide/video-actions-reports-page-views-downloads-clicks/%3Cspan%20class=',
        '/license',
        '/log-analytics/how-to/%20filter%20bots',
        '/docs/campaigns',
        '/blog/2010/05/piwik-0-6/',
        '/blog/2008/01/how-to-design-an-api-best-practises-concepts-technical-aspects/%20and%20updates',
        '/contact-professional-support/',
        '/blog/2011/10/piwik-response-to-cve-2011-3791/?pk_campaign=Blog&pk_kwd=More',
        '/docs/tracking-api/',
        '/docs/ecommerce-analytics/%3Cscript%3Ealert5840%3C/script%3E.html',
        '/blog/tasks/',
        '/blog/2013/09/piwik-mobile-1-9-8-with-full-support-for-ios-7/?pk_campaign=Blog&pk_kwd=More',
        '/FAQ/',
        '/blog/tasks/graphs-list-of-improvements-jqplotjs/?pk_campaign=Email-Nov2011&pk_kwd=OrderNow'
    );

    protected static $resolutions = array(
        '1024x768',
        '1280x800',
        '800x600',
        '480x800',
        '800x480',
        '2560x1440',
        '1536x864',
        '1360x768',
        '768x1024',
        '360x640',
        '640x1136',
        '360x592',
        '720x1280',
        '640x960',
        '1600x1200',
        '3360x2100',
        '1400x1050',
        '3840x2400',
        '601x906',
        '384x592',
        '320x534',
        '2048x1152',
        '600x912',
        '320x240',
        '320x568'
    );

    public function pageURL()
    {
        return static::randomElement(static::$pageUrls);
    }

    public function productName()
    {
        return static::randomElement(array(
            'My Product',
            'Test Product',
            'Product Name',
            'Awesome Product'
        ));
    }

    public function resolution()
    {
        $resolution = static::randomElement(static::$resolutions);

        return explode('x', $resolution);
    }

    public function gender()
    {
        return static::randomElement(array('male', 'female', ''));
    }

    public static function getAcceptLanguages()
    {
        return array(
            "el,fi;q=0.5",
            "de-de,de;q=0.8,en-us",
            "pl,en-us;q=0.7,en;q=",
            "zh-cn",
            "fr-ca",
            "en-us",
            "en-gb",
            "fr-be",
            "fr,de-ch;q=0.5",
            "fr",
            "fr-ch",
            "fr",
        );
    }

    public function acceptLanguage()
    {
        return static::randomElement(self::getAcceptLanguages());
    }

    public function region($countryCode)
    {
        $regions = GeoIp::getRegionNames();

        if (!empty($regions[$countryCode])) {
            $regionCodes = array_keys($regions[$countryCode]);
            $regionCode  = static::randomElement($regionCodes);

            return strtoupper($regionCode);
        }

        return static::randomElement(array(
            '13', 'TX', 'CA', '07', '09', 'E4', 'B7', '01', '46', '01', 'AL', '16', 'B7', 'CA', '78', 'B8', '04', '04', 'B8', 'TX', 'NY', '15', '04', 'FL', 'PA', 'C9', '01', 'P8', '29', '56', '02', '29', 'CA', '27', 'BC', '09', 'NE', '13', 'TX', 'TX', 'B8', 'FL', 'E7', 'PA', '12', '14', '27', 'M3', '02', '09', '29', '42', 'QC', 'C9', '02', '01', 'WV', 'AL', '51', 'H5', '07', 'MD', '34', '16', 'CA', 'E7', 'NY', '08', 'GA',
        ));
    }

    public function searchEngine()
    {
        return static::randomElement(array('', 'DuckDuckGo', 'Google', 'Bing', 'Baidu', 'Yahoo!', 'Ask', 'Babylon'));
    }

    public function searchEngineUrlWithKeyword($keyword)
    {
        $url = static::randomElement(array(
            'http://www.google.com/search?sourceid=chrome&ie=UTF-8&q=',
            'http://www.google.it/url?sa=t&source=web&cd=2&q=',
            'http://www.google.de/search?ie=utf-8&oe=utf-8&aq=t&rls=org.mozilla:de:official&client=firefox-a&q=',
            'http://yandex.ru/yandsearch?lr=213&text=',
            'http://www.bing.com/search?FORM=IE8SRC&q=',
            'http://www.bing.com/search?q=',
            'http://uk.search.yahoo.com/search?ei=UTF-8&fr=moz35&q=',
            'http://search.yahoo.com/search;?p=',
            'http://uk.ask.com/web?l=dis&prt=NIS&chn=retail&geo=GB&ver=19&odn=&dm=all&q='
        ));

        return $url . $keyword;
    }

    public function searchEngineUrlWithOutKeyword()
    {
        $url = static::randomElement(array(
            'https://www.bing.com/',
            'https://duckduckgo.com/',
            'https://www.google.de/url?sa=t&source=web&rct=j&url=https://matomo.org/&ved=0ahUKEwi3qreZtuHaAhXEHpoKHXxxBxEQFggsMAA',
            'https://www.google.fr/',
            'http://r.search.yahoo.com/_ylt=AwrE1yEOwOZauucA_xoDEQx.;_ylu=X3oDMTByOHZyb21tBGNvbG8DYmYxBHBvcwMxBHZ0aWQDBHNlYwNzcg--/RV=2/RE=1525100687/RO=10/RU=https%3a%2f%2fmatomo.org%2f/RK=2/RS=QEhnjr714z0Me7kPhYj1gHrLTKc-',
            'http://search.yahoo.co.jp/r/FOR=wJjKBrpV3iiyQ9OVtYIAEFhwB6F4X7nB3uwubUjurHLqwT8oFNO7dNiZBXYbmgNENZz8yKntTR5X_chrfaAcSOgPUyuK.Y5mOUs5tzKNLuq42vgCKLHdBH3gavAtCoKeCKOItwbkCN10nMDO9gO8MW9zdH9TOyAul7u1sqXEE0wTNpY6DW.EFfagOL54JzI3OBVfIin7/_ylt=A2RAyhx.wOZaQWsATEuDTwx.;_ylu=X3oDMTBtNHJhZXRnBHBvcwMxBHNlYwNzcgRzbGsDdGl0bGU-/SIG=11fhbagaq/EXP=1525172798/**https%3A//matomo.jp/news/7540',
            'https://yandex.ru/'
        ));

        return $url;
    }

    public function referrer()
    {
        $urlReferrer  = $this->generator->url;
        $urlKeyword   = $this->searchEngineUrlWithKeyword($this->generator->word);
        $urlNoKeyword = $this->searchEngineUrlWithOutKeyword();

        return static::randomElement(array(
            '',
            '',
            '',
            $urlReferrer,
            $urlReferrer,
            $urlReferrer,
            $urlReferrer,
            $urlReferrer,
            $urlReferrer,
            $urlReferrer,
            $urlReferrer,
            $urlReferrer,
            $urlNoKeyword,
            $urlNoKeyword,
            $urlNoKeyword,
            $urlNoKeyword,
            $urlKeyword,
            $urlKeyword,
            $urlKeyword,
            $urlKeyword,
            $urlKeyword,
            $urlKeyword,
            $urlKeyword,
            $urlKeyword,
            $urlKeyword,
            'https://www.facebook.com/',
            'https://fb.me/',
            'https://twitter.com/',
            'https://github.com/',
            'http://www.facebook.com/l.php?u=http%3A%2F%2Fpiwik.org%2F',
            'http://www.example.com/5-great-google-analytics-alternatives/?utm_content=ourfake&utm_medium=social&utm_source=twitter.com&utm_campaign=buffer',
            'http://www.example.org/blog/15-google-analytics-alternatives?utm_source=twitter&utm_medium=social&utm_campaign=blog',
            'http://t.co/itFSLvPlqW',
            'http://t.co/g0Alwc83T6'
            ));
    }
}
