<?php
/**
 * @file
 * Default theme implementation to display a node.
 *
 * Available variables:
 * - $title: the (sanitized) title of the node.
 * - $content: An array of node items. Use render($content) to print them all,
 *   or print a subset such as render($content['field_example']). Use
 *   hide($content['field_example']) to temporarily suppress the printing of a
 *   given element.
 * - $user_picture: The node author's picture from user-picture.tpl.php.
 * - $date: Formatted creation date. Preprocess functions can reformat it by
 *   calling format_date() with the desired parameters on the $created variable.
 * - $name: Themed username of node author output from theme_username().
 * - $node_url: Direct URL of the current node.
 * - $display_submitted: Whether submission information should be displayed.
 * - $submitted: Submission information created from $name and $date during
 *   template_preprocess_node().
 * - $classes: String of classes that can be used to style contextually through
 *   CSS. It can be manipulated through the variable $classes_array from
 *   preprocess functions. The default values can be one or more of the
 *   following:
 *   - node: The current template type; for example, "theming hook".
 *   - node-[type]: The current node type. For example, if the node is a
 *     "Blog entry" it would result in "node-blog". Note that the machine
 *     name will often be in a short form of the human readable label.
 *   - node-teaser: Nodes in teaser form.
 *   - node-preview: Nodes in preview mode.
 *   The following are controlled through the node publishing options.
 *   - node-promoted: Nodes promoted to the front page.
 *   - node-sticky: Nodes ordered above other non-sticky nodes in teaser
 *     listings.
 *   - node-unpublished: Unpublished nodes visible only to administrators.
 * - $title_prefix (array): An array containing additional output populated by
 *   modules, intended to be displayed in front of the main title tag that
 *   appears in the template.
 * - $title_suffix (array): An array containing additional output populated by
 *   modules, intended to be displayed after the main title tag that appears in
 *   the template.
 *
 * Other variables:
 * - $node: Full node object. Contains data that may not be safe.
 * - $type: Node type; for example, story, page, blog, etc.
 * - $comment_count: Number of comments attached to the node.
 * - $uid: User ID of the node author.
 * - $created: Time the node was published formatted in Unix timestamp.
 * - $classes_array: Array of html class attribute values. It is flattened
 *   into a string within the variable $classes.
 * - $zebra: Outputs either "even" or "odd". Useful for zebra striping in
 *   teaser listings.
 * - $id: Position of the node. Increments each time it's output.
 *
 * Node status variables:
 * - $view_mode: View mode; for example, "full", "teaser".
 * - $teaser: Flag for the teaser state (shortcut for $view_mode == 'teaser').
 * - $page: Flag for the full page state.
 * - $promote: Flag for front page promotion state.
 * - $sticky: Flags for sticky post setting.
 * - $status: Flag for published status.
 * - $comment: State of comment settings for the node.
 * - $readmore: Flags true if the teaser content of the node cannot hold the
 *   main body content.
 * - $is_front: Flags true when presented in the front page.
 * - $logged_in: Flags true when the current user is a logged-in member.
 * - $is_admin: Flags true when the current user is an administrator.
 *
 * Field variables: for each field instance attached to the node a corresponding
 * variable is defined; for example, $node->body becomes $body. When needing to
 * access a field's raw values, developers/themers are strongly encouraged to
 * use these variables. Otherwise they will have to explicitly specify the
 * desired field language; for example, $node->body['en'], thus overriding any
 * language negotiation rule that was previously applied.
 *
 * @see template_preprocess()
 * @see template_preprocess_node()
 * @see template_process()
 *
 * @ingroup templates
 */
?>
<article id="node-<?php print $node->nid; ?>" class="<?php print $classes; ?> clearfix"<?php print $attributes; ?>>

    <header>
        <div class="container-fluid gardient-blue-bg">
			<div class="row">
					<div class="text-center logo padding-none">
						<div class="container padding-small-vertical"><span class="white pull-left"><strong>weightloss.hu</strong></span> <span class="kalam yellow pull-right"><?php print render($content['field_top_slogan']['#items']['0']['value']); ?></span></div>
					</div>
			</div>
		</div>
		<div class="gray-bg">
			<div class="container">
				<div class="row">
					<div class="">
						<!--<img class="img-responsive" src="img/profile.png" alt="">-->
						<?php if (!empty($content['field_header_image'])): ?>
						<div class="hidden-xs col-sm-6 col-md-5 col-lg-5 col-lg-offset-1 col-md-offset-1">
							<div class="">
								<img class="img-responsive pull-left" id="topWoman" src="<?php print file_create_url($content['field_header_image']['#items'][0]['uri']); ?>" alt="">
							</div>
						</div>
						<?php endif; ?>
						<div class="<?php !empty($content['field_header_image']) ? print 'col-xs-12 col-sm-6 col-md-6 col-lg-6' : print ''; ?>  padding-small-top">
							<?php print render($content['field_header_content']['#items']['0']['value']); ?>
						</div>
					</div>
				</div>
			</div>
        </div>
    </header>

	<?php if (!empty($content['field_line_1'])): ?>
	<section class="padding-medium-vertical light-green-bg">
		<div class="container padding-small-vertical">
			<div class="row">
				<div class="col-lg-12 text-center">
					<h2 class="white margin-none padding-none"><?php print render($content['field_line_1']['#items']['0']['value']); ?></h2>
				</div>
			</div>
		</div>
	</section>
	<?php endif; ?>
	
	<?php if (!empty($content['field_bottom_image']) || !empty($content['field_line_2'])): ?>
	<section class="gray-bg">
		<div class="padding-small-vertical">
			<div class="container">
				<div class="row">
					<?php print render($content['field_line_2']['#items']['0']['value']); ?>
				</div>
			</div>
			<?php if (!empty($content['field_bottom_image'])): ?>
			<div class="">
				<img class="img-responsive" src="<?php print file_create_url($content['field_bottom_image']['#items'][0]['uri']); ?>" />
			</div>
			<?php endif; ?>
		</div>
	</section>
	<?php endif; ?>
	
  <?php /*
    // Hide comments, tags, and links now so that we can render them later.
    hide($content['comments']);
    hide($content['links']);
    hide($content['field_tags']);
    print render($content);
  ?>
  <?php if (!empty($content['field_tags']) || !empty($content['links'])): ?>
  <footer>
    <?php print render($content['field_tags']); ?>
    <?php print render($content['links']); ?>
  </footer>
  <?php endif; ?>
  <?php print render($content['comments']); */ ?>
</article>
