<?php

/**
 * @file A címkézést készíti elő egy Cookie A Hottie blog esetén.
 * 
 * @param string $node Erre a node-ra kell átirányítani a befejezés után a cuccot.
 * @param string $url Erre az URL-re irányítjuk át az illetőt. A http:// ne szerepeljen benne. Ha a node és ez is szerepel a node lesz végrehajtva.
 * @param stings $source Ez a forrás megejelölése az eddig megszokott módokon | karakterel elválasztva.
 * 
 * A rendszer egy cookie-t hoz létre az adatokkal, majd átírányít. Ez azért van,
 * hogy a böngészés esetén is, tudjuk az eredeti forrást és annak a paramétereit.
 */
$params = array('source', 'node', 'url');
$get = array();

// Megtisztítjuk az inputot, és egy külön tömbbe tesszük a kulcsmezőket.
foreach ($_GET as $key => $value) {
  $_GET[$key] = trim(check_plain($value));
  if (in_array($key, $params)) {
    // Ha kulcsmezőről van szó, áttesszük egy másik tömbbe.
    $get[$key] = $_GET[$key];
    unset($_GET[$key]);
  }
}

// Elhelyezzük a Cookie-t.
if (isset($get['source'])) {
  setcookie('HottieBlog.source', $get['source'], time() + 60 * 60 * 24, '/');
}

// Létrehozzuk a paraméter stringet, hogy továbbadhassuk a megkapott
// paramétereket. Ebből a már levettük a node, url, és a source paramétereket.
$param_string = http_build_query($_GET);
if (!empty($param_string)) {
  $param_string = '?' . $param_string;
}

// Átiránytjuk a hívást. Ha se node, se url nincs megadva a címlapra megy.
if (isset($get['node'])) {
  header('Location: /node/' . $get['node'] . $param_string);
}
elseif (isset($get['url'])) {
  header('Location: http://' . $get['url'] . $param_string);
}
else {
  header('Location: /');
}

/**
 * Felkészíti a bevitt szöveget, hogy html-ként jeleníthessük meg.
 * 
 * @param string $text
 *   A szöveg amit feldolgozunk
 * 
 * @return string
 *   A $text HTML biztonságos verziója. Ha $text nem helyes UTF-8, egy üres
 *   stringet adunk vissza, és ha a PHP < 5.4 egy figyelmeztetés jelenhet meg a
 *   a szerver konfigurációjától függően.
 *   @link https://bugs.php.net/bug.php?id=47494 Request #47494	htmlspecialchars
 *   does not throw E_WARNING on multibyte problems
 */
function check_plain($text) {
  return htmlspecialchars($text, ENT_QUOTES, 'UTF-8');
}
