<?php
/**
 * @file
 * Az Intelligent Mailer PHP API-ja.
 * 
 * @author Müller Péter <intelligent-mailer@gmail.com>
 * @copyright © 2014, Müller Péter
 * @version 1.1
 *  
 * @link
 *   http://members.intelligent-mailer.com/content/IdGh2Tnx5rMfBVmlBou9ETxOidL51O2rPi7Akr/
 *   Az API hívások általános felépítése.
 * 
 * @TODO: Gondoskodni róla, hogy a API ne csak e-mailt fogadjon el azonosítónak
 *        hanem a feliratkozó azonosítóját is.
 */

// Az autentikációs változók.
define('USERID', 'x4QyhHJWDVTqOum9HsItBgBfOiAKmz');  // Saját profil oldalról az egyedi azonosító.
define('SECRET', 'IG1QmZpFRB5mFPVtB8XuX3BEmWk1WGZv'); // A beállítások oldalról az API titkos kód.

/**
 * Az API meghívása.
 * 
 * @link
 *   http://members.intelligent-mailer.com/content/ISiGYCoQTOKbLGmYac4tbHEPfnsb3cXRneZlKK/
 *   PHP példa API hívás indítására.
 * 
 * @param array
 *   Az elküldött adatok beállítása.
 * 
 * @param string
 *   A meghívandó url.
 * 
 * @return json 
 *   A lekérés eredménye.
 */
function _im_api_call($params, $url) {
  $auth = array(
    'userId' => USERID,
    'secret' => SECRET,
  );
  
  $postArray = array_merge($auth, array('data' => $params));
  $result = json_encode($postArray);

  $ch = curl_init('http://members.intelligent-mailer.com/api/' . $url . '/');
  curl_setopt($ch, CURLOPT_POST, 1);
  curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postArray));
  //curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
  curl_setopt($ch, CURLOPT_HEADER, 0);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
  $response = curl_exec($ch);
  
  return $response;
}

/**
 * Feliratkozók listájának lekérése.
 * 
 * @link
 *   http://members.intelligent-mailer.com/content/ISixuQGqQGoaEobI1iCfz7weTyf31hR5dYe6v4/ 
 *   API függvények - Feliratkozók listájának lekérése (getSubscribers)
 * 
 * @return json 
 *   A hívás visszaadja az összes feliratkozó email címét, a feliratkozás
 *   idejével együtt.
 */
function im_getSubscribers() {
  $params = array();
  $url = 'getSubscribers';  
  $response = _im_api_call($params, $url);  
  return $response;
}

/**
 * Listán szereplő feliratkozók lekérése.
 * 
 * @link
 *   http://members.intelligent-mailer.com/content/IHItD5ygrAizHoYTLly9f6jkd2W4D8eRTQCRQJ/
 *   API függvények - Listán szereplő feliratkozók lekérése (getSubscribersByList)
 * 
 * @param string $listId
 *   A szóban forgó lista azonosítója.
 * 
 * @return json
 *   A hívás visszaadja az adott pillanatban a listán szereplő összes
 *   feliratkozó email címét, a feliratkozás idejével együtt.
 */

function im_getSubscribersByList($listId) {
  $params = array('listId' => $listId,);
  $url = 'getSubscribersByList';
  $response = _im_api_call($params, $url);  
  return $response;
}

/**
 * Egy konkrét feliratkozó minden adatának lekérése email cím alapján.
 * 
 * @link
 *   http://members.intelligent-mailer.com/content/IdGh2Tnx5rMfBVmlBou9ETxObRCJIprmAdcENq/
 *    API függvények - Egy konkrét feliratkozó minden adatának lekérése (getSubscriber)
 *  
 * @param string $email 
 *   A feliratkozó email címe.
 * 
 * @return json
 *   A hívás visszaadja a lekért feliratkozó adott pillanatban érvényben lévő
 *   minden tárolt adatát.
 */
function im_getSubscriberByEmail($email) {
  $params = array('email' => $email);
  $url = 'getSubscriber';  
  $response = _im_api_call($params, $url);  
  return $response;
}

/**
 * Új feliratkozás rögzítése.
 * 
 * @link
 *   http://members.intelligent-mailer.com/content/ISiGYCoQTOKbLGmYac4tbHEtl7fJZk6lzWhUUr/
 *   API függvények - Új feliratkozás rögzítése (addSubscriber)
 * 
 * @param string $email
 *   A feliratkozó e-mail címe.
 * 
 * @param string $phone
 *   A feliratkozó telefonszáma.
 * 
 * @return json
 *   Sikeres kérés esetén a visszakapott válasz tartalmazza a rendszerben
 *   létrejött feliratkozó egyedi azonosítóját, az email címét, és a feliratás
 *   pontos idejét.
 */
function im_subscribeEmail($email, $phone) {
  $params = array(
    'email' => $email,
    'phone' => $phone,
  );
  $url = 'subscribeEmail';  
  $response = _im_api_call($params, $url);  
  return $response;
}

/**
 * Feliratkozó címkéinek módosítása.
 * 
 * @link
 *   http://members.intelligent-mailer.com/content/IPOlwXCbZ8iUFeTKxC3Sv159kH8Ik1kv8GQf2C/
 *   API függvények - Feliratkozó címkéinek módosítása (modifySubscriberLabels)
 *
 * @param string $email
 *   A feliratkozó e-mail címe.
 * 
 * @param array $add
 *   Egy tömb a hozzáadandó címkékkel. 
 * 
 * @param array $remove
 *   Egy tömb az eltávolítandó címkékkel.
 * 
 * @return json
 *   A hívás visszaadja művelet utáni időpontban a feliratkozó élő címkéit.
 */
function im_modifySubscriberLabels($email, $add, $remove) {
  $params = array(
    'email' => $email,
    'add' => $add,
    'remove' => $remove,
  );
  $url = 'modifySubscriberLabels';  
  $response = _im_api_call($params, $url);  
  return $response;
}

/**
 * Feliratkozó mezőadatainak beállítása.
 * 
 * @link
 *   http://members.intelligent-mailer.com/content/IGZuRTbKJhCbHyQtVoapqFBQgfRgasqTBtYgII/
 *   Feliratkozó mezőadatainak beállítása.
 * 
 * @param string $email
 *   A feliratkozó e-mail címe.
 * 
 * @param string $fieldId
 *   A mező azonosítója.
 * 
 * @param mixed $value
 *   A mező értéke. Jelölőnégyzetes mező esetén az értékek tömb formában adandók
 *   meg. 
 * 
 * @return json
 *   A hívás visszaadja a szóban forgó feliratkozóhoz tartozó friss
 *   mezőértékeket.
 */
function im_setSubscriberField($email, $fieldId, $value) {
  $params = array(
    'email' => $email,
    'fieldId' => $fieldId,
    'value' => $value,
  );
  $url = 'setSubscriberField';  
  $response = _im_api_call($params, $url);  
  return $response;
}

/**
 * Címkék listájának lekérése.
 * 
 * @link
 *   http://members.intelligent-mailer.com/content/IZE2AiaW6qlQ7SICxU99fHEliYFcJr4Cw36iWv/
 *   API függvények - Címkék listájának lekérése (getLabels)
 * 
 * @return json
 *   A hívás visszaadja az összes címkét, azok azonosítóit, és a hozzá tartozó
 *   bővebb leírást.
 */
function im_getLabels() {
  $params = array();
  $url = 'getLabels';  
  $response = _im_api_call($params, $url);  
  return $response;
}

/**
 * Címke létrehozása.
 * 
 * @link
 *   http://members.intelligent-mailer.com/content/IGZuRTbKJhCbHyQtVoapqFBQ4dRsCyJRpWZUpI/
 *   API függvények - Címke létrehozása (createLabel)
 * 
 * @param string $label
 *   A rögzíteni kívánt címke.
 * 
 * @return json
 *   Sikeres kérés esetén a hívás visszaadja az összes címkét, azok azonosítóit,
 *   és a hozzá tartozó bővebb leírást.
 */
function im_createLabel($label) {
  $params = array('label' => $label);
  $url = 'createLabel';  
  $response = _im_api_call($params, $url);  
  return $response;
}

/**
 * Kiküldés indítása egy feliratkozónak.
 * 
 * @link
 *   http://members.intelligent-mailer.com/content/IZE2AiaW6qlQ7SICxU99fHElu7FVVxArZuzcQv/
 *   API függvények - Kiküldés indítása egy feliratkozónak (sendToSubscriber)
 * 
 * @param string $email
 *   A feliratkozó e-mail címe.
 * 
 * @param string $templateId
 *   A küldemény sablon azonosítója.
 * 
 * @return json
 *   A hívás hatására a küldemény beáll a kiküldési sorba, a visszakapott válasz
 *   tartalmazza azt az URL-t, ahol magát a legyártott küldeményt lehet
 *   megtekinteni.
 */
function im_sendToSubscriber($email, $templateId) {
  $params = array(
    'email' => $email,
    'templateId' => $templateId,
  );
  $url = 'sendToSubscriber';  
  $response = _im_api_call($params, $url);  
  return $response;
}

/**
 * Kiküldés indítása listára.
 * 
 * @link
 *   http://members.intelligent-mailer.com/content/IdqECAB1ZHoD0oi2N34zBiufdrW8GgblhqupY5/
 *   API függvények - Kiküldés indítása listára (sendToList)

 * @param string $templateId
 *   A küldemény sablon azonosítója.
 * 
 * @param string $listId
 *   A kiküldési lista azonosítója.
 * 
 * @return json
 *   A hívás hatására a küldemények beállnak a kiküldési sorba, a visszakapott
 *   válasz tartalmazza azt az URL-t, ahol a kiküldés állapotát lehet nyomon
 *   követni.
 */
function im_sendToList($templateId, $listId) {
  $params = array(
    'templateId' => $templateId,
    'listId' => $listId,
  );
  $url = 'sendToList';  
  $response = _im_api_call($params, $url);  
  return $response;
}

/**
 * Feliratkozó elindítása egy szekvencián.
 * 
 * @link
 *   http://members.intelligent-mailer.com/content/ISixuQGqQGoaEobI1iCfz7we7jsd9MWcJOCXWy/
 *   API függvények - Feliratkozó elindítása egy szekvencián (startSubscriberSequence)
 * 
 * @param string $email
 *   A feliratkozó e-mail címe.
 * 
 * @param string $listId
 *   A szekvencia azonosítója.
 * 
 * @return json
 *   A hívás hatására a a feliratkozó elindul a szekvencián, a visszakapott
 *   válasz tartalmazza azt az URL-t, ahol vizuálisan nyomon lehet követni a
 *   haladási folyamatot.
 */
function im_startSubscriberSequence($email, $sequenceId) {
  $params = array(
    'email' => $email,
    'sequenceId' => $sequenceId,
  );
  $url = 'startSubscriberSequence';  
  $response = _im_api_call($params, $url);  
  return $response;
}

/**
 * Jel küldése az Intelligent Mailer felé.
 * 
 * @link
 *   http://members.intelligent-mailer.com/content/IHItD5ygrAizHoYTLly9f6jkwMaRX0vsRNyWSv/
 *   API függvények - Jel küldése az IM felé (signal)
 * 
 * @param string $email
 *   A feliratkozó e-mail címe.
 * 
 * @param string $signal
 *   A jel.
 *   
 * @return json
 *   Sikeres kérés esetén a visszakapott válasz a jel egyedi azonosítóját
 *   tartalmazza.
 */
function im_signal($email, $signal) {
  $params = array(
    'email' => $email,
    'signal' => $signal,
  );
  $url = 'signal';  
  $response = _im_api_call($params, $url);  
  return $response;
}

/**
 * Felkészíti a bevitt szöveget, hogy html-ként jeleníthessük meg.
 * 
 * @param string $text
 *   A szöveg amit feldolgozunk
 * 
 * @return string
 *   A $text HTML biztonságos verziója. Ha $Ttext nem helyes UTF-8, egy üres
 *   stringet adunk vissza, és ha a PHP < 5.4 egy figyelmeztetés jelenhet meg a
 *   a szerver konfigurációjától függőnen.
 *   @link https://bugs.php.net/bug.php?id=47494 Request #47494	htmlspecialchars
 *   does not throw E_WARNING on multibyte problemsdescription
 */
function im_check_plain($text) {
  return htmlspecialchars($text, ENT_QUOTES, 'UTF-8');
}
