<?php

/**
 * @file Is the user has the right to order the CD.
 * @copyright (c) 2015, Müller Péter
 * @package CD
 */

/**
 * Is this ok to the user order the CD?
 * @global object $user The current user object.
 * @return boolean Returns TRUE if 
 */
function is_ok_to_order_cd() {
  global $user;
  $uid = $user->uid;
  $commmon = FALSE;
  $name = 'hottie_ask_for_cd';
  $roles = $user->roles;
  $already_odered_a_cd = user_variable_get($name, $commmon, $uid);
  if (in_array('CD-re jogosult', $roles) && !$already_odered_a_cd) {
    // Ha a szerepköre be van kapcsolva, és még nem rendelt CD-t
    return TRUE;
  } else {
    return FALSE;
  }
}

/**
 * Set the current user varibale taht user already ordered the CD.
 * @global object $user The current user object.
 */
function set_cd_for_current_user() {
  global $user;
  $uid = $user->uid;
  $commmon = FALSE;
  $name = 'hottie_ask_for_cd';
  $value = TRUE;
  user_variable_set($name, $value, $commmon, $uid);
}
