/*global $, window*/
$.fn.editableTableWidget = function (options) {
	'use strict';
	return $(this).each(function () {
		var buildDefaultOptions = function () {
				var opts = $.extend({}, $.fn.editableTableWidget.defaultOptions);
				opts.editor = opts.editor.clone();
				return opts;
			},
			activeOptions = $.extend(buildDefaultOptions(), options),
			ARROW_LEFT = 37, ARROW_UP = 38, ARROW_RIGHT = 39, ARROW_DOWN = 40, ENTER = 13, ESC = 27, TAB = 9,
			element = $(this),
			editor = activeOptions.editor.css('position', 'absolute').hide().appendTo(element.parent()),
			active,
			showEditor = function (select) {
				active = element.find('td:focus');
				if (active.length) {
					editor.val(active.text())
						.removeClass('error')
						.show()
						.offset(active.offset())
						.css(active.css(activeOptions.cloneProperties))
						.width(active.width())
						.height(active.height())
						.focus();
					if (select) {
						editor.select();
					}
				}
			},
			setActiveText = function () {
				var text = editor.val(),
					evt = $.Event('change'),
					originalContent;
				if (active.text() === text || editor.hasClass('error')) {
					return true;
				}
				originalContent = active.html();
				active.text(text).trigger(evt, text);
				if (evt.result === false) {
					active.html(originalContent);
				}
			},
			movement = function (element, keycode) {
				if (keycode === ARROW_RIGHT) {
					return element.next('td');
				} else if (keycode === ARROW_LEFT) {
					return element.prev('td');
				} else if (keycode === ARROW_UP) {
					return element.parent().prev().children().eq(element.index());
				} else if (keycode === ARROW_DOWN) {
					return element.parent().next().children().eq(element.index());
				}
				return [];
			};
		editor.blur(function () {
			setActiveText();
			editor.hide();
		}).keydown(function (e) {
			if (e.which === ENTER) {
				setActiveText();
				editor.hide();
				active.focus();
				e.preventDefault();
				e.stopPropagation();
			} else if (e.which === ESC) {
				editor.val(active.text());
				e.preventDefault();
				e.stopPropagation();
				editor.hide();
				active.focus();
			} else if (e.which === TAB) {
				active.focus();
			} else if (this.selectionEnd - this.selectionStart === this.value.length) {
				var possibleMove = movement(active, e.which);
				if (possibleMove.length > 0) {
					possibleMove.focus();
					e.preventDefault();
					e.stopPropagation();
				}
			}
		})
		.on('input paste', function () {
			var evt = $.Event('validate');
			active.trigger(evt, editor.val());
			if (evt.result === false) {
				editor.addClass('error');
			} else {
				editor.removeClass('error');
			}
		});
		element.on('click keypress dblclick', showEditor)
		.css('cursor', 'pointer')
		.keydown(function (e) {
			var prevent = true,
				possibleMove = movement($(e.target), e.which);
			if (possibleMove.length > 0) {
				possibleMove.focus();
			} else if (e.which === ENTER) {
				showEditor(false);
			} else if (e.which === 17 || e.which === 91 || e.which === 93) {
				showEditor(true);
				prevent = false;
			} else {
				prevent = false;
			}
			if (prevent) {
				e.stopPropagation();
				e.preventDefault();
			}
		});

		element.find('td').prop('tabindex', 1);

		$(window).on('resize', function () {
			if (editor.is(':visible')) {
				editor.offset(active.offset())
				.width(active.width())
				.height(active.height());
			}
		});
	});

};
$.fn.editableTableWidget.defaultOptions = {
	cloneProperties: ['padding', 'padding-top', 'padding-bottom', 'padding-left', 'padding-right',
					  'text-align', 'font', 'font-size', 'font-family', 'font-weight',
					  'border', 'border-top', 'border-bottom', 'border-left', 'border-right'],
	editor: $('<input>')
};

/*$.fn.validExample = function () {
	var element = $(this);
	element.find('td').on('change', function (evt) {
		var cell = $(this),
		      column = cell.index();
		if (column === 0) {
			return;
		}
              }).on('validate', function (evt, value) {
		var cell = $(this),
	              column = cell.index();
		if (column === 0) {
			return !!value && value.trim().length > 0;
		} else if (value !== 'x'){
			return false;
		}
	});
	return this;
};*/

$.fn.validExample = function () {
	var element = $(this);
	element.find('td').off('click');
	element.find('td').on('click', function (evt) {
		var cell = $(this),
		      column = cell.index();
		if (column === 0) {
			return;
		} else {
			if (cell.text() == 'x'){
				cell.text('').blur();
			} else {
				cell.text('x').blur();
			}
		}
	});
	return this;
};


$.fn.percentCount = function () {
	var element = $(this);
		var footer = element.find('tfoot tr'),
		dataRows = element.find('tbody tr'),
		initialPercent = function () {
			var column, percent;
			dataRows.each(function () {
				var row = $(this);
				percent = row.children().eq(1).text()/footer.children().eq(1).text()*100;
				percent = (percent == 0) ? percent : percent.toFixed(1);
				row.children().eq(2).text(percent);
			});
		},
		initTotal = function () {
			var column, total;
				total = 0;
				dataRows.each(function () {
					var row = $(this);
					total += parseFloat(row.children().eq(2).text());
				});
				total = (total > 100) ? 100 : Math.round(total);
				footer.children().eq(2).text(total);
		};
		initialPercent();
		initTotal();
	element.find('td').on('change', function (evt) {
		footer = element.find('tfoot tr');
		dataRows = element.find('tbody tr');
		initialPercent();
		initTotal();
	});
};

$.fn.tableChartPie = function () {
	var element = $(this),
	alertId = '#' + element.attr('data-alert-id');
	if ($(alertId).css('display') == 'none'){
	var container = element.attr('data-chart-container'),
	dataRows = element.find('tbody tr'),
	headRow = element.find('thead tr'),
	dataIn = function () {
		var total = [], r, rdata = {};
			dataRows.each(function () {
				var row = $(this);
				rdata = {
							"label": row.children().eq(0).text(),
							"value": parseInt(row.children().eq(1).text())
						};
				if ( rdata.value > 0 ){
					total.push(rdata);
				}
			});
		return total;
	};
	var cont = '#' + container;
	var size = {
		'height': $(cont).height(),
		'width' : $(cont).width()
	};
	document.getElementById(container).innerHTML = '';
	var pie = new d3pie(container, {
		"header": {
			"title": {
				"text": element.find('thead .chart-title').text(),
				"fontSize": 22,
				"font": "verdana"
			},
			"titleSubtitlePadding": 12
		},
		"footer": {
			"color": "#999999",
			"fontSize": 11,
			"font": "open sans",
			"location": "bottom-center"
		},
		"size": {
			"canvasHeight": size.height,
			"canvasWidth": size.width,
			"pieOuterRadius": "88%"
		},
		"data": {
			"content": dataIn()
		},
		"labels": {
			"outer": {
				"pieDistance": 32
			},
			"mainLabel": {
				"font": "verdana"
			},
			"percentage": {
				"color": "#e1e1e1",
				"font": "verdana",
				"decimalPlaces": 1
			},
			"value": {
				"color": "#e1e1e1",
				"font": "verdana"
			},
			"lines": {
				"enabled": true,
				"color": "#cccccc"
			},
			"truncation": {
				"enabled": true
			}
		},
		"tooltips": {
			"enabled": true,
			"type": "placeholder",
			"string": "{label}: {value}, ({percentage}%)",
			"styles": {
				"color": "#f3f3f3",
				"padding": 7
			}
		},
		"effects": {
			"pullOutSegmentOnClick": {
				"effect": "linear",
				"speed": 200,
				"size": 8
			}
		}
	});
}
};
