<?php
/**
 * @file
 * The primary PHP file for this theme.
 */

require_once dirname(__FILE__) . '/includes/common.inc';

function omniparents_preprocess_page(&$variables) {
  // Add information about the number of sidebars.
  if (!empty($variables['page']['sidebar_first']) && !empty($variables['page']['sidebar_second'])) {
    $variables['content_column_class'] = ' class="col-sm-6"';
  }
  elseif (!empty($variables['page']['sidebar_first']) || !empty($variables['page']['sidebar_second'])) {
    $variables['content_column_class'] = ' class="col-sm-9"';
  }
  else {
    $variables['content_column_class'] = ' class="col-sm-12"';
  }

  if(bootstrap_setting('fluid_container') === 1) {
    $variables['container_class'] = 'container-fluid';
  }
  else {
    $variables['container_class'] = 'container';
  }
  
    // Do we have a node?
    if (isset($variables['node'])) {

        // Ref suggestions cuz it's stupid long.
        $suggests = &$variables['theme_hook_suggestions'];

        // Get path arguments.
        $args = arg();
        // Remove first argument of "node".
        unset($args[0]);

        // Set type.
        $type = "page__type_{$variables['node']->type}";

        // Bring it all together.
        $suggests = array_merge(
          $suggests,
          array($type),
          theme_get_suggestions($args, $type)
        );

        // if the url is: 'http://domain.com/node/123/edit'
        // and node type is 'blog'..
        // 
        // This will be the suggestions:
        //
        // - page__node
        // - page__node__%
        // - page__node__123
        // - page__node__edit
        // - page__type_blog
        // - page__type_blog__%
        // - page__type_blog__123
        // - page__type_blog__edit
        // 
        // Which connects to these templates:
        //
        // - page--node.tpl.php
        // - page--node--%.tpl.php
        // - page--node--123.tpl.php
        // - page--node--edit.tpl.php
        // - page--type-blog.tpl.php          << this is what you want.
        // - page--type-blog--%.tpl.php
        // - page--type-blog--123.tpl.php
        // - page--type-blog--edit.tpl.php
        // 
        // Latter items take precedence.
    }
}

/**
 * Add `btn` class to all buttons.
 *
 * @param $variables
 */
function omniparents_preprocess_button(&$variables) {
  $variables['element']['#attributes']['class'][] = 'btn';
  $variables['element']['#attributes']['class'][] = 'mb-2';

  if (is_array($variables['element']['#attributes']['class'])) {
    if (in_array('btn-default',
        $variables['element']['#attributes']['class']) || in_array('btn-danger',
        $variables['element']['#attributes']['class']) || in_array('btn-warning',
        $variables['element']['#attributes']['class']) || in_array('btn-info',
        $variables['element']['#attributes']['class'])) {
      return;
    }
  }

  // Special styles for Delete/Destructive Buttons.
  if (stristr($variables['element']['#value'], 'Delete') !== FALSE) {
    $variables['element']['#attributes']['class'][] = 'btn-danger';
  }
  else {
    $variables['element']['#attributes']['class'][] = 'btn-primary';
  }
}

/**
 * Add class `form-control` to text fields
 *
 * @param $variables
 */
function omniparents_preprocess_textfield(&$variables) {
  $variables['element']['#attributes']['class'][] = 'form-control';
}

/**
 * Add class `form-control` to file fields
 *
 * @param $variables
 */
function omniparents_preprocess_file(&$variables) {
  $variables['element']['#attributes']['class'][] = 'form-control';
}

/**
 * Implements theme_textfield()
 *
 * The only reason we need this is to remove the default
 * `form-text` class that drupal adds to text fields.
 *
 * @param $variables
 *
 * @return string
 */
function omniparents_textfield($variables) {
  $element = $variables['element'];
  $element['#attributes']['type'] = 'text';
  element_set_attributes($element, [
    'id',
    'name',
    'value',
    'size',
    'maxlength',
  ]);
  //_form_set_class($element, array('form-text'));

  $extra = '';
  if ($element['#autocomplete_path'] && !empty($element['#autocomplete_input'])) {
    drupal_add_library('system', 'drupal.autocomplete');
    $element['#attributes']['class'][] = 'form-autocomplete';

    $attributes = [];
    $attributes['type'] = 'hidden';
    $attributes['id'] = $element['#autocomplete_input']['#id'];
    $attributes['value'] = $element['#autocomplete_input']['#url_value'];
    $attributes['disabled'] = 'disabled';
    $attributes['class'][] = 'autocomplete';
    $extra = '<input' . drupal_attributes($attributes) . ' />';
  }

  $output = '<input' . drupal_attributes($element['#attributes']) . ' />';

  return $output . $extra;
}

/**
 * Implements theme_textarea()
 *
 * Add .form-control to textarea fields
 *
 * @param $variables
 *
 * @return string
 */
function omniparents_textarea($variables) {
  $element = $variables['element'];
  element_set_attributes($element, ['id', 'name']);
  _form_set_class($element, ['form-control']);

  $wrapper_attributes = [
    'class' => ['form-textarea-wrapper'],
  ];

  // Add resizable behavior.
  if (!empty($element['#resizable'])) {
    drupal_add_library('system', 'drupal.textarea');
    $wrapper_attributes['class'][] = 'resizable';
  }
  
  // Add rows attribute
  if (!empty($element['#webform_component']['extra']['rows'])) {
    $element['#attributes']['rows'] = $element['#webform_component']['extra']['rows'];
  }

  $output = '<div' . drupal_attributes($wrapper_attributes) . '>';
  $output .= '<textarea' . drupal_attributes($element['#attributes']) . '>' . check_plain($element['#value']) . '</textarea>';
  $output .= '</div>';

  return $output;
}

/**
 * Implements theme_password()
 *
 * Add .form-control to password fields
 *
 * @param $variables
 *
 * @return string
 */
function omniparents_password($variables) {
  $element = $variables['element'];
  $element['#attributes']['type'] = 'password';
  element_set_attributes($element, ['id', 'name', 'size', 'maxlength']);
  _form_set_class($element, ['form-control']);

  return '<input' . drupal_attributes($element['#attributes']) . ' />';
}

/**
 * Implements theme_form_search_block_form_alter()
 *
 * Alter the search form.
 *
 * @param $form
 */
function omniparents_form_search_block_form_alter(&$form) {
  $form['search_block_form']['#attributes']['placeholder'] = "Search...";
  $form['search_block_form']['#field_prefix'] = FALSE;
  $form['search_block_form']['#field_suffix'] = FALSE;
}

/**
 * Implements theme_form_element().
 *
 * Apply bootstrap wrappings and classes on all form elements.
 *
 * @param $variables
 *
 * @return string
 */
function omniparents_form_element($variables) {
  $element = &$variables['element'];

  // This function is invoked as theme wrapper, but the rendered form element
  // may not necessarily have been processed by form_builder().
  //$element['#title_display'] = 'before';

  // Add a class for disabled elements to facilitate cross-browser styling.
  if (!empty($element['#attributes']['disabled'])) {
    $attributes['class'][] = 'disabled';
  }

  // Add element #id for #type 'item'.
  if (isset($element['#markup']) && !empty($element['#id'])) {
    $attributes['id'] = $element ['#id'];
  }
  // Add element's #type and #name as class to aid with JS/CSS selectors.
  $attributes['class'] = ['form-item'];
  if (!empty($element['#type'])) {
    $attributes['class'][] = 'form-type-' . strtr($element['#type'], '_', '-');
  }
  if (!empty($element['#name'])) {
    $attributes['class'][] = 'form-item-' . strtr($element['#name'], [
        ' ' => '-',
        '_' => '-',
        '[' => '-',
        ']' => '',
      ]);
  }

  $output = '<div' . drupal_attributes($attributes) . '>' . "\n";
  
  // Set attributes for children
  if (!empty($element['#type']) && in_array($element['#type'],
      [
        'radios',
        'checkboxes',
      ])) {
    $element['#attributes']['class'][] = 'custom-control';
    $element['#attributes']['class'][] = 'custom-' . strtr($element['#type'], '_', '-');
  }

  // If #title is not set, we don't display any label or required marker.
  if (!isset($element['#title'])) {
    $element['#title_display'] = 'none';
  }

  if (!isset($element['#title_display'])) {
    $element['#title_display'] = 'before';
  }

  $prefix = isset($element['#field_prefix']) ? '<span class="field-prefix">' . $element['#field_prefix'] . '</span>' : '';
  $suffix = isset($element['#field_suffix']) ? '<span class="field-prefix">' . $element['#field_suffix'] . '</span>' : '';

  switch ($element['#title_display']) {
    case 'before':
    case 'invisible':
      $output .= ' ' . theme('form_element_label', $variables);
      if (!empty($element['#description']) && isset($element['#type']) && in_array($element['#type'],
          [
            'radios',
            'checkboxes',
          ])) {
        $output .= '<div class="form-text text-muted mb-2">' . $element['#description'] . "</div>\n";
      }
      $output .= ' ' . $prefix . $element['#children'] . $suffix . "\n";
      break;

    case 'after':
      $output .= ' ' . $prefix . $element['#children'] . $suffix;
      $output .= ' ' . theme('form_element_label', $variables) . "\n";
      if (!empty($element['#description']) && isset($element['#type']) && in_array($element['#type'],
          [
            'radios',
            'checkboxes',
          ])) {
        $output .= '<div class="form-text text-muted mb-2">' . $element['#description'] . "</div>\n";
      }
      break;

    case 'none':
    case 'attribute':
      // Output no label and no required marker, only the children.
      $output .= ' ' . $prefix . $element['#children'] . $suffix . "\n";
      break;
  }

  if (!empty($element['#description']) && (!isset($element['#type']) || !in_array($element['#type'],
        [
          'radios',
          'checkboxes',
        ]))) {
    $output .= '<div class="form-text text-muted">' . $element['#description'] . "</div>\n";
  }

  $output .= "</div>\n";

  return '<div class="form-group">' . $output . '</div>';
}

/**
 * Implements theme_form_element_label().
 *
 * Apply bootstrap wrappings and classes on all form elements.
 *
 * @param $variables
 *
 * @return string
 */
function omniparents_form_element_label($variables) {
  $element = $variables['element'];

  // This is also used in the installer, pre-database setup.
  $t = get_t();

  // If title and required marker are both empty, output no label.
  if ((!isset($element['#title']) || $element['#title'] === '') && empty($element['#required'])) {
    return '';
  }

  // If the element is required, a required marker is appended to the label.
  $required = !empty($element['#required']) ? theme('form_required_marker', array(
    'element' => $element,
  )) : '';
  $title = filter_xss_admin($element['#title']);
  $attributes = array();

  // Style the label as class option to display inline with the element.
  if ($element['#title_display'] == 'after') {
    $attributes['class'] = 'option';
  }
  elseif ($element['#title_display'] == 'invisible') {
    $attributes['class'] = 'element-invisible';
  }
  if (!empty($element['#id'])) {
    $attributes['for'] = $element['#id'];
  }

  // The leading whitespace helps visually separate fields from inline labels.
  return ' <label' . drupal_attributes($attributes) . '>' . $t('!title !required', array(
    '!title' => $title,
    '!required' => $required,
  )) . "</label>\n";
}

/**
 * Implements theme_button()
 *
 * @param $variables
 *
 * @return string
 */
function omniparents_button($variables) {
  $element = $variables['element'];
  $element['#attributes']['type'] = 'submit';
  element_set_attributes($element, ['id', 'name', 'value']);

  $element ['#attributes']['class'][] = 'form-' . $element ['#button_type'];
  if (!empty($element['#attributes']['disabled'])) {
    $element['#attributes']['class'][] = 'disabled';
  }

  return '<input' . drupal_attributes($element['#attributes']) . ' />';
}


/**
 * Add the menu menu wrapper.
 *
 * @param $variables
 *
 * @return string
 */
function omniparents_menu_tree__primary(array &$variables) {
  return '<ul class="navbar-nav ml-lg-auto mr-md-auto mr-lg-0">' . $variables['tree'] . '</ul>';
}

/**
 * Add the secondary menu wrapper.
 *
 * @param array $variables
 *
 * @return string
 */
function omniparents_menu_tree__secondary(array &$variables) {
  return '<ul class="navbar-nav mr-md-auto mr-lg-0">' . $variables['tree'] . '</ul>';
}

/**
 * Returns HTML for a menu link and submenu.
 *
 * @param array $variables
 *   An associative array containing:
 *   - element: Structured array data for a menu link.
 *
 * @return string
 *   The constructed HTML.
 *
 * @see theme_menu_link()
 *
 * @ingroup theme_functions
 */
function omniparents_menu_link__main_menu(array $variables) {
  $element = $variables['element'];
  $sub_menu = '';

  $title = $element['#title'];
  $href = $element['#href'];
  $options = !empty($element['#localized_options']) ? $element['#localized_options'] : [];
  $attributes = !empty($element['#attributes']) ? $element['#attributes'] : [];
  $attributes['class'][] = 'nav-item';
  $options['attributes']['class'][] = 'nav-link';

  if ($element['#below']) {
    // Prevent dropdown functions from being added to management menu so it
    // does not affect the navbar module.
    if (($element['#original_link']['menu_name'] == 'management') && (module_exists('navbar'))) {
      $sub_menu = drupal_render($element['#below']);
    }
    elseif ((!empty($element['#original_link']['depth'])) && ($element['#original_link']['depth'] == 1)) {
      // Add our own wrapper.
      //$element['#below']['#theme_wrappers'] = array('menu_tree__sub_menu');
      $sub_menu = '<div class="dropdown-menu">' . drupal_render($element['#below']) . '</div>';

      // Generate as standard dropdown.
      $attributes['class'][] = 'dropdown';

      $options['html'] = TRUE;

      // Set dropdown trigger element to # to prevent inadvertant page loading
      // when a submenu link is clicked.
      $options['attributes']['class'][] = 'dropdown-toggle';
      $options['attributes']['data-toggle'] = 'dropdown';
    }
  }

  return '<li' . drupal_attributes($attributes) . '>' . l($title, $href,
      $options) . $sub_menu . "</li>\n";
}

/**
 * @param array $variables
 *
 * @return string
 * @see \theme_menu_link()
 */
function omniparents_menu_link__user_menu(array &$variables) {
  return omniparents_menu_link__main_menu($variables);
}

/**
 * Generates dropdown menu wrapper.
 *
 * @param array $variables
 *
 * @return string
 */
function omniparents_menu_tree_link__sub_menu(array &$variables) {
  return '<div class="dropdown-menu">' . $variables['tree'] . '</div>';
}

function omniparents_menu_local_task($variables) {
  $link = $variables['element']['#link'];
  $link_text = $link['title'];
  if (!empty($variables['element']['#active'])) {

    // Add text to indicate active tab for non-visual users.
    $active = '<span class="element-invisible">' . t('(active tab)') . '</span>';

    // If the link does not contain HTML already, check_plain() it now.
    // After we set 'html'=TRUE the link will not be sanitized by l().
    if (empty($link['localized_options']['html'])) {
      $link['title'] = check_plain($link['title']);
    }
    $link['localized_options']['html'] = TRUE;
    $link_text = t('!local-task-title!active', array(
      '!local-task-title' => $link['title'],
      '!active' => $active,
    ));
  }
  $link['localized_options']['attributes']['class'][] = 'nav-link';
  return '<li' . (!empty($variables['element']['#active']) ? ' class="active nav-item"' : ' class="nav-item"') . '>' . l($link_text, $link['href'], $link['localized_options']) . "</li>\n";
}


/**
 * Alter status messages to use bootstrap alerts.
 *
 * @param $variables
 *
 * @return string
 */
//function omniparents_status_messages($variables) {
//  $display = $variables['display'];
//  $output = '';
//
//  $status_heading = [
//    'status' => t('Status message'),
//    'error' => t('Error message'),
//    'warning' => t('Warning message'),
//  ];
//  foreach (drupal_get_messages($display) as $type => $messages) {
//    switch ($type) {
//      case "error":
//        $cc = 'alert-danger';
//        break;
//      case "warning":
//        $cc = 'alert-warning';
//        break;
//      case 'status':
//        $cc = 'alert-info';
//        break;
//      default:
//        $cc = 'alert-info';
//        break;
//    }
//    $output .= "<div class=\"alert $cc\">\n";
//    if (!empty($status_heading[$type])) {
//      $output .= '<h2 class="element-invisible">' . $status_heading[$type] . "</h2>\n";
//    }
//    if (count($messages) > 1) {
//      $output .= " <ul>\n";
//      foreach ($messages as $message) {
//        $output .= '  <li>' . $message . "</li>\n";
//      }
//      $output .= " </ul>\n";
//    }
//    else {
//      $output .= reset($messages);
//    }
//    $output .= "</div>\n";
//  }
//
//  return $output;
//}
