jQuery(function($){
  // local url of page (minus any hash, but including any potential query string)
  var url = location.href.replace(/#.*/,'');
  var lang = 'hu';
  if ( url.search('hu') > -1 ){
	  url = url.replace('hu', '');
  } else if ( url.search('en') > -1 ){
	  url = url.replace('en', '');
  }
  

  // Find all anchors
  $('#front-nav').find('a[href]').each(function(i,a){
    var $a = $(a);
    var href = $a.attr('href');

    // check is anchor href starts with page's URI
    if (href.indexOf(url+'#') == 0) {
      // remove URI from href
      href = href.replace(url,'');
      // update anchors HREF with new one
      $a.attr('href',href);
    }

    // Now refresh scrollspy
    $('[data-spy="scroll"]').each(function (i,spy) {
       $(spy).scrollspy({offset: 100});
       $(spy).scrollspy('refresh');
    });
  });

});

(function ($) {
	Drupal.behaviors.smoothScrolling = {
	  attach: function (context, settings) {
		$(document).on('click', 'a[href^="#"]', function (event) {
			event.preventDefault();
			var is_acc = $(this).attr('data-parent');
			if ( is_acc != '#accordion'){
				$('html, body').animate({
					scrollTop: $($.attr(this, 'href')).offset().top - 60
				}, 1000, 'swing');
			}
		});
	  }
	};
})(jQuery);

(function ($) {
//	Drupal.behaviors.modalForm = {
//	  attach: function (context, settings) {
//		$(document).ready(function () {
//			var form = $('#block-webform-client-block-15').html();
//			$('#callback-form').html(form);
//		});
//	  }
//	};
})(jQuery);

var device = screen.width;
if ( device > 768 ){
	wow = new WOW({
		  boxClass:     'wow',      // default
		  animateClass: 'animated', // default
		  offset:       0,          // default
		  mobile:       true,       // default
		  live:         true        // default
		});
	wow.init();
}

setCookie("theme-device", device, 365);

function setCookie(cname, cvalue, exdays) {
    var d = new Date();
    d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
    var expires = "expires="+d.toUTCString();
    document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
}

function getCookie(cname) {
    var name = cname + "=";
    var ca = document.cookie.split(';');
    for(var i = 0; i < ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0) == ' ') {
            c = c.substring(1);
        }
        if (c.indexOf(name) == 0) {
            return c.substring(name.length, c.length);
        }
    }
    return "";
}