<?php
/**
 * @file
 * Az általános validációs rutionok.
 */

function _validate_email($element, &$form_state) {
  $email = trim($element['#value']);
  if(!_is_valid_email($email)) {
    form_error($element, 'Helytelen, vagy nem létező e-mail cím lett megadva, kérlek ellenőrizd!');
  }
}

function _validate_phone($element, &$form_state) {
  $phone = $element['#value'];
  if(!_is_valid_phone($phone)) {
    form_error($element, 'A telefonszám mező csak számokat, szóközt tartalamzhat vagy ezeket a jeleket: - / () +');
  }
}

function _validate_firm($element, &$form_state) {
  if ($form_state['values']['is_not_firm_invoice']==0){
    if ($element['#value']=='') {
      form_error($element, '„'.$element['#title'].'” mezőt ki kell tölteni!');
    }
  }
} 

function _validate_taxid($element, &$form_state) {
  $taxid = trim($element['#value']);
  if($form_state['values']['is_not_firm_invoice']==0 && $form_state['values']['country']=='HU' && !_is_valid_taxid($taxid)) {
    form_error($element, 'Helytelen az adószám formátuma! Kérlek ebben a formátumban add meg: 12345678-1-12');
  }
}
