<?php

include_once('ac_api/includes/ActiveCampaign.class.php');

$ac = new ActiveCampaign(variable_get('membership_ac_api_url'), variable_get('membership_ac_api_key'));

/**
 * Add or edit a contact based on their email address. 
 * @param array $contact Contast data
 * @link http://www.activecampaign.com/api/example.php?call=contact_sync
 */
function ac_contact_sync($contact) {
  global $ac;
  $contact_sync = $ac->api("contact/sync", $contact);
 
    if (!(int) $contact_sync->success) {
    // request failed
    echo "<p>Syncing contact failed. Error returned: " . $contact_sync->error . "</p>";
    exit();
    }

    // successful request
    $contact_id = (int) $contact_sync->subscriber_id;
    echo "<p>Contact synced successfully (ID {$contact_id})!</p>";
}

/**
 * Add an existing contact to an existing automation.
 * @param array $post_data The contact email and the automation id(s).
 * @link http://www.activecampaign.com/api/example.php?call=automation_contact_add
 */
function ac_automation_contact_add($post_data) {
  global $ac;
  $response = $ac->api("contact/add", $post_data);
}

/**
 * Specify one or more tags to be added to a contact record.
 * @param array $post_data The contact email and the tag(s).
 * @link http://www.activecampaign.com/api/example.php?call=contact_tag_add
 */
function ac_contact_tag_add($post_data) {
  global $ac;
  $response = $ac->api("contact/tag_add", $post_data);
}

/**
 * Specify one or more tags to be removed from a contact record.
 * @param array $post_data The contact email and the tag(s).
 * @link http://www.activecampaign.com/api/example.php?call=contact_tag_remove
 */
function ac_contact_tag_remove($post_data) {
  global $ac;
  $response = $ac->api("contact/tag_remove", $post_data);
}
