<?php

/**
 * @file API functions.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */

/**
 * Make upsell link from GET parameters.
 * @author Kulcsár Balázs <kulcsar.balazs69@gmail.com>
 */
function membership_api_upsell_order_link($pid = '', $hash = '', $muid = '', $thank_you = '') {

//    // Declare passing variables
//    $pid = '';
//    $hash = '';
//    $muid = '';
    $muser = '';
    $mhash = '';

    if (isset($_GET['pid']) && !empty($_GET['pid']) && _membership_is_int(check_plain(trim($_GET['pid'])))) {
        $pid = check_plain(trim($_GET['pid']));
    }

    if (isset($_GET['hash']) && !empty($_GET['hash']) && strlen(check_plain(trim($_GET['hash']))) === 8) {
        $hash = check_plain(trim($_GET['hash']));
    }

    if ((isset($_GET['email']) && !empty($_GET['email']))) {
        $muser = membership_user_details_object_by_email(check_plain(trim($_GET['email'])));
    } else if ((isset($_GET['uid']) && !empty($_GET['uid'])) && _membership_is_int(check_plain(trim($_GET['uid'])))) {
        $muser = membership_user_details_object_by_uid(check_plain(trim($_GET['uid'])));
    } else if ((isset($_GET['muid']) && !empty($_GET['muid'])) && _membership_is_int(check_plain(trim($_GET['muid'])))) {
        $muser = membership_user_details_object(check_plain(trim($_GET['muid'])));
    }
    if ($muser != '') {
        $muid = $muser->id;
        $mhash = $muser->hash;

        if (isset($_GET['thank_you']) && !empty($_GET['thank_you'])) {
            $thank_you = check_plain(trim($_GET['thank_you']));
        }

        if ($pid != '' && $hash != '' && $muid != '' && $mhash != '') {
            if ($thank_you != '') {
                return "/upsell/$muid/$muser->hash/$pid/$hash?thank_you=$thank_you";
            } else {
                return "/upsell/$muid/$muser->hash/$pid/$hash";
            }
        } else {
            return '#';
        }
    } else {
        return '#';
    }
}
